/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import com.amity.socialcloud.sdk.AmityOkHttp;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.EkoAuthApi;
import com.ekoapp.ekosdk.internal.api.EkoChatApi;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.EkoNotificationApi;
import com.ekoapp.ekosdk.internal.api.EkoStreamApi;
import com.google.gson.Gson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u000bJ\u0006\u0010\u0005\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0006\u0010\u0007\u001a\u00020\u0012J\u0006\u0010\t\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoApi;", "", "()V", "auth", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$AuthApiHolder;", "chat", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$ChatApiHolder;", "notification", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$NotificationApiHolder;", "stream", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$StreamApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoAuthApi;", "Lcom/ekoapp/ekosdk/internal/api/EkoChatApi;", "createRetrofit", "Lretrofit2/Retrofit;", "url", "", "getRetrofit", "Lcom/ekoapp/ekosdk/internal/api/EkoNotificationApi;", "Lcom/ekoapp/ekosdk/internal/api/EkoStreamApi;", "ApiHolder", "AuthApiHolder", "ChatApiHolder", "NotificationApiHolder", "StreamApiHolder", "amity-sdk_release"})
public final class EkoApi {
    private static final AuthApiHolder auth;
    private static final StreamApiHolder stream;
    private static final ChatApiHolder chat;
    private static final NotificationApiHolder notification;
    public static final EkoApi INSTANCE;

    @NotNull
    public final EkoAuthApi auth() {
        return (EkoAuthApi)auth.getApi();
    }

    @NotNull
    public final EkoStreamApi stream() {
        return (EkoStreamApi)stream.getApi();
    }

    @NotNull
    public final EkoChatApi chat() {
        return (EkoChatApi)chat.getApi();
    }

    @NotNull
    public final EkoNotificationApi notification() {
        return (EkoNotificationApi)notification.getApi();
    }

    private final Retrofit getRetrofit() {
        return this.createRetrofit(EkoEndpoint.INSTANCE.getHttpUrl());
    }

    private final Retrofit createRetrofit(String url) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(url).client(AmityOkHttp.Companion.newBuilder$amity_sdk_release().build()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createAsync()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)EkoGson.get())).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026\n                .build()");
        return retrofit;
    }

    private EkoApi() {
    }

    static {
        EkoApi ekoApi;
        INSTANCE = ekoApi = new EkoApi();
        auth = new AuthApiHolder();
        stream = new StreamApiHolder();
        chat = new ChatApiHolder();
        notification = new NotificationApiHolder();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoApi$AuthApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$ApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoAuthApi;", "()V", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "setClazz", "(Ljava/lang/Class;)V", "amity-sdk_release"})
    public static final class AuthApiHolder
    extends ApiHolder<EkoAuthApi> {
        @NotNull
        private Class<EkoAuthApi> clazz = EkoAuthApi.class;

        @Override
        @NotNull
        public Class<EkoAuthApi> getClazz() {
            return this.clazz;
        }

        @Override
        public void setClazz(@NotNull Class<EkoAuthApi> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
            this.clazz = clazz;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoApi$ChatApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$ApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoChatApi;", "()V", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "setClazz", "(Ljava/lang/Class;)V", "amity-sdk_release"})
    public static final class ChatApiHolder
    extends ApiHolder<EkoChatApi> {
        @NotNull
        private Class<EkoChatApi> clazz = EkoChatApi.class;

        @Override
        @NotNull
        public Class<EkoChatApi> getClazz() {
            return this.clazz;
        }

        @Override
        public void setClazz(@NotNull Class<EkoChatApi> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
            this.clazz = clazz;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoApi$StreamApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$ApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoStreamApi;", "()V", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "setClazz", "(Ljava/lang/Class;)V", "amity-sdk_release"})
    public static final class StreamApiHolder
    extends ApiHolder<EkoStreamApi> {
        @NotNull
        private Class<EkoStreamApi> clazz = EkoStreamApi.class;

        @Override
        @NotNull
        public Class<EkoStreamApi> getClazz() {
            return this.clazz;
        }

        @Override
        public void setClazz(@NotNull Class<EkoStreamApi> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
            this.clazz = clazz;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoApi$NotificationApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoApi$ApiHolder;", "Lcom/ekoapp/ekosdk/internal/api/EkoNotificationApi;", "()V", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "setClazz", "(Ljava/lang/Class;)V", "amity-sdk_release"})
    public static final class NotificationApiHolder
    extends ApiHolder<EkoNotificationApi> {
        @NotNull
        private Class<EkoNotificationApi> clazz = EkoNotificationApi.class;

        @Override
        @NotNull
        public Class<EkoNotificationApi> getClazz() {
            return this.clazz;
        }

        @Override
        public void setClazz(@NotNull Class<EkoNotificationApi> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
            this.clazz = clazz;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoApi$ApiHolder;", "T", "", "()V", "apiImpl", "Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "setClazz", "(Ljava/lang/Class;)V", "currentHttpUrl", "", "createApi", "()Ljava/lang/Object;", "getApi", "amity-sdk_release"})
    public static abstract class ApiHolder<T> {
        private String currentHttpUrl = "";
        private T apiImpl;

        @NotNull
        public abstract Class<T> getClazz();

        public abstract void setClazz(@NotNull Class<T> var1);

        public final T getApi() {
            return this.createApi();
        }

        private final T createApi() {
            if (Intrinsics.areEqual((Object)this.currentHttpUrl, (Object)EkoEndpoint.INSTANCE.getHttpUrl()) ^ true) {
                this.currentHttpUrl = EkoEndpoint.INSTANCE.getHttpUrl();
                this.apiImpl = INSTANCE.getRetrofit().create(this.getClazz());
            }
            T t = this.apiImpl;
            if (t == null) {
                Intrinsics.throwNpe();
            }
            return t;
        }
    }
}

