/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class PostDao_Impl
extends PostDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PostEntity> __insertionAdapterOfPostEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final EntityDeletionOrUpdateAdapter<PostEntity> __deletionAdapterOfPostEntity;
    private final EntityDeletionOrUpdateAdapter<PostEntity> __updateAdapterOfPostEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeletePostByPostId;
    private final SharedSQLiteStatement __preparedStmtOfIncrementCommentCount;
    private final SharedSQLiteStatement __preparedStmtOfDecrementCommentCount;
    private final SharedSQLiteStatement __preparedStmtOfSetGlobalRank;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePost;
    private final SharedSQLiteStatement __preparedStmtOfUpdateDeletedImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFeedTypeImpl;

    public PostDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPostEntity = new EntityInsertionAdapter<PostEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `post` (`postId`,`parentPostId`,`postedUserId`,`sharedUserId`,`metadata`,`sharedCount`,`reactions`,`reactionCount`,`commentCount`,`flagCount`,`editedAt`,`isDeleted`,`targetType`,`targetId`,`postDataType`,`data`,`childPostIds`,`globalRank`,`feedType`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                if (value.getParentPostId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getParentPostId());
                }
                if (value.getPostedUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPostedUserId());
                }
                if (value.getSharedUserId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSharedUserId());
                }
                String _tmp = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                stmt.bindLong(6, (long)value.getSharedCount());
                String _tmp_1 = PostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, (long)value.getReactionCount());
                stmt.bindLong(9, (long)value.getCommentCount());
                stmt.bindLong(10, (long)value.getFlagCount());
                String _tmp_2 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                if (value.getTargetType() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetId());
                }
                if (value.getPostDataType() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getPostDataType());
                }
                String _tmp_4 = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                String _tmp_5 = PostDao_Impl.this.__stringListConverter.stringListToString(value.getChildPostIds());
                if (_tmp_5 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_5);
                }
                String _tmp_6 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getGlobalRank());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                if (value.getFeedType() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getFeedType());
                }
                String _tmp_7 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_7);
                }
                String _tmp_8 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_8);
                }
            }
        };
        this.__deletionAdapterOfPostEntity = new EntityDeletionOrUpdateAdapter<PostEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `post` WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
            }
        };
        this.__updateAdapterOfPostEntity = new EntityDeletionOrUpdateAdapter<PostEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `post` SET `postId` = ?,`parentPostId` = ?,`postedUserId` = ?,`sharedUserId` = ?,`metadata` = ?,`sharedCount` = ?,`reactions` = ?,`reactionCount` = ?,`commentCount` = ?,`flagCount` = ?,`editedAt` = ?,`isDeleted` = ?,`targetType` = ?,`targetId` = ?,`postDataType` = ?,`data` = ?,`childPostIds` = ?,`globalRank` = ?,`feedType` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                if (value.getParentPostId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getParentPostId());
                }
                if (value.getPostedUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPostedUserId());
                }
                if (value.getSharedUserId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSharedUserId());
                }
                String _tmp = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                stmt.bindLong(6, (long)value.getSharedCount());
                String _tmp_1 = PostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, (long)value.getReactionCount());
                stmt.bindLong(9, (long)value.getCommentCount());
                stmt.bindLong(10, (long)value.getFlagCount());
                String _tmp_2 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                if (value.getTargetType() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetId());
                }
                if (value.getPostDataType() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getPostDataType());
                }
                String _tmp_4 = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                String _tmp_5 = PostDao_Impl.this.__stringListConverter.stringListToString(value.getChildPostIds());
                if (_tmp_5 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_5);
                }
                String _tmp_6 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getGlobalRank());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                if (value.getFeedType() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getFeedType());
                }
                String _tmp_7 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_7);
                }
                String _tmp_8 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_8);
                }
                if (value.getPostId() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getPostId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from post";
                return "DELETE from post";
            }
        };
        this.__preparedStmtOfDeletePostByPostId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set isDeleted = 1 where postId = ?";
                return "UPDATE post set isDeleted = 1 where postId = ?";
            }
        };
        this.__preparedStmtOfIncrementCommentCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set commentCount = commentCount + 1 where postId = ?";
                return "UPDATE post set commentCount = commentCount + 1 where postId = ?";
            }
        };
        this.__preparedStmtOfDecrementCommentCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set commentCount = commentCount - 1 where postId = ?";
                return "UPDATE post set commentCount = commentCount - 1 where postId = ?";
            }
        };
        this.__preparedStmtOfSetGlobalRank = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set globalRank = ? where postId = ?";
                return "UPDATE post set globalRank = ? where postId = ?";
            }
        };
        this.__preparedStmtOfUpdatePost = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post set postId = postId where postId = ?";
                return "UPDATE post set postId = postId where postId = ?";
            }
        };
        this.__preparedStmtOfUpdateDeletedImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post SET isDeleted = ? WHERE postId LIKE ? ";
                return "UPDATE post SET isDeleted = ? WHERE postId LIKE ? ";
            }
        };
        this.__preparedStmtOfUpdateFeedTypeImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE post SET feedType = ? WHERE postId = ? ";
                return "UPDATE post SET feedType = ? WHERE postId = ? ";
            }
        };
    }

    @Override
    void insertImpl(PostEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPostEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<PostEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPostEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(PostEntity ekoPost) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPostEntity.handle((Object)ekoPost);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<PostEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPostEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(PostEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPostEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(PostEntity object) {
        this.__db.beginTransaction();
        try {
            PostDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<PostEntity> objects) {
        this.__db.beginTransaction();
        try {
            PostDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PostEntity object) {
        this.__db.beginTransaction();
        try {
            PostDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePostByPostId(String postId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeletePostByPostId.acquire();
        int _argIndex = 1;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeletePostByPostId.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementCommentCount(String postId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrementCommentCount.acquire();
        int _argIndex = 1;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfIncrementCommentCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementCommentCount(String postId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDecrementCommentCount.acquire();
        int _argIndex = 1;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDecrementCommentCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalRank(String postId, DateTime globalRank) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetGlobalRank.acquire();
        int _argIndex = 1;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(globalRank);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetGlobalRank.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePost(String postId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePost.acquire();
        int _argIndex = 1;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePost.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateDeletedImpl(String postId, boolean isDeleted) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateDeletedImpl.acquire();
        int _argIndex = 1;
        int _tmp = isDeleted ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateDeletedImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateFeedTypeImpl(String postId, String feedType) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateFeedTypeImpl.acquire();
        int _argIndex = 1;
        if (feedType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, feedType);
        }
        _argIndex = 2;
        if (postId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, postId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateFeedTypeImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<PostEntity> getByIdsNowImpl(List<String> postIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from post where post.postId IN (");
        int _inputSize = postIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : postIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
            int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
            int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
            int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
            int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"globalRank");
            int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<PostEntity> _result = new ArrayList<PostEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                PostEntity _item_1 = new PostEntity();
                String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                _item_1.setPostId(_tmpPostId);
                String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                _item_1.setParentPostId(_tmpParentPostId);
                String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                _item_1.setPostedUserId(_tmpPostedUserId);
                String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                _item_1.setSharedUserId(_tmpSharedUserId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setMetadata(_tmpMetadata);
                int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                _item_1.setSharedCount(_tmpSharedCount);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                _item_1.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item_1.setReactionCount(_tmpReactionCount);
                int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                _item_1.setCommentCount(_tmpCommentCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item_1.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setEditedAt(_tmpEditedAt);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_3 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _item_1.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _item_1.setTargetId(_tmpTargetId);
                String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                _item_1.setPostDataType(_tmpPostDataType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item_1.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                _item_1.setChildPostIds(_tmpChildPostIds);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfGlobalRank) ? null : _cursor.getString(_cursorIndexOfGlobalRank);
                DateTime _tmpGlobalRank = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item_1.setGlobalRank(_tmpGlobalRank);
                String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                _item_1.setFeedType(_tmpFeedType);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<PostEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PostEntity getByIdNowImpl(String postIds) {
        String _sql = "SELECT * from post where post.postId IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post where post.postId IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postIds == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postIds);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PostEntity _result;
            int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
            int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
            int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
            int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
            int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"globalRank");
            int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new PostEntity();
                String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                _result.setPostId(_tmpPostId);
                String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                _result.setParentPostId(_tmpParentPostId);
                String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                _result.setPostedUserId(_tmpPostedUserId);
                String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                _result.setSharedUserId(_tmpSharedUserId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                _result.setSharedCount(_tmpSharedCount);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                _result.setCommentCount(_tmpCommentCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setEditedAt(_tmpEditedAt);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_3 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                _result.setPostDataType(_tmpPostDataType);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _result.setData(_tmpData);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                _result.setChildPostIds(_tmpChildPostIds);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfGlobalRank) ? null : _cursor.getString(_cursorIndexOfGlobalRank);
                DateTime _tmpGlobalRank = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setGlobalRank(_tmpGlobalRank);
                String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                _result.setFeedType(_tmpFeedType);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            PostEntity postEntity = _result;
            return postEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<PostEntity> getPostImpl(String postIds) {
        String _sql = "SELECT * from post where post.postId IN (?) LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post where post.postId IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postIds == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postIds);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post"}, (Callable)new Callable<PostEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PostEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PostEntity _result;
                    int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postId");
                    int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentPostId");
                    int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postedUserId");
                    int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedUserId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sharedCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postDataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childPostIds");
                    int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"globalRank");
                    int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new PostEntity();
                        String _tmpPostId = _cursor.isNull(_cursorIndexOfPostId) ? null : _cursor.getString(_cursorIndexOfPostId);
                        _result.setPostId(_tmpPostId);
                        String _tmpParentPostId = _cursor.isNull(_cursorIndexOfParentPostId) ? null : _cursor.getString(_cursorIndexOfParentPostId);
                        _result.setParentPostId(_tmpParentPostId);
                        String _tmpPostedUserId = _cursor.isNull(_cursorIndexOfPostedUserId) ? null : _cursor.getString(_cursorIndexOfPostedUserId);
                        _result.setPostedUserId(_tmpPostedUserId);
                        String _tmpSharedUserId = _cursor.isNull(_cursorIndexOfSharedUserId) ? null : _cursor.getString(_cursorIndexOfSharedUserId);
                        _result.setSharedUserId(_tmpSharedUserId);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setMetadata(_tmpMetadata);
                        int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                        _result.setSharedCount(_tmpSharedCount);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _result.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_3 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpPostDataType = _cursor.isNull(_cursorIndexOfPostDataType) ? null : _cursor.getString(_cursorIndexOfPostDataType);
                        _result.setPostDataType(_tmpPostDataType);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setData(_tmpData);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfChildPostIds) ? null : _cursor.getString(_cursorIndexOfChildPostIds);
                        List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_5);
                        _result.setChildPostIds(_tmpChildPostIds);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfGlobalRank) ? null : _cursor.getString(_cursorIndexOfGlobalRank);
                        DateTime _tmpGlobalRank = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setGlobalRank(_tmpGlobalRank);
                        String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                        _result.setFeedType(_tmpFeedType);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    PostEntity postEntity = _result;
                    return postEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    PagingSource<Integer, PostEntity> getCommunityFeedPagingSourceImpl(String communityId, String feedType, Boolean isDeleted, String deletedStatus, Boolean isSortedAsc, String sortBy) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from post, community_feed_query_token where post.targetType = 'community' and post.targetId = ?  and post.feedType = ? and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and (community_feed_query_token.communityId = ? and community_feed_query_token.feedType = ? and community_feed_query_token.isDeleted = ? and community_feed_query_token.sortBy = ? and community_feed_query_token.ids like '%' || post.postId || '%') order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post, community_feed_query_token where post.targetType = 'community' and post.targetId = ?  and post.feedType = ? and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and (community_feed_query_token.communityId = ? and community_feed_query_token.feedType = ? and community_feed_query_token.isDeleted = ? and community_feed_query_token.sortBy = ? and community_feed_query_token.ids like '%' || post.postId || '%') order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc", (int)10);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 2;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 3;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 6;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 7;
        if (deletedStatus == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, deletedStatus);
        }
        _argIndex = 8;
        if (sortBy == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sortBy);
        }
        _argIndex = 9;
        Integer n3 = isSortedAsc == null ? null : (_tmp_2 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 10;
        Integer n4 = isSortedAsc == null ? null : (_tmp_3 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return (PagingSource)new DataSource.Factory<Integer, PostEntity>(){

            public LimitOffsetDataSource<PostEntity> create() {
                return new LimitOffsetDataSource<PostEntity>(PostDao_Impl.this.__db, _statement, false, false, new String[]{"post", "community_feed_query_token"}){

                    protected List<PostEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postId");
                        int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentPostId");
                        int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postedUserId");
                        int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedUserId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentCount");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postDataType");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childPostIds");
                        int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"globalRank");
                        int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfFeedType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfIsDeleted_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<PostEntity> _res = new ArrayList<PostEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            PostEntity _item = new PostEntity();
                            String _tmpPostId = cursor.isNull(_cursorIndexOfPostId) ? null : cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.isNull(_cursorIndexOfParentPostId) ? null : cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.isNull(_cursorIndexOfPostedUserId) ? null : cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.isNull(_cursorIndexOfSharedUserId) ? null : cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_7 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_7 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.isNull(_cursorIndexOfPostDataType) ? null : cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_8);
                            _item.setData(_tmpData);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfChildPostIds) ? null : cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_9);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfGlobalRank) ? null : cursor.getString(_cursorIndexOfGlobalRank);
                            DateTime _tmpGlobalRank = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setGlobalRank(_tmpGlobalRank);
                            String _tmpFeedType = cursor.isNull(_cursorIndexOfFeedType) ? null : cursor.getString(_cursorIndexOfFeedType);
                            _item.setFeedType(_tmpFeedType);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmpFeedType_1 = cursor.isNull(_cursorIndexOfFeedType_1) ? null : cursor.getString(_cursorIndexOfFeedType_1);
                            _item.setFeedType(_tmpFeedType_1);
                            int _tmp_13 = cursor.getInt(_cursorIndexOfIsDeleted_1);
                            boolean _tmpIsDeleted_1 = _tmp_13 != 0;
                            _item.setDeleted(_tmpIsDeleted_1);
                            String _tmp_14 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    @Override
    DataSource.Factory<Integer, PostEntity> getCommunityFeedDataSourceImpl(String communityId, String feedType, Boolean isDeleted, String deletedStatus, Boolean isSortedAsc, String sortBy) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from post, community_feed_query_token where post.targetType = 'community' and post.targetId = ?  and post.feedType = ? and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and ((community_feed_query_token.communityId = ? and community_feed_query_token.feedType = ? and community_feed_query_token.isDeleted = ? and community_feed_query_token.sortBy = ? and community_feed_query_token.pageNumber = 1 and community_feed_query_token.ids like '%' || post.postId || '%') or (post.updatedAt > community_feed_query_token.updatedAt)) order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post, community_feed_query_token where post.targetType = 'community' and post.targetId = ?  and post.feedType = ? and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and ((community_feed_query_token.communityId = ? and community_feed_query_token.feedType = ? and community_feed_query_token.isDeleted = ? and community_feed_query_token.sortBy = ? and community_feed_query_token.pageNumber = 1 and community_feed_query_token.ids like '%' || post.postId || '%') or (post.updatedAt > community_feed_query_token.updatedAt)) order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc", (int)10);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 2;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 3;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        _argIndex = 6;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        _argIndex = 7;
        if (deletedStatus == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, deletedStatus);
        }
        _argIndex = 8;
        if (sortBy == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sortBy);
        }
        _argIndex = 9;
        Integer n3 = isSortedAsc == null ? null : (_tmp_2 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 10;
        Integer n4 = isSortedAsc == null ? null : (_tmp_3 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, PostEntity>(){

            public LimitOffsetDataSource<PostEntity> create() {
                return new LimitOffsetDataSource<PostEntity>(PostDao_Impl.this.__db, _statement, false, true, new String[]{"post", "community_feed_query_token"}){

                    protected List<PostEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postId");
                        int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentPostId");
                        int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postedUserId");
                        int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedUserId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentCount");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postDataType");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childPostIds");
                        int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"globalRank");
                        int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfFeedType_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfIsDeleted_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<PostEntity> _res = new ArrayList<PostEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            PostEntity _item = new PostEntity();
                            String _tmpPostId = cursor.isNull(_cursorIndexOfPostId) ? null : cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.isNull(_cursorIndexOfParentPostId) ? null : cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.isNull(_cursorIndexOfPostedUserId) ? null : cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.isNull(_cursorIndexOfSharedUserId) ? null : cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_7 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_7 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.isNull(_cursorIndexOfPostDataType) ? null : cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_8);
                            _item.setData(_tmpData);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfChildPostIds) ? null : cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_9);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfGlobalRank) ? null : cursor.getString(_cursorIndexOfGlobalRank);
                            DateTime _tmpGlobalRank = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setGlobalRank(_tmpGlobalRank);
                            String _tmpFeedType = cursor.isNull(_cursorIndexOfFeedType) ? null : cursor.getString(_cursorIndexOfFeedType);
                            _item.setFeedType(_tmpFeedType);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmpFeedType_1 = cursor.isNull(_cursorIndexOfFeedType_1) ? null : cursor.getString(_cursorIndexOfFeedType_1);
                            _item.setFeedType(_tmpFeedType_1);
                            int _tmp_13 = cursor.getInt(_cursorIndexOfIsDeleted_1);
                            boolean _tmpIsDeleted_1 = _tmp_13 != 0;
                            _item.setDeleted(_tmpIsDeleted_1);
                            String _tmp_14 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    PagingSource<Integer, PostEntity> getUserFeedPagingSourceImpl(String userId, Boolean isDeleted, String deletedStatus, Boolean isSortedAsc, String sortBy) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from post, user_feed_query_token where post.targetType = 'user' and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and (user_feed_query_token.userId = ? and user_feed_query_token.isDeleted = ? and user_feed_query_token.sortBy = ? and user_feed_query_token.ids like '%' || post.postId || '%') order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post, user_feed_query_token where post.targetType = 'user' and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and (user_feed_query_token.userId = ? and user_feed_query_token.isDeleted = ? and user_feed_query_token.sortBy = ? and user_feed_query_token.ids like '%' || post.postId || '%') order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc", (int)8);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 5;
        if (deletedStatus == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, deletedStatus);
        }
        _argIndex = 6;
        if (sortBy == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sortBy);
        }
        _argIndex = 7;
        Integer n3 = isSortedAsc == null ? null : (_tmp_2 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 8;
        Integer n4 = isSortedAsc == null ? null : (_tmp_3 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return (PagingSource)new DataSource.Factory<Integer, PostEntity>(){

            public LimitOffsetDataSource<PostEntity> create() {
                return new LimitOffsetDataSource<PostEntity>(PostDao_Impl.this.__db, _statement, false, false, new String[]{"post", "user_feed_query_token"}){

                    protected List<PostEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postId");
                        int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentPostId");
                        int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postedUserId");
                        int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedUserId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentCount");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postDataType");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childPostIds");
                        int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"globalRank");
                        int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfIsDeleted_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<PostEntity> _res = new ArrayList<PostEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            PostEntity _item = new PostEntity();
                            String _tmpPostId = cursor.isNull(_cursorIndexOfPostId) ? null : cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.isNull(_cursorIndexOfParentPostId) ? null : cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.isNull(_cursorIndexOfPostedUserId) ? null : cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.isNull(_cursorIndexOfSharedUserId) ? null : cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_7 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_7 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.isNull(_cursorIndexOfPostDataType) ? null : cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_8);
                            _item.setData(_tmpData);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfChildPostIds) ? null : cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_9);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfGlobalRank) ? null : cursor.getString(_cursorIndexOfGlobalRank);
                            DateTime _tmpGlobalRank = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setGlobalRank(_tmpGlobalRank);
                            String _tmpFeedType = cursor.isNull(_cursorIndexOfFeedType) ? null : cursor.getString(_cursorIndexOfFeedType);
                            _item.setFeedType(_tmpFeedType);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            int _tmp_13 = cursor.getInt(_cursorIndexOfIsDeleted_1);
                            boolean _tmpIsDeleted_1 = _tmp_13 != 0;
                            _item.setDeleted(_tmpIsDeleted_1);
                            String _tmp_14 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    @Override
    DataSource.Factory<Integer, PostEntity> getUserFeedDataSourceImpl(String userId, Boolean isDeleted, String deletedStatus, Boolean isSortedAsc, String sortBy) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from post, user_feed_query_token where post.targetType = 'user' and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and ((user_feed_query_token.userId = ? and user_feed_query_token.isDeleted = ? and user_feed_query_token.sortBy = ? and user_feed_query_token.pageNumber = 1 and user_feed_query_token.ids like '%' || post.postId || '%') or (post.updatedAt > user_feed_query_token.updatedAt)) order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post, user_feed_query_token where post.targetType = 'user' and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and ((user_feed_query_token.userId = ? and user_feed_query_token.isDeleted = ? and user_feed_query_token.sortBy = ? and user_feed_query_token.pageNumber = 1 and user_feed_query_token.ids like '%' || post.postId || '%') or (post.updatedAt > user_feed_query_token.updatedAt)) order by case when ? = 1 then post.createdAt end asc, case when ? = 0 then post.createdAt end desc", (int)8);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 5;
        if (deletedStatus == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, deletedStatus);
        }
        _argIndex = 6;
        if (sortBy == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, sortBy);
        }
        _argIndex = 7;
        Integer n3 = isSortedAsc == null ? null : (_tmp_2 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 8;
        Integer n4 = isSortedAsc == null ? null : (_tmp_3 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, PostEntity>(){

            public LimitOffsetDataSource<PostEntity> create() {
                return new LimitOffsetDataSource<PostEntity>(PostDao_Impl.this.__db, _statement, false, true, new String[]{"post", "user_feed_query_token"}){

                    protected List<PostEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postId");
                        int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentPostId");
                        int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postedUserId");
                        int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedUserId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentCount");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postDataType");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childPostIds");
                        int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"globalRank");
                        int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfIsDeleted_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<PostEntity> _res = new ArrayList<PostEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            PostEntity _item = new PostEntity();
                            String _tmpPostId = cursor.isNull(_cursorIndexOfPostId) ? null : cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.isNull(_cursorIndexOfParentPostId) ? null : cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.isNull(_cursorIndexOfPostedUserId) ? null : cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.isNull(_cursorIndexOfSharedUserId) ? null : cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_7 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_7 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.isNull(_cursorIndexOfPostDataType) ? null : cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_8);
                            _item.setData(_tmpData);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfChildPostIds) ? null : cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_9);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfGlobalRank) ? null : cursor.getString(_cursorIndexOfGlobalRank);
                            DateTime _tmpGlobalRank = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setGlobalRank(_tmpGlobalRank);
                            String _tmpFeedType = cursor.isNull(_cursorIndexOfFeedType) ? null : cursor.getString(_cursorIndexOfFeedType);
                            _item.setFeedType(_tmpFeedType);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            int _tmp_13 = cursor.getInt(_cursorIndexOfIsDeleted_1);
                            boolean _tmpIsDeleted_1 = _tmp_13 != 0;
                            _item.setDeleted(_tmpIsDeleted_1);
                            String _tmp_14 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, PostEntity> getGlobalPostDataSourceImpl() {
        String _sql = "SELECT * from post, global_feed_query_token where post.isDeleted = 0 and global_feed_query_token.isDeleted = 0 and (global_feed_query_token.ids like '%' || post.postId || '%') and global_feed_query_token.pageNumber = 1 order by post.globalRank asc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post, global_feed_query_token where post.isDeleted = 0 and global_feed_query_token.isDeleted = 0 and (global_feed_query_token.ids like '%' || post.postId || '%') and global_feed_query_token.pageNumber = 1 order by post.globalRank asc", (int)0);
        return new DataSource.Factory<Integer, PostEntity>(){

            public LimitOffsetDataSource<PostEntity> create() {
                return new LimitOffsetDataSource<PostEntity>(PostDao_Impl.this.__db, _statement, false, true, new String[]{"post", "global_feed_query_token"}){

                    protected List<PostEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postId");
                        int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentPostId");
                        int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postedUserId");
                        int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedUserId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentCount");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postDataType");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childPostIds");
                        int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"globalRank");
                        int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfIsDeleted_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<PostEntity> _res = new ArrayList<PostEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            PostEntity _item = new PostEntity();
                            String _tmpPostId = cursor.isNull(_cursorIndexOfPostId) ? null : cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.isNull(_cursorIndexOfParentPostId) ? null : cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.isNull(_cursorIndexOfPostedUserId) ? null : cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.isNull(_cursorIndexOfSharedUserId) ? null : cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_1 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_3 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.isNull(_cursorIndexOfPostDataType) ? null : cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setData(_tmpData);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfChildPostIds) ? null : cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_5);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfGlobalRank) ? null : cursor.getString(_cursorIndexOfGlobalRank);
                            DateTime _tmpGlobalRank = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item.setGlobalRank(_tmpGlobalRank);
                            String _tmpFeedType = cursor.isNull(_cursorIndexOfFeedType) ? null : cursor.getString(_cursorIndexOfFeedType);
                            _item.setFeedType(_tmpFeedType);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            int _tmp_9 = cursor.getInt(_cursorIndexOfIsDeleted_1);
                            boolean _tmpIsDeleted_1 = _tmp_9 != 0;
                            _item.setDeleted(_tmpIsDeleted_1);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    PagingSource<Integer, PostEntity> getGlobalFeedPagingSourceImpl() {
        String _sql = "SELECT * from post, global_feed_query_token where post.isDeleted = 0 and global_feed_query_token.isDeleted = 0 and (global_feed_query_token.ids like '%' || post.postId || '%') order by post.globalRank asc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from post, global_feed_query_token where post.isDeleted = 0 and global_feed_query_token.isDeleted = 0 and (global_feed_query_token.ids like '%' || post.postId || '%') order by post.globalRank asc", (int)0);
        return (PagingSource)new DataSource.Factory<Integer, PostEntity>(){

            public LimitOffsetDataSource<PostEntity> create() {
                return new LimitOffsetDataSource<PostEntity>(PostDao_Impl.this.__db, _statement, false, false, new String[]{"post", "global_feed_query_token"}){

                    protected List<PostEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postId");
                        int _cursorIndexOfParentPostId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentPostId");
                        int _cursorIndexOfPostedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postedUserId");
                        int _cursorIndexOfSharedUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedUserId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfSharedCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sharedCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentCount");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfPostDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postDataType");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfChildPostIds = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childPostIds");
                        int _cursorIndexOfGlobalRank = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"globalRank");
                        int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"feedType");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfIsDeleted_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfUpdatedAt_1 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<PostEntity> _res = new ArrayList<PostEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            PostEntity _item = new PostEntity();
                            String _tmpPostId = cursor.isNull(_cursorIndexOfPostId) ? null : cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.isNull(_cursorIndexOfParentPostId) ? null : cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.isNull(_cursorIndexOfPostedUserId) ? null : cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.isNull(_cursorIndexOfSharedUserId) ? null : cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_1 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = PostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_3 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.isNull(_cursorIndexOfPostDataType) ? null : cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = PostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setData(_tmpData);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfChildPostIds) ? null : cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = PostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_5);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfGlobalRank) ? null : cursor.getString(_cursorIndexOfGlobalRank);
                            DateTime _tmpGlobalRank = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item.setGlobalRank(_tmpGlobalRank);
                            String _tmpFeedType = cursor.isNull(_cursorIndexOfFeedType) ? null : cursor.getString(_cursorIndexOfFeedType);
                            _item.setFeedType(_tmpFeedType);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            int _tmp_9 = cursor.getInt(_cursorIndexOfIsDeleted_1);
                            boolean _tmpIsDeleted_1 = _tmp_9 != 0;
                            _item.setDeleted(_tmpIsDeleted_1);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfUpdatedAt_1) ? null : cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = PostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

