/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption;
import com.amity.socialcloud.sdk.social.community.AmityQuerySortingOrder;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class UserDao
extends EkoObjectDao<UserEntity>
implements AmityPagingDao<UserEntity> {
    @Query(value="SELECT * from user, user_query_token where (user.displayName like '%' || :keyword || '%' or user.userId like '%' || :keyword || '%') and (user_query_token.keyword = :keyword and user_query_token.sortBy = :sortBy and user_query_token.pageNumber = 1 and user_query_token.ids like '%' || user.userId || '%') order by  case when :isTimeRelatedColumn = 1 and :isSortedAsc = 1 then user.createdAt end asc, case when :isTimeRelatedColumn = 1 and :isSortedAsc = 0 then user.createdAt end desc, case when :isTimeRelatedColumn = 0 then user.displayName end asc")
    abstract DataSource.Factory<Integer, UserEntity> getDataSourceImpl(String var1, String var2, Boolean var3, Boolean var4);

    public DataSource.Factory<Integer, UserEntity> getDataSource(String keyword, AmityUserSortOption sortBy) {
        Boolean isTimeRelatedColumn = sortBy.getSortingColumn().equals(AmityUserSortOption.FIRST_CREATED.getSortingColumn()) || sortBy.getSortingColumn().equals(AmityUserSortOption.LAST_CREATED.getSortingColumn());
        return this.getDataSourceImpl(keyword, sortBy.getApiKey(), isTimeRelatedColumn, sortBy.getSortingOrder().equals(AmityQuerySortingOrder.ASC.getSqlOrder()));
    }

    @Query(value="SELECT * from user, user_query_token where (user.displayName like '%' || :keyword || '%' or user.userId like '%' || :keyword || '%') and (user_query_token.keyword = :keyword and user_query_token.sortBy = :sortBy and user_query_token.ids like '%' || user.userId || '%') order by user.displayName asc")
    abstract PagingSource<Integer, UserEntity> getPagingSourceImpl(String var1, String var2);

    public PagingSource<Integer, UserEntity> getPagingSource(String keyword, AmityUserSortOption sortBy) {
        return this.getPagingSourceImpl(keyword, sortBy.getApiKey());
    }

    @Query(value="SELECT * from user where user.userId = :userId LIMIT 1")
    abstract Flowable<UserEntity> getByIdImpl(String var1);

    public Flowable<UserEntity> getById(String userId) {
        return this.getByIdImpl(userId);
    }

    @Query(value="DELETE from user where userId = :userId")
    public abstract void deleteById(String var1);

    @Query(value="SELECT * from user where user.userId = :userId LIMIT 1")
    abstract UserEntity getByIdNowImpl(String var1);

    @Override
    public UserEntity getByIdNow(String userId) {
        return this.getByIdNowImpl(userId);
    }

    @Query(value="SELECT * from user where user.userId IN (:userIds)")
    abstract List<UserEntity> getByIdsNowImpl(List<String> var1);

    @Override
    public List<UserEntity> getByIdsNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Override
    @Query(value="DELETE from user")
    public abstract void deleteAll();
}

