/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.joda.time.DateTime;

@Dao
public abstract class EkoFollowDao
extends EkoObjectDao<EkoUserFollowStatusEntity>
implements AmityPagingDao<EkoUserFollowStatusEntity> {
    @Query(value="UPDATE user_follow set status = :status where targetUserId = :userId")
    public abstract void updateFollowing(String var1, String var2);

    @Query(value="UPDATE user_follow set status = :status where sourceUserId = :userId")
    public abstract void updateFollower(String var1, String var2);

    @Override
    @Query(value="DELETE from user_follow")
    public abstract void deleteAll();

    @Query(value="SELECT * from user_follow where id = :id LIMIT 1")
    abstract EkoUserFollowStatusEntity getByIdNowImpl(String var1);

    @Override
    public EkoUserFollowStatusEntity getByIdNow(String id) {
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT * from user_follow where id IN (:ids)")
    abstract List<EkoUserFollowStatusEntity> getByIdsNowImpl(List<String> var1);

    @Override
    public List<EkoUserFollowStatusEntity> getByIdsNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Query(value="SELECT * from user_follow where sourceUserId = :sourceUserId and targetUserId = :targetUserId LIMIT 1")
    abstract Flowable<EkoUserFollowStatusEntity> getAllByIdImpl(String var1, String var2);

    public Flowable<EkoUserFollowStatusEntity> getUserFollowById(String sourceUserId, String targetUserId) {
        return this.getAllByIdImpl(sourceUserId, targetUserId);
    }

    @Query(value="SELECT * from user_follow, follower_query_token where user_follow.targetUserId = :userId and user_follow.status in (:statuses) and follower_query_token.userId = :userId and follower_query_token.filter = :statusFilter and follower_query_token.pageNumber = 1 and ((follower_query_token.ids like '%' || user_follow.id || '%') or (user_follow.updatedAt > follower_query_token.updatedAt))")
    abstract DataSource.Factory<Integer, EkoUserFollowStatusEntity> getFollowersDataSourceImpl(String var1, List<String> var2, String var3);

    public DataSource.Factory<Integer, EkoUserFollowStatusEntity> getFollowersDataSource(String userId, AmityFollowStatusFilter statusFilter) {
        return this.getFollowersDataSourceImpl(userId, statusFilter.getStatuses(), statusFilter.getApiKey());
    }

    @Query(value="SELECT * from user_follow, following_query_token where user_follow.sourceUserId = :userId and user_follow.status in (:statuses) and following_query_token.userId = :userId and following_query_token.filter = :statusFilter and following_query_token.pageNumber = 1 and ((following_query_token.ids like '%' || user_follow.id || '%') or (user_follow.updatedAt > following_query_token.updatedAt))")
    abstract DataSource.Factory<Integer, EkoUserFollowStatusEntity> getFollowingsDataSourceImpl(String var1, List<String> var2, String var3);

    public DataSource.Factory<Integer, EkoUserFollowStatusEntity> getFollowingsDataSource(String userId, AmityFollowStatusFilter statusFilter) {
        return this.getFollowingsDataSourceImpl(userId, statusFilter.getStatuses(), statusFilter.getApiKey());
    }

    public io.reactivex.Flowable<EkoUserFollowStatusEntity> getLatestFollowing(String userId, List<String> statuses) {
        return this.getLatestFollowingImpl(userId, statuses, DateTime.now());
    }

    @Query(value="SELECT * from user_follow where user_follow.sourceUserId = :userId and user_follow.status in (:statuses) and user_follow.updatedAt > :now order by user_follow.updatedAt  desc limit 1")
    abstract io.reactivex.Flowable<EkoUserFollowStatusEntity> getLatestFollowingImpl(String var1, List<String> var2, DateTime var3);

    public io.reactivex.Flowable<EkoUserFollowStatusEntity> getLatestFollower(String userId, List<String> statuses) {
        return this.getLatestFollowerImpl(userId, statuses, DateTime.now());
    }

    @Query(value="SELECT * from user_follow where user_follow.targetUserId = :userId and user_follow.status in (:statuses) and user_follow.updatedAt > :now order by user_follow.updatedAt  desc limit 1")
    abstract io.reactivex.Flowable<EkoUserFollowStatusEntity> getLatestFollowerImpl(String var1, List<String> var2, DateTime var3);
}

