/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowCountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoFollowCountDao_Impl
extends EkoFollowCountDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoFollowCountEntity> __insertionAdapterOfEkoFollowCountEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoFollowCountEntity> __deletionAdapterOfEkoFollowCountEntity;
    private final EntityDeletionOrUpdateAdapter<EkoFollowCountEntity> __updateAdapterOfEkoFollowCountEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFollowerCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFollowingCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePendingCount;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoFollowCountDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoFollowCountEntity = new EntityInsertionAdapter<EkoFollowCountEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_follow_count` (`userId`,`followerCount`,`followingCount`,`pendingCount`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFollowCountEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getFollowerCount() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)value.getFollowerCount().intValue());
                }
                if (value.getFollowingCount() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getFollowingCount().intValue());
                }
                if (value.getPendingCount() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)value.getPendingCount().intValue());
                }
                String _tmp = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfEkoFollowCountEntity = new EntityDeletionOrUpdateAdapter<EkoFollowCountEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `user_follow_count` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFollowCountEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoFollowCountEntity = new EntityDeletionOrUpdateAdapter<EkoFollowCountEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user_follow_count` SET `userId` = ?,`followerCount` = ?,`followingCount` = ?,`pendingCount` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFollowCountEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getFollowerCount() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)value.getFollowerCount().intValue());
                }
                if (value.getFollowingCount() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getFollowingCount().intValue());
                }
                if (value.getPendingCount() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)value.getPendingCount().intValue());
                }
                String _tmp = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfUpdateFollowerCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE user_follow_count set followerCount = ? where userId = ?";
                return "UPDATE user_follow_count set followerCount = ? where userId = ?";
            }
        };
        this.__preparedStmtOfUpdateFollowingCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE user_follow_count set followingCount = ? where userId = ?";
                return "UPDATE user_follow_count set followingCount = ? where userId = ?";
            }
        };
        this.__preparedStmtOfUpdatePendingCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE user_follow_count set pendingCount = ? where userId = ?";
                return "UPDATE user_follow_count set pendingCount = ? where userId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_follow_count";
                return "DELETE from user_follow_count";
            }
        };
    }

    @Override
    public void insertImpl(EkoFollowCountEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoFollowCountEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends EkoFollowCountEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoFollowCountEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoFollowCountEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoFollowCountEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends EkoFollowCountEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoFollowCountEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(EkoFollowCountEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoFollowCountEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoFollowCountEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFollowCountDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends EkoFollowCountEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoFollowCountDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoFollowCountEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFollowCountDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFollowerCount(String userId, int followerCount) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateFollowerCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)followerCount);
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateFollowerCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFollowingCount(String userId, int followingCount) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateFollowingCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)followingCount);
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateFollowingCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePendingCount(String userId, int pendingCount) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePendingCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)pendingCount);
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePendingCount.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoFollowCountEntity getByIdNowImpl(String userId) {
        String _sql = "SELECT * from user_follow_count where userId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_follow_count where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoFollowCountEntity _result;
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfFollowerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"followerCount");
            int _cursorIndexOfFollowingCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"followingCount");
            int _cursorIndexOfPendingCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pendingCount");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                Integer _tmpFollowerCount = _cursor.isNull(_cursorIndexOfFollowerCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFollowerCount));
                Integer _tmpFollowingCount = _cursor.isNull(_cursorIndexOfFollowingCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFollowingCount));
                Integer _tmpPendingCount = _cursor.isNull(_cursorIndexOfPendingCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPendingCount));
                _result = new EkoFollowCountEntity(_tmpUserId, _tmpFollowerCount, _tmpFollowingCount, _tmpPendingCount);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoFollowCountEntity ekoFollowCountEntity = _result;
            return ekoFollowCountEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoFollowCountEntity> getByIdImpl(String userId) {
        String _sql = "SELECT * from user_follow_count where user_follow_count.userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_follow_count where user_follow_count.userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return androidx.room.rxjava3.RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow_count"}, (Callable)new Callable<EkoFollowCountEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoFollowCountEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoFollowCountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoFollowCountEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFollowerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"followerCount");
                    int _cursorIndexOfFollowingCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"followingCount");
                    int _cursorIndexOfPendingCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pendingCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        Integer _tmpFollowerCount = _cursor.isNull(_cursorIndexOfFollowerCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFollowerCount));
                        Integer _tmpFollowingCount = _cursor.isNull(_cursorIndexOfFollowingCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFollowingCount));
                        Integer _tmpPendingCount = _cursor.isNull(_cursorIndexOfPendingCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPendingCount));
                        _result = new EkoFollowCountEntity(_tmpUserId, _tmpFollowerCount, _tmpFollowingCount, _tmpPendingCount);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoFollowCountEntity ekoFollowCountEntity = _result;
                    return ekoFollowCountEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    io.reactivex.Flowable<List<EkoFollowCountEntity>> getAllByIdImpl(String userId) {
        String _sql = "SELECT * from user_follow_count where user_follow_count.userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_follow_count where user_follow_count.userId = ?", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow_count"}, (Callable)new Callable<List<EkoFollowCountEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoFollowCountEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoFollowCountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFollowerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"followerCount");
                    int _cursorIndexOfFollowingCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"followingCount");
                    int _cursorIndexOfPendingCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pendingCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    ArrayList<EkoFollowCountEntity> _result = new ArrayList<EkoFollowCountEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        Integer _tmpFollowerCount = _cursor.isNull(_cursorIndexOfFollowerCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFollowerCount));
                        Integer _tmpFollowingCount = _cursor.isNull(_cursorIndexOfFollowingCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFollowingCount));
                        Integer _tmpPendingCount = _cursor.isNull(_cursorIndexOfPendingCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPendingCount));
                        EkoFollowCountEntity _item = new EkoFollowCountEntity(_tmpUserId, _tmpFollowerCount, _tmpFollowingCount, _tmpPendingCount);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        _result.add(_item);
                    }
                    ArrayList<EkoFollowCountEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

