/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public final class EkoCommunityCategoryDao_Impl
extends EkoCommunityCategoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommunityCategoryEntity> __insertionAdapterOfCommunityCategoryEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<CommunityCategoryEntity> __deletionAdapterOfCommunityCategoryEntity;
    private final EntityDeletionOrUpdateAdapter<CommunityCategoryEntity> __updateAdapterOfCommunityCategoryEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoCommunityCategoryDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityCategoryEntity = new EntityInsertionAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community_category` (`categoryId`,`name`,`avatarFileId`,`metadata`,`isDeleted`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfCommunityCategoryEntity = new EntityDeletionOrUpdateAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `community_category` WHERE `categoryId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
            }
        };
        this.__updateAdapterOfCommunityCategoryEntity = new EntityDeletionOrUpdateAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `community_category` SET `categoryId` = ?,`name` = ?,`avatarFileId` = ?,`metadata` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `categoryId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                if (value.getCategoryId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCategoryId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from community_category";
                return "DELETE from community_category";
            }
        };
    }

    @Override
    public void insertImpl(CommunityCategoryEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityCategoryEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends CommunityCategoryEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityCategoryEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommunityCategoryEntity category) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityCategoryEntity.handle((Object)category);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends CommunityCategoryEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityCategoryEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(CommunityCategoryEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommunityCategoryEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommunityCategoryDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends CommunityCategoryEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoCommunityCategoryDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommunityCategoryDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, CommunityCategoryEntity> getAllImpl(boolean isSortByName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community_category.name end asc, case when ? = 0 and ? = 1 then community_category.createdAt end asc, case when ? = 0 and ? = 0 then community_category.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community_category.name end asc, case when ? = 0 and ? = 1 then community_category.createdAt end asc, case when ? = 0 and ? = 0 then community_category.createdAt end desc", (int)7);
        int _argIndex = 1;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        int _tmp_2 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 4;
        int _tmp_3 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 5;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 6;
        int _tmp_5 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 7;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityCategoryEntity>(){

            public LimitOffsetDataSource<CommunityCategoryEntity> create() {
                return new LimitOffsetDataSource<CommunityCategoryEntity>(EkoCommunityCategoryDao_Impl.this.__db, _statement, false, true, new String[]{"community_category"}){

                    protected List<CommunityCategoryEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCategoryId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"categoryId");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                        int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"avatarFileId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<CommunityCategoryEntity> _res = new ArrayList<CommunityCategoryEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityCategoryEntity _item = new CommunityCategoryEntity();
                            String _tmpCategoryId = cursor.isNull(_cursorIndexOfCategoryId) ? null : cursor.getString(_cursorIndexOfCategoryId);
                            _item.setCategoryId(_tmpCategoryId);
                            String _tmpName = cursor.isNull(_cursorIndexOfName) ? null : cursor.getString(_cursorIndexOfName);
                            _item.setName(_tmpName);
                            String _tmpAvatarFileId = cursor.isNull(_cursorIndexOfAvatarFileId) ? null : cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            _item.setMetadata(_tmpMetadata);
                            int _tmp_8 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_8 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommunityCategoryEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community_category where community_category.categoryId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCategoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<CommunityCategoryEntity> _result = new ArrayList<CommunityCategoryEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommunityCategoryEntity _item_1 = new CommunityCategoryEntity();
                String _tmpCategoryId = _cursor.isNull(_cursorIndexOfCategoryId) ? null : _cursor.getString(_cursorIndexOfCategoryId);
                _item_1.setCategoryId(_tmpCategoryId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item_1.setName(_tmpName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setMetadata(_tmpMetadata);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<CommunityCategoryEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    PagingSource<Integer, CommunityCategoryEntity> getPagingSourceImpl(boolean isSortByName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community_category.name end asc, case when ? = 0 and ? = 1 then community_category.createdAt end asc, case when ? = 0 and ? = 0 then community_category.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community_category.name end asc, case when ? = 0 and ? = 1 then community_category.createdAt end asc, case when ? = 0 and ? = 0 then community_category.createdAt end desc", (int)7);
        int _argIndex = 1;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        int _tmp_2 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 4;
        int _tmp_3 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 5;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 6;
        int _tmp_5 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 7;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return (PagingSource)new DataSource.Factory<Integer, CommunityCategoryEntity>(){

            public LimitOffsetDataSource<CommunityCategoryEntity> create() {
                return new LimitOffsetDataSource<CommunityCategoryEntity>(EkoCommunityCategoryDao_Impl.this.__db, _statement, false, false, new String[]{"community_category"}){

                    protected List<CommunityCategoryEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCategoryId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"categoryId");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                        int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"avatarFileId");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<CommunityCategoryEntity> _res = new ArrayList<CommunityCategoryEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityCategoryEntity _item = new CommunityCategoryEntity();
                            String _tmpCategoryId = cursor.isNull(_cursorIndexOfCategoryId) ? null : cursor.getString(_cursorIndexOfCategoryId);
                            _item.setCategoryId(_tmpCategoryId);
                            String _tmpName = cursor.isNull(_cursorIndexOfName) ? null : cursor.getString(_cursorIndexOfName);
                            _item.setName(_tmpName);
                            String _tmpAvatarFileId = cursor.isNull(_cursorIndexOfAvatarFileId) ? null : cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            _item.setMetadata(_tmpMetadata);
                            int _tmp_8 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_8 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

