/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amity.socialcloud.sdk.core.AmityConnectionState;
import com.amity.socialcloud.sdk.core.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.socket.AmitySocketException;
import com.amity.socialcloud.sdk.socket.model.SocketRequest;
import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidAddUsersListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidBanListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidCreateListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidDeleteListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidJoinListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidLeaveListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidMarkSeenListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidRemoveUsersListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidUnbanListener;
import com.ekoapp.ekosdk.internal.api.event.ChannelDidUpdateListener;
import com.ekoapp.ekosdk.internal.api.event.MessageDidCreateListener;
import com.ekoapp.ekosdk.internal.api.event.MessageDidDeleteListener;
import com.ekoapp.ekosdk.internal.api.event.MessageDidUpdateListener;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.api.event.StreamDidStartListener;
import com.ekoapp.ekosdk.internal.api.event.StreamDidStopListener;
import com.ekoapp.ekosdk.internal.api.event.UserDidUpdateListener;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.ChatSettingsConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.ChannelStartReadingsRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.GetChatSettingsRequest;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.util.RxEko;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jakewharton.rx.ReplayingShare;
import com.jakewharton.rxrelay2.BehaviorRelay;
import hu.akarnokd.rxjava3.bridge.RxJavaBridge;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.processors.BehaviorProcessor;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.SingleSubject;
import io.socket.client.Ack;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import org.reactivestreams.Publisher;
import timber.log.Timber;

@Deprecated
public class EkoSocket {
    private static final String TAG = EkoSocket.class.getName();
    private static final Socket PROXY = new Socket(null, null, null);
    private static final AtomicInteger rpcId = new AtomicInteger(0);
    private static final EkoSocket INSTANCE = new EkoSocket();
    private static final PublishSubject<AmityGlobalBanEvent> globalBanEventPublisher = PublishSubject.create();
    private final Flowable<EkoAccount> account;
    private final Flowable<Socket> socket;
    private final BehaviorRelay<SocketConnectionEvent> connectionEventRelay = BehaviorRelay.create();

    private EkoSocket() {
        this.account = EkoDatabase.get().accountDao().getCurrentAccountFlowable().doOnNext(acc -> Timber.tag((String)TAG).i("active account changed: %s", new Object[]{acc})).filter(account -> !Strings.isNullOrEmpty((String)account.getAccessToken()));
        EkoAuthenticatedSocket seed = new EkoAuthenticatedSocket(EkoAccount.create("seed"), PROXY);
        this.socket = Flowable.combineLatest(this.account, (Publisher)Flowable.just((Object)PROXY), EkoAuthenticatedSocket::new).subscribeOn(Schedulers.io()).scan((Object)seed, (previous, current) -> {
            EkoAccount oldAccount = previous.account;
            Socket oldSocket = previous.socket;
            EkoAccount newAccount = current.account;
            Socket newSocket = EkoSocket.init(newAccount);
            Timber.tag((String)TAG).e("scan: oldSocket: %s (connected: %s), oldAccount: %s", new Object[]{Integer.toHexString(oldSocket.hashCode()), oldSocket.connected(), oldAccount});
            Timber.tag((String)TAG).e("scan: newSocket: %s (connected: %s), newAccount: %s", new Object[]{Integer.toHexString(newSocket.hashCode()), newSocket.connected(), newAccount});
            if (!PROXY.equals(oldSocket)) {
                oldSocket.disconnect();
                Timber.tag((String)TAG).e("scan: DISCONNECTING oldSocket: %s (connected: %s)", new Object[]{Integer.toHexString(oldSocket.hashCode()), oldSocket.connected()});
            }
            this.autoDisconnectWhenAccountIsInactive(newAccount.getUserId(), newSocket);
            return new EkoAuthenticatedSocket(newAccount, newSocket.connect());
        }).map(auth -> auth.socket).compose((FlowableTransformer)ReplayingShare.instance());
    }

    private void autoDisconnectWhenAccountIsInactive(String userId, Socket socket) {
        CompositeDisposable subscriptions = new CompositeDisposable();
        Disposable subscription = EkoDatabase.get().accountDao().getByIdFlowable(userId).filter(account -> !account.isActive()).doOnNext(account -> {
            subscriptions.clear();
            socket.disconnect();
        }).subscribe();
        subscriptions.add(subscription);
    }

    private static Socket init(EkoAccount account) throws URISyntaxException {
        String userId = account.getUserId();
        String authority = EkoEndpoint.INSTANCE.getSocketUrl();
        Timber.tag((String)TAG).i("init new socket for: %s , url: %s", new Object[]{userId, authority});
        IO.Options options = new IO.Options();
        options.reconnectionDelayMax = 10000L;
        options.transports = new String[]{"websocket"};
        options.query = String.format("token=%s", account.getAccessToken());
        Socket socket = IO.socket((String)authority, (IO.Options)options);
        ImmutableSet events = ImmutableSet.builder().add((Object)"connect").add((Object)"connect_error").add((Object)"connect_timeout").add((Object)"connecting").add((Object)"disconnect").add((Object)"error").add((Object)"reconnect").add((Object)"reconnect_attempt").add((Object)"reconnect_failed").add((Object)"reconnecting").add((Object)"ping").add((Object)"pong").add((Object)"message").build();
        for (String event : events) {
            socket.on(event, args -> {
                Socket currentSocket = (Socket)EkoSocket.INSTANCE.socket.blockingLatest().iterator().next();
                if (Objects.equal((Object)socket, (Object)currentSocket)) {
                    SocketConnectionEvent sce = new SocketConnectionEvent(userId, socket, event, args);
                    EkoSocket.INSTANCE.connectionEventRelay.accept((Object)sce);
                }
            });
        }
        socket.on("disconnect", args -> {
            if (args.length > 0 && Objects.equal((Object)args[0], (Object)"io server disconnect")) {
                socket.connect();
            }
        });
        socket.on("error", args -> {
            try {
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(Arrays.deepToString(args));
                JsonArray array = element.getAsJsonArray();
                JsonObject object = array.get(0).getAsJsonObject();
                AmityException exception = AmityException.create(object.get("message").getAsString(), null, object.get("code").getAsInt());
                if (AmityError.from(exception).is(AmityError.USER_IS_GLOBAL_BANNED)) {
                    globalBanEventPublisher.onNext((Object)new AmityGlobalBanEvent(userId));
                    EkoDatabase.get().accountDao().clearAllUserData(userId);
                }
            }
            catch (Exception e) {
                Timber.tag((String)TAG).e((Throwable)e, String.format("event: error arg: %s", Arrays.deepToString(args)), new Object[0]);
            }
        });
        Completable.fromAction(() -> {
            EkoChannelDao channelDao = UserDatabase.get().channelDao();
            channelDao.deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading();
        }).doOnComplete(() -> socket.on("connect", args -> EkoSocket.callStartReadingOnAllChannelsWithReadingStatus().concatWith((CompletableSource)EkoSocket.fetchChatSettings()).subscribe())).subscribeOn(Schedulers.io()).subscribe();
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidBanListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidCreateListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidJoinListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidLeaveListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidMarkSeenListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidUnbanListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidUpdateListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidAddUsersListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidRemoveUsersListener());
        EkoSocket.subscribeSocketEvent(socket, new ChannelDidDeleteListener());
        EkoSocket.subscribeSocketEvent(socket, new MessageDidCreateListener());
        EkoSocket.subscribeSocketEvent(socket, new MessageDidDeleteListener());
        EkoSocket.subscribeSocketEvent(socket, new MessageDidUpdateListener());
        EkoSocket.subscribeSocketEvent(socket, new UserDidUpdateListener());
        EkoSocket.subscribeSocketEvent(socket, new StreamDidStartListener());
        EkoSocket.subscribeSocketEvent(socket, new StreamDidStopListener());
        return socket;
    }

    private static Completable fetchChatSettings() {
        return EkoSocket.call(Call.create(new GetChatSettingsRequest(), new ChatSettingsConverter())).ignoreElement();
    }

    private static Completable callStartReadingOnAllChannelsWithReadingStatus() {
        EkoChannelExtraDao extraDao = UserDatabase.get().channelExtraDao();
        return RxJavaBridge.toV2Single(extraDao.getAllIdsByReadStatus(EkoChannelReadStatus.READING)).filter(channelIds -> channelIds.size() > 0).flatMapCompletable(channelIds -> EkoSocket.rpc(new ChannelStartReadingsRequest((List<String>)channelIds)).ignoreElement());
    }

    private static void subscribeSocketEvent(@NonNull Socket socket, @NonNull SocketEventListener listener) {
        socket.on(listener.getEvent(), (Emitter.Listener)listener);
    }

    private static Flowable<Socket> socket() {
        BehaviorProcessor socketProcessor = BehaviorProcessor.create();
        EkoSocket.INSTANCE.socket.subscribe((FlowableSubscriber)socketProcessor);
        return socketProcessor;
    }

    public static Flowable<SocketConnectionEvent> connectionEvent() {
        return EkoSocket.INSTANCE.connectionEventRelay.toFlowable(BackpressureStrategy.BUFFER);
    }

    public static Flowable<AmityConnectionState> getConnectionState() {
        return EkoSocket.connectionEvent().map(socketConnectionEvent -> {
            switch (socketConnectionEvent.event) {
                case "connect": {
                    return AmityConnectionState.CONNECTED;
                }
                case "connecting": {
                    return AmityConnectionState.CONNECTING;
                }
                case "disconnect": {
                    return AmityConnectionState.DISCONNECTED;
                }
                case "connect_error": 
                case "reconnect_failed": 
                case "error": {
                    return AmityConnectionState.FAILED;
                }
                case "reconnecting": {
                    return AmityConnectionState.RECONNECTING;
                }
                case "pong": {
                    if (socketConnectionEvent.isConnected) {
                        return AmityConnectionState.CONNECTED;
                    }
                    return AmityConnectionState.DISCONNECTED;
                }
            }
            return AmityConnectionState.UNKNOWN;
        }).filter(amityConnectionState -> amityConnectionState != AmityConnectionState.UNKNOWN).distinctUntilChanged();
    }

    public static <T> Single<T> call(@NonNull Call<T> call2) {
        SingleSubject subject = SingleSubject.create();
        EkoSocket.rpc(call2.getRequest()).map(response -> call2.getConverter().convert((SocketResponse)response)).subscribe((SingleObserver)subject);
        return subject.hide();
    }

    public static Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return globalBanEventPublisher.toFlowable(BackpressureStrategy.BUFFER);
    }

    public static Single<SocketResponse> rpc(@NonNull SocketRequest request2) {
        return EkoSocket.rpc(request2.method(), request2);
    }

    public static Single<SocketResponse> rpc(@NonNull String method) {
        return EkoSocket.rpc(method, null);
    }

    public static Single<SocketResponse> rpc(@NonNull String method, @Nullable Object parameter) {
        SingleSubject responseSubject = SingleSubject.create();
        EkoSocket.socket().subscribeOn(Schedulers.io()).filter(socket -> !Objects.equal((Object)socket, (Object)PROXY)).firstOrError().doOnSuccess(socket -> {
            Timber.tag((String)TAG).i("rpc: socket: %s (connected: %s)", new Object[]{socket, socket.connected()});
            String json = EkoGson.get().toJson(parameter);
            JSONObject orgJson = new JSONObject(json);
            EkoSocket.wrapConnectionError(socket, method, (SingleSubject<SocketResponse>)responseSubject);
            if (socket.connected()) {
                EkoSocket.emit(socket, method, orgJson, (SingleSubject<SocketResponse>)responseSubject);
            } else {
                socket.once("connect", args -> EkoSocket.emit(socket, method, orgJson, (SingleSubject<SocketResponse>)responseSubject));
                Timber.tag((String)TAG).w("rpc: reschedule: %s parameter: %s", new Object[]{method, orgJson});
            }
        }).subscribe();
        return responseSubject.doOnError(RxEko.CATCH_UNAUTHORIZED_ERROR_CONSUMER).hide();
    }

    private static void wrapConnectionError(@NonNull Socket socketio, @NonNull String method, @NonNull SingleSubject<SocketResponse> responseSubject) {
        String[] errors;
        for (String errorEvent : errors = new String[]{"connect_error", "error"}) {
            socketio.once(errorEvent, args -> {
                String msg = errorEvent + ": " + Arrays.deepToString(args);
                int code = AmityError.CONNECTION_ERROR.getCode();
                responseSubject.onError((Throwable)AmitySocketException.Companion.create(msg, code));
                Timber.tag((String)TAG).e("rpc: %s error (%s): %s", new Object[]{method, code, msg});
            });
        }
    }

    private static void emit(@NonNull Socket socket, final @NonNull String method, @Nullable Object parameter, final @NonNull SingleSubject<SocketResponse> responseSubject) {
        final int rpcId = EkoSocket.rpcId.getAndIncrement();
        Timber.tag((String)TAG).i("rpc: %s [%s] parameter: %s", new Object[]{method, rpcId, parameter});
        socket.emit(method, new Object[]{parameter, new Ack(){

            public void call(Object ... args) {
                SocketResponse response = (SocketResponse)EkoGson.get().fromJson(args[0].toString(), SocketResponse.class);
                if (response.isSuccess()) {
                    Timber.tag((String)TAG).i("rpc: %s [%s] success socket response: %s", new Object[]{method, rpcId, Arrays.deepToString(args)});
                    responseSubject.onSuccess((Object)response);
                } else {
                    String msg = response.getMessage();
                    int code = response.getCode();
                    Timber.tag((String)TAG).e("rpc: %s [%s] error socket response (%s): %s", new Object[]{method, rpcId, code, Arrays.deepToString(args)});
                    responseSubject.onError((Throwable)AmitySocketException.Companion.create(msg, code));
                }
            }
        }});
    }

    private static class EkoAuthenticatedSocket {
        final EkoAccount account;
        final Socket socket;

        EkoAuthenticatedSocket(EkoAccount account, Socket socket) {
            this.account = account;
            this.socket = socket;
        }
    }
}

