/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.file;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import co.amity.rxupload.FileProperties;
import co.amity.rxupload.extension.UriKt;
import com.amity.socialcloud.sdk.core.AmityVideo;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.core.file.AmityUploadInfo;
import com.amity.socialcloud.sdk.core.file.AmityUploadResult;
import com.amity.socialcloud.sdk.core.file.AmityUploadService;
import com.amity.socialcloud.sdk.core.file.AmityVideoUploadService;
import com.amity.socialcloud.sdk.core.file.AmityVideoUploadServiceKt;
import com.ekoapp.ekosdk.AmityContentFeedType;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.util.AppContext;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0017B%\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0016H\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/amity/socialcloud/sdk/core/file/AmityVideoUploadService;", "Lcom/amity/socialcloud/sdk/core/file/AmityUploadService;", "Lcom/amity/socialcloud/sdk/core/file/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/core/AmityVideo;", "uri", "Landroid/net/Uri;", "uploadId", "", "feedType", "Lcom/ekoapp/ekosdk/AmityContentFeedType;", "(Landroid/net/Uri;Ljava/lang/String;Lcom/ekoapp/ekosdk/AmityContentFeedType;)V", "getFeedType", "()Lcom/ekoapp/ekosdk/AmityContentFeedType;", "getUploadId", "()Ljava/lang/String;", "getUri", "()Landroid/net/Uri;", "getUploadHeaders", "", "", "getUploadParams", "makeUploadServiceRequest", "Lio/reactivex/Flowable;", "Builder", "amity-sdk_release"})
public final class AmityVideoUploadService
extends AmityUploadService<AmityUploadResult<? extends AmityVideo>> {
    @NotNull
    private final Uri uri;
    @Nullable
    private final String uploadId;
    @Nullable
    private final AmityContentFeedType feedType;

    @Override
    @NotNull
    public Map<String, Object> getUploadParams() {
        Map map;
        if (this.feedType != null) {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)AmityContentFeedType.Companion.getApiKey(), (Object)this.feedType.getApiKey()));
        } else {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadHeaders() {
        boolean bl = false;
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    protected Flowable<AmityUploadResult<AmityVideo>> makeUploadServiceRequest() {
        Flowable flowable;
        Long fileSize;
        AssetFileDescriptor fileDescriptor;
        boolean bl;
        Context context = AppContext.get();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"AppContext.get()");
        ContentResolver contentResolver = context.getContentResolver();
        String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(contentResolver.getType(this.uri));
        if (Intrinsics.areEqual((Object)extension, (Object)"avi") ^ true) {
            long durationTime = 0L;
            MediaPlayer mediaPlayer = MediaPlayer.create((Context)AppContext.get(), (Uri)this.uri);
            boolean bl2 = false;
            boolean bl3 = false;
            MediaPlayer player = mediaPlayer;
            boolean bl4 = false;
            MediaPlayer mediaPlayer2 = player;
            Intrinsics.checkNotNullExpressionValue((Object)mediaPlayer2, (String)"player");
            durationTime = mediaPlayer2.getDuration();
            player.reset();
            player.release();
            bl = durationTime <= AmityVideoUploadServiceKt.access$getMAX_DURATION$p();
        } else {
            bl = true;
        }
        boolean isValidDurationTime = bl;
        AssetFileDescriptor assetFileDescriptor = fileDescriptor = contentResolver.openAssetFileDescriptor(this.uri, "r");
        Long l = fileSize = assetFileDescriptor != null ? Long.valueOf(assetFileDescriptor.getLength()) : null;
        if (isValidDurationTime && fileSize != null && (double)fileSize.longValue() <= 4.0E9) {
            Context context2 = AppContext.get();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"AppContext.get()");
            String string = "files";
            String string2 = this.uploadId;
            Map<String, Object> map = this.getUploadHeaders();
            Map<String, Object> map2 = this.getUploadParams();
            Flowable flowable2 = UriKt.upload((Uri)this.uri, (Context)context2, (String)"api/v4/videos", map, map2, (String)string2, (String)string).flatMap((Function)new Function<FileProperties, Publisher<? extends AmityUploadResult<? extends AmityVideo>>>(this){
                final /* synthetic */ AmityVideoUploadService this$0;

                public final Publisher<? extends AmityUploadResult<AmityVideo>> apply(@NotNull FileProperties it) {
                    Flowable flowable;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it.getProgress() == 100) {
                        Flowable flowable2 = Completable.fromAction((Action)new Action(this, it){
                            final /* synthetic */ makeUploadServiceRequest.1 this$0;
                            final /* synthetic */ FileProperties $it;

                            public final void run() {
                                EkoFileEntity fileEntity = this.this$0.this$0.parseEkoFileEntity(this.$it.getResponseBody());
                                EkoFileDao fileDao = UserDatabase.get().fileDao();
                                fileEntity.setFilePath(this.$it.getUri().getPath());
                                fileDao.insert((EkoObject)fileEntity);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$it = fileProperties;
                            }
                        }).subscribeOn(Schedulers.io()).andThen((Publisher)Flowable.just(new AmityUploadResult.COMPLETE<AmityFileInfo>(new AmityVideo(it))));
                        flowable = flowable2;
                        Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"Completable.fromAction {\u2026OMPLETE(AmityVideo(it))))");
                    } else {
                        Flowable flowable3 = Flowable.just((Object)new AmityUploadResult.PROGRESS(new AmityUploadInfo(it)));
                        flowable = flowable3;
                        Intrinsics.checkNotNullExpressionValue((Object)flowable3, (String)"Flowable.just(AmityUploa\u2026ESS(AmityUploadInfo(it)))");
                    }
                    return (Publisher)flowable;
                }
                {
                    this.this$0 = amityVideoUploadService;
                }
            }).onErrorReturn((Function)new Function<Throwable, AmityUploadResult<? extends AmityVideo>>(this){
                final /* synthetic */ AmityVideoUploadService this$0;

                public final AmityUploadResult<AmityVideo> apply(@NotNull Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AmityException exception = this.this$0.parseErrorResponse(it.getMessage());
                    return new AmityUploadResult.ERROR(exception);
                }
                {
                    this.this$0 = amityVideoUploadService;
                }
            });
            flowable = flowable2;
            Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"uri.upload(context = App\u2026on)\n                    }");
        } else {
            Flowable flowable3 = Flowable.error((Throwable)AmityException.Companion.create("File size exceeded!", null, AmityError.FILE_SIZE_EXCEEDED));
            flowable = flowable3;
            Intrinsics.checkNotNullExpressionValue((Object)flowable3, (String)"Flowable.error(AmityExce\u2026rror.FILE_SIZE_EXCEEDED))");
        }
        return flowable;
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    @Nullable
    public final String getUploadId() {
        return this.uploadId;
    }

    @Nullable
    public final AmityContentFeedType getFeedType() {
        return this.feedType;
    }

    private AmityVideoUploadService(Uri uri, String uploadId, AmityContentFeedType feedType) {
        this.uri = uri;
        this.uploadId = uploadId;
        this.feedType = feedType;
    }

    /* synthetic */ AmityVideoUploadService(Uri uri, String string, AmityContentFeedType amityContentFeedType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            amityContentFeedType = null;
        }
        this(uri, string, amityContentFeedType);
    }

    public /* synthetic */ AmityVideoUploadService(Uri uri, String uploadId, AmityContentFeedType feedType, DefaultConstructorMarker $constructor_marker) {
        this(uri, uploadId, feedType);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/core/file/AmityVideoUploadService$Builder;", "", "()V", "feedType", "Lcom/ekoapp/ekosdk/AmityContentFeedType;", "uploadId", "", "uri", "Landroid/net/Uri;", "build", "Lcom/amity/socialcloud/sdk/core/file/AmityVideoUploadService;", "fileUri", "fileUri$amity_sdk_release", "amity-sdk_release"})
    public static final class Builder {
        private Uri uri;
        private String uploadId;
        private AmityContentFeedType feedType;

        @NotNull
        public final Builder fileUri$amity_sdk_release(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        @NotNull
        public final Builder uploadId(@NotNull String uploadId) {
            Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
            this.uploadId = uploadId;
            return this;
        }

        @NotNull
        public final Builder feedType(@NotNull AmityContentFeedType feedType) {
            Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
            this.feedType = feedType;
            return this;
        }

        @NotNull
        public final AmityVideoUploadService build() {
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            }
            return new AmityVideoUploadService(uri, this.uploadId, this.feedType, null);
        }
    }
}

