/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.community;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.social.community.AmityCommunity;
import com.amity.socialcloud.sdk.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.social.community.AmityCommunitySortOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.CommunityDeleteConverter;
import com.ekoapp.ekosdk.internal.api.socket.call.CommunityListQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityCreateByAdminRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityCreateRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityDeleteByIdRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityGetByIdRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityJoinRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityLeaveRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUpdateByAdminRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUpdateRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoCommunityBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoRecommendedCommunityBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoTrendingCommunityBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.repository.community.CommunityRepository$WhenMappings;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityRepositoryHelper;
import com.google.gson.JsonObject;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Ja\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0011Ju\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007JC\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&2\u0006\u0010\u0018\u001a\u00020\u0007JA\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050(0&2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u001bH\u0002J\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050(0&J\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050(0&J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J[\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00100Jo\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102\u00a8\u00063"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/community/CommunityRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createCommunity", "Lio/reactivex/Single;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunity;", "displayName", "", "description", "categoryIds", "", "isPublic", "", "metadata", "Lcom/google/gson/JsonObject;", "userIds", "avatarFileId", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/util/List;Ljava/lang/String;)Lio/reactivex/Single;", "createCommunityByAdmin", "isOfficial", "onlyAdminCanPost", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Lcom/google/gson/JsonObject;Ljava/util/List;Ljava/lang/String;)Lio/reactivex/Single;", "deleteCommunity", "Lio/reactivex/Completable;", "communityId", "getAllCommunity", "Landroidx/paging/DataSource$Factory;", "", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "keyword", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;", "isDeleted", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;Ljava/lang/Boolean;)Landroidx/paging/DataSource$Factory;", "getCommunity", "Lio/reactivex/Flowable;", "getCommunityCollection", "Landroidx/paging/PagedList;", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/social/community/AmityCommunitySortOption;Ljava/lang/Boolean;)Lio/reactivex/Flowable;", "getDefaultPageSize", "getRecommendedCommunities", "getTrendingCommunities", "joinCommunity", "leaveCommunity", "updateCommunity", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;Lcom/google/gson/JsonObject;Ljava/lang/String;)Lio/reactivex/Single;", "updateCommunityByAdmin", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Lcom/google/gson/JsonObject;Ljava/lang/String;)Lio/reactivex/Single;", "amity-sdk_release"})
public final class CommunityRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Single<AmityCommunity> createCommunity(@NotNull String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable List<String> userIds, @Nullable String avatarFileId) {
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        CommunityCreateRequest request = new CommunityCreateRequest(displayName, description, categoryIds, isPublic, metadata, userIds, avatarFileId);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Single<AmityCommunity> createCommunityByAdmin(@NotNull String displayName, @Nullable String description, @Nullable Boolean isOfficial, @Nullable Boolean isPublic, @Nullable Boolean onlyAdminCanPost, @Nullable List<String> categoryIds, @Nullable JsonObject metadata, @Nullable List<String> userIds, @Nullable String avatarFileId) {
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        CommunityCreateByAdminRequest request = new CommunityCreateByAdminRequest(displayName, description, isOfficial, isPublic, onlyAdminCanPost, categoryIds, metadata, userIds, avatarFileId);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunity>> getCommunityCollection(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortBy, @Nullable Boolean isDeleted) {
        Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
        Intrinsics.checkParameterIsNotNull((Object)categoryId, (String)"categoryId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortBy), (String)"sortBy");
        DataSource.Factory factory2 = this.getAllCommunity(keyword, categoryId, filter, sortBy, isDeleted).map(CommunityRepositoryHelper.INSTANCE.getFactoryMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"getAllCommunity(\n       \u2026toryHelper.factoryMapper)");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoCommunityBoundaryCallback boundaryCallback = new EkoCommunityBoundaryCallback(keyword, categoryId, filter, sortBy, isDeleted, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory4 = factory3.map((Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunity>> getRecommendedCommunities() {
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        DataSource.Factory factory2 = communityDao.getRecommendedCommunityCollection().map(CommunityRepositoryHelper.INSTANCE.getFactoryMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"communityDao.getRecommen\u2026toryHelper.factoryMapper)");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoRecommendedCommunityBoundaryCallback boundaryCallback = new EkoRecommendedCommunityBoundaryCallback(this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory4 = factory3.map((Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunity>> getTrendingCommunities() {
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        DataSource.Factory factory2 = communityDao.getTrendingCommunityCollection().map(CommunityRepositoryHelper.INSTANCE.getFactoryMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"communityDao.getTrending\u2026toryHelper.factoryMapper)");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoTrendingCommunityBoundaryCallback boundaryCallback = new EkoTrendingCommunityBoundaryCallback(this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory4 = factory3.map((Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<AmityCommunity> getCommunity(@NotNull String communityId) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        CommunityGetByIdRequest request = new CommunityGetByIdRequest(communityId);
        CommunityListQueryConverter converter2 = new CommunityListQueryConverter();
        EkoSocket.call(Call.create(request, converter2));
        Flowable flowable = communityDao.getByCommunityId(communityId).map(CommunityRepositoryHelper.INSTANCE.getQueryMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"communityDao.getByCommun\u2026sitoryHelper.queryMapper)");
        return flowable;
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        CommunityDeleteByIdRequest request = new CommunityDeleteByIdRequest(communityId);
        CommunityDeleteConverter converter2 = new CommunityDeleteConverter(communityId);
        Completable completable = EkoSocket.call(Call.create(request, converter2)).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Single<AmityCommunity> updateCommunity(@NotNull String communityId, @Nullable String displayName, @Nullable String description, @Nullable List<String> categoryIds, @Nullable Boolean isPublic, @Nullable JsonObject metadata, @Nullable String avatarFileId) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        String string = avatarFileId;
        JsonObject jsonObject = metadata;
        Boolean bl = isPublic;
        List<String> list = categoryIds;
        CommunityUpdateRequest request = new CommunityUpdateRequest(communityId, displayName, description, bl, list, jsonObject, string);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Single<AmityCommunity> updateCommunityByAdmin(@NotNull String communityId, @Nullable String displayName, @Nullable String description, @Nullable Boolean isOfficial, @Nullable Boolean isPublic, @Nullable Boolean onlyAdminCanPost, @Nullable List<String> categoryIds, @Nullable JsonObject metadata, @Nullable String avatarFileId) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        CommunityUpdateByAdminRequest request = new CommunityUpdateByAdminRequest(communityId, displayName, description, isOfficial, isPublic, onlyAdminCanPost, categoryIds, metadata, avatarFileId);
        Single single = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).map(CommunityRepositoryHelper.INSTANCE.getSingleRequestMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026lper.singleRequestMapper)");
        return single;
    }

    @NotNull
    public final Completable joinCommunity(@NotNull String communityId) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        CommunityJoinRequest request = new CommunityJoinRequest(communityId);
        CommunityListQueryConverter converter2 = new CommunityListQueryConverter();
        Completable completable = EkoSocket.call(Call.create(request, converter2)).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026nverter)).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable leaveCommunity(@NotNull String communityId) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        CommunityLeaveRequest request = new CommunityLeaveRequest(communityId);
        CommunityListQueryConverter converter2 = new CommunityListQueryConverter();
        Completable completable = EkoSocket.call(Call.create(request, converter2)).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026nverter)).ignoreElement()");
        return completable;
    }

    private final DataSource.Factory<Integer, CommunityEntity> getAllCommunity(String keyword, String categoryId, AmityCommunityFilter filter, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        DataSource.Factory<Integer, CommunityEntity> factory2;
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        switch (CommunityRepository$WhenMappings.$EnumSwitchMapping$0[filter.ordinal()]) {
            case 1: {
                DataSource.Factory<Integer, CommunityEntity> factory3;
                CharSequence charSequence = categoryId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    DataSource.Factory<Integer, CommunityEntity> factory4 = communityDao.getAllByKeywordForMember(keyword, sortBy, isDeleted);
                    factory3 = factory4;
                    Intrinsics.checkExpressionValueIsNotNull(factory4, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
                } else {
                    DataSource.Factory<Integer, CommunityEntity> factory5 = communityDao.getAllByCategoryIdForMember(keyword, categoryId, sortBy, isDeleted);
                    factory3 = factory5;
                    Intrinsics.checkExpressionValueIsNotNull(factory5, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
                }
                return factory3;
            }
            case 2: {
                DataSource.Factory<Integer, CommunityEntity> factory6;
                CharSequence charSequence = categoryId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    DataSource.Factory<Integer, CommunityEntity> factory7 = communityDao.getAllByKeywordForNonMember(keyword, sortBy, isDeleted);
                    factory6 = factory7;
                    Intrinsics.checkExpressionValueIsNotNull(factory7, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
                } else {
                    DataSource.Factory<Integer, CommunityEntity> factory8 = communityDao.getAllByCategoryIdForNonMember(keyword, categoryId, sortBy, isDeleted);
                    factory6 = factory8;
                    Intrinsics.checkExpressionValueIsNotNull(factory8, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
                }
                return factory6;
            }
        }
        CharSequence charSequence = categoryId;
        boolean bl = false;
        if (charSequence.length() == 0) {
            DataSource.Factory<Integer, CommunityEntity> factory9 = communityDao.getAllByKeyword(keyword, sortBy, isDeleted);
            factory2 = factory9;
            Intrinsics.checkExpressionValueIsNotNull(factory9, (String)"communityDao.getAllByKey\u2026yword, sortBy, isDeleted)");
        } else {
            DataSource.Factory<Integer, CommunityEntity> factory10 = communityDao.getAllByCategoryId(keyword, categoryId, sortBy, isDeleted);
            factory2 = factory10;
            Intrinsics.checkExpressionValueIsNotNull(factory10, (String)"communityDao.getAllByCat\u2026oryId, sortBy, isDeleted)");
        }
        return factory2;
    }
}

