/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.push;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amity.socialcloud.sdk.push.EkoPushContract;
import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoBaiduToken;
import com.ekoapp.ekosdk.internal.data.model.EkoFcmToken;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import com.ekoapp.ekosdk.internal.util.AppContext;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import org.reactivestreams.Publisher;
import timber.log.Timber;

public class EkoPushContractImpl
implements EkoPushContract {
    private static Flowable<EkoPushConfig> PUSH_CONFIG = EkoDatabase.get().accountDao().getAll().flatMapIterable(accounts -> accounts).distinct(EkoAccount::getUserId).flatMap(account -> EkoDatabase.get().pushConfigDao().getPushConfig(account.getUserId()).distinctUntilChanged(config -> config));
    private static Flowable<EkoApiKey> API_KEY = EkoDatabase.get().apiKeyDao().getCurrentApiKeyFlowable();

    public EkoPushContractImpl() {
        this.initPushService();
    }

    private void initPushService() {
        AppContext.getFlowable().doOnNext(context -> {
            if (this.hasGooglePlayServices((Context)context)) {
                this.initFcm();
            } else {
                this.initBaidu();
            }
        }).subscribe();
    }

    private void initFcm() {
        Flowable.combineLatest((Publisher)EkoDatabase.get().fcmTokenDao().getFcmToken().distinctUntilChanged(fcmToken -> fcmToken), PUSH_CONFIG, API_KEY, (x$0, x$1, x$2) -> new TokenConfigAndApiKey(x$0, (EkoPushConfig)x$1, (EkoApiKey)x$2)).flatMapSingle(tokenConfigAndApiKey -> {
            if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getState()))) {
                RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.create(((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getUserId(), ((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getDeviceId(), ((EkoFcmToken)((TokenConfigAndApiKey)tokenConfigAndApiKey).token).getToken(), Provider.FCM.getApiKey());
                Timber.tag((String)this.getClass().getName()).i(String.format("fcm registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
                return EkoApi.INSTANCE.notification().registerNotificationToken(((TokenConfigAndApiKey)tokenConfigAndApiKey).apiKey.getApiKey(), request);
            }
            UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getUserId(), ((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getDeviceId());
            Timber.tag((String)this.getClass().getName()).i(String.format("fcm un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
            return EkoApi.INSTANCE.notification().unregisterNotificationToken(((TokenConfigAndApiKey)tokenConfigAndApiKey).apiKey.getApiKey(), request);
        }).doOnNext(response -> Timber.tag((String)this.getClass().getName()).i(String.format("fcm response:%s", new Gson().toJson(response)), new Object[0])).subscribeOn(Schedulers.io()).subscribe();
    }

    private void initBaidu() {
        Flowable.combineLatest((Publisher)EkoDatabase.get().baiduTokenDao().getBaiduToken().distinctUntilChanged(baiduToken -> baiduToken), PUSH_CONFIG, API_KEY, (x$0, x$1, x$2) -> new TokenConfigAndApiKey(x$0, (EkoPushConfig)x$1, (EkoApiKey)x$2)).filter(tokenConfigAndApiKey -> ((EkoBaiduToken)((TokenConfigAndApiKey)tokenConfigAndApiKey).token).getUserId() != null && ((EkoBaiduToken)((TokenConfigAndApiKey)tokenConfigAndApiKey).token).getChannelId() != null).flatMapSingle(tokenConfigAndApiKey -> {
            if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getState()))) {
                RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.create(((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getUserId(), ((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getDeviceId(), new Gson().toJson((Object)new RegisterDeviceForPushNotificationRequest.BaiduToken(((EkoBaiduToken)((TokenConfigAndApiKey)tokenConfigAndApiKey).token).getToken(), ((EkoBaiduToken)((TokenConfigAndApiKey)tokenConfigAndApiKey).token).getUserId(), ((EkoBaiduToken)((TokenConfigAndApiKey)tokenConfigAndApiKey).token).getChannelId())), Provider.BAIDU.apiKey);
                Timber.tag((String)this.getClass().getName()).i(String.format("baidu registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
                return EkoApi.INSTANCE.notification().registerNotificationToken(((TokenConfigAndApiKey)tokenConfigAndApiKey).apiKey.getApiKey(), request);
            }
            UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.create(((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getUserId(), ((TokenConfigAndApiKey)tokenConfigAndApiKey).config.getDeviceId());
            Timber.tag((String)this.getClass().getName()).i(String.format("baidu un-registration request:%s", new Gson().toJson((Object)request)), new Object[0]);
            return EkoApi.INSTANCE.notification().unregisterNotificationToken(((TokenConfigAndApiKey)tokenConfigAndApiKey).apiKey.getApiKey(), request);
        }).doOnNext(response -> Timber.tag((String)this.getClass().getName()).i(String.format("baidu response:%s", new Gson().toJson(response)), new Object[0])).subscribeOn(Schedulers.io()).subscribe();
    }

    public Completable insertBaiduApiKey(@NonNull String apiKey) {
        return Completable.fromAction(() -> EkoDatabase.get().baiduTokenDao().insertOrUpdate(new EkoBaiduToken(apiKey)));
    }

    public Completable updateBaiduToken(@Nullable String token, @Nullable String userId, @Nullable String channelId) {
        return Completable.fromAction(() -> EkoDatabase.get().baiduTokenDao().updateToken(token, userId, channelId));
    }

    public Completable insertFcmToken(@NonNull String fcmToken) {
        return Completable.fromAction(() -> EkoDatabase.get().fcmTokenDao().insert(new EkoFcmToken(fcmToken)));
    }

    public Flowable<Boolean> hasRegisteredConfig() {
        return EkoDatabase.get().pushConfigDao().hasRegisteredConfig();
    }

    public boolean hasGooglePlayServices(@NonNull Context context) {
        GoogleApiAvailability googleApi = GoogleApiAvailability.getInstance();
        int result = googleApi.isGooglePlayServicesAvailable(context);
        if (0 == result) {
            return true;
        }
        Timber.tag((String)this.getClass().getName()).i(String.format("Google play services is not available connection_result:%s", result), new Object[0]);
        return false;
    }

    private class TokenConfigAndApiKey<TOKEN> {
        private TOKEN token;
        private EkoPushConfig config;
        private EkoApiKey apiKey;

        private TokenConfigAndApiKey(TOKEN token, EkoPushConfig config, EkoApiKey apiKey) {
            this.token = token;
            this.config = config;
            this.apiKey = apiKey;
        }
    }

    static enum Provider {
        FCM("fcm"),
        BAIDU("baidu");

        private final String apiKey;

        private Provider(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getApiKey() {
            return this.apiKey;
        }
    }
}

