/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.TrendingCommunityDao;
import com.ekoapp.ekosdk.internal.data.model.TrendingCommunityEntity;
import java.util.List;
import org.joda.time.DateTime;

public final class TrendingCommunityDao_Impl
extends TrendingCommunityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfTrendingCommunityEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfTrendingCommunityEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfTrendingCommunityEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public TrendingCommunityDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTrendingCommunityEntity = new EntityInsertionAdapter<TrendingCommunityEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `trending_community`(`communityId`,`createdAt`,`updatedAt`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, TrendingCommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                String _tmp = TrendingCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = TrendingCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfTrendingCommunityEntity = new EntityDeletionOrUpdateAdapter<TrendingCommunityEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `trending_community` WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TrendingCommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
            }
        };
        this.__updateAdapterOfTrendingCommunityEntity = new EntityDeletionOrUpdateAdapter<TrendingCommunityEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `trending_community` SET `communityId` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TrendingCommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                String _tmp = TrendingCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = TrendingCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getCommunityId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from trending_community";
                return "DELETE from trending_community";
            }
        };
    }

    @Override
    void insertImpl(TrendingCommunityEntity object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTrendingCommunityEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<TrendingCommunityEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTrendingCommunityEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(TrendingCommunityEntity object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfTrendingCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<TrendingCommunityEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfTrendingCommunityEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(TrendingCommunityEntity object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfTrendingCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(TrendingCommunityEntity object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<TrendingCommunityEntity> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(TrendingCommunityEntity object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TrendingCommunityEntity getByIdNowImpl(String communityId) {
        String _sql = "SELECT * from trending_community where communityId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from trending_community where communityId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            TrendingCommunityEntity _result;
            int _cursorIndexOfCommunityId = _cursor.getColumnIndexOrThrow("communityId");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new TrendingCommunityEntity();
                String _tmpCommunityId = _cursor.getString(_cursorIndexOfCommunityId);
                _result.setCommunityId(_tmpCommunityId);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            TrendingCommunityEntity trendingCommunityEntity = _result;
            return trendingCommunityEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

