/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.EkoStandardPost;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoStandardPostDao;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoStandardPostDao_Impl
extends EkoStandardPostDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoStandardPost;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEkoStandardPost;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfEkoStandardPost;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeletePostByPostId;
    private final SharedSQLiteStatement __preparedStmtOfIncrementCommentCount;
    private final SharedSQLiteStatement __preparedStmtOfDecrementCommentCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePost;
    private final SharedSQLiteStatement __preparedStmtOfUpdateDeletedImpl;

    public EkoStandardPostDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoStandardPost = new EntityInsertionAdapter<EkoStandardPost>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `standard_post`(`postId`,`parentPostId`,`postedUserId`,`sharedUserId`,`metadata`,`sharedCount`,`reactions`,`reactionCount`,`commentCount`,`flagCount`,`editedAt`,`isDeleted`,`targetType`,`targetId`,`postDataType`,`data`,`childPostIds`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStandardPost value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                if (value.getParentPostId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getParentPostId());
                }
                if (value.getPostedUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPostedUserId());
                }
                if (value.getSharedUserId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSharedUserId());
                }
                String _tmp = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                stmt.bindLong(6, (long)value.getSharedCount());
                String _tmp_1 = EkoStandardPostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, (long)value.getReactionCount());
                stmt.bindLong(9, (long)value.getCommentCount());
                stmt.bindLong(10, (long)value.getFlagCount());
                String _tmp_2 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                if (value.getTargetType() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetId());
                }
                if (value.getPostDataType() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getPostDataType());
                }
                String _tmp_4 = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                String _tmp_5 = EkoStandardPostDao_Impl.this.__stringListConverter.stringListToString(value.getChildPostIds());
                if (_tmp_5 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_5);
                }
                String _tmp_6 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                String _tmp_7 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_7);
                }
            }
        };
        this.__deletionAdapterOfEkoStandardPost = new EntityDeletionOrUpdateAdapter<EkoStandardPost>(__db){

            public String createQuery() {
                return "DELETE FROM `standard_post` WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStandardPost value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
            }
        };
        this.__updateAdapterOfEkoStandardPost = new EntityDeletionOrUpdateAdapter<EkoStandardPost>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `standard_post` SET `postId` = ?,`parentPostId` = ?,`postedUserId` = ?,`sharedUserId` = ?,`metadata` = ?,`sharedCount` = ?,`reactions` = ?,`reactionCount` = ?,`commentCount` = ?,`flagCount` = ?,`editedAt` = ?,`isDeleted` = ?,`targetType` = ?,`targetId` = ?,`postDataType` = ?,`data` = ?,`childPostIds` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStandardPost value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                if (value.getParentPostId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getParentPostId());
                }
                if (value.getPostedUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPostedUserId());
                }
                if (value.getSharedUserId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSharedUserId());
                }
                String _tmp = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                stmt.bindLong(6, (long)value.getSharedCount());
                String _tmp_1 = EkoStandardPostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, (long)value.getReactionCount());
                stmt.bindLong(9, (long)value.getCommentCount());
                stmt.bindLong(10, (long)value.getFlagCount());
                String _tmp_2 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                int _tmp_3 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_3);
                if (value.getTargetType() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetId());
                }
                if (value.getPostDataType() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getPostDataType());
                }
                String _tmp_4 = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                String _tmp_5 = EkoStandardPostDao_Impl.this.__stringListConverter.stringListToString(value.getChildPostIds());
                if (_tmp_5 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_5);
                }
                String _tmp_6 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                String _tmp_7 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_7);
                }
                if (value.getPostId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getPostId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from standard_post";
                return "DELETE from standard_post";
            }
        };
        this.__preparedStmtOfDeletePostByPostId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE standard_post set isDeleted = 1 where postId = ?";
                return "UPDATE standard_post set isDeleted = 1 where postId = ?";
            }
        };
        this.__preparedStmtOfIncrementCommentCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE standard_post set commentCount = commentCount + 1 where postId = ?";
                return "UPDATE standard_post set commentCount = commentCount + 1 where postId = ?";
            }
        };
        this.__preparedStmtOfDecrementCommentCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE standard_post set commentCount = commentCount - 1 where postId = ?";
                return "UPDATE standard_post set commentCount = commentCount - 1 where postId = ?";
            }
        };
        this.__preparedStmtOfUpdatePost = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE standard_post set postId = postId where postId = ?";
                return "UPDATE standard_post set postId = postId where postId = ?";
            }
        };
        this.__preparedStmtOfUpdateDeletedImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE standard_post SET isDeleted = ? WHERE postId LIKE ? ";
                return "UPDATE standard_post SET isDeleted = ? WHERE postId LIKE ? ";
            }
        };
    }

    @Override
    void insertImpl(EkoStandardPost object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoStandardPost.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoStandardPost> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoStandardPost.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoStandardPost> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoStandardPost.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoStandardPost ekoPost) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoStandardPost.handle((Object)ekoPost);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoStandardPost object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoStandardPost.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoStandardPost object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoStandardPost> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoStandardPost object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePostByPostId(String postId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeletePostByPostId.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (postId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, postId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeletePostByPostId.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementCommentCount(String postId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrementCommentCount.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (postId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, postId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfIncrementCommentCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementCommentCount(String postId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDecrementCommentCount.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (postId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, postId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDecrementCommentCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePost(String postId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePost.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (postId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, postId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePost.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateDeletedImpl(String postId, boolean isDeleted) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateDeletedImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            int _tmp = isDeleted ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            _argIndex = 2;
            if (postId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, postId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateDeletedImpl.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, EkoStandardPost> getAllByTargetTypeAndTargetIdOrderByCreatedAtAscImpl(String targetType, String targetId, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.targetType= ? and standard_post.isDeleted = (case when ? is null then isDeleted else ? end) and standard_post.targetId = ?  and standard_post.postId = post_flag.postId and standard_post.parentPostId is null order by createdAt ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.targetType= ? and standard_post.isDeleted = (case when ? is null then isDeleted else ? end) and standard_post.targetId = ?  and standard_post.postId = post_flag.postId and standard_post.parentPostId is null order by createdAt ASC", (int)4);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        return new DataSource.Factory<Integer, EkoStandardPost>(){

            public LimitOffsetDataSource<EkoStandardPost> create() {
                return new LimitOffsetDataSource<EkoStandardPost>(EkoStandardPostDao_Impl.this.__db, _statement, true, new String[]{"standard_post", "post_flag"}){

                    protected List<EkoStandardPost> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = cursor.getColumnIndexOrThrow("postId");
                        int _cursorIndexOfParentPostId = cursor.getColumnIndexOrThrow("parentPostId");
                        int _cursorIndexOfPostedUserId = cursor.getColumnIndexOrThrow("postedUserId");
                        int _cursorIndexOfSharedUserId = cursor.getColumnIndexOrThrow("sharedUserId");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfSharedCount = cursor.getColumnIndexOrThrow("sharedCount");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfCommentCount = cursor.getColumnIndexOrThrow("commentCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfTargetType = cursor.getColumnIndexOrThrow("targetType");
                        int _cursorIndexOfTargetId = cursor.getColumnIndexOrThrow("targetId");
                        int _cursorIndexOfPostDataType = cursor.getColumnIndexOrThrow("postDataType");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfChildPostIds = cursor.getColumnIndexOrThrow("childPostIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoStandardPost> _res = new ArrayList<EkoStandardPost>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoStandardPost _item = new EkoStandardPost();
                            String _tmpPostId = cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoStandardPostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_4 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_5 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_5 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_6 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                            _item.setData(_tmpData);
                            String _tmp_7 = cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = EkoStandardPostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_7);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_8 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_9 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoStandardPost> getAllByTargetTypeAndTargetIdOrderByCreatedAtDescImpl(String targetType, String targetId, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.targetType= ? and standard_post.isDeleted = (case when ? is null then isDeleted else ? end) and standard_post.targetId = ?  and standard_post.postId = post_flag.postId and standard_post.parentPostId is null order by createdAt DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.targetType= ? and standard_post.isDeleted = (case when ? is null then isDeleted else ? end) and standard_post.targetId = ?  and standard_post.postId = post_flag.postId and standard_post.parentPostId is null order by createdAt DESC", (int)4);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        return new DataSource.Factory<Integer, EkoStandardPost>(){

            public LimitOffsetDataSource<EkoStandardPost> create() {
                return new LimitOffsetDataSource<EkoStandardPost>(EkoStandardPostDao_Impl.this.__db, _statement, true, new String[]{"standard_post", "post_flag"}){

                    protected List<EkoStandardPost> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = cursor.getColumnIndexOrThrow("postId");
                        int _cursorIndexOfParentPostId = cursor.getColumnIndexOrThrow("parentPostId");
                        int _cursorIndexOfPostedUserId = cursor.getColumnIndexOrThrow("postedUserId");
                        int _cursorIndexOfSharedUserId = cursor.getColumnIndexOrThrow("sharedUserId");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfSharedCount = cursor.getColumnIndexOrThrow("sharedCount");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfCommentCount = cursor.getColumnIndexOrThrow("commentCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfTargetType = cursor.getColumnIndexOrThrow("targetType");
                        int _cursorIndexOfTargetId = cursor.getColumnIndexOrThrow("targetId");
                        int _cursorIndexOfPostDataType = cursor.getColumnIndexOrThrow("postDataType");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfChildPostIds = cursor.getColumnIndexOrThrow("childPostIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoStandardPost> _res = new ArrayList<EkoStandardPost>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoStandardPost _item = new EkoStandardPost();
                            String _tmpPostId = cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoStandardPostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_4 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_5 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_5 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_6 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                            _item.setData(_tmpData);
                            String _tmp_7 = cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = EkoStandardPostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_7);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_8 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_9 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoStandardPost> getGlobalPostCollectionImpl() {
        String _sql = "SELECT standard_post.*, global_post.* from standard_post, global_post where standard_post.postId = global_post.postId order by global_post.createdAt ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT standard_post.*, global_post.* from standard_post, global_post where standard_post.postId = global_post.postId order by global_post.createdAt ASC", (int)0);
        return new DataSource.Factory<Integer, EkoStandardPost>(){

            public LimitOffsetDataSource<EkoStandardPost> create() {
                return new LimitOffsetDataSource<EkoStandardPost>(EkoStandardPostDao_Impl.this.__db, _statement, true, new String[]{"standard_post", "global_post"}){

                    protected List<EkoStandardPost> convertRows(Cursor cursor) {
                        int _cursorIndexOfPostId = cursor.getColumnIndexOrThrow("postId");
                        int _cursorIndexOfParentPostId = cursor.getColumnIndexOrThrow("parentPostId");
                        int _cursorIndexOfPostedUserId = cursor.getColumnIndexOrThrow("postedUserId");
                        int _cursorIndexOfSharedUserId = cursor.getColumnIndexOrThrow("sharedUserId");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfSharedCount = cursor.getColumnIndexOrThrow("sharedCount");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfCommentCount = cursor.getColumnIndexOrThrow("commentCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfTargetType = cursor.getColumnIndexOrThrow("targetType");
                        int _cursorIndexOfTargetId = cursor.getColumnIndexOrThrow("targetId");
                        int _cursorIndexOfPostDataType = cursor.getColumnIndexOrThrow("postDataType");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfChildPostIds = cursor.getColumnIndexOrThrow("childPostIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        int _cursorIndexOfPostId_1 = cursor.getColumnIndexOrThrow("postId");
                        int _cursorIndexOfCreatedAt_1 = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt_1 = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoStandardPost> _res = new ArrayList<EkoStandardPost>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoStandardPost _item = new EkoStandardPost();
                            String _tmpPostId = cursor.getString(_cursorIndexOfPostId);
                            _item.setPostId(_tmpPostId);
                            String _tmpParentPostId = cursor.getString(_cursorIndexOfParentPostId);
                            _item.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = cursor.getString(_cursorIndexOfPostedUserId);
                            _item.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = cursor.getString(_cursorIndexOfSharedUserId);
                            _item.setSharedUserId(_tmpSharedUserId);
                            String _tmp = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                            _item.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = cursor.getInt(_cursorIndexOfSharedCount);
                            _item.setSharedCount(_tmpSharedCount);
                            String _tmp_1 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoStandardPostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = cursor.getInt(_cursorIndexOfCommentCount);
                            _item.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                            _item.setEditedAt(_tmpEditedAt);
                            int _tmp_3 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_3 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = cursor.getString(_cursorIndexOfTargetType);
                            _item.setTargetType(_tmpTargetType);
                            String _tmpTargetId = cursor.getString(_cursorIndexOfTargetId);
                            _item.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = cursor.getString(_cursorIndexOfPostDataType);
                            _item.setPostDataType(_tmpPostDataType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setData(_tmpData);
                            String _tmp_5 = cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = EkoStandardPostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_5);
                            _item.setChildPostIds(_tmpChildPostIds);
                            String _tmp_6 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_7 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmpPostId_1 = cursor.getString(_cursorIndexOfPostId_1);
                            _item.setPostId(_tmpPostId_1);
                            String _tmp_8 = cursor.getString(_cursorIndexOfCreatedAt_1);
                            DateTime _tmpCreatedAt_1 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                            _item.setCreatedAt(_tmpCreatedAt_1);
                            String _tmp_9 = cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoStandardPost> getByIdsNowImpl(List<String> postIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (");
        int _inputSize = postIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and standard_post.postId = post_flag.postId");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : postIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            ArrayList<EkoStandardPost> arrayList;
            Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
            try {
                int _cursorIndexOfPostId = _cursor.getColumnIndexOrThrow("postId");
                int _cursorIndexOfParentPostId = _cursor.getColumnIndexOrThrow("parentPostId");
                int _cursorIndexOfPostedUserId = _cursor.getColumnIndexOrThrow("postedUserId");
                int _cursorIndexOfSharedUserId = _cursor.getColumnIndexOrThrow("sharedUserId");
                int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                int _cursorIndexOfSharedCount = _cursor.getColumnIndexOrThrow("sharedCount");
                int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                int _cursorIndexOfCommentCount = _cursor.getColumnIndexOrThrow("commentCount");
                int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                int _cursorIndexOfTargetType = _cursor.getColumnIndexOrThrow("targetType");
                int _cursorIndexOfTargetId = _cursor.getColumnIndexOrThrow("targetId");
                int _cursorIndexOfPostDataType = _cursor.getColumnIndexOrThrow("postDataType");
                int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                int _cursorIndexOfChildPostIds = _cursor.getColumnIndexOrThrow("childPostIds");
                int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                ArrayList<EkoStandardPost> _result = new ArrayList<EkoStandardPost>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    EkoStandardPost _item_1 = new EkoStandardPost();
                    String _tmpPostId = _cursor.getString(_cursorIndexOfPostId);
                    _item_1.setPostId(_tmpPostId);
                    String _tmpParentPostId = _cursor.getString(_cursorIndexOfParentPostId);
                    _item_1.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _cursor.getString(_cursorIndexOfPostedUserId);
                    _item_1.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _cursor.getString(_cursorIndexOfSharedUserId);
                    _item_1.setSharedUserId(_tmpSharedUserId);
                    String _tmp = _cursor.getString(_cursorIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                    _item_1.setSharedCount(_tmpSharedCount);
                    String _tmp_1 = _cursor.getString(_cursorIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                    _item_1.setReactions(_tmpReactions);
                    int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                    _item_1.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                    _item_1.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                    _item_1.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _cursor.getString(_cursorIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _cursor.getString(_cursorIndexOfTargetType);
                    _item_1.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _cursor.getString(_cursorIndexOfTargetId);
                    _item_1.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _cursor.getString(_cursorIndexOfPostDataType);
                    _item_1.setPostDataType(_tmpPostDataType);
                    String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setData(_tmpData);
                    String _tmp_5 = _cursor.getString(_cursorIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                    _item_1.setChildPostIds(_tmpChildPostIds);
                    String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoStandardPost getByIdNowImpl(String postIds) {
        String _sql = "SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (?) and standard_post.postId = post_flag.postId LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (?) and standard_post.postId = post_flag.postId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postIds == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postIds);
        }
        this.__db.beginTransaction();
        try {
            EkoStandardPost ekoStandardPost;
            Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
            try {
                EkoStandardPost _result;
                int _cursorIndexOfPostId = _cursor.getColumnIndexOrThrow("postId");
                int _cursorIndexOfParentPostId = _cursor.getColumnIndexOrThrow("parentPostId");
                int _cursorIndexOfPostedUserId = _cursor.getColumnIndexOrThrow("postedUserId");
                int _cursorIndexOfSharedUserId = _cursor.getColumnIndexOrThrow("sharedUserId");
                int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                int _cursorIndexOfSharedCount = _cursor.getColumnIndexOrThrow("sharedCount");
                int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                int _cursorIndexOfCommentCount = _cursor.getColumnIndexOrThrow("commentCount");
                int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                int _cursorIndexOfTargetType = _cursor.getColumnIndexOrThrow("targetType");
                int _cursorIndexOfTargetId = _cursor.getColumnIndexOrThrow("targetId");
                int _cursorIndexOfPostDataType = _cursor.getColumnIndexOrThrow("postDataType");
                int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                int _cursorIndexOfChildPostIds = _cursor.getColumnIndexOrThrow("childPostIds");
                int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                if (_cursor.moveToFirst()) {
                    _result = new EkoStandardPost();
                    String _tmpPostId = _cursor.getString(_cursorIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpParentPostId = _cursor.getString(_cursorIndexOfParentPostId);
                    _result.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _cursor.getString(_cursorIndexOfPostedUserId);
                    _result.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _cursor.getString(_cursorIndexOfSharedUserId);
                    _result.setSharedUserId(_tmpSharedUserId);
                    String _tmp = _cursor.getString(_cursorIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                    _result.setSharedCount(_tmpSharedCount);
                    String _tmp_1 = _cursor.getString(_cursorIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _cursor.getString(_cursorIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _cursor.getString(_cursorIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _cursor.getString(_cursorIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _cursor.getString(_cursorIndexOfPostDataType);
                    _result.setPostDataType(_tmpPostDataType);
                    String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setData(_tmpData);
                    String _tmp_5 = _cursor.getString(_cursorIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                    _result.setChildPostIds(_tmpChildPostIds);
                    String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                ekoStandardPost = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return ekoStandardPost;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    Flowable<EkoStandardPost> getPostImpl(String postIds) {
        String _sql = "SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (?) and standard_post.postId = post_flag.postId LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (?) and standard_post.postId = post_flag.postId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postIds == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postIds);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"standard_post", "post_flag"}, (Callable)new Callable<EkoStandardPost>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoStandardPost call() throws Exception {
                EkoStandardPostDao_Impl.this.__db.beginTransaction();
                try {
                    EkoStandardPost ekoStandardPost;
                    Cursor _cursor = EkoStandardPostDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);
                    try {
                        EkoStandardPost _result;
                        int _cursorIndexOfPostId = _cursor.getColumnIndexOrThrow("postId");
                        int _cursorIndexOfParentPostId = _cursor.getColumnIndexOrThrow("parentPostId");
                        int _cursorIndexOfPostedUserId = _cursor.getColumnIndexOrThrow("postedUserId");
                        int _cursorIndexOfSharedUserId = _cursor.getColumnIndexOrThrow("sharedUserId");
                        int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfSharedCount = _cursor.getColumnIndexOrThrow("sharedCount");
                        int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfCommentCount = _cursor.getColumnIndexOrThrow("commentCount");
                        int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfTargetType = _cursor.getColumnIndexOrThrow("targetType");
                        int _cursorIndexOfTargetId = _cursor.getColumnIndexOrThrow("targetId");
                        int _cursorIndexOfPostDataType = _cursor.getColumnIndexOrThrow("postDataType");
                        int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfChildPostIds = _cursor.getColumnIndexOrThrow("childPostIds");
                        int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                        if (_cursor.moveToFirst()) {
                            _result = new EkoStandardPost();
                            String _tmpPostId = _cursor.getString(_cursorIndexOfPostId);
                            _result.setPostId(_tmpPostId);
                            String _tmpParentPostId = _cursor.getString(_cursorIndexOfParentPostId);
                            _result.setParentPostId(_tmpParentPostId);
                            String _tmpPostedUserId = _cursor.getString(_cursorIndexOfPostedUserId);
                            _result.setPostedUserId(_tmpPostedUserId);
                            String _tmpSharedUserId = _cursor.getString(_cursorIndexOfSharedUserId);
                            _result.setSharedUserId(_tmpSharedUserId);
                            String _tmp = _cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                            _result.setMetadata(_tmpMetadata);
                            int _tmpSharedCount = _cursor.getInt(_cursorIndexOfSharedCount);
                            _result.setSharedCount(_tmpSharedCount);
                            String _tmp_1 = _cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoStandardPostDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                            _result.setReactions(_tmpReactions);
                            int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                            _result.setReactionCount(_tmpReactionCount);
                            int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                            _result.setCommentCount(_tmpCommentCount);
                            int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                            _result.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = _cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                            _result.setEditedAt(_tmpEditedAt);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_3 != 0;
                            _result.setDeleted(_tmpIsDeleted);
                            String _tmpTargetType = _cursor.getString(_cursorIndexOfTargetType);
                            _result.setTargetType(_tmpTargetType);
                            String _tmpTargetId = _cursor.getString(_cursorIndexOfTargetId);
                            _result.setTargetId(_tmpTargetId);
                            String _tmpPostDataType = _cursor.getString(_cursorIndexOfPostDataType);
                            _result.setPostDataType(_tmpPostDataType);
                            String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoStandardPostDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _result.setData(_tmpData);
                            String _tmp_5 = _cursor.getString(_cursorIndexOfChildPostIds);
                            List<String> _tmpChildPostIds = EkoStandardPostDao_Impl.this.__stringListConverter.stringToStringList(_tmp_5);
                            _result.setChildPostIds(_tmpChildPostIds);
                            String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _result.setCreatedAt(_tmpCreatedAt);
                            String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoStandardPostDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _result.setUpdatedAt(_tmpUpdatedAt);
                        } else {
                            _result = null;
                        }
                        EkoStandardPostDao_Impl.this.__db.setTransactionSuccessful();
                        ekoStandardPost = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return ekoStandardPost;
                }
                finally {
                    EkoStandardPostDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

