/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipFilter;
import com.ekoapp.ekosdk.internal.data.converter.EkoChannelMembershipQueryFilterTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.EkoChannelMembershipQueryToken;
import io.reactivex.Maybe;
import java.util.concurrent.Callable;

public final class EkoChannelMembershipQueryTokenDao_Impl
extends EkoChannelMembershipQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoChannelMembershipQueryToken;
    private final EkoChannelMembershipQueryFilterTypeConverter __ekoChannelMembershipQueryFilterTypeConverter = new EkoChannelMembershipQueryFilterTypeConverter();

    public EkoChannelMembershipQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoChannelMembershipQueryToken = new EntityInsertionAdapter<EkoChannelMembershipQueryToken>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_membership_query_token`(`channelId`,`filter`,`previous`,`next`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelMembershipQueryToken value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                String _tmp = EkoChannelMembershipQueryTokenDao_Impl.this.__ekoChannelMembershipQueryFilterTypeConverter.filterToapiKey(value.getFilter());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getNext());
                }
            }
        };
    }

    @Override
    public void insertToken(EkoChannelMembershipQueryToken token) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoChannelMembershipQueryToken.insert((Object)token);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Maybe<EkoChannelMembershipQueryToken> getQueryToken(String channelId, AmityChannelMembershipFilter filter) {
        String _sql = "SELECT * from channel_membership_query_token where channelId = ? and filter = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_membership_query_token where channelId = ? and filter = ?", (int)2);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        String _tmp = this.__ekoChannelMembershipQueryFilterTypeConverter.filterToapiKey(filter);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return Maybe.fromCallable((Callable)new Callable<EkoChannelMembershipQueryToken>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoChannelMembershipQueryToken call() throws Exception {
                try (Cursor _cursor = EkoChannelMembershipQueryTokenDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoChannelMembershipQueryToken _result;
                    int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
                    int _cursorIndexOfFilter = _cursor.getColumnIndexOrThrow("filter");
                    int _cursorIndexOfPrevious = _cursor.getColumnIndexOrThrow("previous");
                    int _cursorIndexOfNext = _cursor.getColumnIndexOrThrow("next");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoChannelMembershipQueryToken();
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfFilter);
                        AmityChannelMembershipFilter _tmpFilter = EkoChannelMembershipQueryTokenDao_Impl.this.__ekoChannelMembershipQueryFilterTypeConverter.apiKeyToFilter(_tmp_1);
                        _result.setFilter(_tmpFilter);
                        String _tmpPrevious = _cursor.getString(_cursorIndexOfPrevious);
                        _result.setPrevious(_tmpPrevious);
                        String _tmpNext = _cursor.getString(_cursorIndexOfNext);
                        _result.setNext(_tmpNext);
                    } else {
                        _result = null;
                    }
                    EkoChannelMembershipQueryToken ekoChannelMembershipQueryToken = _result;
                    return ekoChannelMembershipQueryToken;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

