/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.core.user.AmityMembershipType;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto;
import com.ekoapp.ekosdk.internal.api.dto.OldEkoChannelAndChannelMembershipDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoChannelMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoChannelMembershipMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoTagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoChannelTag;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.reactivex.Flowable;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.joda.time.DateTime;

@Dao
public abstract class EkoChannelDao
extends EkoObjectDao<EkoChannelEntity> {
    private final EkoChannelMembershipDao channelMembershipDao;
    private final EkoMessageDao messageDao;
    private final EkoChannelTagDao channelTagDao;
    private final EkoChannelExtraDao channelExtraDao;

    EkoChannelDao() {
        UserDatabase db = UserDatabase.get();
        this.channelMembershipDao = db.channelMembershipDao();
        this.messageDao = db.messageDao();
        this.channelTagDao = db.channelTagDao();
        this.channelExtraDao = db.channelExtraDao();
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = :membership) and channel_membership.userId = :userId")
    abstract Flowable<List<EkoChannelWithMembershipAndExtra>> getTotalUnreadCountImpl(String var1, String var2);

    public Flowable<Integer> getTotalUnreadCount() {
        return this.getTotalUnreadCountImpl(AmityCoreClient.INSTANCE.getUserId(), AmityMembershipType.MEMBER.getApiKey()).map(channels -> {
            int total = 0;
            for (EkoChannelWithMembershipAndExtra channel : channels) {
                total += channel.getUnreadCount();
            }
            return total;
        });
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) and channel_membership.userId = :userId and channel.channelType in (:channelTypes) and channel.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by channel.lastActivity DESC")
    abstract DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra> getAllOrderByLastActivityImpl(String var1, String[] var2, String[] var3, Boolean var4);

    public DataSource.Factory<Integer, EkoChannelEntity> getAllOrderByLastActivity(String[] channelTypes, String[] excludingTags, Boolean isDeleted) {
        return this.getAllOrderByLastActivityImpl(AmityCoreClient.INSTANCE.getUserId(), channelTypes, excludingTags, isDeleted).map(input -> input);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_tag where tagName in (:includingTags)) and channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) and channel_membership.userId = :userId and channel.channelType in (:channelTypes) and channel.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by channel.lastActivity DESC")
    abstract DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra> getAllByTagsOrderByLastActivityImpl(String var1, String[] var2, String[] var3, String[] var4, Boolean var5);

    public DataSource.Factory<Integer, EkoChannelEntity> getAllByTagsOrderByLastActivity(String[] channelTypes, String[] includingTags, String[] excludingTags, Boolean isDeleted) {
        return this.getAllByTagsOrderByLastActivityImpl(AmityCoreClient.INSTANCE.getUserId(), channelTypes, includingTags, excludingTags, isDeleted).map(input -> input);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) and channel.channelId in (SELECT channelId from channel_membership where membership in (:memberships) and userId = :userId) and channel_membership.userId = :userId and channel.channelType in (:channelTypes) and channel.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by channel.lastActivity DESC")
    abstract DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra> getAllByMembershipsOrderByLastActivityImpl(String var1, String[] var2, String[] var3, String[] var4, Boolean var5);

    public DataSource.Factory<Integer, EkoChannelEntity> getAllByMembershipsOrderByLastActivity(String[] channelTypes, String[] excludingTags, String[] memberships, Boolean isDeleted) {
        return this.getAllByMembershipsOrderByLastActivityImpl(AmityCoreClient.INSTANCE.getUserId(), channelTypes, excludingTags, memberships, isDeleted).map(input -> input);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_tag where tagName in (:includingTags)) and channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) and channel.channelId in (SELECT channelId from channel_membership where membership in (:memberships) and userId = :userId) and channel_membership.userId = :userId and channel.channelType in (:channelTypes) and channel.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by channel.lastActivity DESC")
    abstract DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra> getAllByMembershipsAndTagsOrderByLastActivityImpl(String var1, String[] var2, String[] var3, String[] var4, String[] var5, Boolean var6);

    public DataSource.Factory<Integer, EkoChannelEntity> getAllByMembershipsAndTagsOrderByLastActivity(String[] channelTypes, String[] includingTags, String[] excludingTags, String[] memberships, Boolean isDeleted) {
        return this.getAllByMembershipsAndTagsOrderByLastActivityImpl(AmityCoreClient.INSTANCE.getUserId(), channelTypes, includingTags, excludingTags, memberships, isDeleted).map(input -> input);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    abstract Flowable<EkoChannelWithMembershipAndExtra> getChannelImpl(String var1);

    public Flowable<EkoChannelEntity> getChannel(String channelId) {
        return this.getChannelImpl(channelId).map(input -> input);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    abstract EkoChannelWithMembershipAndExtra getByIdNowImpl(String var1);

    @Override
    public EkoChannelEntity getByIdNow(String id) {
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId  IN (:ids)")
    abstract List<EkoChannelWithMembershipAndExtra> getByIdsNowImpl(List<String> var1);

    @Override
    public List<EkoChannelEntity> getByIdsNow(List<String> ids) {
        return FluentIterable.from(this.getByIdsNowImpl(ids)).transform((Function)new Function<EkoChannelWithMembershipAndExtra, EkoChannelEntity>(){

            @NullableDecl
            public EkoChannelEntity apply(@NullableDecl EkoChannelWithMembershipAndExtra input) {
                return input;
            }
        }).toList();
    }

    @Transaction
    public void insertDto(List<EkoChannelDto> channelDtoList, List<EkoChannelMembershipDto> channelMembershipDtoList) {
        for (EkoChannelDto channelDto : channelDtoList) {
            ChannelMembershipEntity membership;
            EkoChannelEntity channel = (EkoChannelEntity)EkoChannelMapper.MAPPER.map(channelDto);
            this.insert(channel);
            EkoChannelMembershipDto membershipDto = (EkoChannelMembershipDto)FluentIterable.from(channelMembershipDtoList).firstMatch(dto -> dto.getChannelId().equals(channel.getChannelId()) && dto.getUserId().equals(AmityCoreClient.INSTANCE.getUserId())).orNull();
            if (membershipDto != null) {
                membership = (ChannelMembershipEntity)EkoChannelMembershipMapper.MAPPER.map(membershipDto);
            } else {
                membership = new ChannelMembershipEntity();
                membership.setChannelId(channel.getChannelId());
                membership.setUserId(AmityCoreClient.INSTANCE.getUserId());
                membership.setRoles(new AmityRoles());
                membership.setPermissions(new AmityPermissions());
            }
            this.channelMembershipDao.insert(membership);
            ImmutableList membershipList = FluentIterable.from(channelMembershipDtoList).filter(dto -> dto.getChannelId().equals(channel.getChannelId()) && !dto.getUserId().equals(AmityCoreClient.INSTANCE.getUserId())).transform(EkoChannelMembershipMapper.MAPPER::map).toList();
            this.channelMembershipDao.insert((List<ChannelMembershipEntity>)membershipList);
            this.channelExtraDao.insertOrUpdate(membership.getChannelId());
        }
    }

    @Transaction
    public void insertDto(List<OldEkoChannelAndChannelMembershipDto> list) {
        for (OldEkoChannelAndChannelMembershipDto dto : list) {
            EkoChannelEntity channel = (EkoChannelEntity)EkoChannelMapper.MAPPER.map(dto.getChannelDto());
            this.insert(channel);
            ChannelMembershipEntity membership = (ChannelMembershipEntity)EkoChannelMembershipMapper.MAPPER.map(dto.getChannelMembershipDto());
            this.channelMembershipDao.insert(membership);
            this.channelExtraDao.insertOrUpdate(membership.getChannelId());
        }
    }

    @Query(value="UPDATE channel set lastActivity = :lastActivity where channelId = :channelId")
    public abstract void updateLastActivity(String var1, DateTime var2);

    @Query(value="UPDATE channel set memberCount = :memberCount where channelId = :channelId")
    public abstract void updateMemberCount(String var1, int var2);

    @Query(value="UPDATE channel set messageCount = :messageCount where channelId = :channelId and messageCount < :messageCount")
    public abstract void updateMessageCount(String var1, int var2);

    @Override
    @Query(value="DELETE from channel")
    public abstract void deleteAll();

    @Query(value="DELETE from channel where channelId = :channelId")
    abstract void deleteByIdImpl(String var1);

    @Transaction
    public void deleteById(String channelId) {
        this.deleteByIdImpl(channelId);
        this.messageDao.deleteAllFromChannel(channelId);
        this.channelMembershipDao.deleteAllFromChannel(channelId);
        this.channelExtraDao.deleteAllFromChannel(channelId);
    }

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = :userId)")
    public abstract Flowable<List<String>> getActiveIds(String var1);

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = :userId)")
    abstract List<String> getInactiveIds(String var1);

    @Transaction
    public void deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading() {
        List<String> inactiveChannelIds = this.getInactiveIds(AmityCoreClient.INSTANCE.getUserId());
        for (String inactiveChannelId : inactiveChannelIds) {
            this.deleteById(inactiveChannelId);
        }
        this.channelExtraDao.updateAllReadStatuses(EkoChannelReadStatus.NOT_READING);
    }

    private void beforeInsertOrUpdate(EkoChannelEntity channel) {
        EkoChannelEntity c = this.getByIdNow(channel.getChannelId());
        if (c != null) {
            channel.setMessageCount(Math.max(c.getMessageCount(), channel.getMessageCount()));
        }
    }

    private void beforeInsertOrUpdate(List<EkoChannelEntity> cs) {
        for (EkoChannelEntity channel : cs) {
            this.beforeInsertOrUpdate(channel);
        }
    }

    @Override
    @Transaction
    public void insert(EkoChannelEntity channel) {
        this.beforeInsertOrUpdate(channel);
        super.insert(channel);
        EkoTagDao.update(channel, this.channelTagDao, EkoChannelTag::create);
    }

    @Override
    @Transaction
    public void insert(List<EkoChannelEntity> channels) {
        this.beforeInsertOrUpdate(channels);
        super.insert(channels);
        EkoTagDao.update(channels, this.channelTagDao, EkoChannelTag::create);
    }

    @Override
    @Transaction
    public void update(EkoChannelEntity channel) {
        this.beforeInsertOrUpdate(channel);
        super.update(channel);
        EkoTagDao.update(channel, this.channelTagDao, EkoChannelTag::create);
    }
}

