/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.RawQuery;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption;
import com.ekoapp.ekosdk.EkoInternalUser;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;
import io.reactivex.Flowable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Dao
public abstract class EkoUserDao
extends EkoObjectDao<EkoInternalUser> {
    @RawQuery(observedEntities={EkoInternalUser.class, EkoUserFlag.class})
    abstract DataSource.Factory<Integer, EkoInternalUser> getAllImpl(SupportSQLiteQuery var1);

    public DataSource.Factory<Integer, EkoInternalUser> getAll(AmityUserSortOption sortBy) {
        String orderBy = sortBy.getSortingColumn() + " " + sortBy.getSortingOrder();
        String query = "SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = user_flag.userId order by " + orderBy;
        return this.getAllImpl((SupportSQLiteQuery)new SimpleSQLiteQuery(query));
    }

    @RawQuery(observedEntities={EkoInternalUser.class, EkoUserFlag.class})
    abstract DataSource.Factory<Integer, EkoInternalUser> searchAllImpl(SupportSQLiteQuery var1);

    public DataSource.Factory<Integer, EkoInternalUser> searchAll(String keyword, AmityUserSortOption sortBy) {
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            String orderBy = sortBy.getSortingColumn() + " " + sortBy.getSortingOrder();
            String query = "SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = user_flag.userId and user.displayName like ? || '%' COLLATE NOCASE order by " + orderBy;
            return this.searchAllImpl((SupportSQLiteQuery)new SimpleSQLiteQuery(query, new Object[]{keyword}));
        }
        return this.getAll(sortBy);
    }

    @Query(value="SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = :userId and user.userId = user_flag.userId LIMIT 1")
    abstract Flowable<EkoInternalUser> getByIdImpl(String var1);

    public Flowable<EkoInternalUser> getById(String userId) {
        return this.getByIdImpl(userId);
    }

    @Query(value="SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = :userId and user.userId = user_flag.userId LIMIT 1")
    abstract EkoInternalUser getByIdNowImpl(String var1);

    @Override
    public EkoInternalUser getByIdNow(String userId) {
        return this.getByIdNowImpl(userId);
    }

    @Query(value="SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId IN (:userIds) and user.userId = user_flag.userId")
    abstract List<EkoInternalUser> getByIdsNowImpl(List<String> var1);

    @Override
    public List<EkoInternalUser> getByIdsNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Override
    @Query(value="DELETE from user")
    public abstract void deleteAll();
}

