/*
 * Decompiled with CFR 0.152.
 */
package io.tempo;

import android.app.Application;
import android.content.Context;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.processors.ReplayProcessor;
import io.reactivex.schedulers.Schedulers;
import io.tempo.DeviceClocks;
import io.tempo.Scheduler;
import io.tempo.Storage;
import io.tempo.TempoConfig;
import io.tempo.TempoEvent;
import io.tempo.TimeSource;
import io.tempo.TimeSourceWrapper;
import io.tempo.device_clocks.AndroidDeviceClocks;
import io.tempo.internal.TempoInstance;
import io.tempo.schedulers.NoOpScheduler;
import io.tempo.storage.SharedPrefStorage;
import io.tempo.time_sources.SlackSntpTimeSource;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013JF\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J\r\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%J\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010%R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/tempo/Tempo;", "", "()V", "config", "Lio/tempo/TempoConfig;", "getConfig", "()Lio/tempo/TempoConfig;", "eventsSubject", "Lio/reactivex/processors/ReplayProcessor;", "Lio/tempo/TempoEvent;", "kotlin.jvm.PlatformType", "initialized", "", "getInitialized", "()Z", "instance", "Lio/tempo/internal/TempoInstance;", "instanceLock", "activeTimeWrapper", "Lio/tempo/TimeSourceWrapper;", "initialize", "", "application", "Landroid/app/Application;", "timeSources", "", "Lio/tempo/TimeSource;", "storage", "Lio/tempo/Storage;", "deviceClocks", "Lio/tempo/DeviceClocks;", "scheduler", "Lio/tempo/Scheduler;", "now", "", "()Ljava/lang/Long;", "observeEvents", "Lio/reactivex/Flowable;", "syncFlow", "tempo_release"})
public final class Tempo {
    private static final Object instanceLock;
    private static TempoInstance instance;
    private static final ReplayProcessor<TempoEvent> eventsSubject;
    public static final Tempo INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(@NotNull Application application, @NotNull List<? extends TimeSource> timeSources, @NotNull TempoConfig config, @NotNull Storage storage, @NotNull DeviceClocks deviceClocks, @NotNull Scheduler scheduler) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull(timeSources, (String)"timeSources");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)deviceClocks, (String)"deviceClocks");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        Object object = instanceLock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = instance == null;
            if (!bl) {
                boolean bl4 = false;
                String string = "Don't call Tempo::initialize more than once per process.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            TempoInstance tempoInstance = instance = new TempoInstance(timeSources, config, storage, deviceClocks, scheduler);
            if (tempoInstance == null) {
                Intrinsics.throwNpe();
            }
            tempoInstance.observeEvents().subscribe((FlowableSubscriber)eventsSubject);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void initialize$default(Tempo tempo, Application application, List list, TempoConfig tempoConfig, Storage storage, DeviceClocks deviceClocks, Scheduler scheduler, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.listOf((Object)new SlackSntpTimeSource(null, 0, null, 0, 0, 31, null));
        }
        if ((n & 4) != 0) {
            tempoConfig = new TempoConfig(0L, null, 3, null);
        }
        if ((n & 8) != 0) {
            storage = new SharedPrefStorage((Context)application);
        }
        if ((n & 0x10) != 0) {
            deviceClocks = new AndroidDeviceClocks();
        }
        if ((n & 0x20) != 0) {
            scheduler = new NoOpScheduler();
        }
        tempo.initialize(application, list, tempoConfig, storage, deviceClocks, scheduler);
    }

    public final boolean getInitialized() {
        TempoInstance tempoInstance = instance;
        return tempoInstance != null ? tempoInstance.getInitialized() : false;
    }

    @Nullable
    public final TempoConfig getConfig() {
        TempoInstance tempoInstance = instance;
        return tempoInstance != null ? tempoInstance.getConfig() : null;
    }

    @NotNull
    public final Flowable<TempoEvent> observeEvents() {
        Flowable flowable = eventsSubject.onBackpressureLatest();
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"eventsSubject.onBackpressureLatest()");
        return flowable;
    }

    @Nullable
    public final Long now() {
        TempoInstance tempoInstance = instance;
        return tempoInstance != null ? tempoInstance.now() : null;
    }

    @Nullable
    public final Flowable<TempoEvent> syncFlow() {
        TempoInstance tempoInstance = instance;
        return tempoInstance != null ? tempoInstance.syncFlow() : null;
    }

    @Nullable
    public final TimeSourceWrapper activeTimeWrapper() {
        TempoInstance tempoInstance = instance;
        return tempoInstance != null ? tempoInstance.activeTimeWrapper() : null;
    }

    private Tempo() {
    }

    static {
        Tempo tempo;
        INSTANCE = tempo = new Tempo();
        instanceLock = new Object();
        ReplayProcessor replayProcessor = ReplayProcessor.createWithTime((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, (io.reactivex.Scheduler)Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)replayProcessor, (String)"ReplayProcessor.createWi\u2026SECONDS, Schedulers.io())");
        eventsSubject = replayProcessor;
    }
}

