/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundBlockEntityTagQueryPacket
implements MinecraftPacket {
    private final int transactionId;
    @lombok.NonNull
    private final Vector3i position;

    public ServerboundBlockEntityTagQueryPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.transactionId = helper.readVarInt(in);
        this.position = helper.readPosition(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.transactionId);
        helper.writePosition(out, this.position);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundBlockEntityTagQueryPacket)) {
            return false;
        }
        ServerboundBlockEntityTagQueryPacket other = (ServerboundBlockEntityTagQueryPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundBlockEntityTagQueryPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundBlockEntityTagQueryPacket(transactionId=" + this.getTransactionId() + ", position=" + this.getPosition() + ")";
    }

    public @NonNull ServerboundBlockEntityTagQueryPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerboundBlockEntityTagQueryPacket(transactionId, this.position);
    }

    public @NonNull ServerboundBlockEntityTagQueryPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundBlockEntityTagQueryPacket(this.transactionId, position);
    }

    public ServerboundBlockEntityTagQueryPacket(int transactionId, @lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.position = position;
    }
}

