/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetChunkCacheRadiusPacket
implements MinecraftPacket {
    private final int viewDistance;

    public ClientboundSetChunkCacheRadiusPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.viewDistance = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.viewDistance);
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetChunkCacheRadiusPacket)) {
            return false;
        }
        ClientboundSetChunkCacheRadiusPacket other = (ClientboundSetChunkCacheRadiusPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getViewDistance() == other.getViewDistance();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetChunkCacheRadiusPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getViewDistance();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetChunkCacheRadiusPacket(viewDistance=" + this.getViewDistance() + ")";
    }

    public @NonNull ClientboundSetChunkCacheRadiusPacket withViewDistance(int viewDistance) {
        return this.viewDistance == viewDistance ? this : new ClientboundSetChunkCacheRadiusPacket(viewDistance);
    }

    public ClientboundSetChunkCacheRadiusPacket(int viewDistance) {
        this.viewDistance = viewDistance;
    }
}

