/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundProjectilePowerPacket
implements MinecraftPacket {
    private final int id;
    private final double accelerationPower;

    public ClientboundProjectilePowerPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.id = helper.readVarInt(in);
        this.accelerationPower = in.readDouble();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.id);
        out.writeDouble(this.accelerationPower);
    }

    public int getId() {
        return this.id;
    }

    public double getAccelerationPower() {
        return this.accelerationPower;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundProjectilePowerPacket)) {
            return false;
        }
        ClientboundProjectilePowerPacket other = (ClientboundProjectilePowerPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return Double.compare(this.getAccelerationPower(), other.getAccelerationPower()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundProjectilePowerPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        long $accelerationPower = Double.doubleToLongBits(this.getAccelerationPower());
        result = result * 59 + (int)($accelerationPower >>> 32 ^ $accelerationPower);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundProjectilePowerPacket(id=" + this.getId() + ", accelerationPower=" + this.getAccelerationPower() + ")";
    }

    public @NonNull ClientboundProjectilePowerPacket withId(int id) {
        return this.id == id ? this : new ClientboundProjectilePowerPacket(id, this.accelerationPower);
    }

    public @NonNull ClientboundProjectilePowerPacket withAccelerationPower(double accelerationPower) {
        return this.accelerationPower == accelerationPower ? this : new ClientboundProjectilePowerPacket(this.id, accelerationPower);
    }

    public ClientboundProjectilePowerPacket(int id, double accelerationPower) {
        this.id = id;
        this.accelerationPower = accelerationPower;
    }
}

