/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.metadata;

import io.netty.buffer.ByteBuf;
import java.util.OptionalInt;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;

public class OptionalIntMetadataType
extends MetadataType<OptionalInt> {
    protected OptionalIntMetadataType(MetadataType.EntityMetadataFactory<OptionalInt> metadataFactory) {
        super(OptionalIntReader.INSTANCE, OptionalIntWriter.INSTANCE, metadataFactory);
    }

    public static class OptionalIntReader
    implements MetadataType.Reader<OptionalInt> {
        protected static final OptionalIntReader INSTANCE = new OptionalIntReader();

        @Override
        public OptionalInt read(MinecraftCodecHelper helper, ByteBuf input) {
            int value = helper.readVarInt(input);
            if (value == 0) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(value - 1);
        }
    }

    public static class OptionalIntWriter
    implements MetadataType.Writer<OptionalInt> {
        protected static final OptionalIntWriter INSTANCE = new OptionalIntWriter();

        @Override
        public void write(MinecraftCodecHelper helper, ByteBuf output, OptionalInt value) {
            if (value.isPresent()) {
                helper.writeVarInt(output, value.getAsInt() + 1);
            } else {
                helper.writeVarInt(output, 0);
            }
        }
    }
}

