/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.packet;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.geysermc.mcprotocollib.network.codec.PacketCodecHelper;
import org.geysermc.mcprotocollib.network.codec.PacketDefinition;
import org.geysermc.mcprotocollib.network.codec.PacketSerializer;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacketSerializer;
import org.geysermc.mcprotocollib.protocol.codec.PacketFactory;

public class PacketRegistry {
    private final Int2ObjectMap<PacketDefinition<? extends Packet, ?>> serverbound = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<PacketDefinition<? extends Packet, ?>> clientbound = new Int2ObjectOpenHashMap();
    private final Map<Class<? extends Packet>, Integer> clientboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();
    private final Map<Class<? extends Packet>, Integer> serverboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();

    public final void clearPackets() {
        this.serverbound.clear();
        this.clientbound.clear();
        this.clientboundIds.clear();
        this.serverboundIds.clear();
    }

    public final <T extends Packet, H extends PacketCodecHelper> void register(int id, Class<T> packet, PacketSerializer<T, H> serializer) {
        this.registerServerbound(id, packet, serializer);
        this.registerClientbound(id, packet, serializer);
    }

    public final void register(PacketDefinition<? extends Packet, ?> definition) {
        this.registerServerbound(definition);
        this.registerClientbound(definition);
    }

    public final <T extends Packet, H extends PacketCodecHelper> void registerServerbound(int id, Class<T> packet, PacketSerializer<T, H> serializer) {
        this.registerServerbound(new PacketDefinition<T, H>(id, packet, serializer));
    }

    public final void registerServerbound(PacketDefinition<? extends Packet, ?> definition) {
        this.serverbound.put(definition.getId(), definition);
        this.serverboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public final <T extends Packet, H extends PacketCodecHelper> void registerClientbound(int id, Class<T> packet, PacketSerializer<T, H> serializer) {
        this.registerClientbound(new PacketDefinition<T, H>(id, packet, serializer));
    }

    public final void registerClientbound(PacketDefinition<? extends Packet, ?> definition) {
        this.clientbound.put(definition.getId(), definition);
        this.clientboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public <H extends PacketCodecHelper> Packet createClientboundPacket(int id, ByteBuf buf, H codecHelper) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.newInstance(buf, codecHelper);
    }

    public int getClientboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.clientboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered clientbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getClientboundId(Packet packet) {
        return this.getClientboundId(packet.getClass());
    }

    public Class<? extends Packet> getClientboundClass(int id) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }

    public <H extends PacketCodecHelper> Packet createServerboundPacket(int id, ByteBuf buf, H codecHelper) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.newInstance(buf, codecHelper);
    }

    public int getServerboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.serverboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered serverbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getServerboundId(Packet packet) {
        return this.getServerboundId(packet.getClass());
    }

    public Class<? extends Packet> getServerboundClass(int id) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }

    public PacketDefinition<?, ?> getServerboundDefinition(int id) {
        PacketDefinition definition = (PacketDefinition)this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition;
    }

    public PacketDefinition<?, ?> getClientboundDefinition(int id) {
        PacketDefinition definition = (PacketDefinition)this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Int2ObjectMap<PacketDefinition<? extends MinecraftPacket, MinecraftCodecHelper>> clientboundPackets = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<PacketDefinition<? extends MinecraftPacket, MinecraftCodecHelper>> serverboundPackets = new Int2ObjectOpenHashMap();
        private int nextClientboundId = 0;
        private int nextServerboundId = 0;

        public <T extends MinecraftPacket> Builder registerClientboundPacket(int id, Class<T> packetClass, PacketFactory<T, MinecraftCodecHelper> factory) {
            this.nextClientboundId = id;
            return this.registerClientboundPacket(packetClass, factory);
        }

        public <T extends MinecraftPacket> Builder registerClientboundPacket(Class<T> packetClass, PacketFactory<T, MinecraftCodecHelper> factory) {
            this.clientboundPackets.put(this.nextClientboundId, new PacketDefinition(this.nextClientboundId, packetClass, new MinecraftPacketSerializer<T>(factory)));
            ++this.nextClientboundId;
            return this;
        }

        public <T extends MinecraftPacket> Builder registerServerboundPacket(int id, Class<T> packetClass, PacketFactory<T, MinecraftCodecHelper> factory) {
            this.nextServerboundId = id;
            return this.registerServerboundPacket(packetClass, factory);
        }

        public <T extends MinecraftPacket> Builder registerServerboundPacket(Class<T> packetClass, PacketFactory<T, MinecraftCodecHelper> factory) {
            this.serverboundPackets.put(this.nextServerboundId, new PacketDefinition(this.nextServerboundId, packetClass, new MinecraftPacketSerializer<T>(factory)));
            ++this.nextServerboundId;
            return this;
        }

        public PacketRegistry build() {
            PacketRegistry codec = new PacketRegistry();
            for (Int2ObjectMap.Entry entry : this.clientboundPackets.int2ObjectEntrySet()) {
                codec.registerClientbound((PacketDefinition)entry.getValue());
            }
            for (Int2ObjectMap.Entry entry : this.serverboundPackets.int2ObjectEntrySet()) {
                codec.registerServerbound((PacketDefinition)entry.getValue());
            }
            return codec;
        }
    }
}

