/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder.compat;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MediaCodecListCompat {
    public static final int REGULAR_CODECS = 0;
    public static final int ALL_CODECS = 1;

    public MediaCodecListCompat(int kind) {
        if (kind != 0) {
            throw new UnsupportedOperationException("kind other than REGULAR_CODECS is not implemented.");
        }
    }

    public final String findDecoderForFormat(MediaFormat format) {
        return this.findCoderForFormat(format, false);
    }

    public final String findEncoderForFormat(MediaFormat format) {
        return this.findCoderForFormat(format, true);
    }

    private String findCoderForFormat(MediaFormat format, boolean findEncoder) {
        String mimeType = format.getString("mime");
        MediaCodecInfoIterator iterator = new MediaCodecInfoIterator();
        while (iterator.hasNext()) {
            MediaCodecInfo codecInfo = (MediaCodecInfo)iterator.next();
            if (codecInfo.isEncoder() != findEncoder || !Arrays.asList(codecInfo.getSupportedTypes()).contains(mimeType)) continue;
            return codecInfo.getName();
        }
        return null;
    }

    public final MediaCodecInfo[] getCodecInfos() {
        int codecCount = MediaCodecListCompat.getCodecCount();
        MediaCodecInfo[] codecInfos = new MediaCodecInfo[codecCount];
        MediaCodecInfoIterator iterator = new MediaCodecInfoIterator();
        for (int i = 0; i < codecCount; ++i) {
            codecInfos[i] = MediaCodecListCompat.getCodecInfoAt(i);
        }
        return codecInfos;
    }

    private static int getCodecCount() {
        return MediaCodecList.getCodecCount();
    }

    private static MediaCodecInfo getCodecInfoAt(int index) {
        return MediaCodecList.getCodecInfoAt((int)index);
    }

    static /* synthetic */ int access$100() {
        return MediaCodecListCompat.getCodecCount();
    }

    private final class MediaCodecInfoIterator
    implements Iterator<MediaCodecInfo> {
        private int mCodecCount = MediaCodecListCompat.access$100();
        private int mIndex = -1;

        private MediaCodecInfoIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mIndex + 1 < this.mCodecCount;
        }

        @Override
        public MediaCodecInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.mIndex;
            return MediaCodecListCompat.getCodecInfoAt(this.mIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

