/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.v2.builder;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.allenliu.versionchecklib.callback.APKDownloadListener;
import com.allenliu.versionchecklib.callback.CommitClickListener;
import com.allenliu.versionchecklib.callback.OnCancelListener;
import com.allenliu.versionchecklib.utils.FileHelper;
import com.allenliu.versionchecklib.v2.builder.NotificationBuilder;
import com.allenliu.versionchecklib.v2.builder.RequestVersionBuilder;
import com.allenliu.versionchecklib.v2.builder.UIData;
import com.allenliu.versionchecklib.v2.callback.CustomDownloadFailedListener;
import com.allenliu.versionchecklib.v2.callback.CustomDownloadingDialogListener;
import com.allenliu.versionchecklib.v2.callback.CustomInstallListener;
import com.allenliu.versionchecklib.v2.callback.CustomVersionDialogListener;
import com.allenliu.versionchecklib.v2.callback.ForceUpdateListener;
import com.allenliu.versionchecklib.v2.net.RequestVersionManager;
import com.allenliu.versionchecklib.v2.ui.VersionService;

public class DownloadBuilder {
    private RequestVersionBuilder requestVersionBuilder;
    private boolean isSilentDownload;
    private String downloadAPKPath;
    private boolean isForceRedownload;
    private String downloadUrl;
    private boolean isShowDownloadingDialog;
    private boolean isShowNotification;
    private boolean runOnForegroundService;
    private boolean isShowDownloadFailDialog;
    private boolean isDirectDownload;
    private NotificationBuilder notificationBuilder;
    private APKDownloadListener apkDownloadListener;
    private CustomDownloadFailedListener customDownloadFailedListener;
    private CustomDownloadingDialogListener customDownloadingDialogListener;
    private CustomVersionDialogListener customVersionDialogListener;
    private CustomInstallListener customInstallListener;
    private OnCancelListener onCancelListener;
    private CommitClickListener readyDownloadCommitClickListener;
    private CommitClickListener downloadFailedCommitClickListener;
    private OnCancelListener downloadingCancelListener;
    private OnCancelListener downloadFailedCancelListener;
    private OnCancelListener readyDownloadCancelListener;
    private ForceUpdateListener forceUpdateListener;
    private UIData versionBundle;
    private Integer newestVersionCode;
    private String apkName;

    public DownloadBuilder() {
        throw new RuntimeException("can not be instantiated from outside");
    }

    private void initialize() {
        this.isSilentDownload = false;
        this.isForceRedownload = false;
        this.isShowDownloadingDialog = true;
        this.isShowNotification = true;
        this.isDirectDownload = false;
        this.isShowDownloadFailDialog = true;
        this.notificationBuilder = NotificationBuilder.create();
        this.runOnForegroundService = true;
    }

    public DownloadBuilder(RequestVersionBuilder requestVersionBuilder, UIData versionBundle) {
        this.requestVersionBuilder = requestVersionBuilder;
        this.versionBundle = versionBundle;
        this.initialize();
    }

    public ForceUpdateListener getForceUpdateListener() {
        return this.forceUpdateListener;
    }

    public DownloadBuilder setForceUpdateListener(ForceUpdateListener forceUpdateListener) {
        this.forceUpdateListener = forceUpdateListener;
        return this;
    }

    public DownloadBuilder setApkName(String apkName) {
        this.apkName = apkName;
        return this;
    }

    public DownloadBuilder setVersionBundle(@NonNull UIData versionBundle) {
        this.versionBundle = versionBundle;
        return this;
    }

    public UIData getVersionBundle() {
        return this.versionBundle;
    }

    public DownloadBuilder setOnCancelListener(OnCancelListener cancelListener) {
        this.onCancelListener = cancelListener;
        return this;
    }

    public DownloadBuilder setCustomDownloadFailedListener(CustomDownloadFailedListener customDownloadFailedListener) {
        this.customDownloadFailedListener = customDownloadFailedListener;
        return this;
    }

    public DownloadBuilder setCustomDownloadingDialogListener(CustomDownloadingDialogListener customDownloadingDialogListener) {
        this.customDownloadingDialogListener = customDownloadingDialogListener;
        return this;
    }

    public DownloadBuilder setCustomVersionDialogListener(CustomVersionDialogListener customVersionDialogListener) {
        this.customVersionDialogListener = customVersionDialogListener;
        return this;
    }

    public DownloadBuilder setCustomDownloadInstallListener(CustomInstallListener customDownloadInstallListener) {
        this.customInstallListener = customDownloadInstallListener;
        return this;
    }

    public boolean isRunOnForegroundService() {
        return this.runOnForegroundService;
    }

    public DownloadBuilder setRunOnForegroundService(boolean runOnForegroundService) {
        this.runOnForegroundService = runOnForegroundService;
        return this;
    }

    public DownloadBuilder setSilentDownload(boolean silentDownload) {
        this.isSilentDownload = silentDownload;
        return this;
    }

    public Integer getNewestVersionCode() {
        return this.newestVersionCode;
    }

    public DownloadBuilder setNewestVersionCode(Integer newestVersionCode) {
        this.newestVersionCode = newestVersionCode;
        return this;
    }

    public DownloadBuilder setDownloadAPKPath(String downloadAPKPath) {
        this.downloadAPKPath = downloadAPKPath;
        return this;
    }

    public DownloadBuilder setForceRedownload(boolean forceRedownload) {
        this.isForceRedownload = forceRedownload;
        return this;
    }

    public DownloadBuilder setDownloadUrl(@NonNull String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    public DownloadBuilder setShowDownloadingDialog(boolean showDownloadingDialog2) {
        this.isShowDownloadingDialog = showDownloadingDialog2;
        return this;
    }

    public DownloadBuilder setShowNotification(boolean showNotification2) {
        this.isShowNotification = showNotification2;
        return this;
    }

    public DownloadBuilder setShowDownloadFailDialog(boolean showDownloadFailDialog) {
        this.isShowDownloadFailDialog = showDownloadFailDialog;
        return this;
    }

    public DownloadBuilder setApkDownloadListener(APKDownloadListener apkDownloadListener) {
        this.apkDownloadListener = apkDownloadListener;
        return this;
    }

    public CommitClickListener getReadyDownloadCommitClickListener() {
        return this.readyDownloadCommitClickListener;
    }

    public DownloadBuilder setReadyDownloadCommitClickListener(CommitClickListener readyDownloadCommitClickListener) {
        this.readyDownloadCommitClickListener = readyDownloadCommitClickListener;
        return this;
    }

    public CommitClickListener getDownloadFailedCommitClickListener() {
        return this.downloadFailedCommitClickListener;
    }

    public DownloadBuilder setDownloadFailedCommitClickListener(CommitClickListener downloadFailedCommitClickListener) {
        this.downloadFailedCommitClickListener = downloadFailedCommitClickListener;
        return this;
    }

    public OnCancelListener getDownloadingCancelListener() {
        return this.downloadingCancelListener;
    }

    public DownloadBuilder setDownloadingCancelListener(OnCancelListener downloadingCancelListener) {
        this.downloadingCancelListener = downloadingCancelListener;
        return this;
    }

    public OnCancelListener getDownloadFailedCancelListener() {
        return this.downloadFailedCancelListener;
    }

    public DownloadBuilder setDownloadFailedCancelListener(OnCancelListener downloadFailedCancelListener) {
        this.downloadFailedCancelListener = downloadFailedCancelListener;
        return this;
    }

    public OnCancelListener getReadyDownloadCancelListener() {
        return this.readyDownloadCancelListener;
    }

    public DownloadBuilder setReadyDownloadCancelListener(OnCancelListener readyDownloadCancelListener) {
        this.readyDownloadCancelListener = readyDownloadCancelListener;
        return this;
    }

    public boolean isSilentDownload() {
        return this.isSilentDownload;
    }

    public String getDownloadAPKPath() {
        return this.downloadAPKPath;
    }

    public boolean isForceRedownload() {
        return this.isForceRedownload;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean isShowDownloadingDialog() {
        return this.isShowDownloadingDialog;
    }

    public boolean isShowNotification() {
        return this.isShowNotification;
    }

    public boolean isShowDownloadFailDialog() {
        return this.isShowDownloadFailDialog;
    }

    public APKDownloadListener getApkDownloadListener() {
        return this.apkDownloadListener;
    }

    public CustomDownloadFailedListener getCustomDownloadFailedListener() {
        return this.customDownloadFailedListener;
    }

    public OnCancelListener getOnCancelListener() {
        return this.onCancelListener;
    }

    public CustomDownloadingDialogListener getCustomDownloadingDialogListener() {
        return this.customDownloadingDialogListener;
    }

    public CustomInstallListener getCustomInstallListener() {
        return this.customInstallListener;
    }

    public CustomVersionDialogListener getCustomVersionDialogListener() {
        return this.customVersionDialogListener;
    }

    public RequestVersionBuilder getRequestVersionBuilder() {
        return this.requestVersionBuilder;
    }

    public NotificationBuilder getNotificationBuilder() {
        return this.notificationBuilder;
    }

    public DownloadBuilder setNotificationBuilder(NotificationBuilder notificationBuilder) {
        this.notificationBuilder = notificationBuilder;
        return this;
    }

    public String getApkName() {
        return this.apkName;
    }

    public boolean isDirectDownload() {
        return this.isDirectDownload;
    }

    public DownloadBuilder setDirectDownload(boolean directDownload) {
        this.isDirectDownload = directDownload;
        return this;
    }

    private void setupDefaultNotificationIcon(Context context) {
        if (this.notificationBuilder.getIcon() == 0) {
            PackageManager pm = context.getPackageManager();
            try {
                ApplicationInfo applicationInfo = pm.getApplicationInfo(context.getPackageName(), 128);
                int appIconResId = applicationInfo.icon;
                this.notificationBuilder.setIcon(appIconResId);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void executeMission(Context context) {
        if (this.apkName == null) {
            this.apkName = context.getApplicationContext().getPackageName().replaceAll("\\.", "");
        }
        this.setupDefaultNotificationIcon(context);
        this.setupDownloadPath(context);
        if (this.checkWhetherNeedRequestVersion()) {
            RequestVersionManager.getInstance().requestVersion(this, context.getApplicationContext());
        } else {
            this.download(context);
        }
    }

    private void setupDownloadPath(Context context) {
        if (this.downloadAPKPath == null) {
            this.downloadAPKPath = FileHelper.getDownloadApkCachePath(context);
        }
        this.downloadAPKPath = FileHelper.dealDownloadPath(this.downloadAPKPath);
    }

    public void download(Context context) {
        VersionService.Companion.enqueueWork(context.getApplicationContext(), this);
    }

    private boolean checkWhetherNeedRequestVersion() {
        return this.getRequestVersionBuilder() != null;
    }
}

