/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.allenliu.versionchecklib.core.AllenChecker;
import com.allenliu.versionchecklib.core.VersionFileProvider;
import com.allenliu.versionchecklib.v2.AllenVersionChecker;
import com.allenliu.versionchecklib.v2.callback.CustomInstallListener;
import java.io.File;

public final class AppUtils {
    private AppUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static void installApk(Context context, File file) {
        Uri uri;
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            uri = VersionFileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".versionProvider"), (File)file);
            intent.addFlags(1);
        } else {
            uri = Uri.fromFile((File)file);
        }
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        context.startActivity(intent);
        AllenChecker.cancelMission();
        AllenVersionChecker.getInstance().cancelAllMission();
    }

    public static void installApk(Context context, File file, CustomInstallListener listener) {
        Uri uri;
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            uri = VersionFileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".versionProvider"), (File)file);
            intent.addFlags(1);
        } else {
            uri = Uri.fromFile((File)file);
        }
        if (listener != null) {
            listener.install(context, uri);
        } else {
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
            context.startActivity(intent);
            AllenChecker.cancelMission();
            AllenVersionChecker.getInstance().cancelAllMission();
        }
    }
}

