/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.core;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.app.NotificationCompat;
import com.allenliu.versionchecklib.R;
import com.allenliu.versionchecklib.callback.DownloadListener;
import com.allenliu.versionchecklib.core.AllenChecker;
import com.allenliu.versionchecklib.core.VersionFileProvider;
import com.allenliu.versionchecklib.core.VersionParams;
import com.allenliu.versionchecklib.core.http.AllenHttp;
import com.allenliu.versionchecklib.core.http.FileCallBack;
import com.allenliu.versionchecklib.utils.ALog;
import com.allenliu.versionchecklib.utils.AppUtils;
import java.io.File;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;

public class DownloadManager {
    private static int lastProgress = 0;
    private static boolean isDownloadSuccess = false;

    public static void downloadAPK(final String url, final VersionParams versionParams, final DownloadListener listener) {
        lastProgress = 0;
        isDownloadSuccess = false;
        if (url == null || url.isEmpty()) {
            return;
        }
        String downloadPath = versionParams.getDownloadAPKPath() + AllenChecker.getGlobalContext().getString(R.string.versionchecklib_download_apkname, new Object[]{AllenChecker.getGlobalContext().getPackageName()});
        if (versionParams.isSilentDownload()) {
            if (!versionParams.isForceRedownload()) {
                if (DownloadManager.checkAPKIsExists(AllenChecker.getGlobalContext(), downloadPath)) {
                    if (listener != null) {
                        listener.onCheckerDownloadSuccess(new File(downloadPath));
                    }
                    return;
                }
                DownloadManager.silentDownloadAPK(AllenChecker.getGlobalContext(), url, versionParams, listener);
            } else {
                DownloadManager.silentDownloadAPK(AllenChecker.getGlobalContext(), url, versionParams, listener);
            }
            return;
        }
        if (!versionParams.isForceRedownload() && DownloadManager.checkAPKIsExists(AllenChecker.getGlobalContext(), downloadPath)) {
            if (listener != null) {
                listener.onCheckerDownloadSuccess(new File(downloadPath));
            }
            AppUtils.installApk(AllenChecker.getGlobalContext(), new File(downloadPath));
            return;
        }
        if (listener != null) {
            listener.onCheckerStartDownload();
        }
        NotificationCompat.Builder builder = null;
        NotificationManager manager = null;
        if (versionParams.isShowNotification()) {
            manager = (NotificationManager)AllenChecker.getGlobalContext().getSystemService("notification");
            builder = DownloadManager.createNotification(AllenChecker.getGlobalContext());
            manager.notify(0, builder.build());
        }
        final NotificationCompat.Builder finalBuilder = builder;
        final NotificationManager finalManager = manager;
        Request request = new Request.Builder().url(url).build();
        AllenHttp.getHttpClient().newCall(request).enqueue((Callback)new FileCallBack(versionParams.getDownloadAPKPath(), AllenChecker.getGlobalContext().getString(R.string.versionchecklib_download_apkname, new Object[]{AllenChecker.getGlobalContext().getPackageName()})){

            @Override
            public void onSuccess(File file, Call call, Response response) {
                listener.onCheckerDownloadSuccess(file);
                isDownloadSuccess = true;
                if (versionParams.isShowNotification()) {
                    Uri uri;
                    Intent i = new Intent("android.intent.action.VIEW");
                    if (Build.VERSION.SDK_INT >= 24) {
                        uri = VersionFileProvider.getUriForFile((Context)AllenChecker.getGlobalContext(), (String)(AllenChecker.getGlobalContext().getPackageName() + ".versionProvider"), (File)file);
                        ALog.e(AllenChecker.getGlobalContext().getPackageName() + "");
                        i.addFlags(1);
                    } else {
                        uri = Uri.fromFile((File)file);
                    }
                    ALog.e("APK download Success");
                    i.setDataAndType(uri, "application/vnd.android.package-archive");
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)AllenChecker.getGlobalContext(), (int)0, (Intent)i, (int)0);
                    finalBuilder.setContentIntent(pendingIntent);
                    finalBuilder.setContentText((CharSequence)AllenChecker.getGlobalContext().getString(R.string.versionchecklib_download_finish));
                    finalBuilder.setProgress(100, 100, false);
                    finalManager.cancelAll();
                    finalManager.notify(0, finalBuilder.build());
                }
                AppUtils.installApk(AllenChecker.getGlobalContext(), file);
            }

            @Override
            public void onDownloading(int progress) {
                ALog.e("downloadProgress:" + progress + "");
                int currentProgress = progress;
                listener.onCheckerDownloading(currentProgress);
                if (currentProgress - lastProgress >= 5) {
                    lastProgress = currentProgress;
                    if (versionParams.isShowNotification() && !isDownloadSuccess) {
                        finalBuilder.setContentIntent(null);
                        finalBuilder.setContentText((CharSequence)String.format(AllenChecker.getGlobalContext().getString(R.string.versionchecklib_download_progress), lastProgress));
                        finalBuilder.setProgress(100, lastProgress, false);
                        finalManager.notify(0, finalBuilder.build());
                    }
                }
            }

            @Override
            public void onDownloadFailed() {
                if (versionParams.isShowNotification()) {
                    Intent intent = new Intent(AllenChecker.getGlobalContext(), versionParams.getCustomDownloadActivityClass());
                    intent.putExtra("isRetry", true);
                    intent.putExtra("VERSION_PARAMS_KEY", (Parcelable)versionParams);
                    intent.putExtra("downloadUrl", url);
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)AllenChecker.getGlobalContext(), (int)0, (Intent)intent, (int)0x8000000);
                    finalBuilder.setContentIntent(pendingIntent);
                    finalBuilder.setContentText((CharSequence)AllenChecker.getGlobalContext().getString(R.string.versionchecklib_download_fail));
                    finalBuilder.setProgress(100, 0, false);
                    finalManager.notify(0, finalBuilder.build());
                }
                ALog.e("file download failed");
                listener.onCheckerDownloadFail();
            }
        });
    }

    private static void silentDownloadAPK(Context context, String url, VersionParams versionParams, final DownloadListener listener) {
        Request request = new Request.Builder().url(url).build();
        if (listener != null) {
            listener.onCheckerStartDownload();
        }
        AllenHttp.getHttpClient().newCall(request).enqueue((Callback)new FileCallBack(versionParams.getDownloadAPKPath(), context.getString(R.string.versionchecklib_download_apkname, new Object[]{context.getPackageName()})){

            @Override
            public void onSuccess(File file, Call call, Response response) {
                listener.onCheckerDownloadSuccess(file);
            }

            @Override
            public void onDownloading(int progress) {
                ALog.e("silent downloadProgress:" + progress + "");
                int currentProgress = progress;
                if (currentProgress - lastProgress >= 5) {
                    lastProgress = currentProgress;
                }
                listener.onCheckerDownloading(currentProgress);
            }

            @Override
            public void onDownloadFailed() {
                ALog.e("file silent download failed");
                listener.onCheckerDownloadFail();
            }
        });
    }

    public static boolean checkAPKIsExists(Context context, String downloadPath) {
        return DownloadManager.checkAPKIsExists(context, downloadPath, null);
    }

    public static boolean checkAPKIsExists(Context context, String downloadPath, Integer newestVersionCode) {
        File file = new File(downloadPath);
        boolean result = false;
        if (file.exists()) {
            try {
                PackageManager pm = context.getPackageManager();
                PackageInfo info = pm.getPackageArchiveInfo(downloadPath, 1);
                ALog.e("\u672c\u5730\u5b89\u88c5\u5305\u7248\u672c\u53f7\uff1a" + info.versionCode + "\n \u5f53\u524dapp\u7248\u672c\u53f7\uff1a" + context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode);
                if (context.getPackageName().equalsIgnoreCase(info.packageName) && context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode != info.versionCode) {
                    result = newestVersionCode == null || info.versionCode >= newestVersionCode;
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    private static NotificationCompat.Builder createNotification(Context context) {
        String CHANNEL_ID = "0";
        String CHANNEL_NAME = "ALLEN_NOTIFICATION";
        NotificationCompat.Builder builder = null;
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel("0", (CharSequence)"ALLEN_NOTIFICATION", 2);
            notificationChannel.enableLights(false);
            notificationChannel.setLightColor(-65536);
            notificationChannel.enableVibration(false);
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.createNotificationChannel(notificationChannel);
        }
        builder = new NotificationCompat.Builder(context, "0");
        builder.setAutoCancel(true);
        builder.setContentTitle((CharSequence)context.getString(R.string.app_name));
        builder.setTicker((CharSequence)context.getString(R.string.versionchecklib_downloading));
        builder.setContentText((CharSequence)String.format(context.getString(R.string.versionchecklib_download_progress), 0));
        Uri notification = RingtoneManager.getDefaultUri((int)2);
        Ringtone r = RingtoneManager.getRingtone((Context)context, (Uri)notification);
        r.play();
        return builder;
    }
}

