/*
 * Decompiled with CFR 0.152.
 */
package io.agora.log;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.elvishew.xlog.Logger;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.flattener.Flattener2;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.FilePrinter;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import io.agora.log.AgoraAndroidLogPrinter;
import io.agora.log.AgoraConsolePrintType;
import io.agora.log.AgoraFileNameGenerator;
import io.agora.log.AgoraFlattener;
import io.agora.log.AgoraLogType;
import io.agora.log.CheckUtil;

public class AgoraLogManager {
    private Logger logger;
    private CheckUtil checkUtil = new CheckUtil();

    public AgoraLogManager(@NonNull String folderPath, @NonNull String filePrefix, int maximumNumberOfFiles) throws Exception {
        this(folderPath, filePrefix, maximumNumberOfFiles, null);
    }

    public AgoraLogManager(@NonNull String folderPath, @NonNull String filePrefix, int maximumNumberOfFiles, @NonNull String tag) throws Exception {
        this(folderPath, filePrefix, maximumNumberOfFiles, tag, AgoraConsolePrintType.ALL);
    }

    public AgoraLogManager(@NonNull String folderPath, @NonNull String filePrefix, int maximumNumberOfFiles, String tag, int consolePrintType) throws Exception {
        if (TextUtils.isEmpty((CharSequence)folderPath) || TextUtils.isEmpty((CharSequence)filePrefix) || maximumNumberOfFiles <= 0) {
            throw new Exception("Parameter is invalid");
        }
        try {
            this.checkUtil.checkFolder(folderPath, filePrefix, maximumNumberOfFiles);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XLog.init();
        this.logger = XLog.tag((String)tag).logLevel(Integer.MIN_VALUE).printers(new Printer[]{new AgoraAndroidLogPrinter(consolePrintType), new FilePrinter.Builder(folderPath).fileNameGenerator((FileNameGenerator)new AgoraFileNameGenerator(filePrefix)).flattener((Flattener2)new AgoraFlattener()).build()}).build();
    }

    public void logMsg(String msg, AgoraLogType type) {
        switch (type) {
            case DEBUG: {
                this.d(msg, new Object[0]);
                break;
            }
            case WARNING: {
                this.w(msg, new Object[0]);
                break;
            }
            case ERROR: {
                this.e(msg, new Object[0]);
                break;
            }
            default: {
                this.i(msg, new Object[0]);
            }
        }
    }

    public void i(String msg, Object ... args) {
        msg = this.checkUtil.check(msg, args);
        this.logger.i(msg, args);
    }

    public void d(String msg, Object ... args) {
        msg = this.checkUtil.check(msg, args);
        this.logger.d(msg, args);
    }

    public void w(String msg, Object ... args) {
        msg = this.checkUtil.check(msg, args);
        this.logger.w(msg, args);
    }

    public void e(String msg, Object ... args) {
        msg = this.checkUtil.check(msg, args);
        this.logger.e(msg, args);
    }
}

