/*
 * Decompiled with CFR 0.152.
 */
package io.agora.log;

import android.util.Log;
import com.elvishew.xlog.printer.Printer;
import io.agora.log.AgoraConsolePrintType;

public class AgoraAndroidLogPrinter
implements Printer {
    static final int DEFAULT_MAX_CHUNK_SIZE = 4000;
    private int maxChunkSize;
    private int consoleType = AgoraConsolePrintType.NONE;

    public AgoraAndroidLogPrinter(int consoleType) {
        this(consoleType, 4000);
    }

    public AgoraAndroidLogPrinter(int consoleType, int maxChunkSize) {
        this.consoleType = consoleType;
        this.maxChunkSize = maxChunkSize;
    }

    public void println(int logLevel, String tag, String msg) {
        if (this.consoleType == AgoraConsolePrintType.NONE) {
            return;
        }
        if (this.consoleType != AgoraConsolePrintType.ALL && logLevel < this.consoleType && logLevel < this.consoleType) {
            return;
        }
        if (msg.length() <= this.maxChunkSize) {
            this.printChunk(logLevel, tag, msg);
            return;
        }
        int msgLength = msg.length();
        int start = 0;
        while (start < msgLength) {
            int end = AgoraAndroidLogPrinter.adjustEnd(msg, start, Math.min(start + this.maxChunkSize, msgLength));
            this.printChunk(logLevel, tag, msg.substring(start, end));
            start = end;
        }
    }

    static int adjustEnd(String msg, int start, int originEnd) {
        if (originEnd == msg.length()) {
            return originEnd;
        }
        if (msg.charAt(originEnd) == '\n') {
            return originEnd;
        }
        for (int last = originEnd - 1; start < last; --last) {
            if (msg.charAt(last) != '\n') continue;
            return last + 1;
        }
        return originEnd;
    }

    void printChunk(int logLevel, String tag, String msg) {
        Log.println((int)logLevel, (String)tag, (String)msg);
    }
}

