/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary.compressor;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.config.Configuration;
import com.abedelazizshe.lightcompressorlibrary.utils.CompressorUtils;
import com.abedelazizshe.lightcompressorlibrary.utils.StreamableVideo;
import com.abedelazizshe.lightcompressorlibrary.video.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.video.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.video.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.video.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.video.Result;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JK\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u000bH\u0002J(\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0002Jb\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u00109\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u00104\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/compressor/Compressor;", "", "()V", "INVALID_BITRATE", "", "MEDIACODEC_TIMEOUT_DEFAULT", "", "MIME_TYPE", "MIN_BITRATE", "", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/video/Result;", "index", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "destination", "streamableFile", "configuration", "Lcom/abedelazizshe/lightcompressorlibrary/config/Configuration;", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "(ILandroid/content/Context;Landroid/net/Uri;Ljava/lang/String;Ljava/lang/String;Lcom/abedelazizshe/lightcompressorlibrary/config/Configuration;Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "", "videoIndex", "decoder", "Landroid/media/MediaCodec;", "encoder", "inputSurface", "Lcom/abedelazizshe/lightcompressorlibrary/video/InputSurface;", "outputSurface", "Lcom/abedelazizshe/lightcompressorlibrary/video/OutputSurface;", "extractor", "Landroid/media/MediaExtractor;", "prepareDecoder", "inputFormat", "Landroid/media/MediaFormat;", "prepareEncoder", "outputFormat", "hasQTI", "processAudio", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/video/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "disableAudio", "start", "id", "newWidth", "newHeight", "newBitrate", "compressionProgressListener", "duration", "rotation", "lightcompressor_release"})
public final class Compressor {
    @NotNull
    public static final Compressor INSTANCE = new Compressor();
    private static final int MIN_BITRATE = 2000000;
    @NotNull
    private static final String MIME_TYPE = "video/avc";
    private static final long MEDIACODEC_TIMEOUT_DEFAULT = 100L;
    @NotNull
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false";
    private static boolean isRunning = true;

    private Compressor() {
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    @Nullable
    public final Object compressVideo(int index, @NotNull Context context, @NotNull Uri srcUri, @NotNull String destination, @Nullable String streamableFile, @NotNull Configuration configuration, @NotNull CompressionProgressListener listener, @NotNull Continuation<? super Result> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(context, srcUri, index, configuration, destination, streamableFile, listener, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Uri $srcUri;
            final /* synthetic */ int $index;
            final /* synthetic */ Configuration $configuration;
            final /* synthetic */ String $destination;
            final /* synthetic */ String $streamableFile;
            final /* synthetic */ CompressionProgressListener $listener;
            {
                this.$context = $context;
                this.$srcUri = $srcUri;
                this.$index = $index;
                this.$configuration = $configuration;
                this.$destination = $destination;
                this.$streamableFile = $streamableFile;
                this.$listener = $listener;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        int n;
                        Pair pair;
                        int newBitrate;
                        int n2;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                        MediaExtractor extractor = new MediaExtractor();
                        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
                        try {
                            mediaMetadataRetriever.setDataSource(this.$context, this.$srcUri);
                        }
                        catch (IllegalArgumentException exception) {
                            CompressorUtils.INSTANCE.printException(exception);
                            return new Result(this.$index, false, String.valueOf(exception.getMessage()), 0L, null, 24, null);
                        }
                        CoroutineScope exception = $this$withContext;
                        Context context = this.$context;
                        Uri uri = this.$srcUri;
                        try {
                            boolean bl = false;
                            extractor.setDataSource(context, uri, null);
                            Object object2 = kotlin.Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable) {
                            Object object3 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        double height = CompressorUtils.INSTANCE.prepareVideoHeight(mediaMetadataRetriever);
                        double width = CompressorUtils.INSTANCE.prepareVideoWidth(mediaMetadataRetriever);
                        String rotationData = mediaMetadataRetriever.extractMetadata(24);
                        String bitrateData = mediaMetadataRetriever.extractMetadata(20);
                        String durationData = mediaMetadataRetriever.extractMetadata(9);
                        CharSequence charSequence = rotationData;
                        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)bitrateData) == null || charSequence.length() == 0 || (charSequence = (CharSequence)durationData) == null || charSequence.length() == 0) {
                            return new Result(this.$index, false, "Failed to extract video meta-data, please try again", 0L, null, 24, null);
                        }
                        int rotation = Integer.parseInt(rotationData);
                        int bitrate = Integer.parseInt(bitrateData);
                        long duration = Long.parseLong(durationData) * (long)1000;
                        if (this.$configuration.isMinBitrateCheckEnabled() && bitrate <= 2000000) {
                            return new Result(this.$index, false, "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false", 0L, null, 24, null);
                        }
                        if (this.$configuration.getVideoBitrate() == null) {
                            n2 = CompressorUtils.INSTANCE.getBitrate(bitrate, this.$configuration.getQuality());
                        } else {
                            Integer n3 = this.$configuration.getVideoBitrate();
                            Intrinsics.checkNotNull((Object)n3);
                            n2 = newBitrate = n3.intValue();
                        }
                        if (this.$configuration.getVideoHeight() != null) {
                            Double d = this.$configuration.getVideoWidth();
                            Double d2 = this.$configuration.getVideoHeight();
                            pair = new Pair((Object)(d == null ? null : Boxing.boxInt((int)((int)d.doubleValue()))), (Object)(d2 == null ? null : Boxing.boxInt((int)((int)d2.doubleValue()))));
                        } else {
                            pair = CompressorUtils.INSTANCE.generateWidthAndHeight(width, height, this.$configuration.getKeepOriginalResolution());
                        }
                        Pair pair2 = pair;
                        Integer newWidth = (Integer)pair2.component1();
                        Integer newHeight = (Integer)pair2.component2();
                        switch (rotation) {
                            case 90: 
                            case 270: {
                                Integer tempHeight = newHeight;
                                newHeight = newWidth;
                                newWidth = tempHeight;
                                n = 0;
                                break;
                            }
                            case 180: {
                                n = 0;
                                break;
                            }
                            default: {
                                n = rotation;
                            }
                        }
                        rotation = n;
                        Integer n4 = newWidth;
                        Intrinsics.checkNotNull((Object)n4);
                        int n5 = n4;
                        Integer n6 = newHeight;
                        Intrinsics.checkNotNull((Object)n6);
                        return Compressor.access$start(Compressor.INSTANCE, this.$index, n5, n6, this.$destination, newBitrate, this.$streamableFile, this.$configuration.getDisableAudio(), extractor, this.$listener, duration, rotation);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Result>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Result start(int id, int newWidth, int newHeight, String destination, int newBitrate, String streamableFile, boolean disableAudio, MediaExtractor extractor, CompressionProgressListener compressionProgressListener, long duration, int rotation) {
        if (newWidth != 0 && newHeight != 0) {
            File cacheFile = new File(destination);
            try {
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                Mp4Movie movie = CompressorUtils.INSTANCE.setUpMP4Movie(rotation, cacheFile);
                MP4Builder mediaMuxer = new MP4Builder().createMovie(movie);
                int videoIndex = CompressorUtils.INSTANCE.findTrack(extractor, true);
                extractor.selectTrack(videoIndex);
                extractor.seekTo(0L, 0);
                MediaFormat mediaFormat = extractor.getTrackFormat(videoIndex);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(videoIndex)");
                MediaFormat inputFormat = mediaFormat;
                MediaFormat mediaFormat2 = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)newWidth, (int)newHeight);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"createVideoFormat(MIME_TYPE, newWidth, newHeight)");
                MediaFormat outputFormat = mediaFormat2;
                CompressorUtils.INSTANCE.setOutputFileParameters(inputFormat, outputFormat, newBitrate);
                MediaCodec decoder = null;
                boolean hasQTI = CompressorUtils.INSTANCE.hasQTI();
                MediaCodec encoder = this.prepareEncoder(outputFormat, hasQTI);
                InputSurface inputSurface = null;
                OutputSurface outputSurface = null;
                try {
                    boolean inputDone = false;
                    boolean outputDone = false;
                    int videoTrackIndex = -5;
                    inputSurface = new InputSurface(encoder.createInputSurface());
                    inputSurface.makeCurrent();
                    encoder.start();
                    outputSurface = new OutputSurface();
                    decoder = this.prepareDecoder(inputFormat, outputSurface);
                    decoder.start();
                    while (!outputDone) {
                        if (!inputDone) {
                            int inputBufferIndex;
                            int index = extractor.getSampleTrackIndex();
                            if (index == videoIndex) {
                                inputBufferIndex = decoder.dequeueInputBuffer(100L);
                                if (inputBufferIndex >= 0) {
                                    ByteBuffer inputBuffer;
                                    ByteBuffer byteBuffer = inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                    Intrinsics.checkNotNull((Object)byteBuffer);
                                    int chunkSize = extractor.readSampleData(byteBuffer, 0);
                                    if (chunkSize < 0) {
                                        decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                        inputDone = true;
                                    } else {
                                        decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                        extractor.advance();
                                    }
                                }
                            } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(100L)) >= 0) {
                                decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                inputDone = true;
                            }
                        }
                        boolean decoderOutputAvailable = true;
                        boolean encoderOutputAvailable = true;
                        while (decoderOutputAvailable || encoderOutputAvailable) {
                            if (!isRunning) {
                                this.dispose(videoIndex, decoder, encoder, inputSurface, outputSurface, extractor);
                                compressionProgressListener.onProgressCancelled(id);
                                return new Result(id, false, "The compression has stopped!", 0L, null, 24, null);
                            }
                            int encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 100L);
                            if (encoderStatus == -1) {
                                encoderOutputAvailable = false;
                            } else if (encoderStatus == -2) {
                                MediaFormat mediaFormat3 = encoder.getOutputFormat();
                                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat3, (String)"encoder.outputFormat");
                                MediaFormat newFormat = mediaFormat3;
                                if (videoTrackIndex == -5) {
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            } else if (encoderStatus != -3) {
                                if (encoderStatus < 0) {
                                    throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from encoder.dequeueOutputBuffer: ", (Object)encoderStatus));
                                }
                                ByteBuffer byteBuffer = encoder.getOutputBuffer(encoderStatus);
                                if (byteBuffer == null) {
                                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                }
                                ByteBuffer encodedData = byteBuffer;
                                if (bufferInfo.size > 1 && (bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                }
                                outputDone = (bufferInfo.flags & 4) != 0;
                                encoder.releaseOutputBuffer(encoderStatus, false);
                            }
                            if (encoderStatus != -1) continue;
                            int decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 100L);
                            if (decoderStatus == -1) {
                                decoderOutputAvailable = false;
                                continue;
                            }
                            if (decoderStatus == -3 || decoderStatus == -2) continue;
                            if (decoderStatus < 0) {
                                throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from decoder.dequeueOutputBuffer: ", (Object)decoderStatus));
                            }
                            boolean doRender = bufferInfo.size != 0;
                            decoder.releaseOutputBuffer(decoderStatus, doRender);
                            if (doRender) {
                                boolean errorWait = false;
                                try {
                                    outputSurface.awaitNewImage();
                                }
                                catch (Exception e) {
                                    errorWait = true;
                                    String string = e.getMessage();
                                    if (string == null) {
                                        string = "Compression failed at swapping buffer";
                                    }
                                    Log.e((String)"Compressor", (String)string);
                                }
                                if (!errorWait) {
                                    outputSurface.drawImage();
                                    inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                                    compressionProgressListener.onProgressChanged(id, (float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                                    inputSurface.swapBuffers();
                                }
                            }
                            if ((bufferInfo.flags & 4) == 0) continue;
                            decoderOutputAvailable = false;
                            encoder.signalEndOfInputStream();
                        }
                    }
                }
                catch (Exception exception) {
                    CompressorUtils.INSTANCE.printException(exception);
                    return new Result(id, false, exception.getMessage(), 0L, null, 24, null);
                }
                this.dispose(videoIndex, decoder, encoder, inputSurface, outputSurface, extractor);
                this.processAudio(mediaMuxer, bufferInfo, disableAudio, extractor);
                extractor.release();
                try {
                    mediaMuxer.finishMovie();
                }
                catch (Exception e) {
                    CompressorUtils.INSTANCE.printException(e);
                }
            }
            catch (Exception exception) {
                CompressorUtils.INSTANCE.printException(exception);
            }
            File resultFile = null;
            resultFile = cacheFile;
            String string = streamableFile;
            if (string != null) {
                String it = string;
                boolean bl = false;
                try {
                    boolean result = StreamableVideo.INSTANCE.start(cacheFile, new File(it));
                    resultFile = new File(it);
                    if (result && cacheFile.exists()) {
                        cacheFile.delete();
                    }
                }
                catch (Exception e) {
                    CompressorUtils.INSTANCE.printException(e);
                }
            }
            return new Result(id, true, null, resultFile.length(), resultFile.getPath());
        }
        return new Result(id, false, "Something went wrong, please try again", 0L, null, 24, null);
    }

    private final void processAudio(MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo, boolean disableAudio, MediaExtractor extractor) {
        int audioIndex = CompressorUtils.INSTANCE.findTrack(extractor, false);
        if (audioIndex >= 0 && !disableAudio) {
            ByteBuffer byteBuffer;
            long size;
            extractor.selectTrack(audioIndex);
            MediaFormat mediaFormat = extractor.getTrackFormat(audioIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            if (maxBufferSize <= 0) {
                maxBufferSize = 65536;
            }
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(maxBufferSize);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocateDirect(maxBufferSize)");
            ByteBuffer buffer = byteBuffer2;
            if (Build.VERSION.SDK_INT >= 28 && (size = extractor.getSampleSize()) > (long)maxBufferSize) {
                maxBufferSize = (int)(size + (long)1024);
                byteBuffer = ByteBuffer.allocateDirect(maxBufferSize);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(maxBufferSize)");
                buffer = byteBuffer;
            }
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size >= 0) {
                        ByteBuffer $this$processAudio_u24lambda_u2d1 = byteBuffer = bufferInfo;
                        boolean bl = false;
                        ((MediaCodec.BufferInfo)$this$processAudio_u24lambda_u2d1).presentationTimeUs = extractor.getSampleTime();
                        ((MediaCodec.BufferInfo)$this$processAudio_u24lambda_u2d1).offset = 0;
                        ((MediaCodec.BufferInfo)$this$processAudio_u24lambda_u2d1).flags = 1;
                        mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                        extractor.advance();
                        continue;
                    }
                    bufferInfo.size = 0;
                    inputDone = true;
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private final MediaCodec prepareEncoder(MediaFormat outputFormat, boolean hasQTI) {
        MediaCodec mediaCodec = hasQTI ? MediaCodec.createByCodecName((String)"c2.android.avc.encoder") : MediaCodec.createEncoderByType((String)MIME_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"if (hasQTI) {\n          \u2026Type(MIME_TYPE)\n        }");
        MediaCodec encoder = mediaCodec;
        encoder.configure(outputFormat, null, null, 1);
        return encoder;
    }

    private final MediaCodec prepareDecoder(MediaFormat inputFormat, OutputSurface outputSurface) {
        String string = inputFormat.getString("mime");
        Intrinsics.checkNotNull((Object)string);
        MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createDecoderByType(inpu\u2026(MediaFormat.KEY_MIME)!!)");
        MediaCodec decoder = mediaCodec;
        decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
        return decoder;
    }

    private final void dispose(int videoIndex, MediaCodec decoder, MediaCodec encoder, InputSurface inputSurface, OutputSurface outputSurface, MediaExtractor extractor) {
        extractor.unselectTrack(videoIndex);
        decoder.stop();
        decoder.release();
        encoder.stop();
        encoder.release();
        inputSurface.release();
        outputSurface.release();
    }

    public static final /* synthetic */ Result access$start(Compressor $this, int id, int newWidth, int newHeight, String destination, int newBitrate, String streamableFile, boolean disableAudio, MediaExtractor extractor, CompressionProgressListener compressionProgressListener, long duration, int rotation) {
        return $this.start(id, newWidth, newHeight, destination, newBitrate, streamableFile, disableAudio, extractor, compressionProgressListener, duration, rotation);
    }
}

