/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary.compressor;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.config.Configuration;
import com.abedelazizshe.lightcompressorlibrary.utils.CompressorUtils;
import com.abedelazizshe.lightcompressorlibrary.utils.StreamableVideo;
import com.abedelazizshe.lightcompressorlibrary.video.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.video.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.video.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.video.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.video.Result;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bJ0\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020\u0010H\u0002J \u00102\u001a\u00020#2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0010H\u0002JI\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010<\u001a\u0004\u0018\u00010\t2\u0006\u00107\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010=R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/compressor/Compressor;", "", "()V", "INVALID_BITRATE", "", "MEDIACODEC_TIMEOUT_DEFAULT", "", "MIME_TYPE", "MIN_BITRATE", "", "compressionProgressListener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "duration", "extractor", "Landroid/media/MediaExtractor;", "isRunning", "", "()Z", "setRunning", "(Z)V", "resultFile", "Ljava/io/File;", "rotation", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/video/Result;", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "destination", "streamableFile", "configuration", "Lcom/abedelazizshe/lightcompressorlibrary/config/Configuration;", "listener", "dispose", "", "videoIndex", "decoder", "Landroid/media/MediaCodec;", "encoder", "inputSurface", "Lcom/abedelazizshe/lightcompressorlibrary/video/InputSurface;", "outputSurface", "Lcom/abedelazizshe/lightcompressorlibrary/video/OutputSurface;", "prepareDecoder", "inputFormat", "Landroid/media/MediaFormat;", "prepareEncoder", "outputFormat", "hasQTI", "processAudio", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/video/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "disableAudio", "start", "newWidth", "newHeight", "newBitrate", "frameRate", "(IILjava/lang/String;ILjava/lang/String;Ljava/lang/Integer;Z)Lcom/abedelazizshe/lightcompressorlibrary/video/Result;", "lightcompressor_release"})
public final class Compressor {
    @NotNull
    public static final Compressor INSTANCE = new Compressor();
    private static final int MIN_BITRATE = 2000000;
    @NotNull
    private static final String MIME_TYPE = "video/avc";
    private static final long MEDIACODEC_TIMEOUT_DEFAULT = 100L;
    private static MediaExtractor extractor;
    private static CompressionProgressListener compressionProgressListener;
    private static long duration;
    private static int rotation;
    @Nullable
    private static File resultFile;
    @NotNull
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false";
    private static boolean isRunning;

    private Compressor() {
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    @NotNull
    public final Result compressVideo(@NotNull Context context, @NotNull Uri srcUri, @NotNull String destination, @Nullable String streamableFile, @NotNull Configuration configuration, @NotNull CompressionProgressListener listener) {
        int n;
        Pair pair;
        int newBitrate;
        int n2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)srcUri, (String)"srcUri");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        extractor = new MediaExtractor();
        compressionProgressListener = listener;
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        try {
            mediaMetadataRetriever.setDataSource(context, srcUri);
        }
        catch (IllegalArgumentException exception) {
            CompressorUtils.INSTANCE.printException(exception);
            return new Result(false, String.valueOf(exception.getMessage()), 0L, null, 12, null);
        }
        MediaExtractor mediaExtractor = extractor;
        if (mediaExtractor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
            mediaExtractor = null;
        }
        mediaExtractor.setDataSource(context, srcUri, null);
        double height = CompressorUtils.INSTANCE.prepareVideoHeight(mediaMetadataRetriever);
        double width = CompressorUtils.INSTANCE.prepareVideoWidth(mediaMetadataRetriever);
        String rotationData = mediaMetadataRetriever.extractMetadata(24);
        String bitrateData = mediaMetadataRetriever.extractMetadata(20);
        String durationData = mediaMetadataRetriever.extractMetadata(9);
        CharSequence charSequence = rotationData;
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)bitrateData) == null || charSequence.length() == 0 || (charSequence = (CharSequence)durationData) == null || charSequence.length() == 0) {
            return new Result(false, "Failed to extract video meta-data, please try again", 0L, null, 12, null);
        }
        rotation = Integer.parseInt(rotationData);
        int bitrate = Integer.parseInt(bitrateData);
        duration = Long.parseLong(durationData) * (long)1000;
        if (configuration.isMinBitrateCheckEnabled() && bitrate <= 2000000) {
            return new Result(false, INVALID_BITRATE, 0L, null, 12, null);
        }
        if (configuration.getVideoBitrate() == null) {
            n2 = CompressorUtils.INSTANCE.getBitrate(bitrate, configuration.getQuality());
        } else {
            Integer n3 = configuration.getVideoBitrate();
            Intrinsics.checkNotNull((Object)n3);
            n2 = newBitrate = n3.intValue();
        }
        if (configuration.getVideoHeight() != null) {
            Double d = configuration.getVideoWidth();
            Double d2 = configuration.getVideoHeight();
            pair = new Pair((Object)(d == null ? null : Integer.valueOf((int)d.doubleValue())), (Object)(d2 == null ? null : Integer.valueOf((int)d2.doubleValue())));
        } else {
            pair = CompressorUtils.INSTANCE.generateWidthAndHeight(width, height, configuration.getKeepOriginalResolution());
        }
        Pair pair2 = pair;
        Integer newWidth = (Integer)pair2.component1();
        Integer newHeight = (Integer)pair2.component2();
        switch (rotation) {
            case 90: 
            case 270: {
                Integer tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                n = 0;
                break;
            }
            case 180: {
                n = 0;
                break;
            }
            default: {
                n = rotation;
            }
        }
        rotation = n;
        Integer n4 = newWidth;
        Intrinsics.checkNotNull((Object)n4);
        int n5 = n4;
        Integer n6 = newHeight;
        Intrinsics.checkNotNull((Object)n6);
        return this.start(n5, n6, destination, newBitrate, streamableFile, configuration.getFrameRate(), configuration.getDisableAudio());
    }

    private final Result start(int newWidth, int newHeight, String destination, int newBitrate, String streamableFile, Integer frameRate, boolean disableAudio) {
        if (newWidth != 0 && newHeight != 0) {
            long l;
            Unit unit;
            File cacheFile = new File(destination);
            try {
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                Mp4Movie movie = CompressorUtils.INSTANCE.setUpMP4Movie(rotation, cacheFile);
                MP4Builder mediaMuxer = new MP4Builder().createMovie(movie);
                MediaExtractor mediaExtractor = extractor;
                if (mediaExtractor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                    mediaExtractor = null;
                }
                int videoIndex = CompressorUtils.INSTANCE.findTrack(mediaExtractor, true);
                MediaExtractor mediaExtractor2 = extractor;
                if (mediaExtractor2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                    mediaExtractor2 = null;
                }
                mediaExtractor2.selectTrack(videoIndex);
                MediaExtractor mediaExtractor3 = extractor;
                if (mediaExtractor3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                    mediaExtractor3 = null;
                }
                mediaExtractor3.seekTo(0L, 0);
                MediaExtractor mediaExtractor4 = extractor;
                if (mediaExtractor4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                    mediaExtractor4 = null;
                }
                MediaFormat mediaFormat = mediaExtractor4.getTrackFormat(videoIndex);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(videoIndex)");
                MediaFormat inputFormat = mediaFormat;
                MediaFormat mediaFormat2 = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)newWidth, (int)newHeight);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"createVideoFormat(MIME_TYPE, newWidth, newHeight)");
                MediaFormat outputFormat = mediaFormat2;
                CompressorUtils.INSTANCE.setOutputFileParameters(inputFormat, outputFormat, newBitrate, frameRate);
                MediaCodec decoder = null;
                boolean hasQTI = CompressorUtils.INSTANCE.hasQTI();
                MediaCodec encoder = this.prepareEncoder(outputFormat, hasQTI);
                InputSurface inputSurface = null;
                OutputSurface outputSurface = null;
                try {
                    boolean inputDone = false;
                    boolean outputDone = false;
                    int videoTrackIndex = -5;
                    inputSurface = new InputSurface(encoder.createInputSurface());
                    inputSurface.makeCurrent();
                    encoder.start();
                    outputSurface = new OutputSurface();
                    decoder = this.prepareDecoder(inputFormat, outputSurface);
                    decoder.start();
                    while (!outputDone) {
                        if (!inputDone) {
                            int inputBufferIndex;
                            int index;
                            MediaExtractor mediaExtractor5 = extractor;
                            if (mediaExtractor5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                                mediaExtractor5 = null;
                            }
                            if ((index = mediaExtractor5.getSampleTrackIndex()) == videoIndex) {
                                inputBufferIndex = decoder.dequeueInputBuffer(100L);
                                if (inputBufferIndex >= 0) {
                                    ByteBuffer inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                    MediaExtractor mediaExtractor6 = extractor;
                                    if (mediaExtractor6 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                                        mediaExtractor6 = null;
                                    }
                                    ByteBuffer byteBuffer = inputBuffer;
                                    Intrinsics.checkNotNull((Object)byteBuffer);
                                    int chunkSize = mediaExtractor6.readSampleData(byteBuffer, 0);
                                    if (chunkSize < 0) {
                                        decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                        inputDone = true;
                                    } else {
                                        MediaExtractor mediaExtractor7 = extractor;
                                        if (mediaExtractor7 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                                            mediaExtractor7 = null;
                                        }
                                        decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, mediaExtractor7.getSampleTime(), 0);
                                        MediaExtractor mediaExtractor8 = extractor;
                                        if (mediaExtractor8 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                                            mediaExtractor8 = null;
                                        }
                                        mediaExtractor8.advance();
                                    }
                                }
                            } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(100L)) >= 0) {
                                decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                inputDone = true;
                            }
                        }
                        boolean decoderOutputAvailable = true;
                        boolean encoderOutputAvailable = true;
                        while (decoderOutputAvailable || encoderOutputAvailable) {
                            if (!isRunning) {
                                CompressionProgressListener compressionProgressListener = Compressor.compressionProgressListener;
                                if (compressionProgressListener == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"compressionProgressListener");
                                    compressionProgressListener = null;
                                }
                                compressionProgressListener.onProgressCancelled();
                                return new Result(false, "The compression has stopped!", 0L, null, 12, null);
                            }
                            int encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 100L);
                            if (encoderStatus == -1) {
                                encoderOutputAvailable = false;
                            } else if (encoderStatus == -2) {
                                MediaFormat mediaFormat3 = encoder.getOutputFormat();
                                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat3, (String)"encoder.outputFormat");
                                MediaFormat newFormat = mediaFormat3;
                                if (videoTrackIndex == -5) {
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            } else if (encoderStatus != -3) {
                                if (encoderStatus < 0) {
                                    throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from encoder.dequeueOutputBuffer: ", (Object)encoderStatus));
                                }
                                ByteBuffer byteBuffer = encoder.getOutputBuffer(encoderStatus);
                                if (byteBuffer == null) {
                                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                }
                                ByteBuffer encodedData = byteBuffer;
                                if (bufferInfo.size > 1 && (bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                }
                                outputDone = (bufferInfo.flags & 4) != 0;
                                encoder.releaseOutputBuffer(encoderStatus, false);
                            }
                            if (encoderStatus != -1) continue;
                            int decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 100L);
                            if (decoderStatus == -1) {
                                decoderOutputAvailable = false;
                                continue;
                            }
                            if (decoderStatus == -3 || decoderStatus == -2) continue;
                            if (decoderStatus < 0) {
                                throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from decoder.dequeueOutputBuffer: ", (Object)decoderStatus));
                            }
                            boolean doRender = bufferInfo.size != 0;
                            decoder.releaseOutputBuffer(decoderStatus, doRender);
                            if (doRender) {
                                boolean errorWait = false;
                                try {
                                    outputSurface.awaitNewImage();
                                }
                                catch (Exception e) {
                                    errorWait = true;
                                    String string = e.getMessage();
                                    if (string == null) {
                                        string = "Compression failed at swapping buffer";
                                    }
                                    Log.e((String)"Compressor", (String)string);
                                }
                                if (!errorWait) {
                                    outputSurface.drawImage();
                                    inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                                    CompressionProgressListener compressionProgressListener = Compressor.compressionProgressListener;
                                    if (compressionProgressListener == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"compressionProgressListener");
                                        compressionProgressListener = null;
                                    }
                                    compressionProgressListener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                                    inputSurface.swapBuffers();
                                }
                            }
                            if ((bufferInfo.flags & 4) == 0) continue;
                            decoderOutputAvailable = false;
                            encoder.signalEndOfInputStream();
                        }
                    }
                }
                catch (Exception exception) {
                    CompressorUtils.INSTANCE.printException(exception);
                    return new Result(false, exception.getMessage(), 0L, null, 12, null);
                }
                this.dispose(videoIndex, decoder, encoder, inputSurface, outputSurface);
                this.processAudio(mediaMuxer, bufferInfo, disableAudio);
                MediaExtractor mediaExtractor9 = extractor;
                if (mediaExtractor9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                    mediaExtractor9 = null;
                }
                mediaExtractor9.release();
                try {
                    mediaMuxer.finishMovie();
                }
                catch (Exception e) {
                    CompressorUtils.INSTANCE.printException(e);
                }
            }
            catch (Exception exception) {
                CompressorUtils.INSTANCE.printException(exception);
            }
            resultFile = cacheFile;
            String string = streamableFile;
            if (string == null) {
                unit = null;
            } else {
                String it = string;
                boolean bl = false;
                try {
                    boolean result = StreamableVideo.INSTANCE.start(cacheFile, new File(it));
                    resultFile = new File(it);
                    if (result && cacheFile.exists()) {
                        cacheFile.delete();
                    }
                }
                catch (Exception e) {
                    CompressorUtils.INSTANCE.printException(e);
                }
                unit = Unit.INSTANCE;
            }
            File file = resultFile;
            File file2 = resultFile;
            return new Result(true, null, file == null ? 0L : (l = file.length()), (String)(file2 == null ? null : file2.getPath()));
        }
        return new Result(false, "Something went wrong, please try again", 0L, null, 12, null);
    }

    private final void processAudio(MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo, boolean disableAudio) {
        int audioIndex;
        MediaExtractor mediaExtractor = extractor;
        if (mediaExtractor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
            mediaExtractor = null;
        }
        if ((audioIndex = CompressorUtils.INSTANCE.findTrack(mediaExtractor, false)) >= 0 && !disableAudio) {
            ByteBuffer byteBuffer;
            MediaExtractor mediaExtractor2 = extractor;
            if (mediaExtractor2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                mediaExtractor2 = null;
            }
            mediaExtractor2.selectTrack(audioIndex);
            MediaExtractor mediaExtractor3 = extractor;
            if (mediaExtractor3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                mediaExtractor3 = null;
            }
            MediaFormat mediaFormat = mediaExtractor3.getTrackFormat(audioIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            if (maxBufferSize <= 0) {
                maxBufferSize = 65536;
            }
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(maxBufferSize);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocateDirect(maxBufferSize)");
            ByteBuffer buffer = byteBuffer2;
            if (Build.VERSION.SDK_INT >= 28) {
                long size;
                MediaExtractor mediaExtractor4 = extractor;
                if (mediaExtractor4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                    mediaExtractor4 = null;
                }
                if ((size = mediaExtractor4.getSampleSize()) > (long)maxBufferSize) {
                    maxBufferSize = (int)(size + (long)1024);
                    byteBuffer = ByteBuffer.allocateDirect(maxBufferSize);
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(maxBufferSize)");
                    buffer = byteBuffer;
                }
            }
            boolean inputDone = false;
            MediaExtractor mediaExtractor5 = extractor;
            if (mediaExtractor5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                mediaExtractor5 = null;
            }
            mediaExtractor5.seekTo(0L, 0);
            while (!inputDone) {
                int index;
                MediaExtractor mediaExtractor6 = extractor;
                if (mediaExtractor6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                    mediaExtractor6 = null;
                }
                if ((index = mediaExtractor6.getSampleTrackIndex()) == audioIndex) {
                    MediaExtractor mediaExtractor7 = extractor;
                    if (mediaExtractor7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                        mediaExtractor7 = null;
                    }
                    bufferInfo.size = mediaExtractor7.readSampleData(buffer, 0);
                    if (bufferInfo.size >= 0) {
                        ByteBuffer $this$processAudio_u24lambda_u2d1 = byteBuffer = bufferInfo;
                        boolean bl = false;
                        MediaExtractor mediaExtractor8 = extractor;
                        if (mediaExtractor8 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                            mediaExtractor8 = null;
                        }
                        ((MediaCodec.BufferInfo)$this$processAudio_u24lambda_u2d1).presentationTimeUs = mediaExtractor8.getSampleTime();
                        ((MediaCodec.BufferInfo)$this$processAudio_u24lambda_u2d1).offset = 0;
                        ((MediaCodec.BufferInfo)$this$processAudio_u24lambda_u2d1).flags = 1;
                        mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                        MediaExtractor mediaExtractor9 = extractor;
                        if (mediaExtractor9 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                            mediaExtractor9 = null;
                        }
                        mediaExtractor9.advance();
                        continue;
                    }
                    bufferInfo.size = 0;
                    inputDone = true;
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            MediaExtractor mediaExtractor10 = extractor;
            if (mediaExtractor10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
                mediaExtractor10 = null;
            }
            mediaExtractor10.unselectTrack(audioIndex);
        }
    }

    private final MediaCodec prepareEncoder(MediaFormat outputFormat, boolean hasQTI) {
        MediaCodec mediaCodec = hasQTI ? MediaCodec.createByCodecName((String)"c2.android.avc.encoder") : MediaCodec.createEncoderByType((String)MIME_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"if (hasQTI) {\n          \u2026Type(MIME_TYPE)\n        }");
        MediaCodec encoder = mediaCodec;
        encoder.configure(outputFormat, null, null, 1);
        return encoder;
    }

    private final MediaCodec prepareDecoder(MediaFormat inputFormat, OutputSurface outputSurface) {
        String string = inputFormat.getString("mime");
        Intrinsics.checkNotNull((Object)string);
        MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createDecoderByType(inpu\u2026(MediaFormat.KEY_MIME)!!)");
        MediaCodec decoder = mediaCodec;
        decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
        return decoder;
    }

    private final void dispose(int videoIndex, MediaCodec decoder, MediaCodec encoder, InputSurface inputSurface, OutputSurface outputSurface) {
        MediaExtractor mediaExtractor = extractor;
        if (mediaExtractor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extractor");
            mediaExtractor = null;
        }
        mediaExtractor.unselectTrack(videoIndex);
        decoder.stop();
        decoder.release();
        encoder.stop();
        encoder.release();
        inputSurface.release();
        outputSurface.release();
    }

    static {
        isRunning = true;
    }
}

