/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary.video;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.abedelazizshe.lightcompressorlibrary.video.Mdat;
import com.abedelazizshe.lightcompressorlibrary.video.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.video.Sample;
import com.abedelazizshe.lightcompressorlibrary.video.Track;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.HintMediaHeaderBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.NullMediaHeaderBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SubtitleMediaHeaderBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.googlecode.mp4parser.util.Matrix;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010*\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010+\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010,\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010-\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0006\u00100\u001a\u00020&J\b\u00101\u001a\u00020&H\u0002J\u0018\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002J\u0010\u00105\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J&\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010\u001a\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/video/MP4Builder;", "", "()V", "currentMp4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/video/Mp4Movie;", "dataOffset", "", "fc", "Ljava/nio/channels/FileChannel;", "fos", "Ljava/io/FileOutputStream;", "mdat", "Lcom/abedelazizshe/lightcompressorlibrary/video/Mdat;", "sizeBuffer", "Ljava/nio/ByteBuffer;", "track2SampleSizes", "Ljava/util/HashMap;", "Lcom/abedelazizshe/lightcompressorlibrary/video/Track;", "", "writeNewMdat", "", "wroteSinceLastMdat", "addTrack", "", "mediaFormat", "Landroid/media/MediaFormat;", "isAudio", "createFileTypeBox", "Lcom/coremedia/iso/boxes/FileTypeBox;", "createMovie", "mp4Movie", "createMovieBox", "Lcom/coremedia/iso/boxes/MovieBox;", "movie", "createStbl", "Lcom/coremedia/iso/boxes/Box;", "track", "createStco", "", "stbl", "Lcom/coremedia/iso/boxes/SampleTableBox;", "createStsc", "createStsd", "createStss", "createStsz", "createStts", "createTrackBox", "Lcom/coremedia/iso/boxes/TrackBox;", "finishMovie", "flushCurrentMdat", "gcd", "a", "b", "getTimescale", "writeSampleData", "trackIndex", "byteBuf", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "lightcompressor_release"})
public final class MP4Builder {
    private Mdat mdat;
    private Mp4Movie currentMp4Movie;
    private FileOutputStream fos;
    private FileChannel fc;
    private long dataOffset;
    private long wroteSinceLastMdat;
    private boolean writeNewMdat = true;
    @NotNull
    private final HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private ByteBuffer sizeBuffer;

    @NotNull
    public final MP4Builder createMovie(@NotNull Mp4Movie mp4Movie) throws Exception {
        Intrinsics.checkNotNullParameter((Object)mp4Movie, (String)"mp4Movie");
        this.currentMp4Movie = mp4Movie;
        this.fos = new FileOutputStream(mp4Movie.getCacheFile());
        Object object = this.fos;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            throw null;
        }
        FileChannel fileChannel = ((FileOutputStream)object).getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"fos.channel");
        this.fc = fileChannel;
        FileTypeBox fileTypeBox = this.createFileTypeBox();
        object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        fileTypeBox.getBox((WritableByteChannel)object);
        object = this;
        ((MP4Builder)object).dataOffset += fileTypeBox.getSize();
        this.wroteSinceLastMdat = this.dataOffset;
        this.mdat = new Mdat();
        object = ByteBuffer.allocateDirect(4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allocateDirect(4)");
        this.sizeBuffer = object;
        return this;
    }

    private final void flushCurrentMdat() throws Exception {
        Object object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        long oldPosition = ((FileChannel)object).position();
        object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        FileChannel fileChannel = object;
        object = this.mdat;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            throw null;
        }
        fileChannel.position(((Mdat)object).getOffset());
        object = this.mdat;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            throw null;
        }
        Object object2 = object;
        object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        ((Mdat)object2).getBox((WritableByteChannel)object);
        object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        ((FileChannel)object).position(oldPosition);
        object = this.mdat;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            throw null;
        }
        ((Mdat)object).setDataOffset(0L);
        object = this.mdat;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            throw null;
        }
        ((Mdat)object).setContentSize(0L);
        object = this.fos;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            throw null;
        }
        ((OutputStream)object).flush();
    }

    public final void writeSampleData(int trackIndex, @NotNull ByteBuffer byteBuf, @NotNull MediaCodec.BufferInfo bufferInfo, boolean isAudio) throws Exception {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        if (this.writeNewMdat) {
            object2 = this.mdat;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
                throw null;
            }
            boolean bl = false;
            boolean bl2 = false;
            Mdat $this$writeSampleData_u24lambda_u2d0 = object2;
            boolean bl3 = false;
            $this$writeSampleData_u24lambda_u2d0.setContentSize(0L);
            FileChannel fileChannel = this.fc;
            if (fileChannel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
                throw null;
            }
            $this$writeSampleData_u24lambda_u2d0.getBox(fileChannel);
            $this$writeSampleData_u24lambda_u2d0.setDataOffset(this.dataOffset);
            object2 = this;
            ((MP4Builder)object2).dataOffset += (long)16;
            object2 = this;
            ((MP4Builder)object2).wroteSinceLastMdat += (long)16;
            this.writeNewMdat = false;
        }
        if ((object2 = this.mdat) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            throw null;
        }
        Mdat mdat = object2;
        object2 = this.mdat;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            throw null;
        }
        mdat.setContentSize(((Mdat)object2).getContentSize() + (long)bufferInfo.size);
        object2 = this;
        ((MP4Builder)object2).wroteSinceLastMdat += (long)bufferInfo.size;
        boolean flush = false;
        if (this.wroteSinceLastMdat >= 32768L) {
            this.flushCurrentMdat();
            this.writeNewMdat = true;
            flush = true;
            this.wroteSinceLastMdat = 0L;
        }
        if ((object = this.currentMp4Movie) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            throw null;
        }
        ((Mp4Movie)object).addSample(trackIndex, this.dataOffset, bufferInfo);
        if (!isAudio) {
            byteBuf.position(bufferInfo.offset + 4);
            byteBuf.limit(bufferInfo.offset + bufferInfo.size);
            object = this.sizeBuffer;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                throw null;
            }
            ((ByteBuffer)object).position(0);
            object = this.sizeBuffer;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                throw null;
            }
            ((ByteBuffer)object).putInt(bufferInfo.size - 4);
            object = this.sizeBuffer;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                throw null;
            }
            ((ByteBuffer)object).position(0);
            object = this.fc;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
                throw null;
            }
            Object object3 = object;
            object = this.sizeBuffer;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                throw null;
            }
            ((FileChannel)object3).write((ByteBuffer)object);
        } else {
            byteBuf.position(bufferInfo.offset + 0);
            byteBuf.limit(bufferInfo.offset + bufferInfo.size);
        }
        object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        ((FileChannel)object).write(byteBuf);
        object = this;
        ((MP4Builder)object).dataOffset += (long)bufferInfo.size;
        if (flush) {
            object = this.fos;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
                throw null;
            }
            ((OutputStream)object).flush();
        }
    }

    public final int addTrack(@NotNull MediaFormat mediaFormat, boolean isAudio) {
        Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
        Mp4Movie mp4Movie = this.currentMp4Movie;
        if (mp4Movie == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            throw null;
        }
        return mp4Movie.addTrack(mediaFormat, isAudio);
    }

    public final void finishMovie() throws Exception {
        Object object;
        Object object2 = this.mdat;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            throw null;
        }
        if (((Mdat)object2).getContentSize() != 0L) {
            this.flushCurrentMdat();
        }
        if ((object = this.currentMp4Movie) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            throw null;
        }
        object2 = ((Mp4Movie)object).getTracks().iterator();
        while (object2.hasNext()) {
            int n = 0;
            Track track = (Track)object2.next();
            List samples = track.getSamples();
            long[] sizes = new long[samples.size()];
            int n2 = sizes.length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    sizes[i] = ((Sample)samples.get(i)).getSize();
                } while (n <= n2);
            }
            Map map = this.track2SampleSizes;
            Intrinsics.checkNotNullExpressionValue((Object)track, (String)"track");
            Track track2 = track;
            boolean bl = false;
            map.put(track2, sizes);
        }
        object = this.currentMp4Movie;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            throw null;
        }
        Box moov = (Box)this.createMovieBox((Mp4Movie)object);
        object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        moov.getBox((WritableByteChannel)object);
        object = this.fos;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            throw null;
        }
        ((OutputStream)object).flush();
        object = this.fc;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            throw null;
        }
        ((AbstractInterruptibleChannel)object).close();
        object = this.fos;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            throw null;
        }
        ((FileOutputStream)object).close();
    }

    private final FileTypeBox createFileTypeBox() {
        Object[] objectArray = new String[]{"isom", "mp42", "3gp4"};
        List minorBrands = CollectionsKt.listOf((Object[])objectArray);
        return new FileTypeBox("isom", 0L, minorBrands);
    }

    private final long gcd(long a, long b) {
        return b == 0L ? a : this.gcd(b, a % b);
    }

    private final long getTimescale(Mp4Movie mp4Movie) {
        long timescale = 0L;
        Collection collection = mp4Movie.getTracks();
        boolean bl = false;
        if (!collection.isEmpty()) {
            timescale = mp4Movie.getTracks().iterator().next().getTimeScale();
        }
        for (Track track : mp4Movie.getTracks()) {
            timescale = this.gcd(track.getTimeScale(), timescale);
        }
        return timescale;
    }

    private final MovieBox createMovieBox(Mp4Movie movie) {
        MovieHeaderBox mvhd;
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox movieHeaderBox = mvhd = new MovieHeaderBox();
        boolean bl = false;
        boolean bl2 = false;
        MovieHeaderBox $this$createMovieBox_u24lambda_u2d1 = movieHeaderBox;
        boolean bl3 = false;
        $this$createMovieBox_u24lambda_u2d1.setCreationTime(new Date());
        $this$createMovieBox_u24lambda_u2d1.setModificationTime(new Date());
        $this$createMovieBox_u24lambda_u2d1.setMatrix(Matrix.ROTATE_0);
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration = track.getDuration() * movieTimeScale / (long)track.getTimeScale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        mvhd.setNextTrackId((long)(movie.getTracks().size() + 1));
        movieBox.addBox((Box)mvhd);
        for (Track track : movie.getTracks()) {
            Intrinsics.checkNotNullExpressionValue((Object)track, (String)"track");
            movieBox.addBox((Box)this.createTrackBox(track, movie));
        }
        return movieBox;
    }

    private final TrackBox createTrackBox(Track track, Mp4Movie movie) {
        HandlerBox hdlr;
        MediaHeaderBox mdhd;
        TrackHeaderBox tkhd;
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox trackHeaderBox = tkhd = new TrackHeaderBox();
        boolean bl = false;
        boolean bl2 = false;
        TrackHeaderBox $this$createTrackBox_u24lambda_u2d622 = trackHeaderBox;
        boolean bl3 = false;
        $this$createTrackBox_u24lambda_u2d622.setEnabled(true);
        $this$createTrackBox_u24lambda_u2d622.setInPreview(true);
        $this$createTrackBox_u24lambda_u2d622.setInMovie(true);
        $this$createTrackBox_u24lambda_u2d622.setMatrix(track.isAudio() ? Matrix.ROTATE_0 : movie.getMatrix());
        $this$createTrackBox_u24lambda_u2d622.setAlternateGroup(0);
        $this$createTrackBox_u24lambda_u2d622.setCreationTime(track.getCreationTime());
        $this$createTrackBox_u24lambda_u2d622.setDuration(track.getDuration() * this.getTimescale(movie) / (long)track.getTimeScale());
        $this$createTrackBox_u24lambda_u2d622.setHeight((double)track.getHeight());
        $this$createTrackBox_u24lambda_u2d622.setWidth((double)track.getWidth());
        $this$createTrackBox_u24lambda_u2d622.setLayer(0);
        $this$createTrackBox_u24lambda_u2d622.setModificationTime(new Date());
        $this$createTrackBox_u24lambda_u2d622.setTrackId(track.getTrackId() + 1L);
        $this$createTrackBox_u24lambda_u2d622.setVolume(track.getVolume());
        trackBox.addBox((Box)tkhd);
        MediaBox mdia = new MediaBox();
        trackBox.addBox((Box)mdia);
        MediaHeaderBox mediaHeaderBox = mdhd = new MediaHeaderBox();
        boolean $this$createTrackBox_u24lambda_u2d622 = false;
        bl3 = false;
        MediaHeaderBox $this$createTrackBox_u24lambda_u2d52 = mediaHeaderBox;
        boolean bl4 = false;
        $this$createTrackBox_u24lambda_u2d52.setCreationTime(track.getCreationTime());
        $this$createTrackBox_u24lambda_u2d52.setDuration(track.getDuration());
        $this$createTrackBox_u24lambda_u2d52.setTimescale((long)track.getTimeScale());
        $this$createTrackBox_u24lambda_u2d52.setLanguage("eng");
        mdia.addBox((Box)mdhd);
        HandlerBox $this$createTrackBox_u24lambda_u2d622 = hdlr = new HandlerBox();
        bl3 = false;
        boolean $this$createTrackBox_u24lambda_u2d52 = false;
        HandlerBox $this$createTrackBox_u24lambda_u2d4 = $this$createTrackBox_u24lambda_u2d622;
        boolean bl5 = false;
        $this$createTrackBox_u24lambda_u2d4.setName(track.isAudio() ? "SoundHandle" : "VideoHandle");
        $this$createTrackBox_u24lambda_u2d4.setHandlerType(track.getHandler());
        mdia.addBox((Box)hdlr);
        MediaInformationBox minf = new MediaInformationBox();
        if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"vide")) {
            minf.addBox((Box)new VideoMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"soun")) {
            minf.addBox((Box)new SoundMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"text")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"subt")) {
            minf.addBox((Box)new SubtitleMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"hint")) {
            minf.addBox((Box)new HintMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"sbtl")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        }
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox((Box)dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox((Box)url);
        minf.addBox((Box)dinf);
        Box stbl = this.createStbl(track);
        minf.addBox(stbl);
        mdia.addBox((Box)minf);
        return trackBox;
    }

    private final Box createStbl(Track track) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        this.createStts(track, stbl);
        this.createStss(track, stbl);
        this.createStsc(track, stbl);
        this.createStsz(track, stbl);
        this.createStco(track, stbl);
        return (Box)stbl;
    }

    private final void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox((Box)track.getSampleDescriptionBox());
    }

    private final void createStts(Track track, SampleTableBox stbl) {
        TimeToSampleBox.Entry lastEntry = null;
        List entries = new ArrayList();
        for (Long delta : track.getSampleDurations()) {
            if (lastEntry != null) {
                Long l = delta;
                if (l != null && lastEntry.getDelta() == l.longValue()) {
                    lastEntry.setCount(lastEntry.getCount() + 1L);
                    continue;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)delta, (String)"delta");
            lastEntry = new TimeToSampleBox.Entry(1L, delta.longValue());
            entries.add(lastEntry);
        }
        TimeToSampleBox stts = new TimeToSampleBox();
        stts.setEntries(entries);
        stbl.addBox((Box)stts);
    }

    private final void createStss(Track track, SampleTableBox stbl) {
        long[] syncSamples = track.getSyncSamples();
        if (syncSamples != null) {
            long[] lArray = syncSamples;
            boolean bl = false;
            long[] lArray2 = lArray;
            boolean bl2 = false;
            if (!(lArray2.length == 0)) {
                SyncSampleBox stss = new SyncSampleBox();
                stss.setSampleNumber(syncSamples);
                stbl.addBox((Box)stss);
            }
        }
    }

    private final void createStsc(Track track, SampleTableBox stbl) {
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries((List)new LinkedList());
        long lastOffset = 0L;
        int lastChunkNumber = 1;
        int lastSampleCount = 0;
        int previousWrittenChunkCount = -1;
        int samplesCount = track.getSamples().size();
        int n = 0;
        if (n < samplesCount) {
            do {
                int a = n++;
                Sample sample = track.getSamples().get(a);
                Intrinsics.checkNotNullExpressionValue((Object)sample, (String)"track.getSamples()[a]");
                Sample sample2 = sample;
                long offset = sample2.getOffset();
                long size = sample2.getSize();
                lastOffset = offset + size;
                int n2 = lastSampleCount;
                lastSampleCount = n2 + 1;
                boolean write = false;
                if (a != samplesCount - 1) {
                    Sample sample3 = track.getSamples().get(a + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)sample3, (String)"track.getSamples()[a + 1]");
                    Sample nextSample = sample3;
                    if (lastOffset != nextSample.getOffset()) {
                        write = true;
                    }
                } else {
                    write = true;
                }
                if (!write) continue;
                if (previousWrittenChunkCount != lastSampleCount) {
                    stsc.getEntries().add(new SampleToChunkBox.Entry((long)lastChunkNumber, (long)lastSampleCount, 1L));
                    previousWrittenChunkCount = lastSampleCount;
                }
                lastSampleCount = 0;
                int n3 = lastChunkNumber;
                lastChunkNumber = n3 + 1;
            } while (n < samplesCount);
        }
        stbl.addBox((Box)stsc);
    }

    private final void createStsz(Track track, SampleTableBox stbl) {
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox((Box)stsz);
    }

    private final void createStco(Track track, SampleTableBox stbl) {
        ArrayList<Long> chunksOffsets = new ArrayList<Long>();
        long lastOffset = -1L;
        for (Sample sample : track.getSamples()) {
            long offset = sample.getOffset();
            if (lastOffset != -1L && lastOffset != offset) {
                lastOffset = -1L;
            }
            if (lastOffset == -1L) {
                chunksOffsets.add(offset);
            }
            lastOffset = offset + sample.getSize();
        }
        long[] chunkOffsetsLong = new long[chunksOffsets.size()];
        int sample = 0;
        int n = chunksOffsets.size() + -1;
        if (sample <= n) {
            do {
                int a = sample++;
                Object e = chunksOffsets.get(a);
                Intrinsics.checkNotNullExpressionValue(e, (String)"chunksOffsets[a]");
                chunkOffsetsLong[a] = ((Number)e).longValue();
            } while (sample <= n);
        }
        StaticChunkOffsetBox stco = new StaticChunkOffsetBox();
        stco.setChunkOffsets(chunkOffsetsLong);
        stbl.addBox((Box)stco);
    }
}

