/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.Compressor;
import com.abedelazizshe.lightcompressorlibrary.Compressor$WhenMappings;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.Result;
import com.abedelazizshe.lightcompressorlibrary.VideoHelper;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!J,\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040#2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0002J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0017\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020-H\u0003\u00a2\u0006\u0002\u0010.J\u0017\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020-H\u0003\u00a2\u0006\u0002\u0010.J\u0017\u00100\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020-H\u0003\u00a2\u0006\u0002\u0010.J\u0010\u00101\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00102\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-H\u0002J\u0017\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020-H\u0003\u00a2\u0006\u0002\u0010.J\u0017\u00104\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020-H\u0002\u00a2\u0006\u0002\u0010.J\u0014\u00105\u001a\u0002062\n\u00107\u001a\u000608j\u0002`9H\u0002J \u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0002J\u0018\u0010B\u001a\u00020\u00042\u0006\u0010;\u001a\u00020<2\u0006\u0010C\u001a\u00020\u0010H\u0002J \u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020\u0004H\u0002J\u0018\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020LH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006M"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "FRAME_RATE", "", "INVALID_BITRATE", "", "I_FRAME_INTERVAL", "MEDIACODEC_TIMEOUT_DEFAULT", "", "MIME_TYPE", "MIN_BITRATE", "MIN_HEIGHT", "", "MIN_WIDTH", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/Result;", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "srcPath", "destination", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "isMinBitRateEnabled", "keepOriginalResolution", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "generateWidthHeightValue", "value", "factor", "getBitrate", "bitrate", "getColorRange", "format", "Landroid/media/MediaFormat;", "(Landroid/media/MediaFormat;)Ljava/lang/Integer;", "getColorStandard", "getColorTransfer", "getFrameRate", "getIFrameIntervalRate", "getLevel", "getProfile", "printException", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processAudio", "extractor", "Landroid/media/MediaExtractor;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "roundEven", "selectTrack", "isVideo", "setOutputFileParameters", "inputFormat", "outputFormat", "newBitrate", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "cacheFile", "Ljava/io/File;", "lightcompressor_release"})
public final class Compressor {
    private static final int MIN_BITRATE = 2000000;
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 360.0;
    private static final int FRAME_RATE = 30;
    private static final int I_FRAME_INTERVAL = 2;
    private static final String MIME_TYPE = "video/avc";
    private static final long MEDIACODEC_TIMEOUT_DEFAULT = 100L;
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false";
    private static boolean isRunning;
    public static final Compressor INSTANCE;

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Result compressVideo(@Nullable Context context, @Nullable Uri srcUri, @Nullable String srcPath, @NotNull String destination, @NotNull VideoQuality quality, boolean isMinBitRateEnabled, boolean keepOriginalResolution, @NotNull CompressionProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)quality, (String)"quality");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (context == null && srcPath == null && srcUri == null) {
            return new Result(false, "You need to provide either a srcUri or a srcPath");
        }
        if (context == null && srcPath == null && srcUri != null) {
            return new Result(false, "You need to provide the application context");
        }
        var9_9 = new Ref.ObjectRef();
        var9_9.element = srcPath;
        if (context != null && srcUri != null && (String)source.element == null) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, srcUri, (Ref.ObjectRef)source, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ Context $context;
                final /* synthetic */ Uri $srcUri;
                final /* synthetic */ Ref.ObjectRef $source;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$runBlocking = this.p$;
                            job = BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ compressVideo.1 this$0;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$async = this.p$;
                                            return VideoHelper.INSTANCE.getMediaPath(this.this$0.$context, this.this$0.$srcUri);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super String>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            var4_5 = this.$source;
                            this.L$0 = $this$runBlocking;
                            this.L$1 = job;
                            this.L$2 = var4_5;
                            this.label = 1;
                            v0 = job.await((Continuation)this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl22
                        }
                        case 1: {
                            var4_5 = (Ref.ObjectRef)this.L$2;
                            job = (Deferred)this.L$1;
                            $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            var5_6 = v0;
                            var4_5.element = (String)var5_6;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$context = context;
                    this.$srcUri = uri;
                    this.$source = objectRef;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        mediaMetadataRetriever = new MediaMetadataRetriever();
        try {
            mediaMetadataRetriever.setDataSource((String)source.element);
        }
        catch (IllegalArgumentException exception) {
            return new Result(false, "Source path: " + (String)source.element + " can be invalid! or you don't have READ_EXTERNAL_STORAGE permission");
        }
        heightData = mediaMetadataRetriever.extractMetadata(19);
        widthData = mediaMetadataRetriever.extractMetadata(18);
        rotationData = mediaMetadataRetriever.extractMetadata(24);
        bitrateData = mediaMetadataRetriever.extractMetadata(20);
        durationData = mediaMetadataRetriever.extractMetadata(9);
        height = 0.0;
        width = 0.0;
        var20_19 = heightData;
        var21_21 = false;
        var22_24 = false;
        if (var20_19 == null || var20_19.length() == 0) ** GOTO lbl-1000
        var20_19 = widthData;
        var21_21 = false;
        var22_24 = false;
        if (var20_19 == null || var20_19.length() == 0) lbl-1000:
        // 2 sources

        {
            height = 640.0;
            width = 360.0;
        } else {
            var20_19 = heightData;
            var21_21 = false;
            height = Double.parseDouble((String)var20_19);
            var20_19 = widthData;
            var21_21 = false;
            width = Double.parseDouble((String)var20_19);
        }
        var20_19 = rotationData;
        var21_21 = false;
        var22_24 = false;
        if ((var20_19 == null || var20_19.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var20_19 = bitrateData;
        var21_21 = false;
        var22_24 = false;
        if ((var20_19 == null || var20_19.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var20_19 = durationData;
        var21_21 = false;
        var22_24 = false;
        if (var20_19 == null || var20_19.length() == 0) {
            return new Result(false, "Failed to extract video meta-data, please try again");
        }
        var21_22 = rotationData;
        var22_24 = false;
        rotation = Integer.parseInt(var21_22);
        var22_25 = bitrateData;
        var23_27 = false;
        bitrate = Integer.parseInt(var22_25);
        var24_28 = durationData;
        var25_30 = 0;
        duration = Long.parseLong(var24_28) * (long)1000;
        if (isMinBitRateEnabled && bitrate <= 2000000) {
            return new Result(false, "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false");
        }
        newBitrate = this.getBitrate(bitrate, quality);
        var27_31 = this.generateWidthAndHeight(width, height, keepOriginalResolution);
        var25_30 = ((Number)var27_31.component1()).intValue();
        newHeight = ((Number)var27_31.component2()).intValue();
        switch (rotation) {
            case 90: 
            case 270: {
                tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                v0 = 0;
                break;
            }
            case 180: {
                v0 = 0;
                break;
            }
            default: {
                v0 = rotation;
            }
        }
        rotation = v0;
        file = new File((String)source.element);
        if (!file.canRead()) {
            return new Result(false, "The source file cannot be accessed!");
        }
        noExceptions = true;
        if (newWidth == 0) return new Result(false, "Something went wrong, please try again");
        if (newHeight == 0) return new Result(false, "Something went wrong, please try again");
        cacheFile = new File(destination);
        try {
            bufferInfo = new MediaCodec.BufferInfo();
            movie = this.setUpMP4Movie(rotation, cacheFile);
            mediaMuxer = new MP4Builder().createMovie(movie);
            extractor = new MediaExtractor();
            extractor.setDataSource(file.toString());
            videoIndex = this.selectTrack(extractor, true);
            extractor.selectTrack(videoIndex);
            extractor.seekTo(0L, 0);
            v1 = extractor.getTrackFormat(videoIndex);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"extractor.getTrackFormat(videoIndex)");
            inputFormat = v1;
            v2 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"MediaFormat.createVideoF\u2026YPE, newWidth, newHeight)");
            outputFormat = v2;
            this.setOutputFileParameters(inputFormat, outputFormat, newBitrate);
            decoder = null;
            hasQTI = false;
            var42_48 = list = new MediaCodecList(0).getCodecInfos();
            var43_49 = var42_48.length;
            for (var41_53 = 0; var41_53 < var43_49; ++var41_53) {
                v3 = codec = var42_48[var41_53];
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"codec");
                Log.i((String)"CODECS: ", (String)v3.getName());
                v4 = codec.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"codec.name");
                if (!StringsKt.contains$default((CharSequence)v4, (CharSequence)"qti.avc", (boolean)false, (int)2, null)) continue;
                hasQTI = true;
                break;
            }
            if (hasQTI) {
                v5 = MediaCodec.createByCodecName((String)"c2.android.avc.encoder");
                v6 = v5;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"MediaCodec.createByCodec\u2026\"c2.android.avc.encoder\")");
            } else {
                v7 = MediaCodec.createEncoderByType((String)"video/avc");
                v6 = v7;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"MediaCodec.createEncoderByType(MIME_TYPE)");
            }
            encoder = v6;
            inputSurface = null;
            outputSurface = null;
            try {
                inputDone = false;
                outputDone = false;
                videoTrackIndex = -5;
                encoder.configure(outputFormat, null, null, 1);
                inputSurface = new InputSurface(encoder.createInputSurface());
                inputSurface.makeCurrent();
                encoder.start();
                outputSurface = new OutputSurface();
                if (hasQTI) {
                    v8 = MediaCodec.createByCodecName((String)"c2.android.avc.decoder");
                } else {
                    v9 = inputFormat.getString("mime");
                    Intrinsics.checkNotNull((Object)v9);
                    v8 = MediaCodec.createDecoderByType((String)v9);
                }
                decoder = v8;
                decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                decoder.start();
                while (!outputDone) {
                    if (!inputDone) {
                        index = extractor.getSampleTrackIndex();
                        if (index == videoIndex) {
                            inputBufferIndex = decoder.dequeueInputBuffer(100L);
                            if (inputBufferIndex >= 0) {
                                v10 = inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                Intrinsics.checkNotNull((Object)v10);
                                chunkSize = extractor.readSampleData((ByteBuffer)v10, 0);
                                if (chunkSize < 0) {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                    inputDone = true;
                                } else {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                    extractor.advance();
                                }
                            }
                        } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(100L)) >= 0) {
                            decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                            inputDone = true;
                        }
                    }
                    decoderOutputAvailable = true;
                    encoderOutputAvailable = true;
lbl177:
                    // 6 sources

                    while (decoderOutputAvailable || encoderOutputAvailable) {
                        if (Compressor.isRunning) ** GOTO lbl-1000
                        listener.onProgressCancelled();
                        inputBuffer = new Result(false, "The compression has been stopped!");
                        ** GOTO lbl222
                    }
                }
                ** GOTO lbl342
            }
            catch (Exception exception) {
                try {
                    this.printException(exception);
                    noExceptions = false;
                }
                catch (Throwable exception) {
                    extractor.unselectTrack(videoIndex);
                    v11 = decoder;
                    if (v11 != null) {
                        v11.stop();
                        v12 = Unit.INSTANCE;
                    } else {
                        v12 = null;
                    }
                    v13 = decoder;
                    if (v13 != null) {
                        v13.release();
                        v14 = Unit.INSTANCE;
                    } else {
                        v14 = null;
                    }
                    encoder.stop();
                    encoder.release();
                    v15 = inputSurface;
                    if (v15 != null) {
                        v15.release();
                        v16 = Unit.INSTANCE;
                    } else {
                        v16 = null;
                    }
                    v17 = outputSurface;
                    if (v17 != null) {
                        v17.release();
                        v18 = Unit.INSTANCE;
                    } else {
                        v18 = null;
                    }
                    v19 = mediaMuxer;
                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"mediaMuxer");
                    this.processAudio(extractor, v19, bufferInfo);
                    throw exception;
                }
lbl222:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v20 = decoder;
                if (v20 != null) {
                    v20.stop();
                    v21 = Unit.INSTANCE;
                } else {
                    v21 = null;
                }
                v22 = decoder;
                if (v22 != null) {
                    v22.release();
                    v23 = Unit.INSTANCE;
                } else {
                    v23 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v24 = mediaMuxer;
                Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"mediaMuxer");
                this.processAudio(extractor, v24, bufferInfo);
                return inputBuffer;
lbl-1000:
                // 1 sources

                {
                    block81: {
                        encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 100L);
                        if (encoderStatus == -1) {
                            encoderOutputAvailable = false;
                        } else if (encoderStatus == -2) {
                            Intrinsics.checkNotNullExpressionValue((Object)encoder.getOutputFormat(), (String)"encoder.outputFormat");
                            if (videoTrackIndex == -5) {
                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                            }
                        } else if (encoderStatus != -3) {
                            if (encoderStatus < 0) {
                                throw (Throwable)new RuntimeException("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                            }
                            if (encoder.getOutputBuffer(encoderStatus) == null) throw (Throwable)new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                            Intrinsics.checkNotNullExpressionValue((Object)encodedData, (String)"encoder.getOutputBuffer(\u2026$encoderStatus was null\")");
                            if (bufferInfo.size > 1) {
                                if ((bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                } else if (videoTrackIndex == -5) {
                                    csd = new byte[bufferInfo.size];
                                    var51_68 = encodedData;
                                    var52_71 = false;
                                    var53_74 = 0;
                                    $this$apply = var51_68;
                                    $i$a$-apply-Compressor$compressVideo$2 = false;
                                    $this$apply.limit(bufferInfo.offset + bufferInfo.size);
                                    $this$apply.position(bufferInfo.offset);
                                    $this$apply.get(csd);
                                    sps = null;
                                    pps = null;
                                    var53_74 = bufferInfo.size - 1;
                                    var54_75 = false;
                                    while (var53_74 >= 0 && a > 3) {
                                        if (csd[a] == 1 && csd[a - true] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                            sps = ByteBuffer.allocate((int)(a - 3));
                                            pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                            v25 = sps;
                                            Intrinsics.checkNotNull((Object)v25);
                                            v25.put(csd, 0, (int)(a - 3)).position(0);
                                            v26 = pps;
                                            Intrinsics.checkNotNull((Object)v26);
                                            v26.put(csd, (int)(a - 3), bufferInfo.size - (a - 3)).position(0);
                                            break;
                                        }
                                        --a;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight), (String)"MediaFormat.createVideoF\u2026                        )");
                                    if (sps != null && pps != null) {
                                        newFormat.setByteBuffer("csd-0", sps);
                                        newFormat.setByteBuffer("csd-1", pps);
                                    }
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            }
                            outputDone = (bufferInfo.flags & 4) != 0;
                            encoder.releaseOutputBuffer(encoderStatus, false);
                        }
                        if (encoderStatus != -1) ** GOTO lbl177
                        decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 100L);
                        if (decoderStatus != -1) break block81;
                        decoderOutputAvailable = false;
                        ** GOTO lbl177
                    }
                    if (decoderStatus == -3 || decoderStatus == -2) ** GOTO lbl177
                    if (decoderStatus < 0) {
                        throw (Throwable)new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                    }
                    doRender = bufferInfo.size != 0;
                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                    if (doRender) {
                        errorWait = false;
                        try {
                            outputSurface.awaitNewImage();
                        }
                        catch (Exception e) {
                            errorWait = true;
                            v27 = e.getMessage();
                            if (v27 == null) {
                                v27 = "Compression failed at swapping buffer";
                            }
                            Log.e((String)"Compressor", (String)v27);
                        }
                        if (!errorWait) {
                            outputSurface.drawImage();
                            inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                            listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                            inputSurface.swapBuffers();
                        }
                    }
                    if ((bufferInfo.flags & 4) == 0) ** GOTO lbl177
                    decoderOutputAvailable = false;
                    encoder.signalEndOfInputStream();
                    ** GOTO lbl177
                }
lbl342:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v28 = decoder;
                if (v28 != null) {
                    v28.stop();
                    v29 = Unit.INSTANCE;
                } else {
                    v29 = null;
                }
                v30 = decoder;
                if (v30 != null) {
                    v30.release();
                    v31 = Unit.INSTANCE;
                } else {
                    v31 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v32 = mediaMuxer;
                Intrinsics.checkNotNullExpressionValue((Object)v32, (String)"mediaMuxer");
                this.processAudio(extractor, v32, bufferInfo);
                extractor.unselectTrack(videoIndex);
                v33 = decoder;
                if (v33 != null) {
                    v33.stop();
                    v34 = Unit.INSTANCE;
                } else {
                    v34 = null;
                }
                v35 = decoder;
                if (v35 != null) {
                    v35.release();
                    v36 = Unit.INSTANCE;
                } else {
                    v36 = null;
                }
                encoder.stop();
                encoder.release();
                v37 = inputSurface;
                if (v37 != null) {
                    v37.release();
                    v38 = Unit.INSTANCE;
                } else {
                    v38 = null;
                }
                v39 = outputSurface;
                if (v39 != null) {
                    v39.release();
                    v40 = Unit.INSTANCE;
                }
                v40 = null;
            }
            extractor.release();
            try {
                mediaMuxer.finishMovie();
                return new Result(true, null);
            }
            catch (Exception e) {
                this.printException(e);
                return new Result(true, null);
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
        return new Result(true, null);
    }

    private final void printException(Exception exception) {
        String message = "An error has occurred!";
        String string = exception.getMessage();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message);
    }

    private final int getBitrate(int bitrate, VideoQuality quality) {
        int n;
        switch (Compressor$WhenMappings.$EnumSwitchMapping$0[quality.ordinal()]) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.08));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 4: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            case 5: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.5));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(double width, double height, boolean keepOriginalResolution) {
        if (keepOriginalResolution) {
            return new Pair((Object)MathKt.roundToInt((double)width), (Object)MathKt.roundToInt((double)height));
        }
        int newWidth = 0;
        int newHeight = 0;
        if (width >= (double)1920 || height >= (double)1920) {
            newWidth = this.generateWidthHeightValue(width, 0.5);
            newHeight = this.generateWidthHeightValue(height, 0.5);
        } else if (width >= (double)1280 || height >= (double)1280) {
            newWidth = this.generateWidthHeightValue(width, 0.75);
            newHeight = this.generateWidthHeightValue(height, 0.75);
        } else if (width >= (double)960 || height >= (double)960) {
            if (width > height) {
                newWidth = this.generateWidthHeightValue(640.0, 0.95);
                newHeight = this.generateWidthHeightValue(360.0, 0.95);
            } else {
                newWidth = this.generateWidthHeightValue(360.0, 0.95);
                newHeight = this.generateWidthHeightValue(640.0, 0.95);
            }
        } else {
            newWidth = this.generateWidthHeightValue(width, 0.9);
            newHeight = this.generateWidthHeightValue(height, 0.9);
        }
        return new Pair((Object)newWidth, (Object)newHeight);
    }

    private final int roundEven(int value) {
        return value + 1 & ~1;
    }

    private final int generateWidthHeightValue(double value, double factor) {
        return this.roundEven(MathKt.roundToInt((double)(value * factor / (double)16)) * 16);
    }

    private final Mp4Movie setUpMP4Movie(int rotation, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$apply = mp4Movie;
        boolean bl3 = false;
        $this$apply.setCacheFile(cacheFile);
        $this$apply.setRotation(rotation);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat inputFormat, MediaFormat outputFormat, int newBitrate) {
        block5: {
            int it;
            boolean bl;
            boolean bl2;
            Integer n;
            int frameRate = this.getFrameRate(inputFormat);
            int iFrameInterval = this.getIFrameIntervalRate(inputFormat);
            MediaFormat mediaFormat = outputFormat;
            boolean bl3 = false;
            boolean bl4 = false;
            MediaFormat $this$apply = mediaFormat;
            boolean bl5 = false;
            $this$apply.setInteger("color-format", 2130708361);
            $this$apply.setInteger("frame-rate", frameRate);
            $this$apply.setInteger("i-frame-interval", iFrameInterval);
            $this$apply.setInteger("bitrate", newBitrate);
            if (Build.VERSION.SDK_INT <= 23) break block5;
            Integer n2 = INSTANCE.getProfile(inputFormat);
            if (n2 != null) {
                n = n2;
                bl2 = false;
                bl = false;
                it = ((Number)n).intValue();
                boolean bl6 = false;
                $this$apply.setInteger("profile", it);
            }
            Integer n3 = INSTANCE.getLevel(inputFormat);
            if (n3 != null) {
                n = n3;
                bl2 = false;
                bl = false;
                it = ((Number)n).intValue();
                boolean bl7 = false;
                $this$apply.setInteger("level", it);
            }
            Integer n4 = INSTANCE.getColorStandard(inputFormat);
            if (n4 != null) {
                n = n4;
                bl2 = false;
                bl = false;
                it = ((Number)n).intValue();
                boolean bl8 = false;
                $this$apply.setInteger("color-standard", it);
            }
            Integer n5 = INSTANCE.getColorTransfer(inputFormat);
            if (n5 != null) {
                n = n5;
                bl2 = false;
                bl = false;
                it = ((Number)n).intValue();
                boolean bl9 = false;
                $this$apply.setInteger("color-transfer", it);
            }
            Integer n6 = INSTANCE.getColorRange(inputFormat);
            if (n6 != null) {
                n = n6;
                bl2 = false;
                bl = false;
                it = ((Number)n).intValue();
                boolean bl10 = false;
                $this$apply.setInteger("color-range", it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int numTracks = extractor.getTrackCount();
        int n = 0;
        int n2 = numTracks;
        while (n < n2) {
            MediaFormat format;
            void i;
            Intrinsics.checkNotNullExpressionValue((Object)extractor.getTrackFormat((int)i), (String)"extractor.getTrackFormat(i)");
            String mime = format.getString("mime");
            if (isVideo) {
                String string = mime;
                Boolean bl = string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null)) : null;
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) {
                    return (int)i;
                }
            } else {
                String string = mime;
                Boolean bl = string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null)) : null;
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) {
                    return (int)i;
                }
            }
            ++i;
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat mediaFormat = extractor.getTrackFormat(audioIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$apply = bufferInfo2;
                    boolean bl3 = false;
                    $this$apply.presentationTimeUs = extractor.getSampleTime();
                    $this$apply.offset = 0;
                    $this$apply.flags = extractor.getSampleFlags();
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private final int getFrameRate(MediaFormat format) {
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 2;
    }

    @RequiresApi(value=23)
    private final Integer getLevel(MediaFormat format) {
        return format.containsKey("level") ? Integer.valueOf(format.getInteger("level")) : null;
    }

    private final Integer getProfile(MediaFormat format) {
        return format.containsKey("profile") ? Integer.valueOf(format.getInteger("profile")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorStandard(MediaFormat format) {
        return format.containsKey("color-standard") ? Integer.valueOf(format.getInteger("color-standard")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorTransfer(MediaFormat format) {
        return format.containsKey("color-transfer") ? Integer.valueOf(format.getInteger("color-transfer")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorRange(MediaFormat format) {
        return format.containsKey("color-range") ? Integer.valueOf(format.getInteger("color-range")) : null;
    }

    private Compressor() {
    }

    static {
        Compressor compressor;
        INSTANCE = compressor = new Compressor();
        isRunning = true;
    }
}

