/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework.javax;

import apijson.JSON;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.framework.javax.APIJSONConstant;
import apijson.framework.javax.APIJSONCreator;
import apijson.framework.javax.APIJSONFunctionParser;
import apijson.framework.javax.APIJSONParser;
import apijson.framework.javax.APIJSONVerifier;
import apijson.orm.AbstractParser;
import apijson.orm.Parser;
import apijson.orm.Visitor;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.rmi.ServerException;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import unitauto.MethodUtil;

public class APIJSONController<T> {
    public static final String TAG = "APIJSONController";
    @NotNull
    public static APIJSONCreator<? extends Object> APIJSON_CREATOR = new APIJSONCreator();

    public String getRequestURL() {
        return null;
    }

    public Parser<T> newParser(HttpSession session, RequestMethod method) {
        Parser<? extends Object> parser = APIJSON_CREATOR.createParser();
        parser.setMethod(method);
        if (parser instanceof APIJSONParser) {
            ((APIJSONParser)parser).setSession(session);
        }
        if (parser instanceof AbstractParser) {
            ((AbstractParser)parser).setRequestURL(this.getRequestURL());
        }
        return parser;
    }

    public String parse(RequestMethod method, String request, HttpSession session) {
        return this.newParser(session, method).parse(request);
    }

    public String parseByTag(RequestMethod method, String tag, Map<String, String> params, String request, HttpSession session) {
        JSONObject req = AbstractParser.wrapRequest((RequestMethod)method, (String)tag, (JSONObject)JSON.parseObject((String)request), (boolean)false);
        if (req == null) {
            req = new JSONObject(true);
        }
        if (params != null && !params.isEmpty()) {
            req.putAll(params);
        }
        return this.newParser(session, method).parse(req);
    }

    public String crud(String method, String request, HttpSession session) {
        if (APIJSONConstant.METHODS.contains(method)) {
            return this.parse(RequestMethod.valueOf((String)method.toUpperCase()), request, session);
        }
        return APIJSONParser.newErrorResult((Exception)new IllegalArgumentException("URL \u8def\u5f84 /{method} \u4e2d method \u503c " + method + " \u9519\u8bef\uff01\u53ea\u5141\u8bb8 " + APIJSONConstant.METHODS + " \u4e2d\u7684\u4e00\u4e2a\uff01")).toJSONString();
    }

    public String get(String request, HttpSession session) {
        return this.parse(RequestMethod.GET, request, session);
    }

    public String head(String request, HttpSession session) {
        return this.parse(RequestMethod.HEAD, request, session);
    }

    public String gets(String request, HttpSession session) {
        return this.parse(RequestMethod.GETS, request, session);
    }

    public String heads(String request, HttpSession session) {
        return this.parse(RequestMethod.HEADS, request, session);
    }

    public String post(String request, HttpSession session) {
        return this.parse(RequestMethod.POST, request, session);
    }

    public String put(String request, HttpSession session) {
        return this.parse(RequestMethod.PUT, request, session);
    }

    public String delete(String request, HttpSession session) {
        return this.parse(RequestMethod.DELETE, request, session);
    }

    public String crud(String request, HttpSession session) {
        return this.parse(RequestMethod.CRUD, request, session);
    }

    public String crudByTag(String method, String tag, Map<String, String> params, String request, HttpSession session) {
        if (APIJSONConstant.METHODS.contains(method)) {
            return this.parseByTag(RequestMethod.valueOf((String)method.toUpperCase()), tag, params, request, session);
        }
        return APIJSONParser.newErrorResult((Exception)new IllegalArgumentException("URL \u8def\u5f84 /{method}/{tag} \u4e2d method \u503c " + method + " \u9519\u8bef\uff01\u53ea\u5141\u8bb8 " + APIJSONConstant.METHODS + " \u4e2d\u7684\u4e00\u4e2a\uff01")).toJSONString();
    }

    public String getByTag(String tag, Map<String, String> params, String request, HttpSession session) {
        return this.parseByTag(RequestMethod.GET, tag, params, request, session);
    }

    public String headByTag(String tag, Map<String, String> params, String request, HttpSession session) {
        return this.parseByTag(RequestMethod.HEAD, tag, params, request, session);
    }

    public String getsByTag(String tag, Map<String, String> params, String request, HttpSession session) {
        return this.parseByTag(RequestMethod.GETS, tag, params, request, session);
    }

    public String headsByTag(String tag, Map<String, String> params, String request, HttpSession session) {
        return this.parseByTag(RequestMethod.HEADS, tag, params, request, session);
    }

    public String postByTag(String tag, Map<String, String> params, String request, HttpSession session) {
        return this.parseByTag(RequestMethod.POST, tag, params, request, session);
    }

    public String putByTag(String tag, Map<String, String> params, String request, HttpSession session) {
        return this.parseByTag(RequestMethod.PUT, tag, params, request, session);
    }

    public String deleteByTag(String tag, Map<String, String> params, String request, HttpSession session) {
        return this.parseByTag(RequestMethod.DELETE, tag, params, request, session);
    }

    public JSONObject reload(String type) {
        boolean reloadAll;
        JSONObject result = APIJSONParser.newSuccessResult();
        boolean bl = reloadAll = StringUtil.isEmpty((String)type, (boolean)true) || "ALL".equals(type);
        if (reloadAll || "ACCESS".equals(type)) {
            try {
                if (!reloadAll && !APIJSONVerifier.ENABLE_VERIFY_ROLE) {
                    throw new UnsupportedOperationException("AbstractVerifier.ENABLE_VERIFY_ROLE == false \u65f6\u4e0d\u652f\u6301\u6821\u9a8c\u89d2\u8272\u6743\u9650\uff01\u5982\u9700\u652f\u6301\u5219\u8bbe\u7f6e AbstractVerifier.ENABLE_VERIFY_ROLE = true \uff01");
                }
                if (APIJSONVerifier.ENABLE_VERIFY_ROLE) {
                    result.put(APIJSONConstant.ACCESS_, (Object)APIJSONVerifier.initAccess());
                }
            }
            catch (ServerException e) {
                e.printStackTrace();
                result.put(APIJSONConstant.ACCESS_, (Object)APIJSONParser.newErrorResult((Exception)e));
            }
        }
        if (reloadAll || "FUNCTION".equals(type)) {
            try {
                if (!reloadAll && !APIJSONFunctionParser.ENABLE_REMOTE_FUNCTION) {
                    throw new UnsupportedOperationException("AbstractFunctionParser.ENABLE_REMOTE_FUNCTION == false \u65f6\u4e0d\u652f\u6301\u8fdc\u7a0b\u51fd\u6570\uff01\u5982\u9700\u652f\u6301\u5219\u8bbe\u7f6e AbstractFunctionParser.ENABLE_REMOTE_FUNCTION = true \uff01");
                }
                if (APIJSONFunctionParser.ENABLE_REMOTE_FUNCTION) {
                    result.put(APIJSONConstant.FUNCTION_, (Object)APIJSONFunctionParser.init());
                }
            }
            catch (ServerException e) {
                e.printStackTrace();
                result.put(APIJSONConstant.FUNCTION_, (Object)APIJSONParser.newErrorResult((Exception)e));
            }
        }
        if (reloadAll || "REQUEST".equals(type)) {
            try {
                if (!reloadAll && !APIJSONVerifier.ENABLE_VERIFY_CONTENT) {
                    throw new UnsupportedOperationException("AbstractVerifier.ENABLE_VERIFY_CONTENT == false \u65f6\u4e0d\u652f\u6301\u6821\u9a8c\u8bf7\u6c42\u4f20\u53c2\u5185\u5bb9\uff01\u5982\u9700\u652f\u6301\u5219\u8bbe\u7f6e AbstractVerifier.ENABLE_VERIFY_CONTENT = true \uff01");
                }
                if (APIJSONVerifier.ENABLE_VERIFY_CONTENT) {
                    result.put(APIJSONConstant.REQUEST_, (Object)APIJSONVerifier.initRequest());
                }
            }
            catch (ServerException e) {
                e.printStackTrace();
                result.put(APIJSONConstant.REQUEST_, (Object)APIJSONParser.newErrorResult((Exception)e));
            }
        }
        return result;
    }

    public Object login(@NotNull HttpSession session, Visitor<Long> visitor, Integer version, Boolean format, JSONObject defaults) {
        session.setAttribute("visitorId", visitor.getId());
        session.setAttribute(APIJSONConstant.VISITOR_, visitor);
        session.setAttribute("version", (Object)version);
        session.setAttribute("format", (Object)format);
        session.setAttribute("defaults", (Object)defaults);
        return null;
    }

    public Object logout(@NotNull HttpSession session) {
        Object userId = APIJSONVerifier.getVisitorId(session);
        Log.d((String)TAG, (String)("logout  userId = " + userId + "; session.getId() = " + (session == null ? null : session.getId())));
        session.invalidate();
        return null;
    }

    public JSONObject listMethod(String request) {
        if (!Log.DEBUG) {
            return APIJSONParser.newErrorResult((Exception)new IllegalAccessException("\u975e DEBUG \u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4f7f\u7528 UnitAuto \u5355\u5143\u6d4b\u8bd5\uff01"));
        }
        return MethodUtil.listMethod((String)request);
    }

    public void invokeMethod(String request, final HttpServletRequest servletRequest) {
        final AsyncContext asyncContext = servletRequest.startAsync();
        final boolean[] called = new boolean[]{false};
        MethodUtil.Listener<JSONObject> listener = new MethodUtil.Listener<JSONObject>(){

            public void complete(JSONObject data, Method method, MethodUtil.InterfaceProxy proxy, Object ... extras) throws Exception {
                ServletResponse servletResponse;
                ServletResponse servletResponse2 = servletResponse = called[0] ? null : asyncContext.getResponse();
                if (servletResponse == null) {
                    Log.w((String)APIJSONController.TAG, (String)"invokeMethod  listener.complete  servletResponse == null || servletResponse.isCommitted() >> return;");
                    return;
                }
                called[0] = true;
                servletResponse.setCharacterEncoding(servletRequest.getCharacterEncoding());
                servletResponse.setContentType(servletRequest.getContentType());
                servletResponse.getWriter().println(data);
                asyncContext.complete();
            }
        };
        if (!Log.DEBUG) {
            try {
                listener.complete((Object)MethodUtil.JSON_CALLBACK.newErrorResult((Throwable)new IllegalAccessException("\u975e DEBUG \u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4f7f\u7528 UnitAuto \u5355\u5143\u6d4b\u8bd5\uff01")));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                asyncContext.complete();
            }
            return;
        }
        try {
            MethodUtil.invokeMethod((String)request, null, (MethodUtil.Listener)listener);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("invokeMethod  try { JSONObject req = JSON.parseObject(request); ... } catch (Exception e) { \n" + e.getMessage()));
            try {
                listener.complete((Object)MethodUtil.JSON_CALLBACK.newErrorResult((Throwable)e));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                asyncContext.complete();
            }
        }
    }
}

