/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.JSON;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.framework.AssertUtil;
import apijson.framework.BaseModel;
import apijson.orm.AbstractFunctionParser;
import apijson.orm.JSONRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.rmi.ServerException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import unitauto.MethodUtil;

public class APIJSONFunctionParser
extends AbstractFunctionParser {
    public static final String TAG = "APIJSONFunctionParser";
    @NotNull
    public static APIJSONCreator<? extends Object> APIJSON_CREATOR = new APIJSONCreator();
    @NotNull
    public static final String[] ALL_METHODS = new String[]{RequestMethod.GET.name(), RequestMethod.HEAD.name(), RequestMethod.GETS.name(), RequestMethod.HEADS.name(), RequestMethod.POST.name(), RequestMethod.PUT.name(), RequestMethod.DELETE.name()};
    private HttpSession session;

    public APIJSONFunctionParser() {
        this(null);
    }

    public APIJSONFunctionParser(HttpSession session) {
        this(null, null, 0, null, session);
    }

    public APIJSONFunctionParser(RequestMethod method, String tag, int version, JSONObject request, HttpSession session) {
        super(method, tag, version, request);
        this.setSession(session);
    }

    public HttpSession getSession() {
        return this.session;
    }

    public APIJSONFunctionParser setSession(HttpSession session) {
        this.session = session;
        return this;
    }

    public APIJSONFunctionParser setMethod(RequestMethod method) {
        super.setMethod(method);
        return this;
    }

    public APIJSONFunctionParser setTag(String tag) {
        super.setTag(tag);
        return this;
    }

    public APIJSONFunctionParser setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    public static JSONObject init() throws ServerException {
        return APIJSONFunctionParser.init(false);
    }

    public static JSONObject init(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONFunctionParser.init(shutdownWhenServerError, null);
    }

    public static <T> JSONObject init(APIJSONCreator<T> creator) throws ServerException {
        return APIJSONFunctionParser.init(false, creator);
    }

    public static <T> JSONObject init(boolean shutdownWhenServerError, APIJSONCreator<T> creator) throws ServerException {
        return APIJSONFunctionParser.init(shutdownWhenServerError, creator, null);
    }

    public static <T> JSONObject init(boolean shutdownWhenServerError, APIJSONCreator<T> creator, JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        JSONObject function;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        Object object = function = isAll ? new JSONRequest() : table;
        if (!Log.DEBUG) {
            function.put(APIJSONConstant.KEY_DEBUG, (Object)0);
        }
        JSONRequest functionItem = new JSONRequest();
        functionItem.put(APIJSONConstant.FUNCTION_, (Object)function);
        JSONObject request = new JSONObject();
        request.putAll((Map)functionItem.toArray(0, 0, APIJSONConstant.FUNCTION_));
        JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(true).parseResponse(request);
        if (!JSONResponse.isSuccess((JSONObject)response)) {
            APIJSONFunctionParser.onServerError("\n\n\n\n\n !!!! \u67e5\u8be2\u8fdc\u7a0b\u51fd\u6570\u5f02\u5e38 !!!\n" + response.getString(JSONResponse.KEY_MSG) + "\n\n\n\n\n", shutdownWhenServerError);
        }
        int n = size = (list = response.getJSONArray(APIJSONConstant.FUNCTION_ + "[]")) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"init isAll && size <= 0\uff0c\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u8fdc\u7a0b\u51fd\u6570");
            return response;
        }
        if (isAll) {
            FUNCTION_MAP = new LinkedHashMap();
        }
        Map newMap = FUNCTION_MAP;
        for (int i = 0; i < size; ++i) {
            JSONObject item = list.getJSONObject(i);
            if (item == null) continue;
            JSONObject demo = JSON.parseObject((String)item.getString("demo"));
            if (demo == null) {
                APIJSONFunctionParser.onServerError("\u5b57\u6bb5 demo \u7684\u503c\u5fc5\u987b\u4e3a\u5408\u6cd5\u4e14\u975e null \u7684 JSONObejct \u5b57\u7b26\u4e32\uff01", shutdownWhenServerError);
            }
            String name = item.getString("name");
            if (!demo.containsKey((Object)"result()")) {
                demo.put("result()", (Object)APIJSONFunctionParser.getFunctionCall(name, item.getString("arguments")));
            }
            newMap.put(name, item);
            String[] methods = StringUtil.split((String)item.getString("methods"));
            if (methods == null || methods.length <= 0) {
                methods = ALL_METHODS;
            }
            for (String method : methods) {
                JSONObject r = APIJSON_CREATOR.createParser().setMethod(RequestMethod.valueOf((String)method)).setNeedVerify(false).setTag(item.getString("tag")).setVersion(item.getIntValue("version")).parseResponse(demo);
                if (JSONResponse.isSuccess((JSONObject)r)) continue;
                APIJSONFunctionParser.onServerError(JSONResponse.getMsg((JSONObject)r), shutdownWhenServerError);
            }
        }
        return response;
    }

    protected static void onServerError(String msg, boolean shutdown) throws ServerException {
        Log.e((String)TAG, (String)("\n\u8fdc\u7a0b\u51fd\u6570\u6587\u6863\u6d4b\u8bd5\u672a\u901a\u8fc7\uff01\n\u8bf7\u65b0\u589e demo \u91cc\u7684\u51fd\u6570\uff0c\u6216\u4fee\u6539 Function \u8868\u91cc\u7684 demo \u4e3a\u5df2\u6709\u7684\u51fd\u6570\u793a\u4f8b\uff01\n\u4fdd\u8bc1\u524d\u7aef\u770b\u5230\u7684\u8fdc\u7a0b\u51fd\u6570\u6587\u6863\u662f\u6b63\u786e\u7684\uff01\uff01\uff01\n\n\u539f\u56e0\uff1a\n" + msg));
        if (!shutdown) {
            throw new ServerException(msg);
        }
        System.exit(1);
    }

    public static void test() throws Exception {
        APIJSONFunctionParser.test(null);
    }

    public static void test(APIJSONFunctionParser function) throws Exception {
        int i0 = 1;
        int i1 = -2;
        JSONObject request = new JSONObject();
        request.put("id", (Object)10);
        request.put("i0", (Object)i0);
        request.put("i1", (Object)i1);
        JSONArray arr = new JSONArray();
        arr.add((Object)new JSONObject());
        request.put("arr", (Object)arr);
        JSONArray array = new JSONArray();
        array.add((Object)1);
        array.add((Object)2);
        array.add((Object)4);
        array.add((Object)10);
        request.put("array", (Object)array);
        request.put("position", (Object)1);
        request.put("@position", (Object)0);
        request.put("key", (Object)"key");
        JSONObject object = new JSONObject();
        object.put("key", (Object)"success");
        request.put("object", (Object)object);
        if (function == null) {
            function = new APIJSONFunctionParser(null, null, 1, null, null);
        }
        Log.i((String)TAG, (String)("count([1,2,4,10]) = " + function.invoke("countArray(array)", request)));
        AssertUtil.assertEqual(4, function.invoke("countArray(array)", request));
        Log.i((String)TAG, (String)("isContain([1,2,4,10], 10) = " + function.invoke("isContain(array,id)", request)));
        AssertUtil.assertEqual(true, function.invoke("isContain(array,id)", request));
        Log.i((String)TAG, (String)("getFromArray([1,2,4,10], 0) = " + function.invoke("getFromArray(array,@position)", request)));
        AssertUtil.assertEqual(1, function.invoke("getFromArray(array,@position)", request));
        Log.i((String)TAG, (String)("getFromObject({key:\"success\"}, key) = " + function.invoke("getFromObject(object,key)", request)));
        AssertUtil.assertEqual("success", function.invoke("getFromObject(object,key)", request));
    }

    public JSONObject getFunctionDemo(@NotNull JSONObject request) {
        JSONObject demo = JSON.parseObject((String)request.getString("demo"));
        if (demo == null) {
            demo = new JSONObject();
        }
        if (!demo.containsKey((Object)"result()")) {
            demo.put("result()", (Object)APIJSONFunctionParser.getFunctionCall(request.getString("name"), request.getString("arguments")));
        }
        return demo;
    }

    public String getFunctionDetail(@NotNull JSONObject request) {
        return APIJSONFunctionParser.getFunctionCall(request.getString("name"), request.getString("arguments")) + ": " + StringUtil.getTrimedString((String)request.getString("detail"));
    }

    private static String getFunctionCall(String name, String arguments) {
        return name + "(" + StringUtil.getTrimedString((String)arguments) + ")";
    }

    public double plus(@NotNull JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) + request.getDoubleValue(i1);
    }

    public double minus(@NotNull JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) - request.getDoubleValue(i1);
    }

    public double multiply(@NotNull JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) * request.getDoubleValue(i1);
    }

    public double divide(@NotNull JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) / request.getDoubleValue(i1);
    }

    public boolean isArrayEmpty(@NotNull JSONObject request, String array) {
        return BaseModel.isEmpty(request.getJSONArray(array));
    }

    public boolean isObjectEmpty(@NotNull JSONObject request, String object) {
        return BaseModel.isEmpty(request.getJSONObject(object));
    }

    public boolean isContain(@NotNull JSONObject request, String array, String value) {
        List list = com.alibaba.fastjson.JSON.parseArray((String)request.getString(array), String.class);
        return list != null && list.contains(request.getString(value));
    }

    public boolean isContainKey(@NotNull JSONObject request, String object, String key) {
        return BaseModel.isContainKey(request.getJSONObject(object), request.getString(key));
    }

    public boolean isContainValue(@NotNull JSONObject request, String object, String value) {
        return BaseModel.isContainValue(request.getJSONObject(object), request.get((Object)value));
    }

    public int countArray(@NotNull JSONObject request, String array) {
        return BaseModel.count(request.getJSONArray(array));
    }

    public int countObject(@NotNull JSONObject request, String object) {
        return BaseModel.count(request.getJSONObject(object));
    }

    public Object getFromArray(@NotNull JSONObject request, String array, String position) {
        int p;
        try {
            p = Integer.parseInt(position);
        }
        catch (Exception e) {
            p = request.getIntValue(position);
        }
        return BaseModel.get(request.getJSONArray(array), p);
    }

    public Object getFromObject(@NotNull JSONObject request, String object, String key) {
        return BaseModel.get(request.getJSONObject(object), request.getString(key));
    }

    public Object removeIndex(@NotNull JSONObject request, String position) {
        int p;
        try {
            p = Integer.parseInt(position);
        }
        catch (Exception e) {
            p = request.getIntValue(position);
        }
        request.remove((Object)p);
        return null;
    }

    public Object removeKey(@NotNull JSONObject request, String key) {
        request.remove((Object)key);
        return null;
    }

    public boolean booleanValue(@NotNull JSONObject request, String value) {
        return request.getBooleanValue(value);
    }

    public int intValue(@NotNull JSONObject request, String value) {
        return request.getIntValue(value);
    }

    public long longValue(@NotNull JSONObject request, String value) {
        return request.getLongValue(value);
    }

    public float floatValue(@NotNull JSONObject request, String value) {
        return request.getFloatValue(value);
    }

    public double doubleValue(@NotNull JSONObject request, String value) {
        return request.getDoubleValue(value);
    }

    public Object getWithDefault(@NotNull JSONObject request, String value, String defaultValue) {
        Object v = request.get((Object)value);
        return v == null ? request.get((Object)defaultValue) : v;
    }

    public String getMethodArguments(@NotNull JSONObject request) throws IllegalArgumentException, ClassNotFoundException, IOException {
        return this.getMethodArguments(request, "methodArgs");
    }

    public String getMethodArguments(@NotNull JSONObject request, String methodArgsKey) throws IllegalArgumentException, ClassNotFoundException, IOException {
        List methodArgs;
        String argsStr;
        JSONObject obj = request.getJSONObject("request");
        String string = argsStr = obj == null ? null : obj.getString(methodArgsKey);
        if (StringUtil.isEmpty((String)argsStr, (boolean)true)) {
            argsStr = request.getString(methodArgsKey);
        }
        if ((methodArgs = JSON.parseArray((String)APIJSONFunctionParser.removeComment(argsStr), MethodUtil.Argument.class)) == null || methodArgs.isEmpty()) {
            return "";
        }
        String s = "";
        for (int i = 0; i < methodArgs.size(); ++i) {
            String sn;
            MethodUtil.Argument arg = (MethodUtil.Argument)methodArgs.get(i);
            String string2 = sn = arg == null ? null : arg.getType();
            if (sn == null) {
                String string3 = sn = arg.getValue() == null ? Object.class.getSimpleName() : MethodUtil.trimType(arg.getValue().getClass());
            }
            if (i > 0) {
                s = s + ",";
            }
            s = s + sn;
        }
        return s;
    }

    public String getMethodDefination(@NotNull JSONObject request) throws IllegalArgumentException, ClassNotFoundException, IOException {
        return this.getMethodDefination(request, "method", "arguments", "genericType", "genericExceptions", "Java");
    }

    public String getMethodDefination(@NotNull JSONObject request, String method, String arguments, String type, String exceptions, String language) throws IllegalArgumentException, ClassNotFoundException, IOException {
        String n = request.getString(method);
        if (StringUtil.isEmpty((String)n, (boolean)true)) {
            throw new NullPointerException("getMethodDefination  StringUtil.isEmpty(methodArgs, true) !");
        }
        String a = request.getString(arguments);
        String t = request.getString(type);
        String e = request.getString(exceptions);
        if (language == null) {
            language = "";
        }
        switch (language) {
            case "TypeScript": {
                return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : ": " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
            }
            case "Go": {
                return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : " " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
            }
        }
        return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : ": " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
    }

    public String getMethodRequest(@NotNull JSONObject request) {
        String req = request.getString("request");
        if (!StringUtil.isEmpty((String)req, (boolean)true)) {
            return req;
        }
        req = "{";
        Boolean isStatic = request.getBoolean("static");
        String methodArgs = request.getString("methodArgs");
        String classArgs = request.getString("classArgs");
        boolean comma = false;
        if (isStatic != null && isStatic.booleanValue()) {
            req = req + "\n    \"static\": true";
            comma = true;
        }
        if (!StringUtil.isEmpty((String)methodArgs, (boolean)true)) {
            req = req + (comma ? "," : "") + "\n    \"methodArgs\": " + methodArgs;
            comma = true;
        }
        if (!StringUtil.isEmpty((String)classArgs, (boolean)true)) {
            req = req + (comma ? "," : "") + "\n    \"classArgs\": " + classArgs;
        }
        req = req + "\n}";
        return req;
    }

    public static String removeComment(String json) {
        return json == null ? null : json.replaceAll("(//.*)|(/\\*[\\s\\S]*?\\*/)", "");
    }
}

