/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.JSON;
import apijson.JSONObject;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.RequestRole;
import apijson.StringUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONParser;
import apijson.framework.APIJSONVerifier;
import apijson.framework.AssertUtil;
import apijson.framework.BaseModel;
import apijson.orm.AbstractFunctionParser;
import apijson.orm.JSONRequest;
import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import unitauto.MethodUtil;

public class APIJSONFunctionParser
extends AbstractFunctionParser {
    public static final String TAG = "APIJSONFunctionParser";
    @NotNull
    public static APIJSONCreator APIJSON_CREATOR = new APIJSONCreator();
    private HttpSession session;

    public APIJSONFunctionParser() {
        this(null);
    }

    public APIJSONFunctionParser(HttpSession session) {
        this(null, null, 0, null, session);
    }

    public APIJSONFunctionParser(RequestMethod method, String tag, int version, com.alibaba.fastjson.JSONObject request, HttpSession session) {
        super(method, tag, version, request);
        this.setSession(session);
    }

    public HttpSession getSession() {
        return this.session;
    }

    public APIJSONFunctionParser setSession(HttpSession session) {
        this.session = session;
        return this;
    }

    public APIJSONFunctionParser setMethod(RequestMethod method) {
        super.setMethod(method);
        return this;
    }

    public APIJSONFunctionParser setTag(String tag) {
        super.setTag(tag);
        return this;
    }

    public APIJSONFunctionParser setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    public static com.alibaba.fastjson.JSONObject init() throws ServerException {
        return APIJSONFunctionParser.init(false);
    }

    public static com.alibaba.fastjson.JSONObject init(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONFunctionParser.init(shutdownWhenServerError, null);
    }

    public static com.alibaba.fastjson.JSONObject init(APIJSONCreator creator) throws ServerException {
        return APIJSONFunctionParser.init(false, creator);
    }

    public static com.alibaba.fastjson.JSONObject init(boolean shutdownWhenServerError, APIJSONCreator creator) throws ServerException {
        return APIJSONFunctionParser.init(shutdownWhenServerError, creator, null);
    }

    public static com.alibaba.fastjson.JSONObject init(boolean shutdownWhenServerError, APIJSONCreator creator, com.alibaba.fastjson.JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        com.alibaba.fastjson.JSONObject function = isAll ? new JSONRequest() : table;
        JSONRequest functionItem = new JSONRequest();
        functionItem.put(APIJSONConstant.FUNCTION_, (Object)function);
        com.alibaba.fastjson.JSONObject request = new com.alibaba.fastjson.JSONObject();
        request.putAll((Map)functionItem.toArray(0, 0, APIJSONConstant.FUNCTION_));
        com.alibaba.fastjson.JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(true).parseResponse(request);
        if (!JSONResponse.isSuccess((com.alibaba.fastjson.JSONObject)response)) {
            APIJSONFunctionParser.onServerError("\n\n\n\n\n !!!! \u67e5\u8be2\u8fdc\u7a0b\u51fd\u6570\u5f02\u5e38 !!!\n" + response.getString(JSONResponse.KEY_MSG) + "\n\n\n\n\n", shutdownWhenServerError);
        }
        int n = size = (list = response.getJSONArray(APIJSONConstant.FUNCTION_ + "[]")) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"init isAll && size <= 0\uff0c\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u8fdc\u7a0b\u51fd\u6570");
            throw new NullPointerException("\u6ca1\u6709\u53ef\u7528\u7684\u8fdc\u7a0b\u51fd\u6570");
        }
        if (table == null || table.isEmpty()) {
            FUNCTION_MAP.clear();
        }
        for (int i = 0; i < size; ++i) {
            com.alibaba.fastjson.JSONObject item = list.getJSONObject(i);
            if (item == null) continue;
            com.alibaba.fastjson.JSONObject demo = JSON.parseObject((String)item.getString("demo"));
            if (demo == null) {
                APIJSONFunctionParser.onServerError("\u5b57\u6bb5 demo \u7684\u503c\u5fc5\u987b\u4e3a\u5408\u6cd5\u4e14\u975e null \u7684 JSONObejct \u5b57\u7b26\u4e32\uff01", shutdownWhenServerError);
            }
            String name = item.getString("name");
            if (!demo.containsKey((Object)"result()")) {
                demo.put("result()", (Object)APIJSONFunctionParser.getFunctionCall(name, item.getString("arguments")));
            }
            FUNCTION_MAP.put(name, item);
            String[] methods = StringUtil.split((String)item.getString("methods"));
            com.alibaba.fastjson.JSONObject r = new APIJSONParser(methods == null || methods.length <= 0 ? RequestMethod.GET : RequestMethod.valueOf((String)methods[0]), false).setTag(item.getString("tag")).setVersion(item.getIntValue("version")).parseResponse(demo);
            if (JSONResponse.isSuccess((com.alibaba.fastjson.JSONObject)r)) continue;
            APIJSONFunctionParser.onServerError(JSONResponse.getMsg((com.alibaba.fastjson.JSONObject)r), shutdownWhenServerError);
        }
        return response;
    }

    private static void onServerError(String msg, boolean shutdown) throws ServerException {
        Log.e((String)TAG, (String)("\n\u8fdc\u7a0b\u51fd\u6570\u6587\u6863\u6d4b\u8bd5\u672a\u901a\u8fc7\uff01\n\u8bf7\u65b0\u589e demo \u91cc\u7684\u51fd\u6570\uff0c\u6216\u4fee\u6539 Function \u8868\u91cc\u7684 demo \u4e3a\u5df2\u6709\u7684\u51fd\u6570\u793a\u4f8b\uff01\n\u4fdd\u8bc1\u524d\u7aef\u770b\u5230\u7684\u8fdc\u7a0b\u51fd\u6570\u6587\u6863\u662f\u6b63\u786e\u7684\uff01\uff01\uff01\n\n\u539f\u56e0\uff1a\n" + msg));
        if (!shutdown) {
            throw new ServerException(msg);
        }
        System.exit(1);
    }

    public static void test() throws Exception {
        APIJSONFunctionParser.test(null);
    }

    public static void test(APIJSONFunctionParser function) throws Exception {
        int i0 = 1;
        int i1 = -2;
        com.alibaba.fastjson.JSONObject request = new com.alibaba.fastjson.JSONObject();
        request.put("id", (Object)10);
        request.put("i0", (Object)i0);
        request.put("i1", (Object)i1);
        JSONArray arr = new JSONArray();
        arr.add((Object)new com.alibaba.fastjson.JSONObject());
        request.put("arr", (Object)arr);
        JSONArray array = new JSONArray();
        array.add((Object)1);
        array.add((Object)2);
        array.add((Object)4);
        array.add((Object)10);
        request.put("array", (Object)array);
        request.put("position", (Object)1);
        request.put("@position", (Object)0);
        request.put("key", (Object)"key");
        com.alibaba.fastjson.JSONObject object = new com.alibaba.fastjson.JSONObject();
        object.put("key", (Object)"success");
        request.put("object", (Object)object);
        if (function == null) {
            function = new APIJSONFunctionParser(null, null, 1, null, null);
        }
        Log.i((String)TAG, (String)("count([1,2,4,10]) = " + function.invoke("countArray(array)", request)));
        AssertUtil.assertEqual(4, function.invoke("countArray(array)", request));
        Log.i((String)TAG, (String)("isContain([1,2,4,10], 10) = " + function.invoke("isContain(array,id)", request)));
        AssertUtil.assertEqual(true, function.invoke("isContain(array,id)", request));
        Log.i((String)TAG, (String)("getFromArray([1,2,4,10], 0) = " + function.invoke("getFromArray(array,@position)", request)));
        AssertUtil.assertEqual(1, function.invoke("getFromArray(array,@position)", request));
        Log.i((String)TAG, (String)("getFromObject({key:\"success\"}, key) = " + function.invoke("getFromObject(object,key)", request)));
        AssertUtil.assertEqual("success", function.invoke("getFromObject(object,key)", request));
    }

    public com.alibaba.fastjson.JSONObject getFunctionDemo(@NotNull com.alibaba.fastjson.JSONObject request) {
        com.alibaba.fastjson.JSONObject demo = JSON.parseObject((String)request.getString("demo"));
        if (demo == null) {
            demo = new com.alibaba.fastjson.JSONObject();
        }
        if (!demo.containsKey((Object)"result()")) {
            demo.put("result()", (Object)APIJSONFunctionParser.getFunctionCall(request.getString("name"), request.getString("arguments")));
        }
        return demo;
    }

    public String getFunctionDetail(@NotNull com.alibaba.fastjson.JSONObject request) {
        return APIJSONFunctionParser.getFunctionCall(request.getString("name"), request.getString("arguments")) + ": " + StringUtil.getTrimedString((String)request.getString("detail"));
    }

    private static String getFunctionCall(String name, String arguments) {
        return name + "(" + StringUtil.getTrimedString((String)arguments) + ")";
    }

    public JSONArray getIdList(@NotNull com.alibaba.fastjson.JSONObject request) {
        return new JSONArray(new ArrayList<Integer>(Arrays.asList(12, 15, 301, 82001, 82002, 38710)));
    }

    public Object verifyAccess(@NotNull com.alibaba.fastjson.JSONObject request) throws Exception {
        long userId = request.getLongValue(JSONObject.KEY_USER_ID);
        RequestRole role = RequestRole.get((String)request.getString("@role"));
        if (role == RequestRole.OWNER && userId != APIJSONVerifier.getVisitorId(this.session)) {
            throw new IllegalAccessException("\u767b\u5f55\u7528\u6237\u4e0e\u89d2\u8272OWNER\u4e0d\u5339\u914d\uff01");
        }
        return null;
    }

    public double plus(@NotNull com.alibaba.fastjson.JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) + request.getDoubleValue(i1);
    }

    public double minus(@NotNull com.alibaba.fastjson.JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) - request.getDoubleValue(i1);
    }

    public double multiply(@NotNull com.alibaba.fastjson.JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) * request.getDoubleValue(i1);
    }

    public double divide(@NotNull com.alibaba.fastjson.JSONObject request, String i0, String i1) {
        return request.getDoubleValue(i0) / request.getDoubleValue(i1);
    }

    public boolean isArrayEmpty(@NotNull com.alibaba.fastjson.JSONObject request, String array) {
        return BaseModel.isEmpty(request.getJSONArray(array));
    }

    public boolean isObjectEmpty(@NotNull com.alibaba.fastjson.JSONObject request, String object) {
        return BaseModel.isEmpty(request.getJSONObject(object));
    }

    public boolean isContain(@NotNull com.alibaba.fastjson.JSONObject request, String array, String value) {
        List list = com.alibaba.fastjson.JSON.parseArray((String)request.getString(array), String.class);
        return list != null && list.contains(request.getString(value));
    }

    public boolean isContainKey(@NotNull com.alibaba.fastjson.JSONObject request, String object, String key) {
        return BaseModel.isContainKey(request.getJSONObject(object), request.getString(key));
    }

    public boolean isContainValue(@NotNull com.alibaba.fastjson.JSONObject request, String object, String value) {
        return BaseModel.isContainValue(request.getJSONObject(object), request.get((Object)value));
    }

    public int countArray(@NotNull com.alibaba.fastjson.JSONObject request, String array) {
        return BaseModel.count(request.getJSONArray(array));
    }

    public int countObject(@NotNull com.alibaba.fastjson.JSONObject request, String object) {
        return BaseModel.count(request.getJSONObject(object));
    }

    public Object getFromArray(@NotNull com.alibaba.fastjson.JSONObject request, String array, String position) {
        int p;
        try {
            p = Integer.parseInt(position);
        }
        catch (Exception e) {
            p = request.getIntValue(position);
        }
        return BaseModel.get(request.getJSONArray(array), p);
    }

    public Object getFromObject(@NotNull com.alibaba.fastjson.JSONObject request, String object, String key) {
        return BaseModel.get(request.getJSONObject(object), request.getString(key));
    }

    public Object removeIndex(@NotNull com.alibaba.fastjson.JSONObject request, String position) {
        int p;
        try {
            p = Integer.parseInt(position);
        }
        catch (Exception e) {
            p = request.getIntValue(position);
        }
        request.remove((Object)p);
        return null;
    }

    public Object removeKey(@NotNull com.alibaba.fastjson.JSONObject request, String key) {
        request.remove((Object)key);
        return null;
    }

    public boolean booleanValue(@NotNull com.alibaba.fastjson.JSONObject request, String value) {
        return request.getBooleanValue(value);
    }

    public int intValue(@NotNull com.alibaba.fastjson.JSONObject request, String value) {
        return request.getIntValue(value);
    }

    public long longValue(@NotNull com.alibaba.fastjson.JSONObject request, String value) {
        return request.getLongValue(value);
    }

    public float floatValue(@NotNull com.alibaba.fastjson.JSONObject request, String value) {
        return request.getFloatValue(value);
    }

    public double doubleValue(@NotNull com.alibaba.fastjson.JSONObject request, String value) {
        return request.getDoubleValue(value);
    }

    public Object getWithDefault(@NotNull com.alibaba.fastjson.JSONObject request, String value, String defaultValue) {
        Object v = request.get((Object)value);
        return v == null ? request.get((Object)defaultValue) : v;
    }

    public String getMethodArguments(@NotNull com.alibaba.fastjson.JSONObject request) throws IllegalArgumentException, ClassNotFoundException, IOException {
        return this.getMethodArguments(request, "methodArgs");
    }

    public String getMethodArguments(@NotNull com.alibaba.fastjson.JSONObject request, String methodArgsKey) throws IllegalArgumentException, ClassNotFoundException, IOException {
        List methodArgs;
        String argsStr;
        com.alibaba.fastjson.JSONObject obj = request.getJSONObject("request");
        String string = argsStr = obj == null ? null : obj.getString(methodArgsKey);
        if (StringUtil.isEmpty((String)argsStr, (boolean)true)) {
            argsStr = request.getString(methodArgsKey);
        }
        if ((methodArgs = JSON.parseArray((String)APIJSONFunctionParser.removeComment(argsStr), MethodUtil.Argument.class)) == null || methodArgs.isEmpty()) {
            return "";
        }
        String s = "";
        for (int i = 0; i < methodArgs.size(); ++i) {
            String sn;
            MethodUtil.Argument arg = (MethodUtil.Argument)methodArgs.get(i);
            String string2 = sn = arg == null ? null : arg.getType();
            if (sn == null) {
                String string3 = sn = arg.getValue() == null ? Object.class.getSimpleName() : MethodUtil.trimType(arg.getValue().getClass());
            }
            if (i > 0) {
                s = s + ",";
            }
            s = s + sn;
        }
        return s;
    }

    public String getMethodDefination(@NotNull com.alibaba.fastjson.JSONObject request) throws IllegalArgumentException, ClassNotFoundException, IOException {
        return this.getMethodDefination(request, "method", "arguments", "genericType", "genericExceptions", "Java");
    }

    public String getMethodDefination(@NotNull com.alibaba.fastjson.JSONObject request, String method, String arguments, String type, String exceptions, String language) throws IllegalArgumentException, ClassNotFoundException, IOException {
        String n = request.getString(method);
        if (StringUtil.isEmpty((String)n, (boolean)true)) {
            throw new NullPointerException("getMethodDefination  StringUtil.isEmpty(methodArgs, true) !");
        }
        String a = request.getString(arguments);
        String t = request.getString(type);
        String e = request.getString(exceptions);
        if (language == null) {
            language = "";
        }
        switch (language) {
            case "TypeScript": {
                return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : ": " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
            }
            case "Go": {
                return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : " " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
            }
        }
        return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : ": " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
    }

    public String getMethodRequest(@NotNull com.alibaba.fastjson.JSONObject request) {
        String req = request.getString("request");
        if (!StringUtil.isEmpty((String)req, (boolean)true)) {
            return req;
        }
        req = "{";
        Boolean isStatic = request.getBoolean("static");
        String methodArgs = request.getString("methodArgs");
        String classArgs = request.getString("classArgs");
        boolean comma = false;
        if (isStatic != null && isStatic.booleanValue()) {
            req = req + "\n    \"static\": true";
            comma = true;
        }
        if (!StringUtil.isEmpty((String)methodArgs, (boolean)true)) {
            req = req + (comma ? "," : "") + "\n    \"methodArgs\": " + methodArgs;
            comma = true;
        }
        if (!StringUtil.isEmpty((String)classArgs, (boolean)true)) {
            req = req + (comma ? "," : "") + "\n    \"classArgs\": " + classArgs;
        }
        req = req + "\n}";
        return req;
    }

    public static String removeComment(String json) {
        return json == null ? null : json.replaceAll("(//.*)|(/\\*[\\s\\S]*?\\*/)", "");
    }
}

