/*
 * Decompiled with CFR 0.152.
 */
package cn.thens.okbinder2;

import android.os.Binder;
import android.os.IBinder;
import cn.thens.okbinder2.OkBinder;
import cn.thens.okbinder2.OkBinderFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

final class ReflectionFactory
implements OkBinderFactory {
    ReflectionFactory() {
    }

    @Override
    public Binder newBinder(Class<?> serviceClass, Object remoteObject) {
        return new MyBinder(remoteObject, serviceClass);
    }

    @Override
    public Object newProxy(Class<?> serviceClass, IBinder binder) {
        ClassLoader classLoader = serviceClass.getClassLoader();
        return serviceClass.cast(Proxy.newProxyInstance(classLoader, new Class[]{serviceClass}, (InvocationHandler)new MyProxy(binder, serviceClass)));
    }

    private static boolean isOneWay(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    private static final class MyProxy
    extends OkBinderFactory.BaseProxy
    implements InvocationHandler {
        public MyProxy(IBinder binder, Class<?> serviceClass) {
            super(serviceClass, binder);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            int flags = ReflectionFactory.isOneWay(method) ? 1 : 0;
            return this.transact(flags, OkBinder.getFunctionId(method), args);
        }
    }

    private static final class MyBinder
    extends OkBinderFactory.BaseBinder {
        public MyBinder(Object remoteObject, Class<?> serviceClass) {
            super(serviceClass, remoteObject);
            for (Method method : serviceClass.getMethods()) {
                if (method.isBridge()) continue;
                this.register(OkBinder.getFunctionId(method), new MethodFunction(method));
            }
        }
    }

    private static final class MethodFunction
    implements OkBinderFactory.Function {
        private final Method method;

        private MethodFunction(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(Object obj, Object[] args) throws Throwable {
            try {
                return this.method.invoke(obj, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw cause != null ? cause : e;
            }
        }
    }
}

