/*
 * Decompiled with CFR 0.152.
 */
package cn.thens.okbinder2;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import cn.thens.okbinder2.ErrorUtils;
import cn.thens.okbinder2.ObjectFunctions;
import cn.thens.okbinder2.OkBinderParcel;
import cn.thens.okbinder2.OkBinderVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public interface OkBinderFactory {
    public Binder newBinder(Class<?> var1, Object var2);

    public Object newProxy(Class<?> var1, IBinder var2);

    public static class BaseProxy {
        protected final IBinder binder;
        protected final ClassLoader classLoader;
        protected final String descriptor;

        public BaseProxy(Class<?> serviceClass, IBinder binder) {
            this.binder = binder;
            this.classLoader = serviceClass.getClassLoader();
            this.descriptor = serviceClass.getName();
        }

        protected Object transact(int flags, String methodId, Object ... args) {
            if (!this.binder.isBinderAlive()) {
                throw new IllegalStateException("binder has died");
            }
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            Object result = null;
            try {
                data.writeInterfaceToken(this.descriptor);
                data.writeInt(-1588420922);
                data.writeInt(OkBinderVersion.current());
                data.writeString(methodId);
                if (args != null) {
                    data.writeInt(args.length);
                    for (Object arg : args) {
                        OkBinderParcel.write(data, arg);
                    }
                } else {
                    data.writeInt(0);
                }
                this.binder.transact(1, data, reply, flags);
                reply.readException();
                if (reply.readInt() != 0) {
                    result = OkBinderParcel.read(reply, this.classLoader);
                }
            }
            catch (Throwable e) {
                throw ErrorUtils.wrap(e);
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return result;
        }

        public int hashCode() {
            return ObjectFunctions.hashCode(this);
        }

        public boolean equals(Object obj) {
            return ObjectFunctions.equals(this, obj);
        }

        public String toString() {
            return ObjectFunctions.toString(this);
        }
    }

    public static class BaseBinder
    extends Binder
    implements IInterface {
        protected final Object remoteObject;
        protected final String descriptor;
        protected final ClassLoader classLoader;
        private final Map<String, Function> functions = new HashMap<String, Function>();

        public BaseBinder(Class<?> serviceClass, Object remoteObject) {
            this.remoteObject = remoteObject;
            this.descriptor = serviceClass.getName();
            this.classLoader = remoteObject.getClass().getClassLoader();
            this.attachInterface(this, this.descriptor);
            ObjectFunctions.inject(this);
        }

        protected void register(String methodId, Function func) {
            this.functions.put(methodId, func);
        }

        public Object getRemoteObject() {
            return this.remoteObject;
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            if (code == 1) {
                try {
                    data.enforceInterface(this.descriptor);
                    int magicNumber = data.readInt();
                    if (magicNumber != -1588420922) {
                        throw new IllegalArgumentException("Mismatched magic number " + magicNumber);
                    }
                    int version = data.readInt();
                    if (!OkBinderVersion.isSupported(version)) {
                        throw new IllegalArgumentException("Unsupported version " + version + ", the min supported is " + OkBinderVersion.minSupported());
                    }
                    String functionId = data.readString();
                    int argCount = data.readInt();
                    Object[] args = new Object[argCount];
                    for (int i = 0; i < argCount; ++i) {
                        args[i] = OkBinderParcel.read(data, this.classLoader);
                    }
                    Function function = this.functions.get(functionId);
                    if (function == null) {
                        throw new NoSuchElementException("Unregistered function " + functionId);
                    }
                    Object result = function.invoke(this.remoteObject, args);
                    if (reply != null) {
                        reply.writeNoException();
                        if (result != null) {
                            reply.writeInt(1);
                            OkBinderParcel.write(reply, result);
                        } else {
                            reply.writeInt(0);
                        }
                    }
                    return true;
                }
                catch (Throwable e) {
                    Throwable cause = ErrorUtils.unwrap(e);
                    Log.e((String)"@OkBinder", (String)"Binder call failed", (Throwable)cause);
                    RemoteException remoteException = new RemoteException();
                    remoteException.initCause(cause);
                    throw remoteException;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }
    }

    public static interface Function {
        public Object invoke(Object var1, Object[] var2) throws Throwable;
    }
}

