/*
 * Decompiled with CFR 0.152.
 */
package com.chaitin.xray.form;

import com.chaitin.xray.utils.CmdUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EncodeUtilForm {
    private JTextField baseEncodeText;
    private JButton baseEncodeButton;
    private JTextField baseDecodeText;
    private JButton baseDecodeButton;
    private JTextField urlEncodeText;
    private JButton urlEncodeButton;
    private JTextField urlDecodeText;
    private JButton urlDecodeButton;
    private JTextField md5EncodeText;
    private JButton md5EncodeButton;
    private JTextField md5ResultText;
    private JTextField cmdBashEncodeText;
    private JButton cmdBashEncodeButton;
    private JTextField cmdBashResultText;
    private JTextField cmdPwEncodeText;
    private JButton cmdPwEncodeButton;
    private JTextField cmdPwResultText;
    public JPanel encodeUtilPanel;
    private JPanel basePanel;
    private JPanel urlPanel;
    private JPanel md5Panel;
    private JPanel cmdBashPanel;
    private JLabel bashLabel;
    private JPanel cmdPwPanel;
    private JLabel pwLabel;
    private JTextField stringCmdText;
    private JButton stringCmdButton;
    private JTextField stringCmdResultText;
    private JPanel stringCmdPanel;
    private JLabel stringCmdLabel;

    private void initBase64() {
        this.baseEncodeButton.addActionListener(e -> {
            String source = this.baseEncodeText.getText();
            String result = Base64.getEncoder().encodeToString(source.getBytes());
            this.baseDecodeText.setText(result);
        });
        this.baseDecodeButton.addActionListener(e -> {
            String source = this.baseDecodeText.getText();
            String result = new String(Base64.getDecoder().decode(source));
            this.baseEncodeText.setText(result);
        });
    }

    private void initUrl() {
        this.urlEncodeButton.addActionListener(e -> {
            String result;
            String source = this.urlEncodeText.getText();
            try {
                result = URLEncoder.encode(source, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            this.urlDecodeText.setText(result);
        });
        this.urlDecodeButton.addActionListener(e -> {
            String result;
            String source = this.urlDecodeText.getText();
            try {
                result = URLDecoder.decode(source, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            this.urlEncodeText.setText(result);
        });
    }

    private void initMd5() {
        this.md5EncodeButton.addActionListener(e -> {
            String str = this.md5EncodeText.getText();
            byte[] digest = null;
            try {
                MessageDigest md5 = MessageDigest.getInstance("md5");
                digest = md5.digest(str.getBytes(StandardCharsets.UTF_8));
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
            String md5Str = new BigInteger(1, digest != null ? digest : new byte[]{}).toString(16);
            this.md5ResultText.setText(md5Str);
        });
    }

    private void initBash() {
        this.cmdBashEncodeButton.addActionListener(e -> {
            String source = this.cmdBashEncodeText.getText();
            this.cmdBashResultText.setText(CmdUtil.getBashCommand(source));
        });
    }

    private void initPowershell() {
        this.cmdPwEncodeButton.addActionListener(e -> {
            String source = this.cmdPwEncodeText.getText();
            this.cmdPwResultText.setText(CmdUtil.getPowershellCommand(source));
        });
    }

    private void initStringCmd() {
        this.stringCmdButton.addActionListener(e -> {
            String source = this.stringCmdText.getText();
            this.stringCmdResultText.setText(CmdUtil.getStringCommand(source));
        });
    }

    public EncodeUtilForm() {
        this.$$$setupUI$$$();
        this.initBase64();
        this.initUrl();
        this.initMd5();
        this.initBash();
        this.initPowershell();
        this.initStringCmd();
    }

    private void $$$setupUI$$$() {
        this.encodeUtilPanel = new JPanel();
        this.encodeUtilPanel.setLayout(new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.encodeUtilPanel.setBackground(new Color(-725535));
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.basePanel.setBackground(new Color(-725535));
        this.encodeUtilPanel.add((Component)this.basePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.basePanel.setBorder(BorderFactory.createTitledBorder(null, "Base64", 0, 0, null, null));
        this.baseEncodeText = new JTextField();
        this.basePanel.add((Component)this.baseEncodeText, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.baseEncodeButton = new JButton();
        this.baseEncodeButton.setText("\u7f16\u7801");
        this.basePanel.add((Component)this.baseEncodeButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.baseDecodeText = new JTextField();
        this.basePanel.add((Component)this.baseDecodeText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.baseDecodeButton = new JButton();
        this.baseDecodeButton.setText("\u89e3\u7801");
        this.basePanel.add((Component)this.baseDecodeButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.urlPanel = new JPanel();
        this.urlPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.urlPanel.setBackground(new Color(-725535));
        this.encodeUtilPanel.add((Component)this.urlPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.urlPanel.setBorder(BorderFactory.createTitledBorder(null, "URL", 0, 0, null, null));
        this.urlEncodeText = new JTextField();
        this.urlPanel.add((Component)this.urlEncodeText, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.urlEncodeButton = new JButton();
        this.urlEncodeButton.setText("\u7f16\u7801");
        this.urlPanel.add((Component)this.urlEncodeButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.urlDecodeText = new JTextField();
        this.urlPanel.add((Component)this.urlDecodeText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.urlDecodeButton = new JButton();
        this.urlDecodeButton.setText("\u89e3\u7801");
        this.urlPanel.add((Component)this.urlDecodeButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.md5Panel = new JPanel();
        this.md5Panel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.md5Panel.setBackground(new Color(-725535));
        this.encodeUtilPanel.add((Component)this.md5Panel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.md5Panel.setBorder(BorderFactory.createTitledBorder(null, "MD5", 0, 0, null, null));
        this.md5EncodeText = new JTextField();
        this.md5Panel.add((Component)this.md5EncodeText, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.md5EncodeButton = new JButton();
        this.md5EncodeButton.setText("\u52a0\u5bc6");
        this.md5Panel.add((Component)this.md5EncodeButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.md5ResultText = new JTextField();
        this.md5Panel.add((Component)this.md5ResultText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.cmdBashPanel = new JPanel();
        this.cmdBashPanel.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.cmdBashPanel.setBackground(new Color(-725535));
        this.encodeUtilPanel.add((Component)this.cmdBashPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.cmdBashPanel.setBorder(BorderFactory.createTitledBorder(null, "Bash Base64 CMD", 0, 0, null, null));
        this.cmdBashEncodeText = new JTextField();
        this.cmdBashPanel.add((Component)this.cmdBashEncodeText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.cmdBashEncodeButton = new JButton();
        this.cmdBashEncodeButton.setText("\u751f\u6210\u547d\u4ee4");
        this.cmdBashPanel.add((Component)this.cmdBashEncodeButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.cmdBashResultText = new JTextField();
        this.cmdBashResultText.setText("");
        this.cmdBashPanel.add((Component)this.cmdBashResultText, new GridConstraints(2, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.bashLabel = new JLabel();
        this.bashLabel.setEnabled(true);
        this.bashLabel.setText("  \u89e3\u51b3 Java \u6267\u884c\u547d\u4ee4\u65e0\u6cd5\u4f7f\u7528\u91cd\u5b9a\u5411\u548c\u7ba1\u9053\u7b26\u53f7\u95ee\u9898");
        this.cmdBashPanel.add((Component)this.bashLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.cmdPwPanel = new JPanel();
        this.cmdPwPanel.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.cmdPwPanel.setBackground(new Color(-725535));
        this.encodeUtilPanel.add((Component)this.cmdPwPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.cmdPwPanel.setBorder(BorderFactory.createTitledBorder(null, "Powershell Base64 CMD", 0, 0, null, null));
        this.cmdPwEncodeText = new JTextField();
        this.cmdPwPanel.add((Component)this.cmdPwEncodeText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.cmdPwEncodeButton = new JButton();
        this.cmdPwEncodeButton.setText("\u751f\u6210\u547d\u4ee4");
        this.cmdPwPanel.add((Component)this.cmdPwEncodeButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.cmdPwResultText = new JTextField();
        this.cmdPwPanel.add((Component)this.cmdPwResultText, new GridConstraints(2, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.pwLabel = new JLabel();
        this.pwLabel.setText("  \u89e3\u51b3 Java \u6267\u884c\u547d\u4ee4\u65e0\u6cd5\u4f7f\u7528\u91cd\u5b9a\u5411\u548c\u7ba1\u9053\u7b26\u53f7\u95ee\u9898");
        this.cmdPwPanel.add((Component)this.pwLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.stringCmdPanel = new JPanel();
        this.stringCmdPanel.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.stringCmdPanel.setBackground(new Color(-725535));
        this.encodeUtilPanel.add((Component)this.stringCmdPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.stringCmdPanel.setBorder(BorderFactory.createTitledBorder(null, "\u7279\u6b8a\u547d\u4ee4\u5b57\u7b26\u4e32\u751f\u6210", 0, 0, null, null));
        this.stringCmdText = new JTextField();
        this.stringCmdPanel.add((Component)this.stringCmdText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.stringCmdButton = new JButton();
        this.stringCmdButton.setText("\u751f\u6210\u547d\u4ee4");
        this.stringCmdPanel.add((Component)this.stringCmdButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.stringCmdResultText = new JTextField();
        this.stringCmdPanel.add((Component)this.stringCmdResultText, new GridConstraints(2, 0, 1, 1, 8, 1, 4, 0, new Dimension(500, -1), new Dimension(500, -1), new Dimension(500, -1), 0, false));
        this.stringCmdLabel = new JLabel();
        this.stringCmdLabel.setText("\u7528\u4e8e\u751f\u6210\u53ef\u4ee5\u7ed5WAF\u7684Java\u547d\u4ee4");
        this.stringCmdPanel.add((Component)this.stringCmdLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.encodeUtilPanel;
    }
}

