/*
 * Decompiled with CFR 0.152.
 */
package com.chaitin.xray.form;

import com.chaitin.xray.form.MainForm;
import com.chaitin.xray.utils.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AdvanceConfigForm {
    private static final Logger logger = LogManager.getLogger(AdvanceConfigForm.class);
    public JPanel advanceConfigPanel;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JPanel leftPanel;
    private JPanel midPanel;
    private JCheckBox detectCorsHeaderConfigCheckBox;
    private JCheckBox detectServerErrorPageCheckBox;
    private JCheckBox detectPhpinfoCheckBox;
    private JCheckBox detectSystemPathLeakCheckBox;
    private JCheckBox detectOutdatedSslVersionCheckBox;
    private JCheckBox detectHttpHeaderConfigCheckBox;
    private JCheckBox detectCookieHttponlyCheckBox;
    private JCheckBox detectChinaIdCardNumberCheckBox;
    private JCheckBox detectChinaPhoneNumberCheckBox;
    private JCheckBox detectChinaBankCardCheckBox;
    private JCheckBox detectPrivateIpCheckBox;
    private JButton refreshBaselineButton;
    private JButton saveBaselineButton;
    private JTextField usernameDicText;
    private JButton usernameButton;
    private JButton refreshBruteButton;
    private JButton saveBruteButton;
    private JTextField pwdText;
    private JButton pwdDicButton;
    private JTextField dirDepthText;
    private JTextField dirDicText;
    private JButton dirDicButton;
    private JButton dirRefreshButton;
    private JButton dirSaveButton;
    private JTextField shiroCookieText;
    private JTextField shiroAesKeyText;
    private JButton shiroRefreshButton;
    private JButton shiroSaveButton;
    private JCheckBox booleanBasedDetectionCheckBox;
    private JCheckBox errorBasedDetectionCheckBox;
    private JCheckBox timeBasedDetectionCheckBox;
    private JCheckBox useCommentInPayloadCheckBox;
    private JCheckBox detectSqliInCookieCheckBox;
    private JButton refreshSqlButton;
    private JButton saveSqlButton;
    private JTextField shiroKeyFileText;
    private JButton shiroKeyFileButton;
    private JCheckBox detectXssInCookieCheckBox;
    private JCheckBox ieFeatureCheckBox;
    private JButton xssRefreshButton;
    private JButton xssSaveButton;
    private JButton allDefaultButton;
    private JButton allRefreshButton;
    private JButton selectBaselineButton;
    private JButton selectXssButton;
    private JButton selectSqlButton;
    private JPanel baselinePanel;
    private JLabel corsLabel;
    private JLabel serverLabel;
    private JLabel phpinfoLabel;
    private JLabel leakLabel;
    private JLabel sslLabel;
    private JLabel headerLabel;
    private JLabel setCookieLabel;
    private JLabel idLabel;
    private JLabel phoneLabel;
    private JLabel bankLabel;
    private JLabel privateLabel;
    private JPanel sqldetPanel;
    private JLabel boolLabel;
    private JLabel errorLabel;
    private JLabel timeLabel;
    private JLabel commentLabel;
    private JLabel sqlCookieLabel;
    private JPanel configCenterPanel;
    private JLabel showLabel;
    private JPanel bruteForcePanel;
    private JPanel dirscanPanel;
    private JPanel shiroPanel;
    private JPanel xssPanel;
    private JTextField phantasmDepthText;
    private JTextArea phExcludeArea;
    private JButton phRefreshButton;
    private JButton phSaveButton;
    private JCheckBox detectThinkphpSqliCheckBox;
    private JButton thinkphpRefreshButton;
    private JButton thinkphpSaveButton;
    private JTextArea excludeArea;
    private JPanel thinkphpPanel;
    private JLabel thinkphpSqlLabel;
    private JLabel excludeLabel;
    private JLabel phExcludeLabel;
    private JLabel phDefaultLabel;
    private JLabel phLoadLabel;
    private JPanel phantasmPanel;
    private JLabel xssCookieLabel;
    private JLabel xssIeLabel;
    private JLabel phDepthLabel;
    private JLabel dirDepthLabel;
    private JLabel shiroCookieLabel;
    private JLabel shiroAesKeyLabel;
    private JScrollPane phScroll;
    private JScrollPane dirScroll;
    private JButton applyAllButton;
    private final List<JCheckBox> baselineCheckBoxList = new ArrayList<JCheckBox>();
    private final List<JCheckBox> sqlCheckBoxList = new ArrayList<JCheckBox>();
    private final List<JCheckBox> xssCheckBoxList = new ArrayList<JCheckBox>();
    private static boolean baselineAll = false;
    private static boolean sqlAll = false;
    private static boolean xssAll = false;

    private void init() {
        this.baselineCheckBoxList.add(this.detectCorsHeaderConfigCheckBox);
        this.baselineCheckBoxList.add(this.detectServerErrorPageCheckBox);
        this.baselineCheckBoxList.add(this.detectPhpinfoCheckBox);
        this.baselineCheckBoxList.add(this.detectSystemPathLeakCheckBox);
        this.baselineCheckBoxList.add(this.detectOutdatedSslVersionCheckBox);
        this.baselineCheckBoxList.add(this.detectHttpHeaderConfigCheckBox);
        this.baselineCheckBoxList.add(this.detectCookieHttponlyCheckBox);
        this.baselineCheckBoxList.add(this.detectChinaIdCardNumberCheckBox);
        this.baselineCheckBoxList.add(this.detectChinaPhoneNumberCheckBox);
        this.baselineCheckBoxList.add(this.detectChinaBankCardCheckBox);
        this.baselineCheckBoxList.add(this.detectPrivateIpCheckBox);
        this.sqlCheckBoxList.add(this.booleanBasedDetectionCheckBox);
        this.sqlCheckBoxList.add(this.errorBasedDetectionCheckBox);
        this.sqlCheckBoxList.add(this.timeBasedDetectionCheckBox);
        this.sqlCheckBoxList.add(this.useCommentInPayloadCheckBox);
        this.sqlCheckBoxList.add(this.detectSqliInCookieCheckBox);
        this.xssCheckBoxList.add(this.detectXssInCookieCheckBox);
        this.xssCheckBoxList.add(this.ieFeatureCheckBox);
        this.refreshAll();
    }

    private void refreshAll() {
        this.refreshBaseline();
        this.refreshThinkphp();
        this.refreshSql();
        this.refreshXss();
        this.refreshPhantasm();
        this.refreshDirScan();
        this.refreshBrute();
        this.refreshShiro();
    }

    private void initConfigCenter() {
        this.applyAllButton.addActionListener(e -> {
            this.applyBaseline();
            this.applyThinkphp();
            this.applySql();
            this.applyXss();
            this.applyPhantasm();
            this.applyDirScan();
            this.applyBruteForce();
            this.applyShiro();
            JOptionPane.showMessageDialog(null, "\u8bbe\u7f6e\u6210\u529f");
        });
        this.allDefaultButton.addActionListener(e -> {
            MainForm.instance.reloadConfig(true);
            this.refreshAll();
            JOptionPane.showMessageDialog(null, "\u91cd\u7f6e\u6210\u529f");
        });
        this.allRefreshButton.addActionListener(e -> {
            this.refreshAll();
            JOptionPane.showMessageDialog(null, "\u5237\u65b0\u6210\u529f");
        });
        this.selectBaselineButton.addActionListener(e -> {
            if (baselineAll) {
                for (JCheckBox box : this.baselineCheckBoxList) {
                    box.setSelected(false);
                }
                baselineAll = false;
            } else {
                for (JCheckBox box : this.baselineCheckBoxList) {
                    box.setSelected(true);
                }
                baselineAll = true;
            }
        });
        this.selectSqlButton.addActionListener(e -> {
            if (sqlAll) {
                for (JCheckBox box : this.sqlCheckBoxList) {
                    box.setSelected(false);
                }
                sqlAll = false;
            } else {
                for (JCheckBox box : this.sqlCheckBoxList) {
                    box.setSelected(true);
                }
                sqlAll = true;
            }
        });
        this.selectXssButton.addActionListener(e -> {
            if (xssAll) {
                for (JCheckBox box : this.xssCheckBoxList) {
                    box.setSelected(false);
                }
                xssAll = false;
            } else {
                for (JCheckBox box : this.xssCheckBoxList) {
                    box.setSelected(true);
                }
                xssAll = true;
            }
        });
    }

    private void refreshBaseline() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map baselineObj = (Map)plugins.get("baseline");
            this.detectCorsHeaderConfigCheckBox.setSelected((Boolean)baselineObj.get("detect_cors_header_config"));
            this.detectServerErrorPageCheckBox.setSelected((Boolean)baselineObj.get("detect_server_error_page"));
            this.detectPhpinfoCheckBox.setSelected((Boolean)baselineObj.get("detect_phpinfo"));
            this.detectSystemPathLeakCheckBox.setSelected((Boolean)baselineObj.get("detect_system_path_leak"));
            this.detectOutdatedSslVersionCheckBox.setSelected((Boolean)baselineObj.get("detect_outdated_ssl_version"));
            this.detectHttpHeaderConfigCheckBox.setSelected((Boolean)baselineObj.get("detect_http_header_config"));
            this.detectCookieHttponlyCheckBox.setSelected((Boolean)baselineObj.get("detect_cookie_httponly"));
            this.detectChinaIdCardNumberCheckBox.setSelected((Boolean)baselineObj.get("detect_china_id_card_number"));
            this.detectChinaPhoneNumberCheckBox.setSelected((Boolean)baselineObj.get("detect_china_phone_number"));
            this.detectChinaBankCardCheckBox.setSelected((Boolean)baselineObj.get("detect_china_bank_card"));
            this.detectPrivateIpCheckBox.setSelected((Boolean)baselineObj.get("detect_private_ip"));
        }
    }

    private void refreshThinkphp() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("thinkphp");
            this.detectThinkphpSqliCheckBox.setSelected((Boolean)obj.get("detect_thinkphp_sqli"));
        }
    }

    private void refreshSql() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("sqldet");
            this.booleanBasedDetectionCheckBox.setSelected((Boolean)obj.get("boolean_based_detection"));
            this.errorBasedDetectionCheckBox.setSelected((Boolean)obj.get("error_based_detection"));
            this.timeBasedDetectionCheckBox.setSelected((Boolean)obj.get("time_based_detection"));
            this.useCommentInPayloadCheckBox.setSelected((Boolean)obj.get("use_comment_in_payload"));
            this.detectSqliInCookieCheckBox.setSelected((Boolean)obj.get("detect_sqli_in_cookie"));
        }
    }

    private void refreshXss() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("xss");
            this.detectXssInCookieCheckBox.setSelected((Boolean)obj.get("detect_xss_in_cookie"));
            this.ieFeatureCheckBox.setSelected((Boolean)obj.get("ie_feature"));
        }
    }

    private void refreshPhantasm() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("phantasm");
            int depth = (Integer)obj.get("depth");
            this.phantasmDepthText.setText(String.valueOf(depth));
            ArrayList exArray = (ArrayList)obj.get("exclude_poc");
            StringBuilder sb = new StringBuilder();
            for (String ex : exArray) {
                sb.append(ex);
                sb.append("\n");
            }
            this.phExcludeArea.setText(sb.toString());
        }
    }

    private void refreshBrute() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("brute-force");
            String userDic = (String)obj.get("username_dictionary");
            String pwdDic = (String)obj.get("password_dictionary");
            if (StringUtil.notEmpty(userDic)) {
                this.usernameDicText.setText(userDic);
            }
            if (!StringUtil.notEmpty(pwdDic)) continue;
            this.pwdText.setText(pwdDic);
        }
    }

    private void refreshDirScan() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("dirscan");
            int depth = (Integer)obj.get("depth");
            this.dirDepthText.setText(String.valueOf(depth));
            this.dirDicText.setText((String)obj.get("dictionary"));
            ArrayList exArray = (ArrayList)obj.get("exclude_dir");
            StringBuilder sb = new StringBuilder();
            for (String ex : exArray) {
                sb.append(ex);
                sb.append("\n");
            }
            this.phExcludeArea.setText(sb.toString());
        }
    }

    private void refreshShiro() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("shiro");
            String cookieName = (String)obj.get("cookie_name");
            this.shiroCookieText.setText(cookieName);
            ArrayList aesKey = (ArrayList)obj.get("ase_key");
            if (aesKey != null && aesKey.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String k : aesKey) {
                    sb.append(k);
                    sb.append(",");
                }
                String finalStr = sb.toString();
                this.shiroAesKeyText.setText(finalStr.substring(0, finalStr.length() - 1));
            }
            String aesKeyFile = (String)obj.get("aes_key_file");
            this.shiroKeyFileText.setText(aesKeyFile);
        }
    }

    private void applyBaseline() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map baselineObj = (Map)plugins.get("baseline");
            baselineObj.put("detect_cors_header_config", this.detectCorsHeaderConfigCheckBox.isSelected());
            baselineObj.put("detect_server_error_page", this.detectServerErrorPageCheckBox.isSelected());
            baselineObj.put("detect_phpinfo", this.detectPhpinfoCheckBox.isSelected());
            baselineObj.put("detect_system_path_leak", this.detectSystemPathLeakCheckBox.isSelected());
            baselineObj.put("detect_outdated_ssl_version", this.detectOutdatedSslVersionCheckBox.isSelected());
            baselineObj.put("detect_http_header_config", this.detectHttpHeaderConfigCheckBox.isSelected());
            baselineObj.put("detect_cookie_httponly", this.detectCookieHttponlyCheckBox.isSelected());
            baselineObj.put("detect_china_id_card_number", this.detectChinaIdCardNumberCheckBox.isSelected());
            baselineObj.put("detect_china_phone_number", this.detectChinaPhoneNumberCheckBox.isSelected());
            baselineObj.put("detect_china_bank_card", this.detectChinaBankCardCheckBox.isSelected());
            baselineObj.put("detect_private_ip", this.detectPrivateIpCheckBox.isSelected());
        }
        MainForm.instance.refreshConfig();
    }

    private void initBaseline() {
        this.refreshBaselineButton.addActionListener(e -> this.refreshBaseline());
        this.saveBaselineButton.addActionListener(e -> {
            this.applyBaseline();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    private void applyThinkphp() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("thinkphp");
            obj.put("detect_thinkphp_sqli", this.detectThinkphpSqliCheckBox.isSelected());
        }
        MainForm.instance.refreshConfig();
    }

    private void initThinkphp() {
        this.thinkphpRefreshButton.addActionListener(e -> this.refreshThinkphp());
        this.thinkphpSaveButton.addActionListener(e -> {
            this.applyThinkphp();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    private void applySql() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("sqldet");
            obj.put("boolean_based_detection", this.booleanBasedDetectionCheckBox.isSelected());
            obj.put("error_based_detection", this.errorBasedDetectionCheckBox.isSelected());
            obj.put("time_based_detection", this.timeBasedDetectionCheckBox.isSelected());
            obj.put("use_comment_in_payload", this.useCommentInPayloadCheckBox.isSelected());
            obj.put("detect_sqli_in_cookie", this.detectSqliInCookieCheckBox.isSelected());
        }
        MainForm.instance.refreshConfig();
    }

    private void initSqldet() {
        this.refreshSqlButton.addActionListener(e -> this.refreshSql());
        this.saveSqlButton.addActionListener(e -> {
            this.applySql();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    private void applyXss() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("xss");
            obj.put("detect_xss_in_cookie", this.detectXssInCookieCheckBox.isSelected());
            obj.put("ie_feature", this.ieFeatureCheckBox.isSelected());
        }
        MainForm.instance.refreshConfig();
    }

    private void initXss() {
        this.xssRefreshButton.addActionListener(e -> this.refreshXss());
        this.xssSaveButton.addActionListener(e -> {
            this.applyXss();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    private void applyPhantasm() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("phantasm");
            if (StringUtil.notEmpty(this.phantasmDepthText.getText().trim())) {
                obj.put("depth", Integer.parseInt(this.phantasmDepthText.getText().trim()));
            }
            String phText = this.phExcludeArea.getText();
            String[] lines = phText.split("\n");
            ArrayList<String> list = new ArrayList<String>();
            for (String line : lines) {
                if (!StringUtil.notEmpty(line.trim())) continue;
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                list.add(line.trim());
            }
            obj.put("exclude_poc", list);
        }
        MainForm.instance.refreshConfig();
    }

    private void initPhantasm() {
        this.phRefreshButton.addActionListener(e -> this.refreshPhantasm());
        this.phSaveButton.addActionListener(e -> {
            this.applyPhantasm();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    private void applyBruteForce() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("brute-force");
            if (StringUtil.notEmpty(this.usernameDicText.getText().trim())) {
                obj.put("username_dictionary", this.usernameDicText.getText().trim());
            }
            if (!StringUtil.notEmpty(this.pwdText.getText())) continue;
            obj.put("password_dictionary", this.pwdText.getText().trim());
        }
        MainForm.instance.refreshConfig();
    }

    private void getFile(JTextField field) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        int option = fileChooser.showOpenDialog(new JFrame());
        if (option == 0) {
            File file = fileChooser.getSelectedFile();
            String absPath = file.getAbsolutePath();
            field.setText(absPath);
        }
    }

    public void initBruteForce() {
        this.usernameButton.addActionListener(e -> this.getFile(this.usernameDicText));
        this.pwdDicButton.addActionListener(e -> this.getFile(this.pwdText));
        this.refreshBruteButton.addActionListener(e -> this.refreshBrute());
        this.saveBruteButton.addActionListener(e -> {
            this.applyBruteForce();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    private void applyDirScan() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("dirscan");
            obj.put("depth", Integer.parseInt(this.dirDepthText.getText()));
            if (StringUtil.notEmpty(this.dirDicText.getText().trim())) {
                obj.put("dictionary", this.dirDicText.getText().trim());
            }
            String exText = this.excludeArea.getText();
            String[] lines = exText.split("\n");
            ArrayList<String> list = new ArrayList<String>();
            for (String line : lines) {
                if (!StringUtil.notEmpty(line.trim())) continue;
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                list.add(line.trim());
            }
            obj.put("exclude_dir", list);
        }
        MainForm.instance.refreshConfig();
    }

    private void initDirScan() {
        this.dirDicButton.addActionListener(e -> this.getFile(this.dirDicText));
        this.dirRefreshButton.addActionListener(e -> this.refreshDirScan());
        this.dirSaveButton.addActionListener(e -> {
            this.applyDirScan();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    private void applyShiro() {
        for (Map.Entry<String, Object> entry : MainForm.configObj.entrySet()) {
            String[] temp;
            if (!entry.getKey().equals("plugins")) continue;
            Map plugins = (Map)entry.getValue();
            Map obj = (Map)plugins.get("shiro");
            obj.put("cookie_name", this.shiroCookieText.getText());
            ArrayList<String> keys = new ArrayList<String>();
            String text = this.shiroAesKeyText.getText();
            for (String s : temp = text.split(",")) {
                if (!StringUtil.notEmpty(s.trim())) continue;
                keys.add(s.trim());
            }
            obj.put("aes_key", keys);
            obj.put("aes_key_file", this.shiroKeyFileText.getText());
        }
        MainForm.instance.refreshConfig();
    }

    private void initShiro() {
        this.shiroKeyFileButton.addActionListener(e -> this.getFile(this.shiroKeyFileText));
        this.shiroRefreshButton.addActionListener(e -> this.refreshShiro());
        this.shiroSaveButton.addActionListener(e -> {
            this.applyShiro();
            JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f");
        });
    }

    public AdvanceConfigForm() {
        this.$$$setupUI$$$();
        this.init();
        this.initConfigCenter();
        this.initBaseline();
        this.initThinkphp();
        this.initSqldet();
        this.initXss();
        this.initPhantasm();
        this.initBruteForce();
        this.initDirScan();
        this.initShiro();
    }

    private void $$$setupUI$$$() {
        this.advanceConfigPanel = new JPanel();
        this.advanceConfigPanel.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.advanceConfigPanel.setBackground(new Color(-725535));
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.titlePanel.setBackground(new Color(-725535));
        this.advanceConfigPanel.add((Component)this.titlePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 1, 1, null, null, null, 0, false));
        this.titleLabel = new JLabel();
        this.titleLabel.setText("");
        this.titlePanel.add((Component)this.titleLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.leftPanel.setBackground(new Color(-725535));
        this.advanceConfigPanel.add((Component)this.leftPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.baselinePanel = new JPanel();
        this.baselinePanel.setLayout(new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.baselinePanel.setBackground(new Color(-725535));
        this.leftPanel.add((Component)this.baselinePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.baselinePanel.setBorder(BorderFactory.createTitledBorder(null, "baseline", 0, 0, null, null));
        this.detectCorsHeaderConfigCheckBox = new JCheckBox();
        this.detectCorsHeaderConfigCheckBox.setText("detect_cors_header_config");
        this.baselinePanel.add((Component)this.detectCorsHeaderConfigCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.corsLabel = new JLabel();
        this.corsLabel.setText("\u68c0\u67e5 cors \u76f8\u5173\u914d\u7f6e");
        this.baselinePanel.add((Component)this.corsLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.detectServerErrorPageCheckBox = new JCheckBox();
        this.detectServerErrorPageCheckBox.setText("detect_server_error_page");
        this.baselinePanel.add((Component)this.detectServerErrorPageCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectPhpinfoCheckBox = new JCheckBox();
        this.detectPhpinfoCheckBox.setText("detect_phpinfo");
        this.baselinePanel.add((Component)this.detectPhpinfoCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectSystemPathLeakCheckBox = new JCheckBox();
        this.detectSystemPathLeakCheckBox.setText("detect_system_path_leak");
        this.baselinePanel.add((Component)this.detectSystemPathLeakCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectOutdatedSslVersionCheckBox = new JCheckBox();
        this.detectOutdatedSslVersionCheckBox.setText("detect_outdated_ssl_version");
        this.baselinePanel.add((Component)this.detectOutdatedSslVersionCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectHttpHeaderConfigCheckBox = new JCheckBox();
        this.detectHttpHeaderConfigCheckBox.setText("detect_http_header_config");
        this.baselinePanel.add((Component)this.detectHttpHeaderConfigCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectCookieHttponlyCheckBox = new JCheckBox();
        this.detectCookieHttponlyCheckBox.setText("detect_cookie_httponly");
        this.baselinePanel.add((Component)this.detectCookieHttponlyCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectChinaIdCardNumberCheckBox = new JCheckBox();
        this.detectChinaIdCardNumberCheckBox.setText("detect_china_id_card_number");
        this.baselinePanel.add((Component)this.detectChinaIdCardNumberCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectChinaPhoneNumberCheckBox = new JCheckBox();
        this.detectChinaPhoneNumberCheckBox.setText("detect_china_phone_number");
        this.baselinePanel.add((Component)this.detectChinaPhoneNumberCheckBox, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectChinaBankCardCheckBox = new JCheckBox();
        this.detectChinaBankCardCheckBox.setText("detect_china_bank_card");
        this.baselinePanel.add((Component)this.detectChinaBankCardCheckBox, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectPrivateIpCheckBox = new JCheckBox();
        this.detectPrivateIpCheckBox.setText("detect_private_ip");
        this.baselinePanel.add((Component)this.detectPrivateIpCheckBox, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.serverLabel = new JLabel();
        this.serverLabel.setText("\u68c0\u67e5\u670d\u52a1\u5668\u9519\u8bef\u4fe1\u606f");
        this.baselinePanel.add((Component)this.serverLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.phpinfoLabel = new JLabel();
        this.phpinfoLabel.setText("\u68c0\u67e5\u54cd\u5e94\u662f\u5426\u5305\u542bphpinfo");
        this.baselinePanel.add((Component)this.phpinfoLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.leakLabel = new JLabel();
        this.leakLabel.setText("\u68c0\u67e5\u54cd\u5e94\u662f\u5426\u5305\u542b\u7cfb\u7edf\u8def\u5f84\u6cc4\u9732");
        this.baselinePanel.add((Component)this.leakLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.sslLabel = new JLabel();
        this.sslLabel.setText("\u68c0\u67e5 ssl \u7248\u672c\u95ee\u9898");
        this.baselinePanel.add((Component)this.sslLabel, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.headerLabel = new JLabel();
        this.headerLabel.setText("\u68c0\u67e5 http \u5b89\u5168\u76f8\u5173 header \u662f\u5426\u914d\u7f6e");
        this.baselinePanel.add((Component)this.headerLabel, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.setCookieLabel = new JLabel();
        this.setCookieLabel.setText("\u68c0\u67e5 set-cookie \u65f6\u662f\u5426\u8bbe\u7f6e http only");
        this.baselinePanel.add((Component)this.setCookieLabel, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.idLabel = new JLabel();
        this.idLabel.setText("\u68c0\u67e5\u54cd\u5e94\u662f\u5426\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7");
        this.baselinePanel.add((Component)this.idLabel, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.phoneLabel = new JLabel();
        this.phoneLabel.setText("\u68c0\u67e5\u54cd\u5e94\u662f\u5426\u5b58\u5728\u7535\u8bdd\u53f7\u7801");
        this.baselinePanel.add((Component)this.phoneLabel, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.bankLabel = new JLabel();
        this.bankLabel.setText("\u68c0\u67e5\u54cd\u5e94\u662f\u5426\u5b58\u5728\u94f6\u884c\u5361\u53f7");
        this.baselinePanel.add((Component)this.bankLabel, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.privateLabel = new JLabel();
        this.privateLabel.setText("\u68c0\u67e5\u54cd\u5e94\u662f\u5426\u5305\u542b\u5185\u7f51 ip");
        this.baselinePanel.add((Component)this.privateLabel, new GridConstraints(10, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.refreshBaselineButton = new JButton();
        this.refreshBaselineButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.baselinePanel.add((Component)this.refreshBaselineButton, new GridConstraints(11, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.saveBaselineButton = new JButton();
        this.saveBaselineButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.baselinePanel.add((Component)this.saveBaselineButton, new GridConstraints(11, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.sqldetPanel = new JPanel();
        this.sqldetPanel.setLayout(new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.sqldetPanel.setBackground(new Color(-725535));
        this.leftPanel.add((Component)this.sqldetPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.sqldetPanel.setBorder(BorderFactory.createTitledBorder(null, "sqldet", 0, 0, null, null));
        this.booleanBasedDetectionCheckBox = new JCheckBox();
        this.booleanBasedDetectionCheckBox.setText("boolean_based_detection");
        this.sqldetPanel.add((Component)this.booleanBasedDetectionCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.boolLabel = new JLabel();
        this.boolLabel.setText("\u662f\u5426\u68c0\u6d4b\u5e03\u5c14\u76f2\u6ce8");
        this.sqldetPanel.add((Component)this.boolLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.errorBasedDetectionCheckBox = new JCheckBox();
        this.errorBasedDetectionCheckBox.setText("error_based_detection");
        this.sqldetPanel.add((Component)this.errorBasedDetectionCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.timeBasedDetectionCheckBox = new JCheckBox();
        this.timeBasedDetectionCheckBox.setText("time_based_detection");
        this.sqldetPanel.add((Component)this.timeBasedDetectionCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.useCommentInPayloadCheckBox = new JCheckBox();
        this.useCommentInPayloadCheckBox.setText("use_comment_in_payload");
        this.sqldetPanel.add((Component)this.useCommentInPayloadCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.detectSqliInCookieCheckBox = new JCheckBox();
        this.detectSqliInCookieCheckBox.setText("detect_sqli_in_cookie");
        this.sqldetPanel.add((Component)this.detectSqliInCookieCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.errorLabel = new JLabel();
        this.errorLabel.setText("\u662f\u5426\u68c0\u6d4b\u62a5\u9519\u6ce8\u5165");
        this.sqldetPanel.add((Component)this.errorLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.timeLabel = new JLabel();
        this.timeLabel.setText("\u662f\u5426\u68c0\u6d4b\u65f6\u95f4\u76f2\u6ce8");
        this.sqldetPanel.add((Component)this.timeLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.commentLabel = new JLabel();
        this.commentLabel.setText("\u5728 payload \u4e2d\u4f7f\u7528 or (\u614e\u7528\uff01\u53ef\u80fd\u5bfc\u81f4\u5220\u5e93\uff01)");
        this.sqldetPanel.add((Component)this.commentLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.sqlCookieLabel = new JLabel();
        this.sqlCookieLabel.setText("\u662f\u5426\u68c0\u67e5\u5728 cookie \u4e2d\u7684\u6ce8\u5165");
        this.sqldetPanel.add((Component)this.sqlCookieLabel, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.refreshSqlButton = new JButton();
        this.refreshSqlButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.sqldetPanel.add((Component)this.refreshSqlButton, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.saveSqlButton = new JButton();
        this.saveSqlButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.sqldetPanel.add((Component)this.saveSqlButton, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.xssPanel = new JPanel();
        this.xssPanel.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.xssPanel.setBackground(new Color(-725535));
        this.leftPanel.add((Component)this.xssPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.xssPanel.setBorder(BorderFactory.createTitledBorder(null, "xss", 0, 0, null, null));
        this.detectXssInCookieCheckBox = new JCheckBox();
        this.detectXssInCookieCheckBox.setText("detect_xss_in_cookie");
        this.xssPanel.add((Component)this.detectXssInCookieCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.xssCookieLabel = new JLabel();
        this.xssCookieLabel.setText("\u662f\u5426\u63a2\u6d4b\u5165\u53e3\u70b9\u5728 cookie \u4e2d\u7684 xss");
        this.xssPanel.add((Component)this.xssCookieLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.ieFeatureCheckBox = new JCheckBox();
        this.ieFeatureCheckBox.setText("ie_feature");
        this.xssPanel.add((Component)this.ieFeatureCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.xssIeLabel = new JLabel();
        this.xssIeLabel.setText("\u662f\u5426\u626b\u63cf\u4ec5\u80fd\u5728 ie \u4e0b\u5229\u7528\u7684 xss");
        this.xssPanel.add((Component)this.xssIeLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.xssRefreshButton = new JButton();
        this.xssRefreshButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.xssPanel.add((Component)this.xssRefreshButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.xssSaveButton = new JButton();
        this.xssSaveButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.xssPanel.add((Component)this.xssSaveButton, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.thinkphpPanel = new JPanel();
        this.thinkphpPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.thinkphpPanel.setBackground(new Color(-725535));
        this.leftPanel.add((Component)this.thinkphpPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.thinkphpPanel.setBorder(BorderFactory.createTitledBorder(null, "thinkphp", 0, 0, null, null));
        this.detectThinkphpSqliCheckBox = new JCheckBox();
        this.detectThinkphpSqliCheckBox.setText("detect_thinkphp_sqli");
        this.thinkphpPanel.add((Component)this.detectThinkphpSqliCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.thinkphpSqlLabel = new JLabel();
        this.thinkphpSqlLabel.setText("\u68c0\u67e5 thinkphp \u7684 sql \u6ce8\u5165");
        this.thinkphpPanel.add((Component)this.thinkphpSqlLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.thinkphpRefreshButton = new JButton();
        this.thinkphpRefreshButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.thinkphpPanel.add((Component)this.thinkphpRefreshButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.thinkphpSaveButton = new JButton();
        this.thinkphpSaveButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.thinkphpPanel.add((Component)this.thinkphpSaveButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.midPanel = new JPanel();
        this.midPanel.setLayout(new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.midPanel.setBackground(new Color(-725535));
        this.advanceConfigPanel.add((Component)this.midPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.bruteForcePanel = new JPanel();
        this.bruteForcePanel.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.bruteForcePanel.setBackground(new Color(-725535));
        this.midPanel.add((Component)this.bruteForcePanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.bruteForcePanel.setBorder(BorderFactory.createTitledBorder(null, "brute-force", 0, 0, null, null));
        this.usernameDicText = new JTextField();
        this.usernameDicText.setEditable(false);
        this.usernameDicText.setEnabled(false);
        this.bruteForcePanel.add((Component)this.usernameDicText, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.usernameButton = new JButton();
        this.usernameButton.setText("\u9009\u62e9\u7528\u6237\u540d\u5b57\u5178\u6587\u4ef6");
        this.bruteForcePanel.add((Component)this.usernameButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.saveBruteButton = new JButton();
        this.saveBruteButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.bruteForcePanel.add((Component)this.saveBruteButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.refreshBruteButton = new JButton();
        this.refreshBruteButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.bruteForcePanel.add((Component)this.refreshBruteButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.pwdText = new JTextField();
        this.pwdText.setEditable(false);
        this.pwdText.setEnabled(false);
        this.bruteForcePanel.add((Component)this.pwdText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.pwdDicButton = new JButton();
        this.pwdDicButton.setText("\u9009\u62e9\u5bc6\u7801\u5b57\u5178\u6587\u4ef6");
        this.bruteForcePanel.add((Component)this.pwdDicButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.dirscanPanel = new JPanel();
        this.dirscanPanel.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.dirscanPanel.setBackground(new Color(-725535));
        this.midPanel.add((Component)this.dirscanPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.dirscanPanel.setBorder(BorderFactory.createTitledBorder(null, "dirscan", 0, 0, null, null));
        this.dirDepthText = new JTextField();
        this.dirscanPanel.add((Component)this.dirDepthText, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.dirDicText = new JTextField();
        this.dirDicText.setEditable(false);
        this.dirDicText.setEnabled(false);
        this.dirscanPanel.add((Component)this.dirDicText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.dirDicButton = new JButton();
        this.dirDicButton.setText("\u9009\u62e9\u81ea\u5b9a\u4e49\u5b57\u5178");
        this.dirscanPanel.add((Component)this.dirDicButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.dirRefreshButton = new JButton();
        this.dirRefreshButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.dirscanPanel.add((Component)this.dirRefreshButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.dirSaveButton = new JButton();
        this.dirSaveButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.dirscanPanel.add((Component)this.dirSaveButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.dirDepthLabel = new JLabel();
        this.dirDepthLabel.setText("\u8f93\u5165\u68c0\u6d4b\u6df1\u5ea6\uff081-10\uff09");
        this.dirscanPanel.add((Component)this.dirDepthLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.dirScroll = new JScrollPane();
        this.dirscanPanel.add((Component)this.dirScroll, new GridConstraints(2, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.excludeArea = new JTextArea();
        this.dirScroll.setViewportView(this.excludeArea);
        this.excludeLabel = new JLabel();
        this.excludeLabel.setText("<html>\n\u6392\u9664\u54ea\u4e9b\u8def\u5f84\n<br>\n\u5982/admin\u6216/system/key\n<br>\n\u53ef\u8f93\u5165\u591a\u6761\u89c4\u5219\uff0c\u6bcf\u884c\u4e00\u6761\n</html>");
        this.dirscanPanel.add((Component)this.excludeLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.shiroPanel = new JPanel();
        this.shiroPanel.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.shiroPanel.setBackground(new Color(-725535));
        this.midPanel.add((Component)this.shiroPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.shiroPanel.setBorder(BorderFactory.createTitledBorder(null, "shiro", 0, 0, null, null));
        this.shiroCookieText = new JTextField();
        this.shiroPanel.add((Component)this.shiroCookieText, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.shiroAesKeyText = new JTextField();
        this.shiroPanel.add((Component)this.shiroAesKeyText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.shiroRefreshButton = new JButton();
        this.shiroRefreshButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.shiroPanel.add((Component)this.shiroRefreshButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.shiroSaveButton = new JButton();
        this.shiroSaveButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.shiroPanel.add((Component)this.shiroSaveButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.shiroKeyFileText = new JTextField();
        this.shiroKeyFileText.setEditable(false);
        this.shiroKeyFileText.setEnabled(false);
        this.shiroPanel.add((Component)this.shiroKeyFileText, new GridConstraints(2, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.shiroKeyFileButton = new JButton();
        this.shiroKeyFileButton.setText("\u9009\u62e9Key\u6587\u4ef6");
        this.shiroPanel.add((Component)this.shiroKeyFileButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.shiroCookieLabel = new JLabel();
        this.shiroCookieLabel.setText("\u8f93\u5165Cookie\u540d\u79f0");
        this.shiroPanel.add((Component)this.shiroCookieLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.shiroAesKeyLabel = new JLabel();
        this.shiroAesKeyLabel.setText("\u8f93\u5165AES Key");
        this.shiroPanel.add((Component)this.shiroAesKeyLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.phantasmPanel = new JPanel();
        this.phantasmPanel.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.phantasmPanel.setBackground(new Color(-725535));
        this.midPanel.add((Component)this.phantasmPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.phantasmPanel.setBorder(BorderFactory.createTitledBorder(null, "phantasm", 0, 0, null, null));
        this.phantasmDepthText = new JTextField();
        this.phantasmPanel.add((Component)this.phantasmDepthText, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.phRefreshButton = new JButton();
        this.phRefreshButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.phantasmPanel.add((Component)this.phRefreshButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.phSaveButton = new JButton();
        this.phSaveButton.setText("\u786e\u8ba4\u914d\u7f6e");
        this.phantasmPanel.add((Component)this.phSaveButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.phDefaultLabel = new JLabel();
        this.phDefaultLabel.setText("<html>\n\u9ed8\u8ba4\u4f1a\u542f\u52a8\u6240\u6709\u7684\u5185\u7f6ePoC\n<br>\n\u5982\u679c\u4f60\u5e0c\u671b\u6307\u5b9a\u67d0\u4e00\u4e2aPoC\n<br>\n\u8bf7\u524d\u5f80\u4e3b\u754c\u9762PoC\u6a21\u5757\u914d\u7f6e\n</html>");
        this.phantasmPanel.add((Component)this.phDefaultLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.phLoadLabel = new JLabel();
        this.phLoadLabel.setText("<html>\n\u6682\u4e0d\u652f\u6301\u52a0\u8f7d\u672c\u5730\u81ea\u5b9a\u4e49PoC\n<br>\n\u5982\u679c\u4f60\u6709\u4f18\u8d28PoC\u53ef\u4ee5\u4f18\u5148\u63d0\u4ea4\u7ed9\u5e73\u53f0\n<br>\n\u6211\u4eec\u4f1a\u5c3d\u5feb\u5408\u5165\u5185\u7f6ePoC\n</html>");
        this.phantasmPanel.add((Component)this.phLoadLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.phDepthLabel = new JLabel();
        this.phDepthLabel.setText("\u8f93\u5165\u68c0\u6d4b\u6df1\u5ea6\uff081-10\uff09");
        this.phantasmPanel.add((Component)this.phDepthLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.phScroll = new JScrollPane();
        this.phantasmPanel.add((Component)this.phScroll, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.phExcludeArea = new JTextArea();
        this.phScroll.setViewportView(this.phExcludeArea);
        this.phExcludeLabel = new JLabel();
        this.phExcludeLabel.setText("<html>\n\u6392\u9664\u54ea\u4e9b\u5185\u7f6e PoC\n<br>\n\u652f\u6301\u901a\u914d\u7b26\uff08\u5982poc-yaml-tomcat*\uff09\n<br>\n\u53ef\u8f93\u5165\u591a\u6761\u89c4\u5219\uff0c\u6bcf\u884c\u4e00\u6761\n</html>");
        this.phantasmPanel.add((Component)this.phExcludeLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.configCenterPanel = new JPanel();
        this.configCenterPanel.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.configCenterPanel.setBackground(new Color(-725535));
        this.advanceConfigPanel.add((Component)this.configCenterPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.configCenterPanel.setBorder(BorderFactory.createTitledBorder(null, "\u914d\u7f6e\u4e2d\u5fc3", 0, 0, null, null));
        this.allDefaultButton = new JButton();
        this.allDefaultButton.setText("\u6062\u590d\u9ed8\u8ba4");
        this.configCenterPanel.add((Component)this.allDefaultButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.allRefreshButton = new JButton();
        this.allRefreshButton.setText("\u5237\u65b0\u914d\u7f6e");
        this.configCenterPanel.add((Component)this.allRefreshButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.applyAllButton = new JButton();
        this.applyAllButton.setText("\u4e00\u952e\u786e\u8ba4\u6240\u6709\u914d\u7f6e");
        this.configCenterPanel.add((Component)this.applyAllButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.selectBaselineButton = new JButton();
        this.selectBaselineButton.setText("baseline\u5168\u90e8\u52fe\u9009");
        this.configCenterPanel.add((Component)this.selectBaselineButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.selectSqlButton = new JButton();
        this.selectSqlButton.setText("sqldet\u5168\u90e8\u52fe\u9009");
        this.configCenterPanel.add((Component)this.selectSqlButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.selectXssButton = new JButton();
        this.selectXssButton.setText("xss\u5168\u90e8\u52fe\u9009");
        this.configCenterPanel.add((Component)this.selectXssButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.showLabel = new JLabel();
        this.showLabel.setText("<html>\n\u9ad8\u7ea7\u914d\u7f6e\u5e76\u4e0d\u4f1a\u6fc0\u6d3b\u63d2\u4ef6\n<br>\n\u52fe\u9009\u5bf9\u5e94\u63d2\u4ef6 \u70b9\u51fb \u786e\u8ba4\u63d2\u4ef6 \u751f\u6548\n</html>");
        this.advanceConfigPanel.add((Component)this.showLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.advanceConfigPanel;
    }
}

