/*
 * Decompiled with CFR 0.152.
 */
package com.github.twocoffeesoneteam.glidetovectoryou;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.github.twocoffeesoneteam.glidetovectoryou.GlideApp;
import com.github.twocoffeesoneteam.glidetovectoryou.GlideToVectorYouListener;
import com.github.twocoffeesoneteam.glidetovectoryou.SvgSoftwareLayerSetter;

public class GlideToVectorYou {
    private static GlideToVectorYou instance;
    private RequestBuilder<PictureDrawable> requestBuilder;
    private int placeHolderLoading = -1;
    private int placeHolderError = -1;

    public static GlideToVectorYou init() {
        if (instance == null) {
            instance = new GlideToVectorYou();
        }
        return instance;
    }

    public GlideToVectorYou with(Context ctx) {
        this.createRequestBuilder(ctx);
        return instance;
    }

    public GlideToVectorYou withListener(GlideToVectorYouListener listener) {
        this.requestBuilder.listener((RequestListener)new SvgSoftwareLayerSetter(listener));
        return instance;
    }

    public GlideToVectorYou setPlaceHolder(int placeHolderLoading, int placeHolderError) {
        this.placeHolderError = placeHolderError;
        this.placeHolderLoading = placeHolderLoading;
        return instance;
    }

    public void load(Uri uri, ImageView imageView) {
        if (this.placeHolderLoading != -1 && this.placeHolderError != -1) {
            this.requestBuilder.apply(((RequestOptions)new RequestOptions().placeholder(this.placeHolderLoading)).error(this.placeHolderError));
        }
        this.requestBuilder.load(uri).into(imageView);
    }

    public static void justLoadImage(Activity activity, Uri uri, ImageView imageView) {
        GlideApp.with(activity).as(PictureDrawable.class).listener(new SvgSoftwareLayerSetter()).load(uri).into(imageView);
    }

    public static void justLoadImageAsBackground(Activity activity, Uri uri, final View view) {
        GlideApp.with(activity).load(uri).into((Target)new SimpleTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable resource, Transition<? super Drawable> transition) {
                view.setBackground(resource);
            }
        });
    }

    public RequestBuilder<PictureDrawable> getRequestBuilder() {
        return this.requestBuilder;
    }

    private void createRequestBuilder(Context ctx) {
        this.requestBuilder = GlideApp.with(ctx).as(PictureDrawable.class).diskCacheStrategy(DiskCacheStrategy.DATA).listener(new SvgSoftwareLayerSetter());
    }
}

