/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.utils;

import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.utils.MDOUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;

public final class MDOPathUtils {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String EXTENSION_XML = "xml";
    private static final String EXTENSION_MDO = "mdo";

    public static String mdoExtension(ConfigurationSource configurationSource, boolean withDot) {
        String dot = ".";
        if (!withDot) {
            dot = "";
        }
        switch (configurationSource) {
            case EDT: {
                return dot + EXTENSION_MDO;
            }
            case DESIGNER: {
                return dot + EXTENSION_XML;
            }
        }
        return "";
    }

    public static Optional<Path> getMDOPath(ConfigurationSource configurationSource, Path rootPath, MDOType type, String name) {
        Path value;
        if (configurationSource == ConfigurationSource.EDT) {
            value = MDOPathUtils.getMDOPathEDT(MDOPathUtils.getMDOTypeFolderPathEDT(rootPath, type), name);
        } else if (configurationSource == ConfigurationSource.DESIGNER) {
            value = MDOPathUtils.getMDOPathDesigner(MDOPathUtils.getMDOTypeFolderPathDesigner(rootPath, type), name);
        } else {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Path> getMDOPath(ConfigurationSource configurationSource, Path folder, String name) {
        Path value;
        if (configurationSource == ConfigurationSource.EDT) {
            value = MDOPathUtils.getMDOPathEDT(folder, name);
        } else if (configurationSource == ConfigurationSource.DESIGNER) {
            value = MDOPathUtils.getMDOPathDesigner(folder, name);
        } else {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Path> getRootPathByConfigurationMDO(Path mdoPath) {
        Path value;
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(mdoPath);
        if (configurationSource == ConfigurationSource.EDT) {
            value = Paths.get(FilenameUtils.getFullPathNoEndSeparator((String)MDOPathUtils.getMDOTypeFolderPathByMDOPathEDT(mdoPath).toString()), new String[0]);
        } else if (configurationSource == ConfigurationSource.DESIGNER) {
            value = MDOPathUtils.getMDOTypeFolderPathByMDOPathDesigner(mdoPath);
        } else {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Path> getMDOTypeFolderByMDOPath(ConfigurationSource configurationSource, Path mdoPath) {
        Path value;
        if (configurationSource == ConfigurationSource.EDT) {
            value = MDOPathUtils.getMDOTypeFolderPathByMDOPathEDT(mdoPath);
        } else if (configurationSource == ConfigurationSource.DESIGNER) {
            value = MDOPathUtils.getMDOTypeFolderPathByMDOPathDesigner(mdoPath);
        } else {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Path> getMDOTypeFolderByMDOPath(Path mdoPath, MDOType type) {
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(mdoPath);
        Optional<Path> result = type == MDOType.CONFIGURATION ? (configurationSource == ConfigurationSource.EDT ? Optional.of(Paths.get(FilenameUtils.getFullPathNoEndSeparator((String)mdoPath.toString()), new String[0])) : (configurationSource == ConfigurationSource.DESIGNER ? Optional.of(MDOPathUtils.getMDOTypeFolderPathByMDOPathDesigner(mdoPath)) : Optional.empty())) : MDOPathUtils.getMDOTypeFolderByMDOPath(configurationSource, mdoPath);
        return result;
    }

    public static Optional<Path> getModulePath(ConfigurationSource configurationSource, Path folder, String name, ModuleType moduleType) {
        Path value;
        if (configurationSource == ConfigurationSource.EDT) {
            value = MDOPathUtils.getModulePathEDT(folder, name, moduleType);
        } else if (configurationSource == ConfigurationSource.DESIGNER) {
            value = MDOPathUtils.getModulePathDesigner(folder, name, moduleType);
        } else {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Path> getParentConfigurationsPath(ConfigurationSource configurationSource, Path rootPath) {
        Path value;
        if (configurationSource == ConfigurationSource.EDT) {
            value = Paths.get(rootPath.toString(), "src", MDOType.CONFIGURATION.getName(), "ParentConfigurations.bin");
        } else if (configurationSource == ConfigurationSource.DESIGNER) {
            value = Paths.get(rootPath.toString(), "Ext", "ParentConfigurations.bin");
        } else {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Path> getChildrenFolder(String mdoName, Path folder, MDOType type) {
        Path formFolder = Paths.get(folder.toString(), mdoName, type.getGroupName());
        if (formFolder.toFile().exists()) {
            return Optional.of(formFolder);
        }
        return Optional.empty();
    }

    public static Path getFormDataPath(AbstractMDObjectBase form) {
        Path currentPath = form.getPath().getParent();
        String basePath = currentPath.toString();
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(form.getPath());
        currentPath = configurationSource == ConfigurationSource.EDT ? (form.getType() == MDOType.COMMON_FORM ? Path.of(basePath, "Form.form") : Path.of(basePath, MDOType.FORM.getGroupName(), form.getName(), "Form.form")) : Path.of(currentPath.toString(), form.getName(), "Ext", "Form.xml");
        return currentPath;
    }

    public static Path getTemplateDataPath(AbstractMDObjectBase template) {
        Path currentPath = template.getPath().getParent();
        String basePath = currentPath.toString();
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(template.getPath());
        currentPath = configurationSource == ConfigurationSource.EDT ? (template.getType() == MDOType.COMMON_TEMPLATE ? Path.of(basePath, "Template.dcs") : Path.of(basePath, MDOType.TEMPLATE.getGroupName(), template.getName(), "Template.dcs")) : Paths.get(basePath, template.getName(), "Ext", "Template.xml");
        return currentPath;
    }

    public static Path getPackageDataPath(AbstractMDObjectBase xdto) {
        Path currentPath = xdto.getPath().getParent();
        String basePath = currentPath.toString();
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(xdto.getPath());
        currentPath = configurationSource == ConfigurationSource.EDT ? Path.of(basePath, "Package.xdto") : Paths.get(basePath, xdto.getName(), "Ext", "Package.bin");
        return currentPath;
    }

    private static Path getMDOTypeFolderPathEDT(Path rootPath, MDOType type) {
        return Paths.get(rootPath.toString(), "src", type.getGroupName());
    }

    private static Path getMDOTypeFolderPathByMDOPathEDT(Path mdoPath) {
        return Paths.get(FilenameUtils.getFullPathNoEndSeparator((String)FilenameUtils.getFullPathNoEndSeparator((String)mdoPath.toString())), new String[0]);
    }

    private static Path getMDOPathEDT(Path folder, String name) {
        return Paths.get(folder.toString(), name, name + ".mdo");
    }

    private static Path getModulePathEDT(Path folder, String name, ModuleType moduleType) {
        return Paths.get(folder.toString(), name, moduleType.getFileName());
    }

    private static Path getMDOTypeFolderPathDesigner(Path rootPath, MDOType type) {
        return Paths.get(rootPath.toString(), type.getGroupName());
    }

    private static Path getMDOTypeFolderPathByMDOPathDesigner(Path mdoPath) {
        return Paths.get(FilenameUtils.getFullPathNoEndSeparator((String)mdoPath.toString()), new String[0]);
    }

    private static Path getMDOPathDesigner(Path folder, String name) {
        return Paths.get(folder.toString(), name + ".xml");
    }

    private static Path getModulePathDesigner(Path folder, String name, ModuleType moduleType) {
        Object subdirectory = "Ext";
        if (moduleType == ModuleType.FormModule) {
            subdirectory = (String)subdirectory + FILE_SEPARATOR + "Form";
        }
        if (!MDOUtils.getModuleTypesForMdoTypes().get((Object)MDOType.CONFIGURATION).contains((Object)moduleType)) {
            subdirectory = name + FILE_SEPARATOR + (String)subdirectory;
        }
        return Paths.get(folder.toString(), new String[]{subdirectory, moduleType.getFileName()});
    }

    public static Path getRoleDataPath(ConfigurationSource configurationSource, String basePath, String mdoName) {
        Path path = configurationSource == ConfigurationSource.EDT ? Path.of(basePath, "Rights.rights") : Path.of(basePath, mdoName, "Ext", "Rights.xml");
        return path;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MDOPathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

