/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.mdo.metadata;

import com.github._1c_syntax.mdclasses.mdo.metadata.AttributeMetadata;
import com.github._1c_syntax.mdclasses.mdo.metadata.Metadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataStorage.class);
    private static final Map<Class<?>, Metadata> STORAGE = MetadataStorage.computeStorage(Metadata.class);
    private static final Map<Class<?>, AttributeMetadata> ATTRIBUTE_STORAGE = MetadataStorage.computeStorage(AttributeMetadata.class);

    private MetadataStorage() {
    }

    public static Map<Class<?>, Metadata> getStorage() {
        return STORAGE;
    }

    public static Map<Class<?>, AttributeMetadata> getAttributeStorage() {
        return ATTRIBUTE_STORAGE;
    }

    public static Metadata get(Class<?> clazz) {
        return STORAGE.get(clazz);
    }

    public static AttributeMetadata getAttribute(Class<?> clazz) {
        return ATTRIBUTE_STORAGE.get(clazz);
    }

    private static <T extends Annotation> Map<Class<?>, T> computeStorage(Class<T> annotation) {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().acceptPackages(new String[]{"com.github._1c_syntax.mdclasses"}).scan();){
            HashMap localStorage = new HashMap();
            ClassInfoList classes = scanResult.getClassesWithAnnotation(annotation.getName());
            classes.stream().map(MetadataStorage.getClassFromInfoClass()).filter(Objects::nonNull).forEach(aClass -> localStorage.put(aClass, aClass.getAnnotation(annotation)));
            Map map = Collections.unmodifiableMap(localStorage);
            return map;
        }
    }

    private static Function<ClassInfo, ? extends Class<?>> getClassFromInfoClass() {
        return classInfo -> {
            try {
                return Class.forName(classInfo.getName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Cannot resolve class: " + classInfo.getName());
                return null;
            }
        };
    }
}

