/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.mdo;

import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.metadata.Metadata;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerMDO;
import com.github._1c_syntax.mdclasses.utils.MDOFactory;
import com.github._1c_syntax.mdclasses.utils.MDOPathUtils;
import com.github._1c_syntax.mdclasses.utils.MDOUtils;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vavr.control.Either;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

@Metadata(type=MDOType.SUBSYSTEM, name="Subsystem", nameRu="\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0430", groupName="Subsystems", groupNameRu="\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b")
public class MDSubsystem
extends AbstractMDObjectBase {
    @XStreamImplicit
    private List<Either<String, AbstractMDObjectBase>> children = Collections.emptyList();
    private boolean includeInCommandInterface;

    public MDSubsystem(DesignerMDO designerMDO) {
        super(designerMDO);
        ArrayList<Either<String, AbstractMDObjectBase>> newChildren = new ArrayList<Either<String, AbstractMDObjectBase>>();
        designerMDO.getProperties().getContent().getItems().forEach(item -> newChildren.add(Either.left((Object)item.getValue())));
        this.includeInCommandInterface = designerMDO.getProperties().isIncludeInCommandInterface();
        newChildren.addAll(designerMDO.getChildObjects().getChildren());
        this.setChildren(newChildren);
    }

    @Override
    public void supplement() {
        super.supplement();
        this.computeSubsystemChildren();
    }

    @Override
    public void supplement(AbstractMDObjectBase parent) {
        super.supplement(parent);
        this.computeSubsystemChildren();
    }

    public void linkToChildren(Map<String, AbstractMDObjectBase> allMDO) {
        ArrayList<Either<String, AbstractMDObjectBase>> localChildren = new ArrayList<Either<String, AbstractMDObjectBase>>();
        this.children.forEach(mdoPair -> {
            if (mdoPair.isLeft()) {
                AbstractMDObjectBase mdo = (AbstractMDObjectBase)allMDO.get(mdoPair.getLeft());
                if (mdo != null) {
                    localChildren.add(Either.right((Object)mdo));
                    this.setSubsystemForChild(allMDO, mdo);
                } else {
                    localChildren.add((Either<String, AbstractMDObjectBase>)mdoPair);
                }
            } else {
                AbstractMDObjectBase mdo = (AbstractMDObjectBase)mdoPair.get();
                if (!mdo.getIncludedSubsystems().contains(this)) {
                    localChildren.add((Either<String, AbstractMDObjectBase>)mdoPair);
                    this.setSubsystemForChild(allMDO, mdo);
                }
            }
        });
        this.setChildren(localChildren);
    }

    private void computeSubsystemChildren() {
        if (this.children.isEmpty()) {
            return;
        }
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(this.getPath());
        Optional<Path> rootFolder = MDOPathUtils.getMDOTypeFolderByMDOPath(configurationSource, this.getPath());
        if (rootFolder.isEmpty()) {
            return;
        }
        ArrayList<Either<String, AbstractMDObjectBase>> newChildren = new ArrayList<Either<String, AbstractMDObjectBase>>();
        Path folder = Paths.get(rootFolder.get().toString(), this.getName(), MDOType.SUBSYSTEM.getGroupName());
        String startName = MDOType.SUBSYSTEM.getName() + ".";
        this.children.stream().filter(Either::isLeft).filter(child -> ((String)child.getLeft()).startsWith(startName) && !((String)child.getLeft()).contains("-")).forEach(child -> {
            int subsystemObjectLastPosition = ((String)child.getLeft()).lastIndexOf(startName);
            String subsystemName = ((String)child.getLeft()).substring(subsystemObjectLastPosition + startName.length());
            MDOPathUtils.getMDOPath(configurationSource, folder, subsystemName).ifPresent(mdoPath -> {
                AbstractMDObjectBase childSubsystem = MDOFactory.readMDO(mdoPath);
                if (childSubsystem != null) {
                    childSubsystem.supplement(this);
                    newChildren.add(Either.right((Object)childSubsystem));
                } else if (!((String)child.getLeft()).equals(this.getMdoReference().getMdoRef())) {
                    newChildren.add((Either<String, AbstractMDObjectBase>)child);
                }
            });
        });
        newChildren.addAll(this.children.stream().filter(Either::isLeft).filter(child -> !((String)child.getLeft()).startsWith(startName)).collect(Collectors.toList()));
        this.setChildren(newChildren);
    }

    private void setSubsystemForChild(Map<String, AbstractMDObjectBase> allMDO, AbstractMDObjectBase mdo) {
        mdo.addIncludedSubsystem(this);
        if (mdo instanceof MDSubsystem) {
            ((MDSubsystem)mdo).linkToChildren(allMDO);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Either<String, AbstractMDObjectBase>> getChildren() {
        return this.children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isIncludeInCommandInterface() {
        return this.includeInCommandInterface;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChildren(List<Either<String, AbstractMDObjectBase>> children) {
        this.children = children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setIncludeInCommandInterface(boolean includeInCommandInterface) {
        this.includeInCommandInterface = includeInCommandInterface;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MDSubsystem)) {
            return false;
        }
        MDSubsystem other = (MDSubsystem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MDSubsystem;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MDSubsystem(super=" + super.toString() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MDSubsystem() {
    }
}

