/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.mdo;

import com.github._1c_syntax.mdclasses.common.CompatibilityMode;
import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBSL;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.MDCommonAttribute;
import com.github._1c_syntax.mdclasses.mdo.MDLanguage;
import com.github._1c_syntax.mdclasses.mdo.MDSubsystem;
import com.github._1c_syntax.mdclasses.mdo.metadata.Metadata;
import com.github._1c_syntax.mdclasses.mdo.support.ConfigurationExtensionPurpose;
import com.github._1c_syntax.mdclasses.mdo.support.DataLockControlMode;
import com.github._1c_syntax.mdclasses.mdo.support.LanguageContent;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ScriptVariant;
import com.github._1c_syntax.mdclasses.mdo.support.UseMode;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerContentItem;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerMDO;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerProperties;
import com.github._1c_syntax.mdclasses.utils.MDOFactory;
import com.github._1c_syntax.mdclasses.utils.MDOPathUtils;
import com.github._1c_syntax.mdclasses.utils.MDOUtils;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vavr.control.Either;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

@Metadata(type=MDOType.CONFIGURATION, name="Configuration", nameRu="\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", groupName="", groupNameRu="")
public class MDConfiguration
extends AbstractMDObjectBSL {
    private ScriptVariant scriptVariant = ScriptVariant.ENGLISH;
    private CompatibilityMode compatibilityMode = new CompatibilityMode();
    private CompatibilityMode configurationExtensionCompatibilityMode = new CompatibilityMode();
    private UseMode modalityUseMode = UseMode.USE;
    private UseMode synchronousExtensionAndAddInCallUseMode = UseMode.USE;
    private UseMode synchronousPlatformExtensionAndAddInCallUseMode = UseMode.USE;
    private boolean useManagedFormInOrdinaryApplication;
    @XStreamImplicit(itemFieldName="copyright")
    private List<LanguageContent> copyrights = Collections.emptyList();
    @XStreamImplicit(itemFieldName="detailedInformation")
    private List<LanguageContent> detailedInformation = Collections.emptyList();
    @XStreamImplicit(itemFieldName="briefInformation")
    private List<LanguageContent> briefInformation = Collections.emptyList();
    private boolean useOrdinaryFormInManagedApplication;
    private String defaultRunMode = "";
    private Either<String, MDLanguage> defaultLanguage = Either.right((Object)MDOFactory.fakeLanguage(this.scriptVariant));
    private DataLockControlMode dataLockControlMode = DataLockControlMode.AUTOMATIC;
    private String objectAutonumerationMode = "";
    @XStreamImplicit
    private List<Either<String, AbstractMDObjectBase>> children = Collections.emptyList();
    private ConfigurationExtensionPurpose configurationExtensionPurpose = ConfigurationExtensionPurpose.PATCH;
    private String namePrefix = "";

    public MDConfiguration(DesignerMDO designerMDO) {
        super(designerMDO);
        DesignerProperties designerProperties = designerMDO.getProperties();
        this.scriptVariant = designerProperties.getScriptVariant();
        this.compatibilityMode = designerProperties.getCompatibilityMode();
        this.configurationExtensionCompatibilityMode = designerProperties.getConfigurationExtensionCompatibilityMode();
        this.dataLockControlMode = designerProperties.getDataLockControlMode();
        this.defaultLanguage = Either.left((Object)designerProperties.getDefaultLanguage());
        this.defaultRunMode = designerProperties.getDefaultRunMode();
        this.modalityUseMode = designerProperties.getModalityUseMode();
        this.objectAutonumerationMode = designerProperties.getObjectAutonumerationMode();
        this.synchronousExtensionAndAddInCallUseMode = designerProperties.getSynchronousExtensionAndAddInCallUseMode();
        this.synchronousPlatformExtensionAndAddInCallUseMode = designerProperties.getSynchronousPlatformExtensionAndAddInCallUseMode();
        this.configurationExtensionPurpose = designerProperties.getConfigurationExtensionPurpose();
        this.namePrefix = designerProperties.getNamePrefix();
        this.useManagedFormInOrdinaryApplication = designerProperties.isUseManagedFormInOrdinaryApplication();
        this.useOrdinaryFormInManagedApplication = designerProperties.isUseOrdinaryFormInManagedApplication();
        this.copyrights = MDConfiguration.createLanguageContent(designerProperties.getCopyrights());
        this.briefInformation = MDConfiguration.createLanguageContent(designerProperties.getBriefInformation());
        this.detailedInformation = MDConfiguration.createLanguageContent(designerProperties.getDetailedInformation());
        this.children = designerMDO.getChildObjects().getChildren();
    }

    @Override
    public void supplement() {
        super.supplement();
        MDOPathUtils.getRootPathByConfigurationMDO(this.path).ifPresent(this::computeAllMDObject);
        Map<String, AbstractMDObjectBase> localChildren = this.getAllMDO();
        this.linkChildAndSubsystem(localChildren);
        this.linkCommonAttributesAndUsing(localChildren);
        this.setDefaultConfigurationLanguage();
    }

    private static List<LanguageContent> createLanguageContent(List<DesignerContentItem> designerContentItems) {
        if (designerContentItems.isEmpty()) {
            return Collections.emptyList();
        }
        return designerContentItems.stream().map(designerCopyright -> new LanguageContent(designerCopyright.getLanguage(), designerCopyright.getContent())).collect(Collectors.toList());
    }

    private void setDefaultConfigurationLanguage() {
        if (this.defaultLanguage.isLeft()) {
            String defaultLang = (String)this.defaultLanguage.getLeft();
            this.children.stream().filter(Either::isRight).map(Either::get).filter(MDLanguage.class::isInstance).map(MDLanguage.class::cast).filter(mdo -> defaultLang.equals(mdo.getMdoReference().getMdoRef())).findFirst().ifPresent(mdo -> this.setDefaultLanguage((Either<String, MDLanguage>)Either.right((Object)mdo)));
        }
    }

    private void computeAllMDObject(Path rootPath) {
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByMDOPath(this.path);
        List<Either<String, AbstractMDObjectBase>> localChildren = this.children.parallelStream().map(child -> MDConfiguration.readChildMDO(configurationSource, rootPath, (Either<String, AbstractMDObjectBase>)child)).collect(Collectors.toList());
        this.setChildren(localChildren);
    }

    private static Either<String, AbstractMDObjectBase> readChildMDO(ConfigurationSource configurationSource, Path rootPath, Either<String, AbstractMDObjectBase> child) {
        if (!child.isRight()) {
            String value = (String)child.getLeft();
            int dotPosition = value.indexOf(46);
            Optional<MDOType> type = MDOType.fromValue(value.substring(0, dotPosition));
            String name = value.substring(dotPosition + 1);
            if (type.isPresent()) {
                Optional<Either> mdo = MDOPathUtils.getMDOPath(configurationSource, rootPath, type.get(), name).flatMap(MDOFactory::readMDObject);
                return mdo.map(Either::right).orElse(child);
            }
        }
        return child;
    }

    private void linkChildAndSubsystem(Map<String, AbstractMDObjectBase> allMDO) {
        this.children.stream().filter(Either::isRight).map(Either::get).filter(mdo -> mdo.getType() == MDOType.SUBSYSTEM).map(MDSubsystem.class::cast).forEach(subsystem -> subsystem.linkToChildren(allMDO));
    }

    private void linkCommonAttributesAndUsing(Map<String, AbstractMDObjectBase> allMDO) {
        this.children.stream().filter(Either::isRight).map(Either::get).filter(mdo -> mdo.getType() == MDOType.COMMON_ATTRIBUTE).map(MDCommonAttribute.class::cast).forEach(commonAttribute -> commonAttribute.linkUsing(allMDO));
    }

    private Map<String, AbstractMDObjectBase> getAllMDO() {
        return this.children.stream().filter(Either::isRight).map(Either::get).collect(Collectors.toMap(mdo -> mdo.getMdoReference().getMdoRef(), mdo -> mdo));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScriptVariant getScriptVariant() {
        return this.scriptVariant;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompatibilityMode getCompatibilityMode() {
        return this.compatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompatibilityMode getConfigurationExtensionCompatibilityMode() {
        return this.configurationExtensionCompatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UseMode getModalityUseMode() {
        return this.modalityUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UseMode getSynchronousExtensionAndAddInCallUseMode() {
        return this.synchronousExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UseMode getSynchronousPlatformExtensionAndAddInCallUseMode() {
        return this.synchronousPlatformExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseManagedFormInOrdinaryApplication() {
        return this.useManagedFormInOrdinaryApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LanguageContent> getCopyrights() {
        return this.copyrights;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LanguageContent> getDetailedInformation() {
        return this.detailedInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LanguageContent> getBriefInformation() {
        return this.briefInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseOrdinaryFormInManagedApplication() {
        return this.useOrdinaryFormInManagedApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDefaultRunMode() {
        return this.defaultRunMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Either<String, MDLanguage> getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DataLockControlMode getDataLockControlMode() {
        return this.dataLockControlMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getObjectAutonumerationMode() {
        return this.objectAutonumerationMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Either<String, AbstractMDObjectBase>> getChildren() {
        return this.children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigurationExtensionPurpose getConfigurationExtensionPurpose() {
        return this.configurationExtensionPurpose;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNamePrefix() {
        return this.namePrefix;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setScriptVariant(ScriptVariant scriptVariant) {
        this.scriptVariant = scriptVariant;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCompatibilityMode(CompatibilityMode compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationExtensionCompatibilityMode(CompatibilityMode configurationExtensionCompatibilityMode) {
        this.configurationExtensionCompatibilityMode = configurationExtensionCompatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModalityUseMode(UseMode modalityUseMode) {
        this.modalityUseMode = modalityUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSynchronousExtensionAndAddInCallUseMode(UseMode synchronousExtensionAndAddInCallUseMode) {
        this.synchronousExtensionAndAddInCallUseMode = synchronousExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSynchronousPlatformExtensionAndAddInCallUseMode(UseMode synchronousPlatformExtensionAndAddInCallUseMode) {
        this.synchronousPlatformExtensionAndAddInCallUseMode = synchronousPlatformExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUseManagedFormInOrdinaryApplication(boolean useManagedFormInOrdinaryApplication) {
        this.useManagedFormInOrdinaryApplication = useManagedFormInOrdinaryApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCopyrights(List<LanguageContent> copyrights) {
        this.copyrights = copyrights;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDetailedInformation(List<LanguageContent> detailedInformation) {
        this.detailedInformation = detailedInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBriefInformation(List<LanguageContent> briefInformation) {
        this.briefInformation = briefInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUseOrdinaryFormInManagedApplication(boolean useOrdinaryFormInManagedApplication) {
        this.useOrdinaryFormInManagedApplication = useOrdinaryFormInManagedApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDefaultRunMode(String defaultRunMode) {
        this.defaultRunMode = defaultRunMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDefaultLanguage(Either<String, MDLanguage> defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDataLockControlMode(DataLockControlMode dataLockControlMode) {
        this.dataLockControlMode = dataLockControlMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setObjectAutonumerationMode(String objectAutonumerationMode) {
        this.objectAutonumerationMode = objectAutonumerationMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChildren(List<Either<String, AbstractMDObjectBase>> children) {
        this.children = children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationExtensionPurpose(ConfigurationExtensionPurpose configurationExtensionPurpose) {
        this.configurationExtensionPurpose = configurationExtensionPurpose;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MDConfiguration)) {
            return false;
        }
        MDConfiguration other = (MDConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isUseManagedFormInOrdinaryApplication() != other.isUseManagedFormInOrdinaryApplication()) {
            return false;
        }
        if (this.isUseOrdinaryFormInManagedApplication() != other.isUseOrdinaryFormInManagedApplication()) {
            return false;
        }
        ScriptVariant this$scriptVariant = this.getScriptVariant();
        ScriptVariant other$scriptVariant = other.getScriptVariant();
        if (this$scriptVariant == null ? other$scriptVariant != null : !this$scriptVariant.equals(other$scriptVariant)) {
            return false;
        }
        CompatibilityMode this$compatibilityMode = this.getCompatibilityMode();
        CompatibilityMode other$compatibilityMode = other.getCompatibilityMode();
        if (this$compatibilityMode == null ? other$compatibilityMode != null : !this$compatibilityMode.equals(other$compatibilityMode)) {
            return false;
        }
        CompatibilityMode this$configurationExtensionCompatibilityMode = this.getConfigurationExtensionCompatibilityMode();
        CompatibilityMode other$configurationExtensionCompatibilityMode = other.getConfigurationExtensionCompatibilityMode();
        if (this$configurationExtensionCompatibilityMode == null ? other$configurationExtensionCompatibilityMode != null : !this$configurationExtensionCompatibilityMode.equals(other$configurationExtensionCompatibilityMode)) {
            return false;
        }
        UseMode this$modalityUseMode = this.getModalityUseMode();
        UseMode other$modalityUseMode = other.getModalityUseMode();
        if (this$modalityUseMode == null ? other$modalityUseMode != null : !this$modalityUseMode.equals(other$modalityUseMode)) {
            return false;
        }
        UseMode this$synchronousExtensionAndAddInCallUseMode = this.getSynchronousExtensionAndAddInCallUseMode();
        UseMode other$synchronousExtensionAndAddInCallUseMode = other.getSynchronousExtensionAndAddInCallUseMode();
        if (this$synchronousExtensionAndAddInCallUseMode == null ? other$synchronousExtensionAndAddInCallUseMode != null : !this$synchronousExtensionAndAddInCallUseMode.equals(other$synchronousExtensionAndAddInCallUseMode)) {
            return false;
        }
        UseMode this$synchronousPlatformExtensionAndAddInCallUseMode = this.getSynchronousPlatformExtensionAndAddInCallUseMode();
        UseMode other$synchronousPlatformExtensionAndAddInCallUseMode = other.getSynchronousPlatformExtensionAndAddInCallUseMode();
        if (this$synchronousPlatformExtensionAndAddInCallUseMode == null ? other$synchronousPlatformExtensionAndAddInCallUseMode != null : !this$synchronousPlatformExtensionAndAddInCallUseMode.equals(other$synchronousPlatformExtensionAndAddInCallUseMode)) {
            return false;
        }
        List<LanguageContent> this$copyrights = this.getCopyrights();
        List<LanguageContent> other$copyrights = other.getCopyrights();
        if (this$copyrights == null ? other$copyrights != null : !((Object)this$copyrights).equals(other$copyrights)) {
            return false;
        }
        List<LanguageContent> this$detailedInformation = this.getDetailedInformation();
        List<LanguageContent> other$detailedInformation = other.getDetailedInformation();
        if (this$detailedInformation == null ? other$detailedInformation != null : !((Object)this$detailedInformation).equals(other$detailedInformation)) {
            return false;
        }
        List<LanguageContent> this$briefInformation = this.getBriefInformation();
        List<LanguageContent> other$briefInformation = other.getBriefInformation();
        if (this$briefInformation == null ? other$briefInformation != null : !((Object)this$briefInformation).equals(other$briefInformation)) {
            return false;
        }
        String this$defaultRunMode = this.getDefaultRunMode();
        String other$defaultRunMode = other.getDefaultRunMode();
        if (this$defaultRunMode == null ? other$defaultRunMode != null : !this$defaultRunMode.equals(other$defaultRunMode)) {
            return false;
        }
        Either<String, MDLanguage> this$defaultLanguage = this.getDefaultLanguage();
        Either<String, MDLanguage> other$defaultLanguage = other.getDefaultLanguage();
        if (this$defaultLanguage == null ? other$defaultLanguage != null : !this$defaultLanguage.equals(other$defaultLanguage)) {
            return false;
        }
        DataLockControlMode this$dataLockControlMode = this.getDataLockControlMode();
        DataLockControlMode other$dataLockControlMode = other.getDataLockControlMode();
        if (this$dataLockControlMode == null ? other$dataLockControlMode != null : !this$dataLockControlMode.equals(other$dataLockControlMode)) {
            return false;
        }
        String this$objectAutonumerationMode = this.getObjectAutonumerationMode();
        String other$objectAutonumerationMode = other.getObjectAutonumerationMode();
        if (this$objectAutonumerationMode == null ? other$objectAutonumerationMode != null : !this$objectAutonumerationMode.equals(other$objectAutonumerationMode)) {
            return false;
        }
        List<Either<String, AbstractMDObjectBase>> this$children = this.getChildren();
        List<Either<String, AbstractMDObjectBase>> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        ConfigurationExtensionPurpose this$configurationExtensionPurpose = this.getConfigurationExtensionPurpose();
        ConfigurationExtensionPurpose other$configurationExtensionPurpose = other.getConfigurationExtensionPurpose();
        if (this$configurationExtensionPurpose == null ? other$configurationExtensionPurpose != null : !this$configurationExtensionPurpose.equals(other$configurationExtensionPurpose)) {
            return false;
        }
        String this$namePrefix = this.getNamePrefix();
        String other$namePrefix = other.getNamePrefix();
        return !(this$namePrefix == null ? other$namePrefix != null : !this$namePrefix.equals(other$namePrefix));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MDConfiguration;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUseManagedFormInOrdinaryApplication() ? 79 : 97);
        result = result * 59 + (this.isUseOrdinaryFormInManagedApplication() ? 79 : 97);
        ScriptVariant $scriptVariant = this.getScriptVariant();
        result = result * 59 + ($scriptVariant == null ? 43 : $scriptVariant.hashCode());
        CompatibilityMode $compatibilityMode = this.getCompatibilityMode();
        result = result * 59 + ($compatibilityMode == null ? 43 : $compatibilityMode.hashCode());
        CompatibilityMode $configurationExtensionCompatibilityMode = this.getConfigurationExtensionCompatibilityMode();
        result = result * 59 + ($configurationExtensionCompatibilityMode == null ? 43 : $configurationExtensionCompatibilityMode.hashCode());
        UseMode $modalityUseMode = this.getModalityUseMode();
        result = result * 59 + ($modalityUseMode == null ? 43 : $modalityUseMode.hashCode());
        UseMode $synchronousExtensionAndAddInCallUseMode = this.getSynchronousExtensionAndAddInCallUseMode();
        result = result * 59 + ($synchronousExtensionAndAddInCallUseMode == null ? 43 : $synchronousExtensionAndAddInCallUseMode.hashCode());
        UseMode $synchronousPlatformExtensionAndAddInCallUseMode = this.getSynchronousPlatformExtensionAndAddInCallUseMode();
        result = result * 59 + ($synchronousPlatformExtensionAndAddInCallUseMode == null ? 43 : $synchronousPlatformExtensionAndAddInCallUseMode.hashCode());
        List<LanguageContent> $copyrights = this.getCopyrights();
        result = result * 59 + ($copyrights == null ? 43 : ((Object)$copyrights).hashCode());
        List<LanguageContent> $detailedInformation = this.getDetailedInformation();
        result = result * 59 + ($detailedInformation == null ? 43 : ((Object)$detailedInformation).hashCode());
        List<LanguageContent> $briefInformation = this.getBriefInformation();
        result = result * 59 + ($briefInformation == null ? 43 : ((Object)$briefInformation).hashCode());
        String $defaultRunMode = this.getDefaultRunMode();
        result = result * 59 + ($defaultRunMode == null ? 43 : $defaultRunMode.hashCode());
        Either<String, MDLanguage> $defaultLanguage = this.getDefaultLanguage();
        result = result * 59 + ($defaultLanguage == null ? 43 : $defaultLanguage.hashCode());
        DataLockControlMode $dataLockControlMode = this.getDataLockControlMode();
        result = result * 59 + ($dataLockControlMode == null ? 43 : $dataLockControlMode.hashCode());
        String $objectAutonumerationMode = this.getObjectAutonumerationMode();
        result = result * 59 + ($objectAutonumerationMode == null ? 43 : $objectAutonumerationMode.hashCode());
        List<Either<String, AbstractMDObjectBase>> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        ConfigurationExtensionPurpose $configurationExtensionPurpose = this.getConfigurationExtensionPurpose();
        result = result * 59 + ($configurationExtensionPurpose == null ? 43 : $configurationExtensionPurpose.hashCode());
        String $namePrefix = this.getNamePrefix();
        result = result * 59 + ($namePrefix == null ? 43 : $namePrefix.hashCode());
        return result;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MDConfiguration(super=" + super.toString() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MDConfiguration() {
    }
}

