/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses.mdo;

import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDO;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBSL;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.MDOHasChildren;
import com.github._1c_syntax.mdclasses.mdo.attributes.AbstractMDOAttribute;
import com.github._1c_syntax.mdclasses.mdo.attributes.AccountingFlag;
import com.github._1c_syntax.mdclasses.mdo.attributes.AddressingAttribute;
import com.github._1c_syntax.mdclasses.mdo.attributes.Attribute;
import com.github._1c_syntax.mdclasses.mdo.attributes.Column;
import com.github._1c_syntax.mdclasses.mdo.attributes.Dimension;
import com.github._1c_syntax.mdclasses.mdo.attributes.ExtDimensionAccountingFlag;
import com.github._1c_syntax.mdclasses.mdo.attributes.Recalculation;
import com.github._1c_syntax.mdclasses.mdo.attributes.Resource;
import com.github._1c_syntax.mdclasses.mdo.attributes.TabularSection;
import com.github._1c_syntax.mdclasses.mdo.children.Command;
import com.github._1c_syntax.mdclasses.mdo.children.Form;
import com.github._1c_syntax.mdclasses.mdo.children.Template;
import com.github._1c_syntax.mdclasses.mdo.support.MDOReference;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerChildObjects;
import com.github._1c_syntax.mdclasses.unmarshal.wrapper.DesignerMDO;
import com.github._1c_syntax.mdclasses.utils.MDOFactory;
import com.github._1c_syntax.mdclasses.utils.MDOPathUtils;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractMDObjectComplex
extends AbstractMDObjectBSL
implements MDOHasChildren {
    @XStreamImplicit
    private List<Form> forms = Collections.emptyList();
    @XStreamImplicit
    private List<Template> templates = Collections.emptyList();
    @XStreamImplicit
    private List<Command> commands = Collections.emptyList();
    private Set<AbstractMDObjectBase> children;
    @XStreamImplicit
    private List<AbstractMDOAttribute> attributes = Collections.emptyList();

    protected AbstractMDObjectComplex(DesignerMDO designerMDO) {
        super(designerMDO);
        this.mdoReference = new MDOReference(this);
        MDOPathUtils.getMDOTypeFolderByMDOPath(ConfigurationSource.DESIGNER, designerMDO.getMdoPath()).ifPresent(mdoFolder -> {
            this.computeForms((Path)mdoFolder, designerMDO.getChildObjects().getForms());
            this.computeTemplates((Path)mdoFolder, designerMDO.getChildObjects().getTemplates());
            this.computeRecalculations((Path)mdoFolder, designerMDO.getChildObjects().getRecalculations());
        });
        this.computeCommands(designerMDO.getChildObjects().getCommands());
        this.computeChildren(designerMDO.getChildObjects());
    }

    @Override
    public Set<AbstractMDObjectBase> getChildren() {
        if (this.children == null) {
            this.children = new HashSet<AbstractMDObjectBase>();
            this.children.addAll(this.forms);
            this.children.addAll(this.commands);
            this.children.addAll(this.templates);
            this.children.addAll(this.attributes);
            this.attributes.stream().filter(MDOHasChildren.class::isInstance).map(MDOHasChildren.class::cast).forEach(mdo -> this.children.addAll(mdo.getChildren()));
        }
        return Collections.unmodifiableSet(this.children);
    }

    private void computeForms(Path folder, List<String> formNames) {
        MDOPathUtils.getChildrenFolder(this.getName(), folder, MDOType.FORM).ifPresent(childrenFolder -> this.setForms(AbstractMDObjectComplex.readDesignerMDOChildren(childrenFolder, Form.class, formNames)));
    }

    private void computeTemplates(Path folder, List<String> templateNames) {
        MDOPathUtils.getChildrenFolder(this.getName(), folder, MDOType.TEMPLATE).ifPresent(childrenFolder -> this.setTemplates(AbstractMDObjectComplex.readDesignerMDOChildren(childrenFolder, Template.class, templateNames)));
    }

    private void computeCommands(List<DesignerMDO> commandsDesigner) {
        ArrayList<Command> computedCommands = new ArrayList<Command>();
        commandsDesigner.forEach(designerMDO -> computedCommands.add(new Command((DesignerMDO)designerMDO)));
        this.setCommands(computedCommands);
    }

    private void computeRecalculations(Path folder, List<String> recalculationNames) {
        MDOPathUtils.getChildrenFolder(this.getName(), folder, MDOType.RECALCULATION).ifPresent(childrenFolder -> {
            List<Recalculation> recalculations = AbstractMDObjectComplex.readDesignerMDOChildren(childrenFolder, Recalculation.class, recalculationNames);
            this.setAttributes(recalculations.stream().map(AbstractMDOAttribute.class::cast).collect(Collectors.toList()));
        });
    }

    private void computeChildren(DesignerChildObjects childObjects) {
        ArrayList<AbstractMDOAttribute> computedAttributes = new ArrayList<AbstractMDOAttribute>(this.getAttributes());
        childObjects.getAccountingFlags().forEach(designerMDO -> computedAttributes.add(new AccountingFlag((DesignerMDO)designerMDO)));
        childObjects.getAddressingAttributes().forEach(designerMDO -> computedAttributes.add(new AddressingAttribute((DesignerMDO)designerMDO)));
        childObjects.getAttributes().forEach(designerMDO -> computedAttributes.add(new Attribute((DesignerMDO)designerMDO)));
        childObjects.getColumns().forEach(designerMDO -> computedAttributes.add(new Column((DesignerMDO)designerMDO)));
        childObjects.getDimensions().forEach(designerMDO -> computedAttributes.add(new Dimension((DesignerMDO)designerMDO)));
        childObjects.getExtDimensionAccountingFlags().forEach(designerMDO -> computedAttributes.add(new ExtDimensionAccountingFlag((DesignerMDO)designerMDO)));
        childObjects.getResources().forEach(designerMDO -> computedAttributes.add(new Resource((DesignerMDO)designerMDO)));
        childObjects.getTabularSections().forEach(designerMDO -> computedAttributes.add(new TabularSection((DesignerMDO)designerMDO)));
        this.setAttributes(computedAttributes);
    }

    private static <T extends AbstractMDO> List<T> readDesignerMDOChildren(Path childrenFolder, Class<T> childClass, List<String> childNames) {
        ArrayList children = new ArrayList();
        AbstractMDObjectComplex.getMDOFilesInFolder(childrenFolder, childNames).forEach(mdoFile -> {
            AbstractMDObjectBase child = MDOFactory.readMDO(mdoFile);
            if (child != null) {
                children.add((AbstractMDO)childClass.cast(child));
            }
        });
        return children;
    }

    @Override
    public void supplement() {
        super.supplement();
        this.forms.stream().filter(child -> child.getPath() == null).forEach(child -> child.setPath(this.path));
        this.forms.forEach(child -> child.supplement(this));
        this.templates.stream().filter(child -> child.getPath() == null).forEach(child -> child.setPath(this.path));
        this.templates.forEach(child -> child.supplement(this));
        this.commands.stream().filter(child -> child.getPath() == null).forEach(child -> child.setPath(this.path));
        this.commands.forEach(child -> child.supplement(this));
        this.attributes.forEach(child -> child.supplement(this));
    }

    private static List<Path> getMDOFilesInFolder(Path folder, List<String> childNames) {
        List<Path> childrenNames;
        int maxDepth = 1;
        AtomicReference<String> extension = new AtomicReference<String>(MDOPathUtils.mdoExtension(ConfigurationSource.DESIGNER, true));
        try (Stream<Path> files = Files.walk(folder, maxDepth, new FileVisitOption[0]);){
            childrenNames = ((Stream)files.parallel()).filter(path -> path.toString().endsWith((String)extension.get())).filter(path -> childNames.contains(FilenameUtils.getBaseName((String)path.toString()))).collect(Collectors.toList());
        }
        return childrenNames;
    }

    public void addAttribute(AbstractMDOAttribute attribute) {
        ArrayList<AbstractMDOAttribute> computedAttributes = new ArrayList<AbstractMDOAttribute>(this.getAttributes());
        computedAttributes.add(attribute);
        this.setAttributes(computedAttributes);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Form> getForms() {
        return this.forms;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Template> getTemplates() {
        return this.templates;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Command> getCommands() {
        return this.commands;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<AbstractMDOAttribute> getAttributes() {
        return this.attributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setForms(List<Form> forms) {
        this.forms = forms;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTemplates(List<Template> templates) {
        this.templates = templates;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCommands(List<Command> commands) {
        this.commands = commands;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChildren(Set<AbstractMDObjectBase> children) {
        this.children = children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAttributes(List<AbstractMDOAttribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMDObjectComplex)) {
            return false;
        }
        AbstractMDObjectComplex other = (AbstractMDObjectComplex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Form> this$forms = this.getForms();
        List<Form> other$forms = other.getForms();
        if (this$forms == null ? other$forms != null : !((Object)this$forms).equals(other$forms)) {
            return false;
        }
        List<Template> this$templates = this.getTemplates();
        List<Template> other$templates = other.getTemplates();
        if (this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates)) {
            return false;
        }
        List<Command> this$commands = this.getCommands();
        List<Command> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        Set<AbstractMDObjectBase> this$children = this.getChildren();
        Set<AbstractMDObjectBase> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List<AbstractMDOAttribute> this$attributes = this.getAttributes();
        List<AbstractMDOAttribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractMDObjectComplex;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Form> $forms = this.getForms();
        result = result * 59 + ($forms == null ? 43 : ((Object)$forms).hashCode());
        List<Template> $templates = this.getTemplates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        List<Command> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        Set<AbstractMDObjectBase> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List<AbstractMDOAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AbstractMDObjectComplex(super=" + super.toString() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractMDObjectComplex() {
    }
}

