/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.mdclasses;

import com.github._1c_syntax.mdclasses.ConfigurationExtension;
import com.github._1c_syntax.mdclasses.common.CompatibilityMode;
import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBSL;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.MDCommonModule;
import com.github._1c_syntax.mdclasses.mdo.MDConfiguration;
import com.github._1c_syntax.mdclasses.mdo.MDLanguage;
import com.github._1c_syntax.mdclasses.mdo.MDOHasChildren;
import com.github._1c_syntax.mdclasses.mdo.MDRole;
import com.github._1c_syntax.mdclasses.mdo.support.ApplicationRunMode;
import com.github._1c_syntax.mdclasses.mdo.support.DataLockControlMode;
import com.github._1c_syntax.mdclasses.mdo.support.LanguageContent;
import com.github._1c_syntax.mdclasses.mdo.support.MDOModule;
import com.github._1c_syntax.mdclasses.mdo.support.MDOReference;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.support.ObjectBelonging;
import com.github._1c_syntax.mdclasses.mdo.support.ScriptVariant;
import com.github._1c_syntax.mdclasses.mdo.support.UseMode;
import com.github._1c_syntax.mdclasses.supportconf.ParseSupportData;
import com.github._1c_syntax.mdclasses.supportconf.SupportConfiguration;
import com.github._1c_syntax.mdclasses.supportconf.SupportVariant;
import com.github._1c_syntax.mdclasses.utils.MDOFactory;
import com.github._1c_syntax.mdclasses.utils.MDOPathUtils;
import com.github._1c_syntax.mdclasses.utils.MDOUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vavr.control.Either;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private String name;
    private String uuid;
    private ConfigurationSource configurationSource;
    private CompatibilityMode compatibilityMode;
    private CompatibilityMode configurationExtensionCompatibilityMode;
    private ScriptVariant scriptVariant;
    private ApplicationRunMode defaultRunMode;
    private MDLanguage defaultLanguage;
    private DataLockControlMode dataLockControlMode;
    private String objectAutonumerationMode;
    private UseMode modalityUseMode;
    private UseMode synchronousExtensionAndAddInCallUseMode;
    private UseMode synchronousPlatformExtensionAndAddInCallUseMode;
    private boolean useManagedFormInOrdinaryApplication;
    private boolean useOrdinaryFormInManagedApplication;
    private List<LanguageContent> copyrights;
    private List<LanguageContent> detailedInformation;
    private List<LanguageContent> briefInformation;
    private Map<URI, ModuleType> modulesByType;
    private Map<String, Map<ModuleType, URI>> modulesByMDORef;
    private Map<URI, AbstractMDObjectBSL> modulesByObject;
    private List<MDOModule> modules;
    private Map<URI, Map<SupportConfiguration, SupportVariant>> modulesBySupport;
    private Set<AbstractMDObjectBase> children;
    private Map<MDOReference, AbstractMDObjectBase> childrenByMdoRef;
    private Map<String, MDCommonModule> commonModules;
    private Map<String, MDLanguage> languages;
    private Path rootPath;
    private List<MDRole> roles;

    protected Configuration() {
        this.configurationSource = ConfigurationSource.EMPTY;
        this.children = Collections.emptySet();
        this.childrenByMdoRef = Collections.emptyMap();
        this.modulesByType = Collections.emptyMap();
        this.modulesBySupport = Collections.emptyMap();
        this.modulesByObject = Collections.emptyMap();
        this.modules = Collections.emptyList();
        this.commonModules = Collections.emptyMap();
        this.languages = Collections.emptyMap();
        this.modulesByMDORef = Collections.emptyMap();
        this.roles = Collections.emptyList();
        this.copyrights = Collections.emptyList();
        this.detailedInformation = Collections.emptyList();
        this.briefInformation = Collections.emptyList();
        this.rootPath = null;
        this.name = "";
        this.uuid = "";
        this.compatibilityMode = new CompatibilityMode();
        this.configurationExtensionCompatibilityMode = new CompatibilityMode();
        this.scriptVariant = ScriptVariant.ENGLISH;
        this.defaultRunMode = ApplicationRunMode.MANAGED_APPLICATION;
        this.defaultLanguage = MDOFactory.fakeLanguage(this.scriptVariant);
        this.dataLockControlMode = DataLockControlMode.AUTOMATIC;
        this.objectAutonumerationMode = "";
        this.modalityUseMode = UseMode.USE;
        this.synchronousExtensionAndAddInCallUseMode = UseMode.USE;
        this.synchronousPlatformExtensionAndAddInCallUseMode = UseMode.USE;
    }

    protected Configuration(MDConfiguration mdoConfiguration, ConfigurationSource source, Path path) {
        this.configurationSource = source;
        this.children = Configuration.getAllChildren(mdoConfiguration);
        this.childrenByMdoRef = new HashMap<MDOReference, AbstractMDObjectBase>();
        this.commonModules = new CaseInsensitiveMap();
        this.languages = new HashMap<String, MDLanguage>();
        this.roles = new ArrayList<MDRole>();
        this.children.forEach(mdo -> {
            this.childrenByMdoRef.put(mdo.getMdoReference(), (AbstractMDObjectBase)mdo);
            if (mdo instanceof MDCommonModule) {
                this.commonModules.put(mdo.getName(), (MDCommonModule)mdo);
            } else if (mdo instanceof MDLanguage) {
                this.languages.put(((MDLanguage)mdo).getLanguageCode(), (MDLanguage)mdo);
            } else if (mdo instanceof MDRole) {
                this.roles.add((MDRole)mdo);
            }
        });
        this.rootPath = path;
        this.name = mdoConfiguration.getName();
        this.uuid = mdoConfiguration.getUuid();
        this.configurationExtensionCompatibilityMode = mdoConfiguration.getConfigurationExtensionCompatibilityMode();
        this.compatibilityMode = CompatibilityMode.compareTo(mdoConfiguration.getCompatibilityMode(), "") == 0 ? mdoConfiguration.getConfigurationExtensionCompatibilityMode() : mdoConfiguration.getCompatibilityMode();
        this.scriptVariant = mdoConfiguration.getScriptVariant();
        this.defaultRunMode = ApplicationRunMode.getByName(mdoConfiguration.getDefaultRunMode());
        this.defaultLanguage = mdoConfiguration.getDefaultLanguage().isRight() ? (MDLanguage)mdoConfiguration.getDefaultLanguage().get() : MDOFactory.fakeLanguage(this.scriptVariant);
        this.dataLockControlMode = mdoConfiguration.getDataLockControlMode();
        this.objectAutonumerationMode = mdoConfiguration.getObjectAutonumerationMode();
        this.modalityUseMode = mdoConfiguration.getModalityUseMode();
        this.synchronousExtensionAndAddInCallUseMode = mdoConfiguration.getSynchronousExtensionAndAddInCallUseMode();
        this.synchronousPlatformExtensionAndAddInCallUseMode = mdoConfiguration.getSynchronousPlatformExtensionAndAddInCallUseMode();
        this.useManagedFormInOrdinaryApplication = mdoConfiguration.isUseManagedFormInOrdinaryApplication();
        this.useOrdinaryFormInManagedApplication = mdoConfiguration.isUseOrdinaryFormInManagedApplication();
        this.copyrights = mdoConfiguration.getCopyrights();
        this.briefInformation = mdoConfiguration.getBriefInformation();
        this.detailedInformation = mdoConfiguration.getDetailedInformation();
        HashMap<URI, ModuleType> modulesType = new HashMap<URI, ModuleType>();
        HashMap<URI, Map<SupportConfiguration, SupportVariant>> modulesSupport = new HashMap<URI, Map<SupportConfiguration, SupportVariant>>();
        HashMap<URI, AbstractMDObjectBSL> modulesObject = new HashMap<URI, AbstractMDObjectBSL>();
        CaseInsensitiveMap modulesMDORef = new CaseInsensitiveMap();
        ArrayList<MDOModule> modulesList = new ArrayList<MDOModule>();
        Map<String, Map<SupportConfiguration, SupportVariant>> supportMap = this.getSupportMap();
        this.children.forEach(arg_0 -> Configuration.lambda$new$1(supportMap, modulesType, modulesSupport, modulesObject, modulesList, (Map)modulesMDORef, arg_0));
        this.modulesBySupport = modulesSupport;
        this.modulesByType = modulesType;
        this.modulesByObject = modulesObject;
        this.modules = modulesList;
        this.modulesByMDORef = modulesMDORef;
    }

    public static Configuration create() {
        return new Configuration();
    }

    public static Configuration createExtension() {
        return new ConfigurationExtension();
    }

    public static Configuration create(Path rootPath) {
        Optional<AbstractMDObjectBase> configurationMDO;
        ConfigurationSource configurationSource = MDOUtils.getConfigurationSourceByPath(rootPath);
        if (configurationSource != ConfigurationSource.EMPTY && (configurationMDO = MDOFactory.readMDOConfiguration(configurationSource, rootPath)).isPresent()) {
            MDConfiguration mdoConfiguration = (MDConfiguration)configurationMDO.get();
            if (mdoConfiguration.getObjectBelonging() == ObjectBelonging.ADOPTED) {
                return new ConfigurationExtension(mdoConfiguration, configurationSource, rootPath);
            }
            return new Configuration(mdoConfiguration, configurationSource, rootPath);
        }
        return Configuration.create();
    }

    public Optional<Path> getRootPath() {
        if (this.rootPath == null) {
            return Optional.empty();
        }
        return Optional.of(this.rootPath);
    }

    public ModuleType getModuleType(URI uri) {
        return this.modulesByType.getOrDefault(uri, ModuleType.UNKNOWN);
    }

    public Map<SupportConfiguration, SupportVariant> getModuleSupport(URI uri) {
        return this.modulesBySupport.getOrDefault(uri, new HashMap());
    }

    public Optional<MDCommonModule> getCommonModule(String name) {
        return Optional.ofNullable(this.commonModules.get(name));
    }

    public Map<ModuleType, URI> getModulesByMDORef(String mdoRef) {
        return this.modulesByMDORef.getOrDefault(mdoRef, Collections.emptyMap());
    }

    public Map<ModuleType, URI> getModulesByMDORef(MDOReference mdoRef) {
        return this.getModulesByMDORef(mdoRef.getMdoRef());
    }

    private Map<String, Map<SupportConfiguration, SupportVariant>> getSupportMap() {
        Optional<Path> fileParentConfiguration = MDOPathUtils.getParentConfigurationsPath(this.configurationSource, this.rootPath);
        if (fileParentConfiguration.isPresent() && fileParentConfiguration.get().toFile().exists()) {
            ParseSupportData supportData = new ParseSupportData(fileParentConfiguration.get());
            return supportData.getSupportMap();
        }
        return Collections.emptyMap();
    }

    private static void computeModules(Map<URI, ModuleType> modulesType, Map<URI, Map<SupportConfiguration, SupportVariant>> modulesSupport, Map<URI, AbstractMDObjectBSL> modulesObject, List<MDOModule> modulesList, Map<String, Map<ModuleType, URI>> modulesMDORef, AbstractMDObjectBSL mdo, Map<SupportConfiguration, SupportVariant> supports) {
        EnumMap modulesTypesAndURIs = new EnumMap(ModuleType.class);
        mdo.getModules().forEach(module -> {
            URI uri = module.getUri();
            modulesType.put(uri, module.getModuleType());
            modulesTypesAndURIs.put(module.getModuleType(), uri);
            modulesObject.put(uri, mdo);
            if (!supports.isEmpty()) {
                modulesSupport.put(uri, supports);
            }
            modulesList.add((MDOModule)module);
        });
        modulesMDORef.put(mdo.getMdoReference().getMdoRef(), modulesTypesAndURIs);
    }

    private static Set<AbstractMDObjectBase> getAllChildren(MDConfiguration mdoConfiguration) {
        Set<AbstractMDObjectBase> allChildren = mdoConfiguration.getChildren().stream().filter(Either::isRight).map(Either::get).collect(Collectors.toSet());
        allChildren.addAll(allChildren.stream().filter(MDOHasChildren.class::isInstance).map(MDOHasChildren.class::cast).map(MDOHasChildren::getChildren).flatMap(Collection::stream).collect(Collectors.toSet()));
        allChildren.add(mdoConfiguration);
        return allChildren;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompatibilityMode getCompatibilityMode() {
        return this.compatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompatibilityMode getConfigurationExtensionCompatibilityMode() {
        return this.configurationExtensionCompatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScriptVariant getScriptVariant() {
        return this.scriptVariant;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ApplicationRunMode getDefaultRunMode() {
        return this.defaultRunMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MDLanguage getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DataLockControlMode getDataLockControlMode() {
        return this.dataLockControlMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getObjectAutonumerationMode() {
        return this.objectAutonumerationMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UseMode getModalityUseMode() {
        return this.modalityUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UseMode getSynchronousExtensionAndAddInCallUseMode() {
        return this.synchronousExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UseMode getSynchronousPlatformExtensionAndAddInCallUseMode() {
        return this.synchronousPlatformExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseManagedFormInOrdinaryApplication() {
        return this.useManagedFormInOrdinaryApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseOrdinaryFormInManagedApplication() {
        return this.useOrdinaryFormInManagedApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LanguageContent> getCopyrights() {
        return this.copyrights;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LanguageContent> getDetailedInformation() {
        return this.detailedInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LanguageContent> getBriefInformation() {
        return this.briefInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<URI, ModuleType> getModulesByType() {
        return this.modulesByType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Map<ModuleType, URI>> getModulesByMDORef() {
        return this.modulesByMDORef;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<URI, AbstractMDObjectBSL> getModulesByObject() {
        return this.modulesByObject;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<MDOModule> getModules() {
        return this.modules;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<URI, Map<SupportConfiguration, SupportVariant>> getModulesBySupport() {
        return this.modulesBySupport;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<AbstractMDObjectBase> getChildren() {
        return this.children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<MDOReference, AbstractMDObjectBase> getChildrenByMdoRef() {
        return this.childrenByMdoRef;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, MDCommonModule> getCommonModules() {
        return this.commonModules;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, MDLanguage> getLanguages() {
        return this.languages;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<MDRole> getRoles() {
        return this.roles;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationSource(ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCompatibilityMode(CompatibilityMode compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationExtensionCompatibilityMode(CompatibilityMode configurationExtensionCompatibilityMode) {
        this.configurationExtensionCompatibilityMode = configurationExtensionCompatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setScriptVariant(ScriptVariant scriptVariant) {
        this.scriptVariant = scriptVariant;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDefaultRunMode(ApplicationRunMode defaultRunMode) {
        this.defaultRunMode = defaultRunMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDefaultLanguage(MDLanguage defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDataLockControlMode(DataLockControlMode dataLockControlMode) {
        this.dataLockControlMode = dataLockControlMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setObjectAutonumerationMode(String objectAutonumerationMode) {
        this.objectAutonumerationMode = objectAutonumerationMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModalityUseMode(UseMode modalityUseMode) {
        this.modalityUseMode = modalityUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSynchronousExtensionAndAddInCallUseMode(UseMode synchronousExtensionAndAddInCallUseMode) {
        this.synchronousExtensionAndAddInCallUseMode = synchronousExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSynchronousPlatformExtensionAndAddInCallUseMode(UseMode synchronousPlatformExtensionAndAddInCallUseMode) {
        this.synchronousPlatformExtensionAndAddInCallUseMode = synchronousPlatformExtensionAndAddInCallUseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUseManagedFormInOrdinaryApplication(boolean useManagedFormInOrdinaryApplication) {
        this.useManagedFormInOrdinaryApplication = useManagedFormInOrdinaryApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUseOrdinaryFormInManagedApplication(boolean useOrdinaryFormInManagedApplication) {
        this.useOrdinaryFormInManagedApplication = useOrdinaryFormInManagedApplication;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCopyrights(List<LanguageContent> copyrights) {
        this.copyrights = copyrights;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDetailedInformation(List<LanguageContent> detailedInformation) {
        this.detailedInformation = detailedInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBriefInformation(List<LanguageContent> briefInformation) {
        this.briefInformation = briefInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModulesByType(Map<URI, ModuleType> modulesByType) {
        this.modulesByType = modulesByType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModulesByMDORef(Map<String, Map<ModuleType, URI>> modulesByMDORef) {
        this.modulesByMDORef = modulesByMDORef;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModulesByObject(Map<URI, AbstractMDObjectBSL> modulesByObject) {
        this.modulesByObject = modulesByObject;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModules(List<MDOModule> modules) {
        this.modules = modules;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setModulesBySupport(Map<URI, Map<SupportConfiguration, SupportVariant>> modulesBySupport) {
        this.modulesBySupport = modulesBySupport;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChildren(Set<AbstractMDObjectBase> children) {
        this.children = children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChildrenByMdoRef(Map<MDOReference, AbstractMDObjectBase> childrenByMdoRef) {
        this.childrenByMdoRef = childrenByMdoRef;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCommonModules(Map<String, MDCommonModule> commonModules) {
        this.commonModules = commonModules;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLanguages(Map<String, MDLanguage> languages) {
        this.languages = languages;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRootPath(Path rootPath) {
        this.rootPath = rootPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRoles(List<MDRole> roles) {
        this.roles = roles;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseManagedFormInOrdinaryApplication() != other.isUseManagedFormInOrdinaryApplication()) {
            return false;
        }
        if (this.isUseOrdinaryFormInManagedApplication() != other.isUseOrdinaryFormInManagedApplication()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        ConfigurationSource this$configurationSource = this.getConfigurationSource();
        ConfigurationSource other$configurationSource = other.getConfigurationSource();
        if (this$configurationSource == null ? other$configurationSource != null : !((Object)((Object)this$configurationSource)).equals((Object)other$configurationSource)) {
            return false;
        }
        CompatibilityMode this$compatibilityMode = this.getCompatibilityMode();
        CompatibilityMode other$compatibilityMode = other.getCompatibilityMode();
        if (this$compatibilityMode == null ? other$compatibilityMode != null : !this$compatibilityMode.equals(other$compatibilityMode)) {
            return false;
        }
        CompatibilityMode this$configurationExtensionCompatibilityMode = this.getConfigurationExtensionCompatibilityMode();
        CompatibilityMode other$configurationExtensionCompatibilityMode = other.getConfigurationExtensionCompatibilityMode();
        if (this$configurationExtensionCompatibilityMode == null ? other$configurationExtensionCompatibilityMode != null : !this$configurationExtensionCompatibilityMode.equals(other$configurationExtensionCompatibilityMode)) {
            return false;
        }
        ScriptVariant this$scriptVariant = this.getScriptVariant();
        ScriptVariant other$scriptVariant = other.getScriptVariant();
        if (this$scriptVariant == null ? other$scriptVariant != null : !this$scriptVariant.equals(other$scriptVariant)) {
            return false;
        }
        ApplicationRunMode this$defaultRunMode = this.getDefaultRunMode();
        ApplicationRunMode other$defaultRunMode = other.getDefaultRunMode();
        if (this$defaultRunMode == null ? other$defaultRunMode != null : !((Object)((Object)this$defaultRunMode)).equals((Object)other$defaultRunMode)) {
            return false;
        }
        MDLanguage this$defaultLanguage = this.getDefaultLanguage();
        MDLanguage other$defaultLanguage = other.getDefaultLanguage();
        if (this$defaultLanguage == null ? other$defaultLanguage != null : !((Object)this$defaultLanguage).equals(other$defaultLanguage)) {
            return false;
        }
        DataLockControlMode this$dataLockControlMode = this.getDataLockControlMode();
        DataLockControlMode other$dataLockControlMode = other.getDataLockControlMode();
        if (this$dataLockControlMode == null ? other$dataLockControlMode != null : !this$dataLockControlMode.equals(other$dataLockControlMode)) {
            return false;
        }
        String this$objectAutonumerationMode = this.getObjectAutonumerationMode();
        String other$objectAutonumerationMode = other.getObjectAutonumerationMode();
        if (this$objectAutonumerationMode == null ? other$objectAutonumerationMode != null : !this$objectAutonumerationMode.equals(other$objectAutonumerationMode)) {
            return false;
        }
        UseMode this$modalityUseMode = this.getModalityUseMode();
        UseMode other$modalityUseMode = other.getModalityUseMode();
        if (this$modalityUseMode == null ? other$modalityUseMode != null : !this$modalityUseMode.equals(other$modalityUseMode)) {
            return false;
        }
        UseMode this$synchronousExtensionAndAddInCallUseMode = this.getSynchronousExtensionAndAddInCallUseMode();
        UseMode other$synchronousExtensionAndAddInCallUseMode = other.getSynchronousExtensionAndAddInCallUseMode();
        if (this$synchronousExtensionAndAddInCallUseMode == null ? other$synchronousExtensionAndAddInCallUseMode != null : !this$synchronousExtensionAndAddInCallUseMode.equals(other$synchronousExtensionAndAddInCallUseMode)) {
            return false;
        }
        UseMode this$synchronousPlatformExtensionAndAddInCallUseMode = this.getSynchronousPlatformExtensionAndAddInCallUseMode();
        UseMode other$synchronousPlatformExtensionAndAddInCallUseMode = other.getSynchronousPlatformExtensionAndAddInCallUseMode();
        if (this$synchronousPlatformExtensionAndAddInCallUseMode == null ? other$synchronousPlatformExtensionAndAddInCallUseMode != null : !this$synchronousPlatformExtensionAndAddInCallUseMode.equals(other$synchronousPlatformExtensionAndAddInCallUseMode)) {
            return false;
        }
        List<LanguageContent> this$copyrights = this.getCopyrights();
        List<LanguageContent> other$copyrights = other.getCopyrights();
        if (this$copyrights == null ? other$copyrights != null : !((Object)this$copyrights).equals(other$copyrights)) {
            return false;
        }
        List<LanguageContent> this$detailedInformation = this.getDetailedInformation();
        List<LanguageContent> other$detailedInformation = other.getDetailedInformation();
        if (this$detailedInformation == null ? other$detailedInformation != null : !((Object)this$detailedInformation).equals(other$detailedInformation)) {
            return false;
        }
        List<LanguageContent> this$briefInformation = this.getBriefInformation();
        List<LanguageContent> other$briefInformation = other.getBriefInformation();
        if (this$briefInformation == null ? other$briefInformation != null : !((Object)this$briefInformation).equals(other$briefInformation)) {
            return false;
        }
        Map<URI, ModuleType> this$modulesByType = this.getModulesByType();
        Map<URI, ModuleType> other$modulesByType = other.getModulesByType();
        if (this$modulesByType == null ? other$modulesByType != null : !((Object)this$modulesByType).equals(other$modulesByType)) {
            return false;
        }
        Map<String, Map<ModuleType, URI>> this$modulesByMDORef = this.getModulesByMDORef();
        Map<String, Map<ModuleType, URI>> other$modulesByMDORef = other.getModulesByMDORef();
        if (this$modulesByMDORef == null ? other$modulesByMDORef != null : !((Object)this$modulesByMDORef).equals(other$modulesByMDORef)) {
            return false;
        }
        Map<URI, AbstractMDObjectBSL> this$modulesByObject = this.getModulesByObject();
        Map<URI, AbstractMDObjectBSL> other$modulesByObject = other.getModulesByObject();
        if (this$modulesByObject == null ? other$modulesByObject != null : !((Object)this$modulesByObject).equals(other$modulesByObject)) {
            return false;
        }
        List<MDOModule> this$modules = this.getModules();
        List<MDOModule> other$modules = other.getModules();
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        Map<URI, Map<SupportConfiguration, SupportVariant>> this$modulesBySupport = this.getModulesBySupport();
        Map<URI, Map<SupportConfiguration, SupportVariant>> other$modulesBySupport = other.getModulesBySupport();
        if (this$modulesBySupport == null ? other$modulesBySupport != null : !((Object)this$modulesBySupport).equals(other$modulesBySupport)) {
            return false;
        }
        Set<AbstractMDObjectBase> this$children = this.getChildren();
        Set<AbstractMDObjectBase> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        Map<MDOReference, AbstractMDObjectBase> this$childrenByMdoRef = this.getChildrenByMdoRef();
        Map<MDOReference, AbstractMDObjectBase> other$childrenByMdoRef = other.getChildrenByMdoRef();
        if (this$childrenByMdoRef == null ? other$childrenByMdoRef != null : !((Object)this$childrenByMdoRef).equals(other$childrenByMdoRef)) {
            return false;
        }
        Map<String, MDCommonModule> this$commonModules = this.getCommonModules();
        Map<String, MDCommonModule> other$commonModules = other.getCommonModules();
        if (this$commonModules == null ? other$commonModules != null : !((Object)this$commonModules).equals(other$commonModules)) {
            return false;
        }
        Map<String, MDLanguage> this$languages = this.getLanguages();
        Map<String, MDLanguage> other$languages = other.getLanguages();
        if (this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages)) {
            return false;
        }
        Optional<Path> this$rootPath = this.getRootPath();
        Optional<Path> other$rootPath = other.getRootPath();
        if (this$rootPath == null ? other$rootPath != null : !((Object)this$rootPath).equals(other$rootPath)) {
            return false;
        }
        List<MDRole> this$roles = this.getRoles();
        List<MDRole> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseManagedFormInOrdinaryApplication() ? 79 : 97);
        result = result * 59 + (this.isUseOrdinaryFormInManagedApplication() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        ConfigurationSource $configurationSource = this.getConfigurationSource();
        result = result * 59 + ($configurationSource == null ? 43 : ((Object)((Object)$configurationSource)).hashCode());
        CompatibilityMode $compatibilityMode = this.getCompatibilityMode();
        result = result * 59 + ($compatibilityMode == null ? 43 : $compatibilityMode.hashCode());
        CompatibilityMode $configurationExtensionCompatibilityMode = this.getConfigurationExtensionCompatibilityMode();
        result = result * 59 + ($configurationExtensionCompatibilityMode == null ? 43 : $configurationExtensionCompatibilityMode.hashCode());
        ScriptVariant $scriptVariant = this.getScriptVariant();
        result = result * 59 + ($scriptVariant == null ? 43 : $scriptVariant.hashCode());
        ApplicationRunMode $defaultRunMode = this.getDefaultRunMode();
        result = result * 59 + ($defaultRunMode == null ? 43 : ((Object)((Object)$defaultRunMode)).hashCode());
        MDLanguage $defaultLanguage = this.getDefaultLanguage();
        result = result * 59 + ($defaultLanguage == null ? 43 : ((Object)$defaultLanguage).hashCode());
        DataLockControlMode $dataLockControlMode = this.getDataLockControlMode();
        result = result * 59 + ($dataLockControlMode == null ? 43 : $dataLockControlMode.hashCode());
        String $objectAutonumerationMode = this.getObjectAutonumerationMode();
        result = result * 59 + ($objectAutonumerationMode == null ? 43 : $objectAutonumerationMode.hashCode());
        UseMode $modalityUseMode = this.getModalityUseMode();
        result = result * 59 + ($modalityUseMode == null ? 43 : $modalityUseMode.hashCode());
        UseMode $synchronousExtensionAndAddInCallUseMode = this.getSynchronousExtensionAndAddInCallUseMode();
        result = result * 59 + ($synchronousExtensionAndAddInCallUseMode == null ? 43 : $synchronousExtensionAndAddInCallUseMode.hashCode());
        UseMode $synchronousPlatformExtensionAndAddInCallUseMode = this.getSynchronousPlatformExtensionAndAddInCallUseMode();
        result = result * 59 + ($synchronousPlatformExtensionAndAddInCallUseMode == null ? 43 : $synchronousPlatformExtensionAndAddInCallUseMode.hashCode());
        List<LanguageContent> $copyrights = this.getCopyrights();
        result = result * 59 + ($copyrights == null ? 43 : ((Object)$copyrights).hashCode());
        List<LanguageContent> $detailedInformation = this.getDetailedInformation();
        result = result * 59 + ($detailedInformation == null ? 43 : ((Object)$detailedInformation).hashCode());
        List<LanguageContent> $briefInformation = this.getBriefInformation();
        result = result * 59 + ($briefInformation == null ? 43 : ((Object)$briefInformation).hashCode());
        Map<URI, ModuleType> $modulesByType = this.getModulesByType();
        result = result * 59 + ($modulesByType == null ? 43 : ((Object)$modulesByType).hashCode());
        Map<String, Map<ModuleType, URI>> $modulesByMDORef = this.getModulesByMDORef();
        result = result * 59 + ($modulesByMDORef == null ? 43 : ((Object)$modulesByMDORef).hashCode());
        Map<URI, AbstractMDObjectBSL> $modulesByObject = this.getModulesByObject();
        result = result * 59 + ($modulesByObject == null ? 43 : ((Object)$modulesByObject).hashCode());
        List<MDOModule> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        Map<URI, Map<SupportConfiguration, SupportVariant>> $modulesBySupport = this.getModulesBySupport();
        result = result * 59 + ($modulesBySupport == null ? 43 : ((Object)$modulesBySupport).hashCode());
        Set<AbstractMDObjectBase> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        Map<MDOReference, AbstractMDObjectBase> $childrenByMdoRef = this.getChildrenByMdoRef();
        result = result * 59 + ($childrenByMdoRef == null ? 43 : ((Object)$childrenByMdoRef).hashCode());
        Map<String, MDCommonModule> $commonModules = this.getCommonModules();
        result = result * 59 + ($commonModules == null ? 43 : ((Object)$commonModules).hashCode());
        Map<String, MDLanguage> $languages = this.getLanguages();
        result = result * 59 + ($languages == null ? 43 : ((Object)$languages).hashCode());
        Optional<Path> $rootPath = this.getRootPath();
        result = result * 59 + ($rootPath == null ? 43 : ((Object)$rootPath).hashCode());
        List<MDRole> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Configuration(name=" + this.getName() + ", uuid=" + this.getUuid() + ", configurationSource=" + this.getConfigurationSource() + ", compatibilityMode=" + this.getCompatibilityMode() + ", configurationExtensionCompatibilityMode=" + this.getConfigurationExtensionCompatibilityMode() + ", scriptVariant=" + this.getScriptVariant() + ", defaultRunMode=" + this.getDefaultRunMode() + ", defaultLanguage=" + this.getDefaultLanguage() + ", dataLockControlMode=" + this.getDataLockControlMode() + ", objectAutonumerationMode=" + this.getObjectAutonumerationMode() + ", modalityUseMode=" + this.getModalityUseMode() + ", synchronousExtensionAndAddInCallUseMode=" + this.getSynchronousExtensionAndAddInCallUseMode() + ", synchronousPlatformExtensionAndAddInCallUseMode=" + this.getSynchronousPlatformExtensionAndAddInCallUseMode() + ", useManagedFormInOrdinaryApplication=" + this.isUseManagedFormInOrdinaryApplication() + ", useOrdinaryFormInManagedApplication=" + this.isUseOrdinaryFormInManagedApplication() + ", copyrights=" + this.getCopyrights() + ", detailedInformation=" + this.getDetailedInformation() + ", briefInformation=" + this.getBriefInformation() + ", modulesByType=" + this.getModulesByType() + ", modulesByMDORef=" + this.getModulesByMDORef() + ", modulesByObject=" + this.getModulesByObject() + ", modules=" + this.getModules() + ", modulesBySupport=" + this.getModulesBySupport() + ", children=" + this.getChildren() + ", childrenByMdoRef=" + this.getChildrenByMdoRef() + ", commonModules=" + this.getCommonModules() + ", languages=" + this.getLanguages() + ", rootPath=" + this.getRootPath() + ", roles=" + this.getRoles() + ")";
    }

    private static /* synthetic */ void lambda$new$1(Map supportMap, Map modulesType, Map modulesSupport, Map modulesObject, List modulesList, Map modulesMDORef, AbstractMDObjectBase mdo) {
        Map<SupportConfiguration, SupportVariant> supports = supportMap.getOrDefault(mdo.getUuid(), Collections.emptyMap());
        if (mdo instanceof AbstractMDObjectBSL) {
            Configuration.computeModules(modulesType, modulesSupport, modulesObject, modulesList, modulesMDORef, (AbstractMDObjectBSL)mdo, supports);
        }
    }
}

