/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.description.support;

import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.description.support.ParameterDescription;
import com.github._1c_syntax.bsl.parser.description.support.TypeDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class DescriptionReader {
    private static final int HYPERLINK_REF_LEN = 4;

    DescriptionReader() {
    }

    public static List<ParameterDescription> readParameters(BSLMethodDescriptionParser.MethodDescriptionContext ctx) {
        if (ctx.parameters() == null) {
            return Collections.emptyList();
        }
        if (ctx.parameters().hyperlinkBlock() != null) {
            ArrayList<ParameterDescription> result = new ArrayList<ParameterDescription>();
            if (ctx.parameters().hyperlinkBlock().hyperlinkType() != null) {
                result.add(new ParameterDescription("", Collections.emptyList(), DescriptionReader.getDescriptionString(ctx.parameters().hyperlinkBlock()).substring(4), true));
            }
            return result;
        }
        if (ctx.parameters().parameterString() == null) {
            return Collections.emptyList();
        }
        return DescriptionReader.getParametersStrings(ctx.parameters().parameterString());
    }

    public static List<TypeDescription> readReturnedValue(BSLMethodDescriptionParser.MethodDescriptionContext ctx) {
        if (ctx.returnsValues() == null) {
            return Collections.emptyList();
        }
        if (ctx.returnsValues().hyperlinkBlock() != null) {
            ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
            if (ctx.returnsValues().hyperlinkBlock().hyperlinkType() != null) {
                String hyperlink = DescriptionReader.getDescriptionString(ctx.returnsValues().hyperlinkBlock());
                result.add(new TypeDescription(hyperlink, "", Collections.emptyList(), hyperlink.substring(4), true));
            }
            return result;
        }
        if (ctx.returnsValues().returnsValuesString() == null) {
            return Collections.emptyList();
        }
        TempParameterData fakeParam = new TempParameterData("");
        int typeStartStringLen = -1;
        for (BSLMethodDescriptionParser.ReturnsValuesStringContext returnsValuesStringContext : ctx.returnsValues().returnsValuesString()) {
            if (returnsValuesStringContext.returnsValue() != null) {
                if (typeStartStringLen == -1 || returnsValuesStringContext.returnsValue().startPart().getText().length() == typeStartStringLen) {
                    fakeParam.addType(returnsValuesStringContext.returnsValue().type(), returnsValuesStringContext.returnsValue().typeDescription());
                    typeStartStringLen = returnsValuesStringContext.returnsValue().startPart().getText().length();
                    continue;
                }
                Object text = "";
                if (returnsValuesStringContext.returnsValue().type() != null && returnsValuesStringContext.returnsValue().type().getText() != null) {
                    text = (String)text + returnsValuesStringContext.returnsValue().type().getText();
                }
                if (returnsValuesStringContext.returnsValue().typeDescription() != null && returnsValuesStringContext.returnsValue().typeDescription().getText() != null) {
                    text = (String)text + " - " + returnsValuesStringContext.returnsValue().typeDescription().getText();
                }
                fakeParam.addTypeDescription((String)text);
                continue;
            }
            if (returnsValuesStringContext.typesBlock() != null) {
                fakeParam.addType(returnsValuesStringContext.typesBlock().type(), returnsValuesStringContext.typesBlock().typeDescription());
                continue;
            }
            if (returnsValuesStringContext.typeDescription() != null) {
                fakeParam.addTypeDescription(returnsValuesStringContext.typeDescription());
                continue;
            }
            if (returnsValuesStringContext.subParameter() == null) continue;
            fakeParam.addSubParameter(returnsValuesStringContext.subParameter());
        }
        return fakeParam.makeParameterDescription().getTypes();
    }

    public static String readDeprecationInfo(BSLMethodDescriptionParser.MethodDescriptionContext ctx) {
        BSLMethodDescriptionParser.DeprecateDescriptionContext deprecationDescription;
        if (ctx.deprecate() != null && (deprecationDescription = ctx.deprecate().deprecateDescription()) != null) {
            return deprecationDescription.getText().strip();
        }
        return "";
    }

    public static List<String> readCallOptions(BSLMethodDescriptionParser.MethodDescriptionContext ctx) {
        List<? extends BSLMethodDescriptionParser.CallOptionsStringContext> strings;
        if (ctx.callOptions() != null && (strings = ctx.callOptions().callOptionsString()) != null) {
            return strings.stream().map(DescriptionReader::getDescriptionString).filter(s -> !s.isBlank()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> readExamples(BSLMethodDescriptionParser.MethodDescriptionContext ctx) {
        List<? extends BSLMethodDescriptionParser.ExamplesStringContext> strings;
        if (ctx.examples() != null && (strings = ctx.examples().examplesString()) != null) {
            return strings.stream().map(DescriptionReader::getDescriptionString).filter(s -> !s.isBlank()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String readPurposeDescription(BSLMethodDescriptionParser.MethodDescriptionContext ctx) {
        if (ctx.descriptionBlock() != null) {
            List<? extends BSLMethodDescriptionParser.DescriptionStringContext> strings;
            if (ctx.descriptionBlock().description() != null && (strings = ctx.descriptionBlock().description().descriptionString()) != null) {
                return strings.stream().map(DescriptionReader::getDescriptionString).collect(Collectors.joining("\n")).strip();
            }
            if (ctx.descriptionBlock().hyperlinkBlock() != null) {
                return DescriptionReader.getDescriptionString(ctx.descriptionBlock().hyperlinkBlock());
            }
        }
        return "";
    }

    public static String readLink(BSLMethodDescriptionParser.MethodDescriptionContext ctx) {
        if (ctx.descriptionBlock() != null && ctx.descriptionBlock().hyperlinkBlock() != null) {
            return DescriptionReader.getDescriptionString(ctx.descriptionBlock().hyperlinkBlock()).substring(4);
        }
        return "";
    }

    private static String getDescriptionString(BSLParserRuleContext ctx) {
        StringJoiner strings = new StringJoiner("");
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof BSLMethodDescriptionParser.StartPartContext) continue;
            strings.add(child.getText());
        }
        return strings.toString().strip();
    }

    private static List<ParameterDescription> getParametersStrings(List<? extends BSLMethodDescriptionParser.ParameterStringContext> strings) {
        ArrayList<ParameterDescription> result = new ArrayList<ParameterDescription>();
        TempParameterData current = new TempParameterData();
        for (BSLMethodDescriptionParser.ParameterStringContext parameterStringContext : strings) {
            if (parameterStringContext.parameter() != null) {
                if (!current.isEmpty()) {
                    result.add(current.makeParameterDescription());
                }
                current = new TempParameterData(parameterStringContext.parameter());
                continue;
            }
            if (parameterStringContext.typesBlock() != null) {
                current.addType(parameterStringContext.typesBlock().type(), parameterStringContext.typesBlock().typeDescription());
                continue;
            }
            if (parameterStringContext.typeDescription() != null) {
                if (current.isEmpty()) {
                    String text = parameterStringContext.typeDescription().getText().strip();
                    if (text.split("\\s").length != 1) continue;
                    current = new TempParameterData(text);
                    continue;
                }
                current.addTypeDescription(parameterStringContext.typeDescription());
                continue;
            }
            if (parameterStringContext.subParameter() == null) continue;
            current.addSubParameter(parameterStringContext.subParameter());
        }
        if (!current.isEmpty()) {
            result.add(current.makeParameterDescription());
        }
        return result;
    }

    private static final class TempParameterData {
        private String name = "";
        private boolean empty = true;
        private final List<TempParameterTypeData> types = new ArrayList<TempParameterTypeData>();
        private int level = 1;

        private TempParameterData() {
        }

        private TempParameterData(BSLMethodDescriptionParser.ParameterContext parameter) {
            this();
            if (parameter.parameterName() != null) {
                this.name = parameter.parameterName().getText().strip();
                this.empty = false;
                if (parameter.typesBlock() != null) {
                    this.addType(parameter.typesBlock().type(), parameter.typesBlock().typeDescription());
                }
            }
        }

        private TempParameterData(BSLMethodDescriptionParser.SubParameterContext subParameter, int level) {
            this();
            this.level = level;
            if (subParameter.parameterName() != null) {
                this.name = subParameter.parameterName().getText().strip();
                this.empty = false;
                if (subParameter.typesBlock() != null) {
                    this.addType(subParameter.typesBlock().type(), subParameter.typesBlock().typeDescription());
                }
            }
        }

        private TempParameterData(String name) {
            this();
            this.name = name.strip();
            this.empty = false;
        }

        private boolean isEmpty() {
            return this.empty;
        }

        private Optional<TempParameterTypeData> lastType() {
            if (!this.types.isEmpty()) {
                return Optional.of(this.types.get(this.types.size() - 1));
            }
            return Optional.empty();
        }

        private ParameterDescription makeParameterDescription() {
            List<TypeDescription> parameterTypes = this.types.stream().map(child -> {
                ArrayList<ParameterDescription> subParameters = new ArrayList<ParameterDescription>();
                if (!child.subParameters.isEmpty()) {
                    child.subParameters.forEach(subParam -> subParameters.add(subParam.makeParameterDescription()));
                }
                String link = "";
                if (child.isHyperlink) {
                    link = child.name.substring(4);
                }
                return new TypeDescription(child.name, child.description.toString(), subParameters, link, child.isHyperlink);
            }).collect(Collectors.toList());
            return new ParameterDescription(this.name, parameterTypes, "", false);
        }

        private void addType(@Nullable BSLMethodDescriptionParser.TypeContext paramType, @Nullable BSLMethodDescriptionParser.TypeDescriptionContext paramDescription) {
            if (this.isEmpty() || paramType == null) {
                return;
            }
            if (paramType.listTypes() != null) {
                String[] stringTypes;
                for (String stringType : stringTypes = paramType.listTypes().getText().split(",")) {
                    if (stringType.isBlank()) continue;
                    this.addType(paramDescription, stringType.strip(), false);
                }
            } else if (paramType.hyperlinkType() != null) {
                this.addType(paramDescription, paramType.hyperlinkType().getText(), true);
            } else if (paramType.simpleType() != null) {
                this.addType(paramDescription, paramType.simpleType().getText(), false);
            } else if (paramType.complexType() != null) {
                this.addType(paramDescription, paramType.complexType().getText(), false);
            }
        }

        private void addType(@Nullable BSLMethodDescriptionParser.TypeDescriptionContext descriptionContext, String text, boolean isHyperlink) {
            TempParameterTypeData newType = new TempParameterTypeData(text, this.level, isHyperlink);
            if (descriptionContext != null) {
                newType.addTypeDescription(descriptionContext);
            }
            this.types.add(newType);
        }

        private void addTypeDescription(BSLMethodDescriptionParser.TypeDescriptionContext typeDescription) {
            this.lastType().ifPresent(lastType -> lastType.addTypeDescription(typeDescription));
        }

        public void addTypeDescription(String textDescription) {
            this.lastType().ifPresent(lastType -> lastType.addTypeDescription(textDescription));
        }

        private void addSubParameter(BSLMethodDescriptionParser.SubParameterContext subParameter) {
            this.lastType().ifPresent(lastType -> lastType.addSubParameter(subParameter));
        }
    }

    private static final class TempParameterTypeData {
        private final String name;
        private final StringJoiner description;
        private final int level;
        private final List<TempParameterData> subParameters;
        private final boolean isHyperlink;

        private TempParameterTypeData(String name, int level, boolean isHyperlink) {
            this.name = name;
            this.description = new StringJoiner("\n");
            this.level = level;
            this.subParameters = new ArrayList<TempParameterData>();
            this.isHyperlink = isHyperlink;
        }

        private void addTypeDescription(BSLMethodDescriptionParser.TypeDescriptionContext typeDescription) {
            if (typeDescription.getText() != null) {
                if (this.lastSubParameter().isPresent()) {
                    this.lastSubParameter().get().addTypeDescription(typeDescription);
                } else {
                    this.description.add(typeDescription.getText().strip());
                }
            }
        }

        public void addTypeDescription(String textDescription) {
            if (!textDescription.isEmpty()) {
                if (this.lastSubParameter().isPresent()) {
                    this.lastSubParameter().get().addTypeDescription(textDescription);
                } else {
                    this.description.add(textDescription.strip());
                }
            }
        }

        private Optional<TempParameterData> lastSubParameter() {
            if (!this.subParameters.isEmpty()) {
                return Optional.of(this.subParameters.get(this.subParameters.size() - 1));
            }
            return Optional.empty();
        }

        private void addSubParameter(BSLMethodDescriptionParser.SubParameterContext subParameter) {
            TerminalNode star = subParameter.getToken(10, 0);
            if (star == null) {
                return;
            }
            if (star.getText().length() == this.level) {
                this.subParameters.add(new TempParameterData(subParameter, this.level + 1));
            } else {
                this.lastSubParameter().ifPresent(subParam -> subParam.addSubParameter(subParameter));
            }
        }
    }
}

