/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser;

import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.UnicodeBOMInputStream;
import com.github._1c_syntax.utils.Lazy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.apache.commons.io.IOUtils;

public abstract class Tokenizer<T extends BSLParserRuleContext, P extends Parser> {
    private final InputStream content;
    private final Lexer lexer;
    private final Lazy<CommonTokenStream> tokenStream = new Lazy(this::computeTokenStream);
    private final Lazy<List<Token>> tokens = new Lazy(this::computeTokens);
    private final Lazy<T> ast = new Lazy(this::computeAST);
    private final Class<P> parserClass;
    protected P parser;

    protected Tokenizer(String content, Lexer lexer, Class<P> parserClass) {
        this(IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8), lexer, parserClass);
    }

    protected Tokenizer(InputStream content, Lexer lexer, Class<P> parserClass) {
        Objects.requireNonNull(content);
        Objects.requireNonNull(lexer);
        this.content = content;
        this.lexer = lexer;
        this.parserClass = parserClass;
    }

    public List<Token> getTokens() {
        return (List)this.tokens.getOrCompute();
    }

    public T getAst() {
        return (T)((Object)((BSLParserRuleContext)((Object)this.ast.getOrCompute())));
    }

    private List<Token> computeTokens() {
        ArrayList<Token> tokensTemp = new ArrayList<Token>(this.getTokenStream().getTokens());
        Token lastToken = (Token)tokensTemp.get(tokensTemp.size() - 1);
        if (lastToken.getType() == -1 && lastToken instanceof CommonToken) {
            ((CommonToken)lastToken).setChannel(1);
        }
        return tokensTemp;
    }

    private T computeAST() {
        this.parser = this.createParser(this.getTokenStream());
        this.parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        try {
            ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return this.rootAST();
        }
        catch (Exception ex) {
            this.parser.reset();
            ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return this.rootAST();
        }
    }

    protected abstract T rootAST();

    private CommonTokenStream computeTokenStream() {
        CodePointCharStream input;
        try (UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(this.content);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)ubis, StandardCharsets.UTF_8);){
            ubis.skipBOM();
            input = CharStreams.fromReader((Reader)inputStreamReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lexer.setInputStream((CharStream)input);
        this.lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        CommonTokenStream tempTokenStream = new CommonTokenStream((TokenSource)this.lexer);
        tempTokenStream.fill();
        return tempTokenStream;
    }

    protected CommonTokenStream getTokenStream() {
        CommonTokenStream tokenStreamUnboxed = (CommonTokenStream)this.tokenStream.getOrCompute();
        tokenStreamUnboxed.seek(0);
        return tokenStreamUnboxed;
    }

    private P createParser(CommonTokenStream tokenStream) {
        try {
            return (P)((Parser)this.parserClass.getDeclaredConstructor(TokenStream.class).newInstance(tokenStream));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

