/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import cn.forward.androids.utils.StatusBarUtil;
import cn.hzw.doodle.R;
import cn.hzw.doodle.imagepicker.ImageSelectorView;
import cn.hzw.doodle.util.DrawUtil;
import java.util.List;

public class DialogController {
    public static Dialog showEnterCancelDialog(Activity activity, String title, String msg, View.OnClickListener enterClick, View.OnClickListener cancelClick) {
        return DialogController.showMsgDialog(activity, title, msg, activity.getString(R.string.doodle_cancel), activity.getString(R.string.doodle_enter), enterClick, cancelClick);
    }

    public static Dialog showEnterDialog(Activity activity, String title, String msg, View.OnClickListener enterClick) {
        return DialogController.showMsgDialog(activity, title, msg, null, activity.getString(R.string.doodle_enter), enterClick, null);
    }

    public static Dialog showMsgDialog(Activity activity, String title, String msg, String btn01, String btn02, final View.OnClickListener enterClick, final View.OnClickListener cancelClick) {
        TextView textView;
        TextView titleView;
        Dialog dialog = DialogController.getDialog(activity);
        dialog.getWindow().setSoftInputMode(16);
        StatusBarUtil.setStatusBarTranslucent((Window)dialog.getWindow(), (boolean)true, (boolean)false);
        dialog.show();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        final Dialog finalDialog = dialog;
        View view = View.inflate((Context)activity, (int)R.layout.doodle_dialog, null);
        dialog.setContentView(view);
        if (TextUtils.isEmpty((CharSequence)title)) {
            dialog.findViewById(R.id.dialog_title).setVisibility(8);
            dialog.findViewById(R.id.dialog_list_title_divider).setVisibility(8);
        } else {
            titleView = (TextView)dialog.findViewById(R.id.dialog_title);
            titleView.setText((CharSequence)title);
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            dialog.findViewById(R.id.dialog_enter_msg).setVisibility(8);
        } else {
            titleView = (TextView)dialog.findViewById(R.id.dialog_enter_msg);
            titleView.setText((CharSequence)Html.fromHtml((String)msg));
        }
        if (TextUtils.isEmpty((CharSequence)btn01)) {
            dialog.findViewById(R.id.dialog_enter_btn_01).setVisibility(8);
        } else {
            textView = (TextView)dialog.findViewById(R.id.dialog_enter_btn_01);
            textView.setText((CharSequence)btn01);
        }
        if (TextUtils.isEmpty((CharSequence)btn02)) {
            dialog.findViewById(R.id.dialog_enter_btn_02).setVisibility(8);
        } else {
            textView = (TextView)dialog.findViewById(R.id.dialog_enter_btn_02);
            textView.setText((CharSequence)btn02);
        }
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (v.getId() == R.id.dialog_bg) {
                    finalDialog.dismiss();
                } else if (v.getId() == R.id.dialog_enter_btn_02) {
                    finalDialog.dismiss();
                    if (enterClick != null) {
                        enterClick.onClick(v);
                    }
                } else if (v.getId() == R.id.dialog_enter_btn_01) {
                    finalDialog.dismiss();
                    if (cancelClick != null) {
                        cancelClick.onClick(v);
                    }
                }
            }
        };
        view.findViewById(R.id.dialog_bg).setOnClickListener(onClickListener);
        view.findViewById(R.id.dialog_enter_btn_01).setOnClickListener(onClickListener);
        view.findViewById(R.id.dialog_enter_btn_02).setOnClickListener(onClickListener);
        return dialog;
    }

    public static Dialog showInputTextDialog(Activity activity, String text, final View.OnClickListener enterClick, final View.OnClickListener cancelClick) {
        boolean fullScreen = (activity.getWindow().getAttributes().flags & 0x400) != 0;
        final Dialog dialog = DialogController.getDialog(activity);
        dialog.getWindow().setSoftInputMode(16);
        dialog.show();
        ViewGroup container = (ViewGroup)View.inflate((Context)activity, (int)R.layout.doodle_create_text, null);
        container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        dialog.setContentView((View)container);
        if (fullScreen) {
            DrawUtil.assistActivity(dialog.getWindow());
        }
        final EditText textView = (EditText)container.findViewById(R.id.doodle_selectable_edit);
        final View cancelBtn = container.findViewById(R.id.doodle_text_cancel_btn);
        final TextView enterBtn = (TextView)container.findViewById(R.id.doodle_text_enter_btn);
        textView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String text = (textView.getText() + "").trim();
                if (TextUtils.isEmpty((CharSequence)text)) {
                    enterBtn.setEnabled(false);
                    enterBtn.setTextColor(-5000269);
                } else {
                    enterBtn.setEnabled(true);
                    enterBtn.setTextColor(-14474461);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        textView.setText((CharSequence)(text == null ? "" : text));
        cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (cancelClick != null) {
                    cancelClick.onClick(cancelBtn);
                }
            }
        });
        enterBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (enterClick != null) {
                    enterBtn.setTag((Object)(textView.getText() + "").trim());
                    enterClick.onClick((View)enterBtn);
                }
            }
        });
        return dialog;
    }

    public static Dialog showSelectImageDialog(Activity activity, final ImageSelectorView.ImageSelectorListener listener) {
        final Dialog dialog = DialogController.getDialog(activity);
        dialog.getWindow().setSoftInputMode(16);
        dialog.show();
        ViewGroup container = (ViewGroup)View.inflate((Context)activity, (int)R.layout.doodle_create_bitmap, null);
        container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        dialog.setContentView((View)container);
        ViewGroup selectorContainer = (ViewGroup)dialog.findViewById(R.id.doodle_image_selector_container);
        ImageSelectorView selectorView = new ImageSelectorView((Context)activity, false, 1, null, new ImageSelectorView.ImageSelectorListener(){

            @Override
            public void onCancel() {
                dialog.dismiss();
                if (listener != null) {
                    listener.onCancel();
                }
            }

            @Override
            public void onEnter(List<String> pathList) {
                dialog.dismiss();
                if (listener != null) {
                    listener.onEnter(pathList);
                }
            }
        });
        selectorView.setColumnCount(4);
        selectorContainer.addView((View)selectorView);
        return dialog;
    }

    private static Dialog getDialog(Activity activity) {
        boolean fullScreen = (activity.getWindow().getAttributes().flags & 0x400) != 0;
        Dialog dialog = null;
        dialog = fullScreen ? new Dialog((Context)activity, 0x1030011) : new Dialog((Context)activity, 0x1030010);
        return dialog;
    }
}

