/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle.dialog;

import android.content.Context;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import cn.forward.androids.utils.Util;

public class ColorPickerView
extends View {
    private Paint mPaint;
    private Paint mCenterPaint;
    private Paint mLinePaint;
    private Paint mRectPaint;
    private Shader rectShader;
    private float rectLeft;
    private float rectTop;
    private float rectRight;
    private float rectBottom;
    private final int[] mCircleColors;
    private final int[] mRectColors;
    private int mHeight;
    private int mWidth;
    private float r;
    private float centerRadius;
    private boolean downInCircle = true;
    private boolean downInRect;
    private boolean highlightCenter;
    private boolean highlightCenterLittle;
    private RectF mRectF = new RectF();
    private OnSelectedColorListener mOnSelectedColorListener;
    private Drawable mDrawable;
    private BitmapShader mBitmapShader;

    public ColorPickerView(Context context, int initColor, int height, int width, OnSelectedColorListener listener) {
        super(context);
        this.mHeight = height;
        this.mWidth = width;
        this.setMinimumHeight(height);
        this.setMinimumWidth(width);
        this.mCircleColors = new int[]{-65536, -65281, -16776961, -16711681, -16711936, -256, -65536};
        SweepGradient s = new SweepGradient(0.0f, 0.0f, this.mCircleColors, null);
        this.mPaint = new Paint(1);
        this.mPaint.setShader((Shader)s);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)Util.dp2px((Context)context, (float)30.0f));
        this.r = (float)(width / 2) * 0.7f - this.mPaint.getStrokeWidth() * 0.5f;
        this.mCenterPaint = new Paint(1);
        this.mCenterPaint.setColor(initColor);
        this.mCenterPaint.setStrokeWidth(5.0f);
        this.centerRadius = (this.r - this.mPaint.getStrokeWidth() / 2.0f) * 0.7f;
        this.mLinePaint = new Paint(1);
        this.mLinePaint.setColor(Color.parseColor((String)"#72A1D1"));
        this.mLinePaint.setStrokeWidth(4.0f);
        this.mRectColors = new int[]{-16777216, this.mCenterPaint.getColor(), -1};
        this.mRectPaint = new Paint(1);
        this.mRectPaint.setStrokeWidth((float)Util.dp2px((Context)context, (float)5.0f));
        this.rectLeft = -this.r - this.mPaint.getStrokeWidth() * 0.5f;
        this.rectTop = this.r + this.mPaint.getStrokeWidth() * 0.5f + this.mLinePaint.getStrokeMiter() * 0.5f + 15.0f;
        this.rectRight = this.r + this.mPaint.getStrokeWidth() * 0.5f;
        this.rectBottom = this.rectTop + (float)Util.dp2px((Context)context, (float)30.0f);
        this.mOnSelectedColorListener = listener;
    }

    public void setDrawable(BitmapDrawable drawable) {
        this.mDrawable = drawable;
        this.mBitmapShader = new BitmapShader(drawable.getBitmap(), Shader.TileMode.MIRROR, Shader.TileMode.MIRROR);
        this.invalidate();
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    protected void onDraw(Canvas canvas) {
        canvas.translate((float)(this.mWidth / 2), (float)(this.mHeight / 2 - 50));
        if (this.mDrawable != null) {
            this.mCenterPaint.setShader((Shader)this.mBitmapShader);
        } else {
            this.mCenterPaint.setShader(null);
        }
        canvas.drawCircle(0.0f, 0.0f, this.centerRadius, this.mCenterPaint);
        if (this.highlightCenter || this.highlightCenterLittle) {
            int c = this.mCenterPaint.getColor();
            this.mCenterPaint.setStyle(Paint.Style.STROKE);
            if (this.highlightCenter) {
                this.mCenterPaint.setAlpha(255);
            } else if (this.highlightCenterLittle) {
                this.mCenterPaint.setAlpha(144);
            }
            canvas.drawCircle(0.0f, 0.0f, this.centerRadius + this.mCenterPaint.getStrokeWidth(), this.mCenterPaint);
            this.mCenterPaint.setStyle(Paint.Style.FILL);
            this.mCenterPaint.setColor(c);
        }
        this.mRectF.set(-this.r, -this.r, this.r, this.r);
        canvas.drawOval(this.mRectF, this.mPaint);
        if (this.downInCircle && this.mRectColors[1] != this.mCenterPaint.getColor()) {
            this.mRectColors[1] = this.mCenterPaint.getColor();
            this.rectShader = new LinearGradient(this.rectLeft, 0.0f, this.rectRight, 0.0f, this.mRectColors, null, Shader.TileMode.MIRROR);
        }
        if (this.rectShader == null) {
            this.rectShader = new LinearGradient(this.rectLeft, 0.0f, this.rectRight, 0.0f, this.mRectColors, null, Shader.TileMode.MIRROR);
        }
        this.mRectPaint.setShader(this.rectShader);
        canvas.drawRect(this.rectLeft, this.rectTop, this.rectRight, this.rectBottom, this.mRectPaint);
        float offset = this.mLinePaint.getStrokeWidth() / 2.0f;
        canvas.drawLine(this.rectLeft - offset, this.rectTop - offset * 2.0f, this.rectLeft - offset, this.rectBottom + offset * 2.0f, this.mLinePaint);
        canvas.drawLine(this.rectLeft - offset * 2.0f, this.rectTop - offset, this.rectRight + offset * 2.0f, this.rectTop - offset, this.mLinePaint);
        canvas.drawLine(this.rectRight + offset, this.rectTop - offset * 2.0f, this.rectRight + offset, this.rectBottom + offset * 2.0f, this.mLinePaint);
        canvas.drawLine(this.rectLeft - offset * 2.0f, this.rectBottom + offset, this.rectRight + offset * 2.0f, this.rectBottom + offset, this.mLinePaint);
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX() - (float)(this.mWidth / 2);
        float y = event.getY() - (float)(this.mHeight / 2) + 50.0f;
        boolean inCircle = this.inColorCircle(x, y, this.r + this.mPaint.getStrokeWidth() / 2.0f, this.r - this.mPaint.getStrokeWidth() / 2.0f);
        boolean inCenter = this.inCenter(x, y, this.centerRadius);
        boolean inRect = this.inRect(x, y);
        switch (event.getAction()) {
            case 0: {
                this.downInCircle = inCircle;
                this.downInRect = inRect;
                this.highlightCenter = inCenter;
            }
            case 2: {
                if (this.downInCircle && inCircle) {
                    float angle = (float)Math.atan2(y, x);
                    float unit = (float)((double)angle / (Math.PI * 2));
                    if (unit < 0.0f) {
                        unit += 1.0f;
                    }
                    this.mDrawable = null;
                    this.mCenterPaint.setColor(this.interpCircleColor(this.mCircleColors, unit));
                } else if (this.downInRect && inRect) {
                    this.mDrawable = null;
                    this.mCenterPaint.setColor(this.interpRectColor(this.mRectColors, x));
                }
                if (this.highlightCenter && inCenter || this.highlightCenterLittle && inCenter) {
                    this.highlightCenter = true;
                    this.highlightCenterLittle = false;
                } else if (this.highlightCenter || this.highlightCenterLittle) {
                    this.highlightCenter = false;
                    this.highlightCenterLittle = true;
                } else {
                    this.highlightCenter = false;
                    this.highlightCenterLittle = false;
                }
                this.invalidate();
                break;
            }
            case 1: {
                if (this.highlightCenter && inCenter && this.mOnSelectedColorListener != null) {
                    this.mOnSelectedColorListener.onSelected(this.mCenterPaint.getColor());
                }
                if (this.downInCircle) {
                    this.downInCircle = false;
                }
                if (this.downInRect) {
                    this.downInRect = false;
                }
                if (this.highlightCenter) {
                    this.highlightCenter = false;
                }
                if (this.highlightCenterLittle) {
                    this.highlightCenterLittle = false;
                }
                this.invalidate();
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(this.mWidth, this.mHeight);
    }

    private boolean inColorCircle(float x, float y, float outRadius, float inRadius) {
        double outCircle = Math.PI * (double)outRadius * (double)outRadius;
        double inCircle = Math.PI * (double)inRadius * (double)inRadius;
        double fingerCircle = Math.PI * (double)(x * x + y * y);
        return fingerCircle < outCircle && fingerCircle > inCircle;
    }

    private boolean inCenter(float x, float y, float centerRadius) {
        double fingerCircle = Math.PI * (double)(x * x + y * y);
        double centerCircle = Math.PI * (double)centerRadius * (double)centerRadius;
        return fingerCircle < centerCircle;
    }

    private boolean inRect(float x, float y) {
        return x <= this.rectRight && x >= this.rectLeft && y <= this.rectBottom && y >= this.rectTop;
    }

    private int interpCircleColor(int[] colors, float unit) {
        if (unit <= 0.0f) {
            return colors[0];
        }
        if (unit >= 1.0f) {
            return colors[colors.length - 1];
        }
        float p = unit * (float)(colors.length - 1);
        int i = (int)p;
        int c0 = colors[i];
        int c1 = colors[i + 1];
        int a = this.ave(Color.alpha((int)c0), Color.alpha((int)c1), p -= (float)i);
        int r = this.ave(Color.red((int)c0), Color.red((int)c1), p);
        int g = this.ave(Color.green((int)c0), Color.green((int)c1), p);
        int b = this.ave(Color.blue((int)c0), Color.blue((int)c1), p);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    private int interpRectColor(int[] colors, float x) {
        float p;
        int c1;
        int c0;
        if (x < 0.0f) {
            c0 = colors[0];
            c1 = colors[1];
            p = (x + this.rectRight) / this.rectRight;
        } else {
            c0 = colors[1];
            c1 = colors[2];
            p = x / this.rectRight;
        }
        int a = this.ave(Color.alpha((int)c0), Color.alpha((int)c1), p);
        int r = this.ave(Color.red((int)c0), Color.red((int)c1), p);
        int g = this.ave(Color.green((int)c0), Color.green((int)c1), p);
        int b = this.ave(Color.blue((int)c0), Color.blue((int)c1), p);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    private int ave(int s, int d, float p) {
        return s + Math.round(p * (float)(d - s));
    }

    public void setColor(int color) {
        this.mCenterPaint.setColor(color);
        this.mRectColors[1] = this.mCenterPaint.getColor();
    }

    public int getColor() {
        return this.mCenterPaint.getColor();
    }

    public static interface OnSelectedColorListener {
        public void onSelected(int var1);
    }
}

