/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import cn.forward.androids.utils.ImageUtils;
import cn.forward.androids.utils.Util;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.IDoodleListener;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodlePen;
import cn.hzw.doodle.core.IDoodleShape;
import cn.hzw.doodle.core.IDoodleTouchDetector;
import cn.hzw.doodle.util.DrawUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class DoodleView
extends View
implements IDoodle {
    public static final float MAX_SCALE = 5.0f;
    public static final float MIN_SCALE = 0.25f;
    public static final int DEFAULT_SIZE = 6;
    public static final int ERROR_INIT = -1;
    public static final int ERROR_SAVE = -2;
    private IDoodleListener mDoodleListener;
    private Bitmap mBitmap;
    private float mCenterScale;
    private int mCenterHeight;
    private int mCenterWidth;
    private float mCentreTranX;
    private float mCentreTranY;
    private float mRotateScale = 1.0f;
    private float mRotateTranX;
    private float mRotateTranY;
    private float mScale = 1.0f;
    private float mTransX = 0.0f;
    private float mTransY = 0.0f;
    private float mMinScale = 0.25f;
    private float mMaxScale = 5.0f;
    private float mSize;
    private IDoodleColor mColor;
    private boolean isJustDrawOriginal;
    private boolean mIsDrawableOutside = false;
    private boolean mReady = false;
    private CopyOnWriteArrayList<IDoodleItem> mItemStack = new CopyOnWriteArrayList();
    private IDoodlePen mPen;
    private IDoodleShape mShape;
    private float mTouchX;
    private float mTouchY;
    private boolean mEnableZoomer = false;
    private boolean mEnableOverview = true;
    private float mLastZoomerY;
    private float mZoomerRadius;
    private Path mZoomerPath;
    private float mZoomerScale = 0.0f;
    private Paint mZooomerPaint;
    private Paint mZoomerTouchPaint;
    private int mZoomerHorizonX;
    private boolean mIsScrollingDoodle = false;
    private float mDoodleSizeUnit = 1.0f;
    private int mDoodleRotateDegree = 0;
    private IDoodleTouchDetector mDefaultTouchDetector;
    private Map<IDoodlePen, IDoodleTouchDetector> mTouchDetectorMap = new HashMap<IDoodlePen, IDoodleTouchDetector>();
    private DoodleViewInner mInner;
    private RectF mDoodleBound = new RectF();
    private PointF mTempPoint = new PointF();
    private boolean mIsEditMode = false;
    private Matrix mTouchEventMatrix = new Matrix();
    private View.OnTouchListener mOnTouchListener;

    public DoodleView(Context context, Bitmap bitmap, IDoodleListener listener) {
        this(context, bitmap, listener, null);
    }

    public DoodleView(Context context, Bitmap bitmap, IDoodleListener listener, IDoodleTouchDetector defaultDetector) {
        super(context);
        this.setLayerType(1, null);
        this.mBitmap = bitmap;
        this.mDoodleListener = listener;
        if (this.mDoodleListener == null) {
            throw new RuntimeException("IDoodleListener is null!!!");
        }
        if (this.mBitmap == null) {
            throw new RuntimeException("Bitmap is null!!!");
        }
        this.mScale = 1.0f;
        this.mColor = new DoodleColor(-65536);
        this.mPen = DoodlePen.BRUSH;
        this.mShape = DoodleShape.HAND_WRITE;
        this.mZooomerPaint = new Paint();
        this.mZooomerPaint.setColor(-1426063361);
        this.mZooomerPaint.setStyle(Paint.Style.STROKE);
        this.mZooomerPaint.setAntiAlias(true);
        this.mZooomerPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mZooomerPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mZooomerPaint.setStrokeWidth((float)Util.dp2px((Context)this.getContext(), (float)10.0f));
        this.mZoomerTouchPaint = new Paint();
        this.mZoomerTouchPaint.setStyle(Paint.Style.STROKE);
        this.mZoomerTouchPaint.setAntiAlias(true);
        this.mZoomerTouchPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mZoomerTouchPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDefaultTouchDetector = defaultDetector;
        this.mInner = new DoodleViewInner();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initDoodleBitmap();
        if (!this.mReady) {
            this.mDoodleListener.onReady(this);
            this.mReady = true;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mOnTouchListener != null && this.mOnTouchListener.onTouch((View)this, event)) {
            return true;
        }
        this.mTouchX = event.getX();
        this.mTouchY = event.getY();
        MotionEvent transformedEvent = MotionEvent.obtain((MotionEvent)event);
        this.mTouchEventMatrix.reset();
        this.mTouchEventMatrix.setRotate((float)(-this.mDoodleRotateDegree), (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        transformedEvent.transform(this.mTouchEventMatrix);
        boolean handled = this.mInner.onTouchEvent(transformedEvent);
        transformedEvent.recycle();
        return handled;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mOnTouchListener = l;
        super.setOnTouchListener(l);
    }

    private void initDoodleBitmap() {
        float nh;
        int w = this.mBitmap.getWidth();
        int h = this.mBitmap.getHeight();
        float nw = (float)w * 1.0f / (float)this.getWidth();
        if (nw > (nh = (float)h * 1.0f / (float)this.getHeight())) {
            this.mCenterScale = 1.0f / nw;
            this.mCenterWidth = this.getWidth();
            this.mCenterHeight = (int)((float)h * this.mCenterScale);
        } else {
            this.mCenterScale = 1.0f / nh;
            this.mCenterWidth = (int)((float)w * this.mCenterScale);
            this.mCenterHeight = this.getHeight();
        }
        this.mCentreTranX = (float)(this.getWidth() - this.mCenterWidth) / 2.0f;
        this.mCentreTranY = (float)(this.getHeight() - this.mCenterHeight) / 2.0f;
        this.mZoomerRadius = Math.min(this.getWidth(), this.getHeight()) / 4;
        this.mZoomerPath = new Path();
        this.mZoomerPath.addCircle(this.mZoomerRadius, this.mZoomerRadius, this.mZoomerRadius, Path.Direction.CCW);
        this.mZoomerHorizonX = (int)((float)(Math.min(this.getWidth(), this.getHeight()) / 2) - this.mZoomerRadius);
        this.mDoodleSizeUnit = (float)Util.dp2px((Context)this.getContext(), (float)1.0f) / this.mCenterScale;
        if (!this.mReady) {
            this.mSize = 6.0f * this.mDoodleSizeUnit;
        }
        this.mTransY = 0.0f;
        this.mTransX = 0.0f;
        this.mScale = 1.0f;
        this.refresh();
    }

    public RectF getDoodleBound() {
        float width = (float)this.mCenterWidth * this.mRotateScale * this.mScale;
        float height = (float)this.mCenterHeight * this.mRotateScale * this.mScale;
        if (this.mDoodleRotateDegree % 90 == 0) {
            if (this.mDoodleRotateDegree == 0) {
                this.mTempPoint.x = this.toTouchX(0.0f);
                this.mTempPoint.y = this.toTouchY(0.0f);
            } else if (this.mDoodleRotateDegree == 90) {
                this.mTempPoint.x = this.toTouchX(0.0f);
                this.mTempPoint.y = this.toTouchY(this.mBitmap.getHeight());
                float t = width;
                width = height;
                height = t;
            } else if (this.mDoodleRotateDegree == 180) {
                this.mTempPoint.x = this.toTouchX(this.mBitmap.getWidth());
                this.mTempPoint.y = this.toTouchY(this.mBitmap.getHeight());
            } else if (this.mDoodleRotateDegree == 270) {
                this.mTempPoint.x = this.toTouchX(this.mBitmap.getWidth());
                this.mTempPoint.y = this.toTouchY(0.0f);
                float t = width;
                width = height;
                height = t;
            }
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, this.mTempPoint.x, this.mTempPoint.y, this.getWidth() / 2, this.getHeight() / 2);
            this.mDoodleBound.set(this.mTempPoint.x, this.mTempPoint.y, this.mTempPoint.x + width, this.mTempPoint.y + height);
        } else {
            float ltX = this.toTouchX(0.0f);
            float ltY = this.toTouchY(0.0f);
            float rbX = this.toTouchX(this.mBitmap.getWidth());
            float rbY = this.toTouchY(this.mBitmap.getHeight());
            float lbX = this.toTouchX(0.0f);
            float lbY = this.toTouchY(this.mBitmap.getHeight());
            float rtX = this.toTouchX(this.mBitmap.getWidth());
            float rtY = this.toTouchY(0.0f);
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, ltX, ltY, this.getWidth() / 2, this.getHeight() / 2);
            ltX = this.mTempPoint.x;
            ltY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, rbX, rbY, this.getWidth() / 2, this.getHeight() / 2);
            rbX = this.mTempPoint.x;
            rbY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, lbX, lbY, this.getWidth() / 2, this.getHeight() / 2);
            lbX = this.mTempPoint.x;
            lbY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, rtX, rtY, this.getWidth() / 2, this.getHeight() / 2);
            rtX = this.mTempPoint.x;
            rtY = this.mTempPoint.y;
            this.mDoodleBound.left = Math.min(Math.min(ltX, rbX), Math.min(lbX, rtX));
            this.mDoodleBound.top = Math.min(Math.min(ltY, rbY), Math.min(lbY, rtY));
            this.mDoodleBound.right = Math.max(Math.max(ltX, rbX), Math.max(lbX, rtX));
            this.mDoodleBound.bottom = Math.max(Math.max(ltY, rbY), Math.max(lbY, rtY));
        }
        return this.mDoodleBound;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mBitmap.isRecycled()) {
            return;
        }
        canvas.save();
        canvas.rotate((float)this.mDoodleRotateDegree, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.mInner.onDraw(canvas);
        canvas.restore();
        if (this.mIsScrollingDoodle && this.mEnableZoomer && this.mZoomerScale > 0.0f) {
            canvas.save();
            float unitSize = this.getUnitSize();
            if (this.mTouchY <= this.mZoomerRadius * 2.0f) {
                this.mLastZoomerY = (float)this.getHeight() - this.mZoomerRadius * 2.0f;
            } else if (this.mTouchY >= (float)this.getHeight() - this.mZoomerRadius * 2.0f) {
                this.mLastZoomerY = 0.0f;
            }
            canvas.translate((float)this.mZoomerHorizonX, this.mLastZoomerY);
            canvas.clipPath(this.mZoomerPath);
            canvas.drawColor(-16777216);
            canvas.save();
            float scale = this.mZoomerScale / this.mScale;
            canvas.scale(scale, scale);
            canvas.translate(-this.mTouchX + this.mZoomerRadius / scale, -this.mTouchY + this.mZoomerRadius / scale);
            canvas.rotate((float)this.mDoodleRotateDegree, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.mInner.onDraw(canvas);
            float left = this.getAllTranX();
            float top = this.getAllTranY();
            canvas.translate(left, top);
            scale = this.getAllScale();
            canvas.scale(scale, scale);
            this.mZoomerTouchPaint.setStrokeWidth(unitSize / 2.0f);
            float radius = this.mSize / 2.0f - unitSize / 2.0f;
            float radius2 = radius - unitSize / 2.0f;
            if (radius <= 1.0f) {
                radius = 1.0f;
                radius2 = radius / 2.0f;
                this.mZoomerTouchPaint.setStrokeWidth(this.mSize);
            }
            this.mZoomerTouchPaint.setColor(-1442840576);
            DrawUtil.drawCircle(canvas, this.toX(this.mTouchX), this.toY(this.mTouchY), radius, this.mZoomerTouchPaint);
            this.mZoomerTouchPaint.setColor(-1426063361);
            DrawUtil.drawCircle(canvas, this.toX(this.mTouchX), this.toY(this.mTouchY), radius2, this.mZoomerTouchPaint);
            canvas.restore();
            DrawUtil.drawCircle(canvas, this.mZoomerRadius, this.mZoomerRadius, this.mZoomerRadius, this.mZooomerPaint);
            canvas.restore();
            canvas.save();
            canvas.translate((float)this.mZoomerHorizonX, this.mLastZoomerY);
            scale = this.mZoomerRadius / 2.0f / (float)this.getWidth();
            canvas.scale(scale, scale);
            float strokeWidth = 1.0f / scale;
            canvas.clipRect(-strokeWidth, -strokeWidth, (float)this.getWidth() + strokeWidth, (float)this.getHeight() + strokeWidth);
            canvas.drawColor(-2004318072);
            canvas.save();
            canvas.rotate((float)this.mDoodleRotateDegree, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            float tempScale = this.mScale;
            float tempTransX = this.mTransX;
            float tempTransY = this.mTransY;
            this.mScale = 1.0f;
            this.mTransY = 0.0f;
            this.mTransX = 0.0f;
            this.mInner.onDraw(canvas);
            this.mScale = tempScale;
            this.mTransX = tempTransX;
            this.mTransY = tempTransY;
            canvas.restore();
            this.mZoomerTouchPaint.setStrokeWidth(strokeWidth);
            this.mZoomerTouchPaint.setColor(-1442840576);
            DrawUtil.drawRect(canvas, 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.mZoomerTouchPaint);
            this.mZoomerTouchPaint.setColor(-1426063361);
            DrawUtil.drawRect(canvas, strokeWidth, strokeWidth, (float)this.getWidth() - strokeWidth, (float)this.getHeight() - strokeWidth, this.mZoomerTouchPaint);
            canvas.restore();
        }
    }

    private void doDraw(Canvas canvas) {
        float left = this.getAllTranX();
        float top = this.getAllTranY();
        canvas.translate(left, top);
        float scale = this.getAllScale();
        canvas.scale(scale, scale);
        if (this.isJustDrawOriginal) {
            canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
            return;
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
        boolean canvasClipped = false;
        canvas.save();
        if (!this.mIsDrawableOutside) {
            canvasClipped = true;
            canvas.clipRect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
        }
        for (IDoodleItem item : this.mItemStack) {
            if (!item.isNeedClipOutside()) {
                if (canvasClipped) {
                    canvas.restore();
                }
                item.draw(canvas);
                if (!canvasClipped) continue;
                canvas.save();
                canvas.clipRect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                continue;
            }
            item.draw(canvas);
        }
        for (IDoodleItem item : this.mItemStack) {
            if (!item.isNeedClipOutside()) {
                if (canvasClipped) {
                    canvas.restore();
                }
                item.drawAtTheTop(canvas);
                if (!canvasClipped) continue;
                canvas.save();
                canvas.clipRect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                continue;
            }
            item.drawAtTheTop(canvas);
        }
        canvas.restore();
        if (this.mPen != null) {
            this.mPen.drawHelpers(canvas, this);
        }
        if (this.mShape != null) {
            this.mShape.drawHelpers(canvas, this);
        }
    }

    public float getAllScale() {
        return this.mCenterScale * this.mRotateScale * this.mScale;
    }

    public float getAllTranX() {
        return this.mCentreTranX + this.mRotateTranX + this.mTransX;
    }

    public float getAllTranY() {
        return this.mCentreTranY + this.mRotateTranY + this.mTransY;
    }

    public final float toX(float touchX) {
        return (touchX - this.getAllTranX()) / this.getAllScale();
    }

    public final float toY(float touchY) {
        return (touchY - this.getAllTranY()) / this.getAllScale();
    }

    public final float toTouchX(float x) {
        return x * this.getAllScale() + this.getAllTranX();
    }

    public final float toTouchY(float y) {
        return y * this.getAllScale() + this.getAllTranY();
    }

    public final float toTransX(float touchX, float doodleX) {
        return -doodleX * this.getAllScale() + touchX - this.mCentreTranX - this.mRotateTranX;
    }

    public final float toTransY(float touchY, float doodleY) {
        return -doodleY * this.getAllScale() + touchY - this.mCentreTranY - this.mRotateTranY;
    }

    public void bindTouchDetector(IDoodlePen pen, IDoodleTouchDetector detector) {
        if (pen == null) {
            return;
        }
        this.mTouchDetectorMap.put(pen, detector);
    }

    public IDoodleTouchDetector getDefaultTouchDetector(IDoodlePen pen) {
        return this.mTouchDetectorMap.get(pen);
    }

    public void removeTouchDetector(IDoodlePen pen) {
        if (pen == null) {
            return;
        }
        this.mTouchDetectorMap.remove(pen);
    }

    public void setDefaultTouchDetector(IDoodleTouchDetector touchGestureDetector) {
        this.mDefaultTouchDetector = touchGestureDetector;
    }

    public IDoodleTouchDetector getDefaultTouchDetector() {
        return this.mDefaultTouchDetector;
    }

    @Override
    public void refresh() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    @Override
    public int getDoodleRotation() {
        return this.mDoodleRotateDegree;
    }

    @Override
    public void setDoodleRotation(int degree) {
        float nh;
        this.mDoodleRotateDegree = degree;
        this.mDoodleRotateDegree %= 360;
        if (this.mDoodleRotateDegree < 0) {
            this.mDoodleRotateDegree = 360 + this.mDoodleRotateDegree;
        }
        RectF rectF = this.getDoodleBound();
        int w = (int)(rectF.width() / this.getAllScale());
        int h = (int)(rectF.height() / this.getAllScale());
        float nw = (float)w * 1.0f / (float)this.getWidth();
        float scale = nw > (nh = (float)h * 1.0f / (float)this.getHeight()) ? 1.0f / nw : 1.0f / nh;
        int pivotX = this.mBitmap.getWidth() / 2;
        int pivotY = this.mBitmap.getHeight() / 2;
        this.mTransY = 0.0f;
        this.mTransX = 0.0f;
        this.mRotateTranY = 0.0f;
        this.mRotateTranX = 0.0f;
        this.mScale = 1.0f;
        this.mRotateScale = 1.0f;
        float touchX = this.toTouchX(pivotX);
        float touchY = this.toTouchY(pivotY);
        this.mRotateScale = scale / this.mCenterScale;
        float tx = this.toTransX(touchX, pivotX);
        float ty = this.toTransY(touchY, pivotY);
        this.mRotateTranX = tx;
        this.mRotateTranY = ty;
        this.refresh();
    }

    @Override
    public void save() {
        Bitmap savedBitmap = this.mBitmap.copy(this.mBitmap.getConfig(), true);
        Canvas canvas = new Canvas(savedBitmap);
        for (IDoodleItem item : this.mItemStack) {
            if (!(item instanceof DoodleItemBase)) continue;
            item.draw(canvas);
        }
        savedBitmap = ImageUtils.rotate((Bitmap)savedBitmap, (int)this.mDoodleRotateDegree, (boolean)true);
        this.mDoodleListener.onSaved(this, savedBitmap, new Runnable(){

            @Override
            public void run() {
                DoodleView.this.refresh();
            }
        });
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.mItemStack.size(); ++i) {
            IDoodleItem item = this.mItemStack.remove(i);
            item.onRemove();
        }
        this.mItemStack.clear();
        this.refresh();
    }

    @Override
    public boolean undo(int step) {
        if (this.mItemStack.size() > 0) {
            step = Math.min(this.mItemStack.size(), step);
            IDoodleItem item = this.mItemStack.get(this.mItemStack.size() - step);
            this.removeItem(item);
            return true;
        }
        return false;
    }

    @Override
    public boolean undo() {
        return this.undo(1);
    }

    @Override
    public void setShowOriginal(boolean justDrawOriginal) {
        this.isJustDrawOriginal = justDrawOriginal;
        this.refresh();
    }

    @Override
    public boolean isShowOriginal() {
        return this.isJustDrawOriginal;
    }

    @Override
    public void setColor(IDoodleColor color) {
        this.mColor = color;
        this.refresh();
    }

    @Override
    public IDoodleColor getColor() {
        return this.mColor;
    }

    @Override
    public void setDoodleScale(float scale, float pivotX, float pivotY) {
        if (scale < this.mMinScale) {
            scale = this.mMinScale;
        } else if (scale > this.mMaxScale) {
            scale = this.mMaxScale;
        }
        float touchX = this.toTouchX(pivotX);
        float touchY = this.toTouchY(pivotY);
        this.mScale = scale;
        this.mTransX = this.toTransX(touchX, pivotX);
        this.mTransY = this.toTransY(touchY, pivotY);
        this.refresh();
    }

    @Override
    public float getDoodleScale() {
        return this.mScale;
    }

    @Override
    public void setPen(IDoodlePen pen) {
        if (pen == null) {
            throw new RuntimeException("Pen can't be null");
        }
        IDoodlePen old = this.mPen;
        this.mPen = pen;
        this.refresh();
    }

    @Override
    public IDoodlePen getPen() {
        return this.mPen;
    }

    @Override
    public void setShape(IDoodleShape shape) {
        if (shape == null) {
            throw new RuntimeException("Shape can't be null");
        }
        this.mShape = shape;
        this.refresh();
    }

    @Override
    public IDoodleShape getShape() {
        return this.mShape;
    }

    @Override
    public void setDoodleTranslation(float transX, float transY) {
        this.mTransX = transX;
        this.mTransY = transY;
        this.refresh();
    }

    @Override
    public void setDoodleTranslationX(float transX) {
        this.mTransX = transX;
        this.refresh();
    }

    @Override
    public float getDoodleTranslationX() {
        return this.mTransX;
    }

    @Override
    public void setDoodleTranslationY(float transY) {
        this.mTransY = transY;
        this.refresh();
    }

    @Override
    public float getDoodleTranslationY() {
        return this.mTransY;
    }

    @Override
    public void setSize(float paintSize) {
        this.mSize = paintSize;
        this.refresh();
    }

    @Override
    public float getSize() {
        return this.mSize;
    }

    @Override
    public void setIsDrawableOutside(boolean isDrawableOutside) {
        this.mIsDrawableOutside = isDrawableOutside;
    }

    @Override
    public boolean isDrawableOutside() {
        return this.mIsDrawableOutside;
    }

    @Override
    public void setZoomerScale(float scale) {
        this.mZoomerScale = scale;
        this.refresh();
    }

    @Override
    public float getZoomerScale() {
        return this.mZoomerScale;
    }

    public void enableZoomer(boolean enable) {
        this.mEnableZoomer = enable;
    }

    public boolean isEnableZoomer() {
        return this.mEnableZoomer;
    }

    public void enableOverview(boolean enableOverview) {
        this.mEnableOverview = enableOverview;
    }

    public boolean isEnableOverview() {
        return this.mEnableOverview;
    }

    public boolean isScrollingDoodle() {
        return this.mIsScrollingDoodle;
    }

    public void setScrollingDoodle(boolean scrollingDoodle) {
        this.mIsScrollingDoodle = scrollingDoodle;
        this.refresh();
    }

    @Override
    public void topItem(IDoodleItem item) {
        if (item == null) {
            throw new RuntimeException("item is null");
        }
        this.mItemStack.remove(item);
        this.mItemStack.add(item);
        this.refresh();
    }

    @Override
    public void bottomItem(IDoodleItem item) {
        if (item == null) {
            throw new RuntimeException("item is null");
        }
        this.mItemStack.remove(item);
        this.mItemStack.add(0, item);
        this.refresh();
    }

    @Override
    public void setDoodleMinScale(float minScale) {
        this.mMinScale = minScale;
        this.setDoodleScale(this.mScale, 0.0f, 0.0f);
    }

    @Override
    public float getDoodleMinScale() {
        return this.mMinScale;
    }

    @Override
    public void setDoodleMaxScale(float maxScale) {
        this.mMaxScale = maxScale;
        this.setDoodleScale(this.mScale, 0.0f, 0.0f);
    }

    @Override
    public float getDoodleMaxScale() {
        return this.mMaxScale;
    }

    @Override
    public float getUnitSize() {
        return this.mDoodleSizeUnit;
    }

    @Override
    public void addItem(IDoodleItem item) {
        if (item == null) {
            throw new RuntimeException("item is null");
        }
        if (this != item.getDoodle()) {
            throw new RuntimeException("the object Doodle is illegal");
        }
        if (this.mItemStack.contains(item)) {
            throw new RuntimeException("the item has been added");
        }
        this.mItemStack.add(item);
        item.onAdd();
        this.refresh();
    }

    @Override
    public void removeItem(IDoodleItem doodleItem) {
        if (!this.mItemStack.remove(doodleItem)) {
            return;
        }
        doodleItem.onRemove();
        this.refresh();
    }

    @Override
    public List<IDoodleItem> getAllItem() {
        return this.mItemStack;
    }

    @Override
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public Bitmap getDoodleBitmap() {
        return this.mBitmap;
    }

    public int getCenterWidth() {
        return this.mCenterWidth;
    }

    public int getCenterHeight() {
        return this.mCenterHeight;
    }

    public float getCenterScale() {
        return this.mCenterScale;
    }

    public float getCentreTranX() {
        return this.mCentreTranX;
    }

    public float getCentreTranY() {
        return this.mCentreTranY;
    }

    public float getRotateScale() {
        return this.mRotateScale;
    }

    public float getRotateTranX() {
        return this.mRotateTranX;
    }

    public float getRotateTranY() {
        return this.mRotateTranY;
    }

    public boolean isEditMode() {
        return this.mIsEditMode;
    }

    public void setEditMode(boolean editMode) {
        this.mIsEditMode = editMode;
        this.refresh();
    }

    private class DoodleViewInner {
        private DoodleViewInner() {
        }

        public boolean onTouchEvent(MotionEvent event) {
            IDoodleTouchDetector detector = (IDoodleTouchDetector)DoodleView.this.mTouchDetectorMap.get(DoodleView.this.mPen);
            if (detector != null) {
                return detector.onTouchEvent(event);
            }
            if (DoodleView.this.mDefaultTouchDetector != null) {
                return DoodleView.this.mDefaultTouchDetector.onTouchEvent(event);
            }
            return false;
        }

        protected void onDraw(Canvas canvas) {
            canvas.save();
            DoodleView.this.doDraw(canvas);
            canvas.restore();
        }
    }
}

